(******************************************************************)
(* UCompSpvLibsvmCsvc.pas - Copyright (c) 2006 Ricco RAKOTOMALALA *)
(******************************************************************)

{
@abstract(Utilisation de la mthode C-SVC de la bibliothque LIBSVM)
@author(Ricco)
@created(08/01/2006)

2 objectifs :
(a) une mthode de SVM supplmentaire dans TANAGRA
(b) montrer qu'il est possible d'importer des mthodes  partir de bibliothques
externes crites dans un autre langage (le C++ en l'occurence).

}

unit UCompSpvLibsvmCsvc;

interface

USES
       Classes, Forms, IniFiles,
       UCompDefinition,
       UCompSpvLDefinition,
       UOperatorDefinition,
       UDatasetImplementation;

TYPE

       TMLGCompSpvCSVC = class(TMLGenCompSpvLearning)
                         public
                         function    GetClassMLComponent: TClassMLComponent; override;
                         end;

       TMLCompSpvCSVC = class(TMLCompSpvLearning)
                        protected
                        function    getClassOperator: TClassOperator; override;
                        function    GetLogResultDescription(): string; override;
                        end;

       TOpSpvCSVC = class(TOpSpvLearningContinuous)
                    protected
                    function    getClassParameter: TClassOperatorParameter; override;
                    function    getClassSpvLearning(): TClassCalcSpvLearning; override;
                    function    ConnectDescriptors(prmData: TMLDataset): boolean; override;
                    end;

       TOpPrmCSVC = class(TOpPrmSpvLearning)
                    private
                    protected
                    function    CreateDlgParameters(): TForm; override;
                    procedure   SetDefaultParameters(); override;
                    public
                    //trs moche de faire ainsi, mais au moins on voit bien l'quivalence
                    _kernel_type: integer;//kernel type
                    degree: double;	//* for poly */
                    gamma: double;	//* for poly/rbf/sigmoid */
                    coef0: double;	//* for poly/sigmoid */
                    eps: double;	//* stopping criteria */
                    C: double;	//* for C_SVC, EPSILON_SVR and NU_SVR */
                    shrinking: integer;	//* use the shrinking heuristics */
                    probability: integer; //* do probability estimates */
                    //affichage
                    function    getHTMLParameters(): string; override;
                    //I-O
                    procedure   LoadFromStream(prmStream: TStream); override;
                    procedure   SaveToStream(prmStream: TStream); override;
                    procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                    procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                    end;

implementation

uses
    Sysutils, UDatasetDefinition, UCalcSpvLibsvmCsvc, ULibSVMImport,
  UConstConfiguration, UDlgOpPrmSpvLibSvmCSVC;

{ TMLGCompSpvCSVC }

function TMLGCompSpvCSVC.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSpvCSVC;
end;

{ TMLCompSpvCSVC }

function TMLCompSpvCSVC.getClassOperator: TClassOperator;
begin
 result:= TOpSpvCSVC;
end;

function TMLCompSpvCSVC.GetLogResultDescription: string;
begin
 result:= '[C-SVC] from LIBSVM generated';
end;

{ TOpSpvCSVC }

function TOpSpvCSVC.ConnectDescriptors(prmData: TMLDataset): boolean;
var ok: boolean;
begin
 //ok:= inherited ConnectDescriptors(prmData);
 //new -- 26/12/2005 -- accepter les prdicteurs quasi-continus, i.e. continus ou discrets binaires
 ok:= (prmData.LstAtts[asInput].Count > 0) AND (prmData.LstAtts[asInput].isAllCategory(caQuasiContinue));
 if ok then FDescriptorsAtt:= prmData.LstAtts[asInput];//branchement direct, pas de recopie locale
 //non, a marche mme pour le multi-classes
 //ok:= ok and (self.ClassAttribute.nbValues = 2);
 //and then...
 result:= ok;
end;

function TOpSpvCSVC.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmCSVC;
end;

function TOpSpvCSVC.getClassSpvLearning: TClassCalcSpvLearning;
begin
 result:= TCalcLibsvmCsvc;
end;

{ TOpPrmCSVC }

function TOpPrmCSVC.CreateDlgParameters: TForm;
begin
 result:= TdlgOpPrmSpvLibsvmCsvc.CreateFromOpPrm(self);
end;

function TOpPrmCSVC.getHTMLParameters: string;
var s: string;
begin
 s:= HTML_HEADER_TABLE_RESULT;
 s:= s + HTML_TABLE_COLOR_HEADER_GRAY + '<TH colspan=2>Parameters</TH></TR>';
 s:= s + HTML_TABLE_COLOR_DATA_GRAY + format('<TD>Kernel type</TD><TD align=right>%s</TD<</TR>',[str_kernel_type[kernel_type(_kernel_type)]]);
 s:= s + HTML_TABLE_COLOR_DATA_GRAY + format('<TD>Degree (poly)</TD><TD align=right>%.2f</TD<</TR>',[degree]);
 s:= s + HTML_TABLE_COLOR_DATA_GRAY + format('<TD>Gamma in kernel function (poly/rbf/sigmoid)</TD><TD align=right>%.2f</TD<</TR>',[gamma]);
 s:= s + HTML_TABLE_COLOR_DATA_GRAY + format('<TD>Coef0 in kernel function(ploy/sigmoid)</TD><TD align=right>%.2f</TD<</TR>',[Coef0]);
 s:= s + HTML_TABLE_COLOR_DATA_GRAY + format('<TD>Tolerance of termination criteria</TD><TD align=right>%.4f</TD<</TR>',[gamma]);
 s:= s + HTML_TABLE_COLOR_DATA_GRAY + format('<TD>C (Complexity Cost)</TD><TD align=right>%.2f</TD<</TR>',[C]);
 s:= s + HTML_TABLE_COLOR_DATA_GRAY + format('<TD>Compute probability estimates</TD><TD align=right>%d</TD<</TR>',[probability]);
 s:= s + HTML_TABLE_COLOR_DATA_GRAY + format('<TD>Use shrinking heuristics</TD><TD align=right>%d</TD<</TR>',[shrinking]);
 s:= s + '</table>';
 result:= s;
end;

procedure TOpPrmCSVC.LoadFromINI(prmSection: string; prmINI: TMemIniFile);
begin
  _kernel_type:= prmINI.readInteger(prmSection,'kernel_type',_kernel_type);//kernel type
  degree:= prmINI.readFloat(prmSection,'degree',degree);	//* for poly */
  gamma:= prmINI.readFloat(prmSection,'gamma',gamma);	//* for poly/rbf/sigmoid */
  coef0:= prmINI.readFloat(prmSection,'coef0',coef0);	//* for poly/sigmoid */
  eps:= prmINI.readFloat(prmSection,'eps',eps);	//* stopping criteria */
  C:= prmINI.readFloat(prmSection,'C',C);	//* for C_SVC, EPSILON_SVR and NU_SVR */
  shrinking:= prmINI.readInteger(prmSection,'shrinking',shrinking);	//* use the shrinking heuristics */
  probability:= prmINI.readInteger(prmSection,'probability',probability); //* do probability estimates */
end;

procedure TOpPrmCSVC.LoadFromStream(prmStream: TStream);
begin
  prmStream.ReadBuffer(_kernel_type,sizeof(_kernel_type));//kernel type
  prmStream.ReadBuffer(degree,sizeof(degree));
  prmStream.ReadBuffer(gamma,sizeof(gamma));
  prmStream.ReadBuffer(coef0,sizeof(coef0));
  prmStream.ReadBuffer(eps,sizeof(eps));
  prmStream.ReadBuffer(C,sizeof(C));
  prmStream.ReadBuffer(shrinking,sizeof(shrinking));
  prmStream.ReadBuffer(probability,sizeof(probability));
end;

procedure TOpPrmCSVC.SaveToINI(prmSection: string; prmINI: TMemIniFile);
begin
  prmINI.WriteInteger(prmSection,'kernel_type',_kernel_type);//kernel type
  prmINI.WriteFloat(prmSection,'degree',degree);	//* for poly */
  prmINI.WriteFloat(prmSection,'gamma',gamma);	//* for poly/rbf/sigmoid */
  prmINI.WriteFloat(prmSection,'coef0',coef0);	//* for poly/sigmoid */
  prmINI.WriteFloat(prmSection,'eps',eps);	//* stopping criteria */
  prmINI.WriteFloat(prmSection,'C',C);	//* for C_SVC, EPSILON_SVR and NU_SVR */
  prmINI.WriteInteger(prmSection,'shrinking',shrinking);	//* use the shrinking heuristics */
  prmINI.WriteInteger(prmSection,'probability',probability); //* do probability estimates */
end;

procedure TOpPrmCSVC.SaveToStream(prmStream: TStream);
begin
  prmStream.WriteBuffer(_kernel_type,sizeof(_kernel_type));//kernel type
  prmStream.WriteBuffer(degree,sizeof(degree));
  prmStream.WriteBuffer(gamma,sizeof(gamma));
  prmStream.WriteBuffer(coef0,sizeof(coef0));
  prmStream.WriteBuffer(eps,sizeof(eps));
  prmStream.WriteBuffer(C,sizeof(C));
  prmStream.WriteBuffer(shrinking,sizeof(shrinking));
  prmStream.WriteBuffer(probability,sizeof(probability));
end;

procedure TOpPrmCSVC.SetDefaultParameters;
begin
  _kernel_type := ord(LINEAR); //>>type de noyau
  degree := 1; //>>degr du kernel
  gamma := 0;	// 1/k >>gamma
  coef0 := 0; //>>coef. 0 dans le kernel
  C := 1;//>>penalit
  eps := 1e-3;//>>tolerance
  shrinking := 1;//>>use shrinking heuristics
  probability := 0;//>>use probability estimate
end;

initialization
 RegisterClass(TMLGCompSpvCSVC);
end.
