unit UDlgOpPrmSpvLibSvmCSVC;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, ComCtrls, StdCtrls, ExtCtrls,
  LMDCustomControl, LMDCustomPanel, LMDCustomBevelPanel, LMDBaseEdit,
  LMDCustomEdit, LMDCustomMaskEdit, LMDMaskEdit, LMDControl,
  LMDBaseControl, LMDBaseGraphicControl, LMDBaseLabel,
  LMDCustomSimpleLabel, LMDSimpleLabel;

type
  TdlgOpPrmSpvLibsvmCsvc = class(TDlgBaseOperatorParameter)
    TabSheet1: TTabSheet;
    Label1: TLabel;
    cmbKernelType: TComboBox;
    Label2: TLabel;
    edDegree: TLMDMaskEdit;
    Label3: TLabel;
    edGamma: TLMDMaskEdit;
    Label4: TLabel;
    edCoef0: TLMDMaskEdit;
    chkProba: TCheckBox;
    Label5: TLabel;
    edEpsilon: TLMDMaskEdit;
    Label6: TLabel;
    edCost: TLMDMaskEdit;
    chkShrinking: TCheckBox;
    LMDSimpleLabel1: TLMDSimpleLabel;
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  procedure   ApplyModifications(); override;
  procedure   SetParameters(); override;      
  end;

var
  dlgOpPrmSpvLibsvmCsvc: TdlgOpPrmSpvLibsvmCsvc;

implementation

uses UCompSpvLibsvmCsvc;

{$R *.dfm}

{ TdlgOpPrmSpvLibsvmCsvc }

procedure TdlgOpPrmSpvLibsvmCsvc.ApplyModifications;
var prm: TOpPrmCSVC;
begin
 prm:= self.OpPrm as TOpPrmCSVC;
 //rcuprer les paramtres
 TRY
 prm._kernel_type:= self.cmbKernelType.ItemIndex;
 prm.degree:= strtofloat(self.edDegree.Text);
 prm.gamma:= strtofloat(self.edGamma.Text);
 prm.coef0:= strtofloat(self.edCoef0.Text);
 prm.C:= strtofloat(self.edCost.Text);
 prm.probability:= integer(self.chkProba.Checked);
 prm.eps:= strtofloat(self.edEpsilon.Text);
 prm.shrinking:= integer(self.chkShrinking.Checked);
 EXCEPT
 END;
end;

procedure TdlgOpPrmSpvLibsvmCsvc.SetParameters;
var prm: TOpPrmCSVC;
begin
 prm:= self.OpPrm as TOpPrmCSVC;
 //passer les paramtres
 self.cmbKernelType.ItemIndex:= prm._kernel_type;
 self.edDegree.Text:= floattostr(prm.degree);
 self.edGamma.Text:= floattostr(prm.gamma);
 self.edCoef0.Text:= floattostr(prm.coef0);
 self.edCost.Text:= floattostr(prm.C);
 self.chkProba.Checked:= boolean(prm.probability);
 self.edEpsilon.Text:= floattostr(prm.eps);
 self.chkShrinking.Checked:= boolean(prm.shrinking);
end;

end.
