(*************************************************************)
(* ULibSVMImport.pas - Copyright (c) 2006 Ricco RAKOTOMALALA *)
(*************************************************************)

{
@abstract(Unit d'importation de LIBSVM)
@author(Ricco)
@created(08/01/2006)

Importation implicite des fonctions de la bibliothque LIBSVM
(http://www.csie.ntu.edu.tw/~cjlin/libsvm/)

Plusieurs mthodes sont disponibles, on utilisera dans un premier temps
la partie "apprentissage supervis".

Le plus important est de bien faire attention aux conversions de type, bien
que le passage C++ Builder -> Delphi ne devrait pas trop poser problme.

}
unit ULibSVMImport;

interface

TYPE
//struct svm_node
svm_node = record
           index: integer;
           value: double;
end;
p_svm_node = ^svm_node;

//tableaux de noeuds
array_svm_node = array of svm_node;
array_array_svm_node = array of array_svm_node;

//tableaux de rels
array_double = array of double;
array_array_double = array of array_double;

//tableaux d'entiers
array_integer = array of integer;

//struct svm_problem
svm_problem = record
              l: integer;
              y: array_double;
              x: array_array_svm_node;
end;
p_svm_problem = ^svm_problem;

//enum { C_SVC, NU_SVC, ONE_CLASS, EPSILON_SVR, NU_SVR };	/* svm_type */
svm_type = (C_SVC, NU_SVC, ONE_CLASS, EPSILON_SVR, NU_SVR);

CONST
str_svm_type : array[svm_type] of string = ('C-SVC','NU-SVC','ONE CLASS','EPSILON-SVR','NU-SVR');

TYPE
//enum { LINEAR, POLY, RBF, SIGMOID };	/* kernel_type */
kernel_type = (LINEAR, POLY, RBF, SIGMOID);

CONST
str_kernel_type : array[kernel_type] of string = ('LINEAR','POLY','RBF','SIGMOID');

TYPE
//struct svm_parameter
svm_parameter = record
	svm_type: integer;
	kernel_type: integer;
	degree: double;	//* for poly */
	gamma: double;	//* for poly/rbf/sigmoid */
	coef0: double;	//* for poly/sigmoid */

	//* these are for training only */
	cache_size: double; //* in MB */
	eps: double;	//* stopping criteria */
	C: double;	//* for C_SVC, EPSILON_SVR and NU_SVR */
	nr_weight: integer;		//* for C_SVC */
	weight_label: array_integer;	//* for C_SVC */
	weight: array_double;		//* for C_SVC */
	nu: double;	//* for NU_SVC, ONE_CLASS, and NU_SVR */
	p: double;	//* for EPSILON_SVR */
	shrinking: integer;	//* use the shrinking heuristics */
	probability: integer; //* do probability estimates */
end;
p_svm_parameter = ^svm_parameter;

//
// svm_model
//
//struct svm_model
svm_model = record
	param: svm_parameter;	// parameter
	nr_class: integer;		// number of classes, = 2 in regression/one class svm
	l: integer;			// total #SV
	SV: array_array_svm_node;		// SVs (SV[l])
	sv_coef: array_array_double;	// coefficients for SVs in decision functions (sv_coef[n-1][l])
	rho: array_double;		// constants in decision functions (rho[n*(n-1)/2])
	probA: array_double;          // pariwise probability information
	probB: array_double;
	// for classification only
	_label: array_integer;		// label of each class (label[n])
	nSV: array_integer;		// number of SVs for each class (nSV[n])
				// nSV[0] + nSV[1] + ... + nSV[n-1] = l
	// XXX
	free_sv: integer;		// 1 if svm_model is created by svm_load_model
				            // 0 if svm_model is created by svm_train
end;
p_svm_model = ^svm_model;

function  svm_train(const prob: p_svm_problem ; const param: p_svm_parameter): p_svm_model; stdcall; external '.\dll\libsvm.dll';
procedure svm_cross_validation(const prob: p_svm_problem ; const param: p_svm_parameter ; nr_fold: integer ; target: array_double); stdcall; external '.\dll\libsvm.dll';

//R.R. -- inutile pour l'instant les fonctions d'I/O, on ne sauve pas les modles.
//__declspec(dllexport) int __stdcall svm_save_model(const char *model_file_name, const struct svm_model *model); stdcall; external '.\dll\libsvm.dll';
//__declspec(dllexport) struct svm_model* __stdcall svm_load_model(const char *model_file_name); stdcall; external '.\dll\libsvm.dll';

function  svm_get_svm_type(const model: p_svm_model): integer; stdcall; external '.\dll\libsvm.dll';
function  svm_get_nr_class(const model: p_svm_model): integer; stdcall; external '.\dll\libsvm.dll';
procedure svm_get_labels(const model: p_svm_model ; _label: array_integer); stdcall; external '.\dll\libsvm.dll';
function  svm_get_svr_probability(const model: p_svm_model): double; stdcall; external '.\dll\libsvm.dll';

procedure svm_predict_values(const model: p_svm_model ; const x: array_svm_node ; var dec_values: array_double); stdcall; external '.\dll\libsvm.dll';
function  svm_predict(const model: p_svm_model ; const x: array_svm_node): double; stdcall; external '.\dll\libsvm.dll';
function  svm_predict_probability(const model: p_svm_model ; const x: array_svm_node ; prob_estimates: array_double): double; stdcall; external '.\dll\libsvm.dll';

procedure svm_destroy_model(model: p_svm_model); stdcall; external '.\dll\libsvm.dll';
procedure svm_destroy_param(param: p_svm_parameter); stdcall; external '.\dll\libsvm.dll';

function  svm_check_parameter(const prob: p_svm_problem ; const param: p_svm_parameter): PChar; stdcall; external '.\dll\libsvm.dll';
function  svm_check_probability_model(const prob: p_svm_problem): integer; stdcall; external '.\dll\libsvm.dll';

implementation

end.


