(***********************************************************)
(* UCalcLIBSVM.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(***********************************************************)

{

@abstract(Portage de la classe LIBSVM)
@author(Ricco)
@created(05/01/2006)

Traduction directe de SVM.JAVA de la bibliothque LIBSVM
On n'utilise que la partie supervise.

//!\ Abandonn les 08 janv. 2006
>>>
Nous allons tester une autre technologie, importer le code programme
 partir d'une DLL. C'est une bonne piste pour intgrer d'autres mthodes  l'avenir,
a permet aussi de voir si cette approche est viable pour enrichir  moindre cot
la bibilothque des mthodes.
<<<

}

unit UCalcLIBSVM;

interface

USES
UCalcLIBSVMSomeClasses;



implementation

USES
Math, ULogFile, Sysutils;

TYPE
//vecteur de donnes
TVectorData = array of single;

//tableau de donnes
TMatrixData = array of TVectorData;

//tableau de coefs.
svm_array_double = array of double;

//matrice de coefs.
svm_array_array_double = array of svm_array_double;

//classe prive
head_t = class
prev,next: head_t;
data: TVectorData;
len: integer;
end;

//Kernel Cache
Cache = class
private
l: integer;
size: integer;
head: array of head_t;
lru_head: head_t;
procedure lru_delete(h: head_t);
procedure lru_insert(h: head_t);
public
constructor create(l_: integer; size_: integer);
destructor  destroy(); override;
function    get_data(index: integer; data: TMatrixData; len: integer): integer;
procedure   swap_index(i,j: integer);
end;

//
// Kernel evaluation
//
// the static method k_function is for doing single kernel evaluation
// the constructor of Kernel prepares to calculate the l*l kernel matrix
// the member function get_Q is for getting one column from the Q Matrix
//
QMatrix = class
public
function get_Q(column: integer; len: integer): TVectorData; virtual; abstract;
function get_QD(): TVectorData; virtual; abstract;
procedure swap_index(i,j: integer); virtual; abstract;
end;

//Kernel
Kernel = class(QMatrix)
private
x: array_array_svm_node;
x_square: svm_array_double;
// svm_parameter
kernel_type: libsvm_kernel_type;
degree: double;
gamma: double;
coef0: double;
function tanh(x: double): double;
public
constructor create(l: integer; x_: array_array_svm_node; param: libsvm_svm_parameter);
function dot(x,y: array_svm_node): double;
function kernel_function(i,j: integer): double;
procedure swap_index(i,j: integer); override;
function k_function(x,y: array_svm_node; param: libsvm_svm_parameter): double;
end;

constructor Cache.create(l_: integer; size_: integer);
var i: integer;
begin
  l := l_;
  size := size_;
  setLength(head,l);
  for i:= 0 to l do
   head[i]:= head_t.Create();
  size:= size div 4;
  size:= size - l * (16 div 4);	// sizeof(head_t) == 16
  size:= Math.max(size, 2*l);  // cache must be large enough for two columns
  lru_head:= head_t.Create();
  //lru_head.next = lru_head.prev = lru_head;
  lru_head.prev:= lru_head;
  lru_head.next:= lru_head.prev;
end;

destructor Cache.destroy();
begin
 //???
 //mystre
 //
 inherited destroy();
end;

procedure Cache.lru_delete(h: head_t);
begin
// delete from current location
h.prev.next := h.next;
h.next.prev := h.prev;
end;

procedure Cache.lru_insert(h: head_t);
begin
// insert to last position
h.next:= lru_head;
h.prev:= lru_head.prev;
h.prev.next := h;
h.next.prev := h;
end;

// request data [0,len)
// return some position p where [p,len) need to be filled
// (p >= len if nothing needs to be filled)
// java: simulate pointer using single-element array
function Cache.get_data(index: integer; data: TMatrixData; len: integer): integer;
var h,old: head_t;
    more,_: integer;
    new_data: TVectorData;
begin
  h := head[index];
  if (h.len > 0) then lru_delete(h);
  more := len - h.len;

  if (more > 0) then
  begin
          // free old space
          while (size < more) do
          begin
                  old := lru_head.next;
                  lru_delete(old);
                  size := size + old.len;
                  old.data:= nil;
                  old.len := 0;
          end;

          // allocate new space
          setlength(new_data,len);
          if (h.data <> nil) then System.Move(h.data[0],new_data[0],h.len * sizeof(single));  //System.arraycopy(h.data,0,new_data,0,h.len);
          h.data := new_data;
          size := size - more;
          repeat
          _:=h.len; h.len:=len; len:=_;
          until (true);
  end;

  lru_insert(h);
  //data[0] := h.data; -- ???
  setlength(data[0],len);
  System.Move(h.data[0],data[0][0],h.len*sizeof(single));
  //
  result:= len;
end;

procedure Cache.swap_index(i,j: integer);
var _data: TVectorData;
    _len: integer;
    _index: integer;
    _value: single;    
    h: head_t;    
begin
        _data:= nil;
        if(i = j) then exit;

        if (head[i].len > 0) then lru_delete(head[i]);
        if (head[j].len > 0) then lru_delete(head[j]);

        _data:=head[i].data;
        head[i].data:=head[j].data;
        head[j].data:=_data;

        _len:= head[i].len;
        head[i].len:= head[j].len;
        head[j].len:= _len;

        if (head[i].len > 0) then lru_insert(head[i]);
        if (head[j].len > 0) then lru_insert(head[j]);

        if (i>j) then
        begin
        _index:= i;
        i:=j;
        j:= _index;
        end;

        //for(head_t h = lru_head.next; h!=lru_head; h=h.next)
        h:= lru_head.next;
        while (h <> lru_head) do
        begin
        if (h.len > i) then
                begin
                        if (h.len > j) then
                        begin
                         _value:= h.data[i]; h.data[i]:=h.data[j]; h.data[j]:= _value;
                        end
                        else
                        begin
                                // give up
                                lru_delete(h);
                                size := size + h.len;
                                h.data := nil;
                                h.len := 0;
                        end;
                end;
        h:= h.next;
        end;
end;

procedure Kernel.swap_index(i,j: integer);
var _sn: array_svm_node;
    _value: double;
begin
 _sn:= x[i]; x[i]:=x[j]; x[j]:=_sn;
 if (x_square <> nil) then
 begin
  _value:= x_square[i]; x_square[i]:=x_square[j]; x_square[j]:= _value;
 end;
end;

function Kernel.tanh(x: double): double;
var e: double;
begin
 e:= EXP(x);
 result:= 1.0-2.0/(e*e+1);
end;

function Kernel.kernel_function(i,j: integer): double;
begin
  case kernel_type of
  kt_LINEAR: result:= dot(x[i],x[j]);
  kt_POLY: result:= MATH.Power(gamma*dot(x[i],x[j])+coef0,degree);
  kt_RBF: result:= exp(-gamma*(x_square[i]+x_square[j]-2*dot(x[i],x[j])));
  kt_SIGMOID: result:= tanh(gamma*dot(x[i],x[j])+coef0)
  else
  result:= 0.0;	// java
  end;
end;

function Kernel.dot(x,y: array_svm_node): double;
var sum: double;
  xlen, ylen, i, j: integer;
begin
  sum := 0;
  xlen := length(x);
  ylen := length(y);
  i := 0;
  j := 0;
  while(i < xlen) and (j < ylen) do
  begin
          if (x[i].index = y[j].index) then
                  begin
                  sum := sum + x[i].value * y[j].value;
                  inc(i);
                  inc(j);
                  end
          else
          begin
                  if(x[i].index > y[j].index) then
                          inc(j)
                  else
                          inc(i);
          end;
  end;
  result:= sum;
end;

constructor Kernel.create(l: integer; x_: array_array_svm_node; param: libsvm_svm_parameter);
var i: integer;
begin
 inherited create();
 kernel_type := param.kernel_type;
 degree := param.degree;
 gamma := param.gamma;
 coef0 := param.coef0;
 //x = (svm_node[][])x_.clone();
 //!\\ hum ! ce n'est pas une copie ici !!!
 x:= x_;
 //
 if (kernel_type = kt_RBF) then
 begin
  setlength(x_square,l);
  for i:= 0 to pred(l) do
   x_square[i] := dot(x[i],x[i]);
 end
 else x_square := nil;
end;


function Kernel.k_function(x,y: array_svm_node; param: libsvm_svm_parameter): double;
var sum: double;
    xlen, ylen, i, j: integer;
    d: double;
begin
  case param.kernel_type of
  kt_LINEAR: result:= dot(x,y);
  kt_POLY: result:= Math.POWER(param.gamma*dot(x,y)+param.coef0,param.degree);
  kt_RBF:
          begin
                  sum := 0;
                  xlen := length(x);
                  ylen := length(y);
                  i := 0;
                  j := 0;
                  while (i < xlen) and (j < ylen) do
                  begin
                          if (x[i].index = y[j].index) then
                          begin
                                  d := x[i].value - y[j].value;
                                  inc(i);
                                  inc(j);
                                  sum := sum + d*d;
                          end
                          else if (x[i].index > y[j].index) then
                          begin
                                  sum := sum + y[j].value * y[j].value;
                                  inc(j);
                          end
                          else
                          begin
                                  sum := sum + x[i].value * x[i].value;
                                  inc(i);
                          end;
                  end;

                  while (i < xlen) do
                  begin
                          sum := sum + x[i].value * x[i].value;
                          inc(i);
                  end;

                  while (j < ylen) do
                  begin
                          sum := sum + y[j].value * y[j].value;
                          inc(j);
                  end;

                  result:= exp(-param.gamma*sum);
          end;
          kt_SIGMOID: result:= tanh(param.gamma*dot(x,y)+param.coef0)
          else result:= 0.0;	// java
  end;
end;

// java: information about solution except alpha,
// because we cannot return multiple values otherwise...
TYPE
SolutionInfo = class
        obj: double;
        rho: double;
        upper_bound_p: double;
        upper_bound_n: double;
        r: double;	// for Solver_NU
end;

// Generalized SMO+SVMlight algorithm
// Solves:
//
//	min 0.5(\alpha^T Q \alpha) + b^T \alpha
//
//		y^T \alpha = \delta
//		y_i = +1 or -1
//		0 <= alpha_i <= Cp for y_i = 1
//		0 <= alpha_i <= Cn for y_i = -1
//
// Given:
//
//	Q, b, y, Cp, Cn, and an initial feasible point \alpha
//	l is the size of vectors and matrices
//	eps is the stopping criterion
//
// solution will be put in \alpha, objective value will be put in obj
//
TYPE
Solver = class
        public
	active_size: integer;
	y: array of smallint;
	G: svm_array_double;		// gradient of objective function
	LOWER_BOUND : smallint;
	UPPER_BOUND : smallint;
	FREE : smallint;
	alpha_status: array of smallint;	// LOWER_BOUND, UPPER_BOUND, FREE
	alpha: svm_array_double;
	Q: QMatrix;
	QD: TvectorData;
	eps: double;
	Cp,Cn: double;
	b: svm_array_double;
	active_set: array of integer;
	G_bar: svm_array_double;		// gradient, if we treat free variables as 0
	l: integer;
	unshrinked: boolean;	// XXX

	INF : double;
        constructor create();
        function    get_C(i: integer): double;
        procedure   update_alpha_status(i: integer);
        function    is_upper_bound(i: integer): boolean;
        function    is_lower_bound(i: integer): boolean;
        function    is_free(i: integer): boolean;
        procedure   swap_index(i,j: integer);
        procedure   reconstruct_gradient(); virtual;
        procedure   Solve(l: integer; Q: QMatrix; b_: svm_array_double; y_: array of smallint; alpha_: svm_array_double; Cp, Cn, eps: double; si: SolutionInfo; shrinking: integer); virtual;
        procedure   do_shrinking(); virtual;
        function    select_working_set(working_set: array of integer): integer; virtual;
        function    calculate_rho(): double; virtual;
        function    max_violating_pair(working_set: array of integer): integer; virtual;                
end;

constructor Solver.create();
begin
 inherited create();
 LOWER_BOUND:= 0;
 UPPER_BOUND:= 1;
 FREE := 2;
 INF  := MATH.MaxDouble;
end;

function Solver.get_C(i: integer): double;
begin
if (y[i] > 0)then result:= Cp
             else result:= Cn;
end;

procedure Solver.update_alpha_status(i: integer);
begin
		if(alpha[i] >= get_C(i)) then
			alpha_status[i] := UPPER_BOUND
		else if(alpha[i] <= 0) then
			alpha_status[i] := LOWER_BOUND
		else alpha_status[i] := FREE;
end;

function Solver.is_upper_bound(i: integer): boolean;
begin
 result:= alpha_status[i] = UPPER_BOUND;
end;

function Solver.is_lower_bound(i: integer): boolean;
begin
 result:= alpha_status[i] = LOWER_BOUND;
end;

function Solver.is_free(i: integer): boolean;
begin
 result:= alpha_status[i] = FREE;
end;

procedure Solver.swap_index(i,j: integer);
var _b: smallint;
    _d: double;
    _i: integer;
begin
  Q.swap_index(i,j);

  _b:=y[i]; y[i]:=y[j]; y[j]:=_b;
  _d:=G[i]; G[i]:=G[j]; G[j]:=_d;
  _b:=alpha_status[i]; alpha_status[i]:=alpha_status[j]; alpha_status[j]:=_b;
  _d:=alpha[i]; alpha[i]:=alpha[j]; alpha[j]:=_d;
  _d:=b[i]; b[i]:=b[j]; b[j]:=_d;
  _i:=active_set[i]; active_set[i]:= active_set[j]; active_set[j]:=_i;
  _d:=G_bar[i]; G_bar[i]:=G_bar[j]; G_bar[j]:=_d;
end;

procedure Solver.reconstruct_gradient();
var i,j: integer;
    Q_i: TVectorData;
    alpha_i: double;
begin
  Q_i:= NIL;
  // reconstruct inactive elements of G from G_bar and free variables

  if (active_size = l) then exit;

  for i:=active_size to pred(l) do
          G[i] := G_bar[i] + b[i];

  for i:=0 to pred(active_size) do
          if (is_free(i)) then
          begin
                  Q_i := Q.get_Q(i,l);
                  alpha_i := alpha[i];
                  for j:= active_size to pred(l) do
                          G[j] := G[j] + alpha_i * Q_i[j];
          end;
end;


procedure Solver.Solve(l: integer; Q: QMatrix; b_: svm_array_double; y_: array of smallint;
		       alpha_: svm_array_double; Cp, Cn, eps: double; si: SolutionInfo; shrinking: integer);
var i,j,k: integer;
    Q_i,Q_j: TVectorData;
    alpha_i: double;
    //iter: integer;
    counter: integer;
    working_set: array of integer;
    C_i,C_j,old_alpha_i,old_alpha_j: double;
    delta_alpha_i,delta_alpha_j: double;
    quad_coef,delta,diff,sum: double;
    ui,uj: boolean;
    v: double;
begin
  Q_i:= nil;
  Q_j:= nil;

  self.l := l;
  self.Q := Q;
  QD := Q.get_QD();
  //b = (double[])b_.clone(); -- ???
  setlength(b,length(b_));
  Move(b_[0],b[0],length(b_)*sizeof(double));
  //y = (smallint[])y_.clone(); -- ???
  setlength(y,length(y_));
  Move(y_[0],y[0],length(y_)*sizeof(smallint));
  //alpha = (double[])alpha_.clone(); -- ???
  setlength(alpha,length(alpha_));
  Move(alpha_[0],alpha[0],length(alpha_)*sizeof(double));

  self.Cp := Cp;
  self.Cn := Cn;
  self.eps := eps;
  self.unshrinked := false;

  // initialize alpha_status
  begin
    setlength(alpha_status,l);
    for i:= 0 to pred(l) do
     update_alpha_status(i);
  end;

  // initialize active set (for shrinking)
  begin
    setlength(active_set,l);
    for i:= 0 to pred(l) do
            active_set[i] := i;
    active_size := l;
  end;

  // initialize gradient
  begin
          setlength(G,l);
          setlength(G_bar,l);
          for i:= 0 to pred(l) do
          begin
                  G[i] := b[i];
                  G_bar[i] := 0;
          end;
          
          for i:=0 to pred(l) do
                  if not(is_lower_bound(i)) then
                  begin
                          Q_i := Q.get_Q(i,l);
                          alpha_i := alpha[i];
                          for j:=0 to pred(l) do
                                  G[j] := G[j] + alpha_i*Q_i[j];
                          if (is_upper_bound(i)) then
                                  for j:=0 to pred(l) do
                                          G_bar[j] := G_bar[j] + get_C(i) * Q_i[j];
                  end;
  end;

  // optimization step

  //iter := 0;
  counter := Math.min(l,1000)+1;
  setlength(working_set,2);

  while (true) do
  begin
          // show progress and do shrinking
          dec(counter);
          if (counter = 0) then
          begin
                  counter := Math.min(l,1000);
                  if (shrinking<>0) then do_shrinking();
                  //System.err.print(".");
          end;

          if (select_working_set(working_set)<>0) then
          begin
                  // reconstruct the whole gradient
                  reconstruct_gradient();
                  // reset active set size and check
                  active_size := l;
                  //System.err.print("*");
                  if (select_working_set(working_set)<>0) then
                          break
                  else
                          counter := 1;	// do shrinking next iteration
          end;

          i := working_set[0];
          j := working_set[1];

          //inc(iter);

          // update alpha[i] and alpha[j], handle bounds carefully

          Q_i := Q.get_Q(i,active_size);
          Q_j := Q.get_Q(j,active_size);

          C_i := get_C(i);
          C_j := get_C(j);

          old_alpha_i := alpha[i];
          old_alpha_j := alpha[j];

          if (y[i]<>y[j]) then
          begin
                  quad_coef := Q_i[i]+Q_j[j]+2*Q_i[j];
                  if (quad_coef <= 0) then
                          quad_coef := 1e-12;
                  delta := (-G[i]-G[j])/quad_coef;
                  diff := alpha[i] - alpha[j];
                  alpha[i] := alpha[i] + delta;
                  alpha[j] := alpha[j] + delta;

                  if (diff > 0) then
                  begin
                          if(alpha[j] < 0) then
                          begin
                                  alpha[j] := 0;
                                  alpha[i] := diff;
                          end;
                  end
                  else
                  begin
                          if (alpha[i] < 0) then
                          begin
                                  alpha[i] := 0;
                                  alpha[j] := -diff;
                          end;
                  end;
                  
                  if (diff > C_i - C_j) then
                  begin
                          if(alpha[i] > C_i) then
                          begin
                                  alpha[i] := C_i;
                                  alpha[j] := C_i - diff;
                          end;
                  end
                  else
                  begin
                          if(alpha[j] > C_j) then
                          begin
                                  alpha[j] := C_j;
                                  alpha[i] := C_j + diff;
                          end;
                  end;
          end
          else
          begin
                  quad_coef := Q_i[i]+Q_j[j]-2*Q_i[j];
                  if (quad_coef <= 0) then
                          quad_coef := 1e-12;
                  delta := (G[i]-G[j])/quad_coef;
                  sum := alpha[i] + alpha[j];
                  alpha[i] := alpha[i] - delta;
                  alpha[j] := alpha[j] + delta;

                  if (sum > C_i) then
                  begin
                          if(alpha[i] > C_i) then
                          begin
                                  alpha[i] := C_i;
                                  alpha[j] := sum - C_i;
                          end;
                  end
                  else
                  begin
                          if(alpha[j] < 0) then
                          begin
                                  alpha[j] := 0;
                                  alpha[i] := sum;
                          end;
                  end;

                  if (sum > C_j) then
                  begin
                          if(alpha[j] > C_j) then
                          begin
                                  alpha[j] := C_j;
                                  alpha[i] := sum - C_j;
                          end;
                  end
                  else
                  begin
                          if(alpha[i] < 0) then
                          begin
                                  alpha[i] := 0;
                                  alpha[j] := sum;
                          end;
                  end;
          end;

          // update G

          delta_alpha_i := alpha[i] - old_alpha_i;
          delta_alpha_j := alpha[j] - old_alpha_j;

          for k:=0 to pred(active_size) do
          begin
                  G[k] := G[k] + Q_i[k]*delta_alpha_i + Q_j[k]*delta_alpha_j;
          end;

          // update alpha_status and G_bar

          begin
                  ui := is_upper_bound(i);
                  uj := is_upper_bound(j);
                  update_alpha_status(i);
                  update_alpha_status(j);

                  if (ui <> is_upper_bound(i)) then
                  begin
                          Q_i := Q.get_Q(i,l);
                          if(ui) then
                          begin
                                  for k:=0 to pred(l) do
                                          G_bar[k] := G_bar[k] - C_i * Q_i[k];
                          end
                          else
                                  for k:=0 to pred(l) do
                                          G_bar[k] := G_bar[k] + C_i * Q_i[k];
                  end;

                  if (uj <> is_upper_bound(j)) then
                  begin
                          Q_j := Q.get_Q(j,l);
                          if(uj) then
                          begin
                                  for k:=0 to pred(l) do
                                          G_bar[k] := G_bar[k] - C_j * Q_j[k];
                          end
                          else
                                  for k:=0 to pred(l) do
                                          G_bar[k] := G_bar[k] + C_j * Q_j[k];
                  end;
          end;

  end;

  // calculate rho

  si.rho := calculate_rho();

  // calculate objective value
  begin
          v := 0;

          for i:=0 to pred(l) do
                  v := v + alpha[i] * (G[i] + b[i]);

          si.obj := v/2;
  end;

  // put back the solution
  begin
          for i:=0 to pred(l) do
                  alpha_[active_set[i]] := alpha[i];
  end;

  si.upper_bound_p := Cp;
  si.upper_bound_n := Cn;

  //System.out.print("\noptimization finished, #iter = "+iter+"\n");
end;

	// return 1 if already optimal, return 0 otherwise
function Solver.select_working_set(working_set: array of integer): integer;
var Gmax,Gmax2: double;
    Gmax_idx,Gmin_idx: integer;
    obj_diff_min: double;
    t: integer;
    i,j: integer;
    Q_i: TVectorData;
    obj_diff,grad_diff,quad_coef: double;
begin
		// return i,j such that
		// i: maximizes -y_i * grad(f)_i, i in I_up(\alpha)
		// j: mimimizes the decrease of obj value
		//    (if quadratic coefficeint <= 0, replace it with tau)
		//    -y_j*grad(f)_j < -y_i*grad(f)_i, j in I_low(\alpha)

		Gmax := -INF;
		Gmax2 := -INF;
		Gmax_idx := -1;
		Gmin_idx := -1;
		obj_diff_min := INF;
	
		for t:=0 to pred(active_size) do
			if (y[t]=+1) then
			begin
				if not(is_upper_bound(t)) then
					if (-G[t] >= Gmax) then
					begin
						Gmax := -G[t];
						Gmax_idx := t;
					end;
			end
			else
			begin
				if not(is_lower_bound(t)) then
					if (G[t] >= Gmax) then
					begin
						Gmax := G[t];
						Gmax_idx := t;
					end;
			end;
	
		i:= Gmax_idx;
		Q_i := nil;
		if (i <> -1) then // null Q_i not accessed: Gmax=-INF if i=-1
			Q_i := Q.get_Q(i,active_size);
	
		for j:=0 to pred(active_size) do
		begin
			if (y[j]=+1) then
			begin
				if not(is_lower_bound(j)) then
				begin
					grad_diff:= Gmax+G[j];
					if (G[j] >= Gmax2) then
						Gmax2 := G[j];
					if (grad_diff > 0) then
					begin
						//double obj_diff;
						quad_coef:= Q_i[i]+QD[j]-2*y[i]*Q_i[j];
						if (quad_coef > 0) then
							obj_diff := -(grad_diff*grad_diff)/quad_coef
						else
							obj_diff := -(grad_diff*grad_diff)/1e-12;

						if (obj_diff <= obj_diff_min) then
						begin
							Gmin_idx:=j;
							obj_diff_min := obj_diff;
						end;
					end;
				end;
			end
			else
			begin
				if not(is_upper_bound(j)) then
				begin
					grad_diff:= Gmax-G[j];
					if (-G[j] >= Gmax2) then
						Gmax2 := -G[j];
					if (grad_diff > 0) then
					begin
						//double obj_diff;
						quad_coef:= Q_i[i]+QD[j]+2*y[i]*Q_i[j];
						if (quad_coef > 0) then
							obj_diff := -(grad_diff*grad_diff)/quad_coef
						else
							obj_diff := -(grad_diff*grad_diff)/1e-12;

						if (obj_diff <= obj_diff_min) then
						begin
							Gmin_idx:=j;
							obj_diff_min := obj_diff;
						end;
					end;
				end;
			end;
		end;

		if (Gmax+Gmax2 < eps) then
                begin
			result:= 1;
                        exit;
                end;

		working_set[0] := Gmax_idx;
		working_set[1] := Gmin_idx;
		result:= 0;
end;

	// return 1 if already optimal, return 0 otherwise
function Solver.max_violating_pair(working_set: array of integer): integer;
var Gmax1, Gmax2: double;
    Gmax1_idx,Gmax2_idx: integer;
    i: integer;
begin
		// return i,j which maximize -grad(f)^T d , under constraint
		// if alpha_i == C, d != +1
		// if alpha_i == 0, d != -1

		Gmax1 := -INF;		// max { -y_i * grad(f)_i | i in I_up(\alpha) }
		Gmax1_idx := -1;

		Gmax2_idx := -1;
		Gmax2 := -INF;		// max { y_i * grad(f)_i | i in I_low(\alpha) }

		for i:=0 to pred(active_size) do
		begin
			if (y[i]=+1) then	// y = +1
			begin
				if not(is_upper_bound(i)) then	// d = +1
				begin
					if(-G[i] >= Gmax1) then
					begin
						Gmax1 := -G[i];
						Gmax1_idx := i;
					end;
				end;
				if not(is_lower_bound(i)) then // d = -1
				begin
					if (G[i] >= Gmax2) then
					begin
						Gmax2 := G[i];
						Gmax2_idx := i;
					end;
				end;
			end
			else		// y = -1
			begin
				if not(is_upper_bound(i)) then	// d = +1
				begin
					if(-G[i] >= Gmax2) then
					begin
						Gmax2 := -G[i];
						Gmax2_idx := i;
					end;
				end;

				if not(is_lower_bound(i)) then	// d = -1
				begin
					if(G[i] >= Gmax1) then
					begin
						Gmax1 := G[i];
						Gmax1_idx := i;
					end;
				end;
			end;
		end;

		if(Gmax1+Gmax2 < eps) then
                begin
	 		result:= 1;
                        exit;
                end;

		working_set[0] := Gmax1_idx;
		working_set[1] := Gmax2_idx;
		result:= 0;
end;

procedure Solver.do_shrinking();
label next_k_one,next_k_two;
var i,j,k: integer;
    working_set: array of integer;
    Gm1,Gm2: double;

begin
		//int i,j,k;
		setlength(working_set,2);
		if (max_violating_pair(working_set)<> 0) then exit;

		i := working_set[0];
		j := working_set[1];
		Gm1 := -y[j]*G[j];
		Gm2 := y[i]*G[i];

		// shrink
	        k:= 0;
		while (k<active_size) do
		begin
			if(is_lower_bound(k)) then
			begin
				if(y[k]=+1) then
				begin
					if(-G[k] >= Gm1) then goto next_k_one;
				end
				else	if(-G[k] >= Gm2) then goto next_k_one;
			end
			else if(is_upper_bound(k)) then
			begin
				if(y[k]=+1) then
				begin
					if(G[k] >= Gm2) then goto next_k_one;
				end
				else	if(G[k] >= Gm1) then goto next_k_one;
			end
			else goto next_k_one;

			dec(active_size);
			swap_index(k,active_size);
			dec(k);	// look at the newcomer
                        
                next_k_one:
                inc(k);
		end;

		// unshrink, check all variables again before final iterations

		if(unshrinked) OR (-(Gm1 + Gm2) > eps*10) then exit;

		unshrinked := true;
		reconstruct_gradient();

                k:= l-1;
		while (k>=active_size) do
		begin
			if(is_lower_bound(k)) then
			begin
				if(y[k]=+1) then
				begin
					if(-G[k] < Gm1) then goto next_k_two;
				end
				else	if(-G[k] < Gm2) then goto next_k_two;
			end
			else if(is_upper_bound(k)) then
			begin
				if(y[k]=+1) then
				begin
					if(G[k] < Gm2) then goto next_k_two;
				end
				else	if(G[k] < Gm1) then goto next_k_two;
			end
			else goto next_k_two;

			swap_index(k,active_size);
			inc(active_size);
			inc(k);	// look at the newcomer
                        
                next_k_two:
                dec(k);
		end;
end;

function Solver.calculate_rho(): double;
var r,ub,lb,sum_free: double;
    nr_free,i: integer;
    yG: double;
begin
		//double r;
		nr_free := 0;
		ub := INF; lb := -INF; sum_free := 0;
		for i:=0 to pred(active_size) do
		begin
			yG := y[i]*G[i];

			if(is_lower_bound(i)) then
			begin
				if(y[i] > 0) then
					ub := Math.min(ub,yG)
				else
					lb := Math.max(lb,yG);
			end
			else
                        begin
                          if(is_upper_bound(i)) then
                          begin
                                  if(y[i] < 0) then
                                          ub := Math.min(ub,yG)
                                  else
                                          lb := Math.max(lb,yG);
                          end
                          else
                          begin
                                  inc(nr_free);
                                  sum_free := sum_free + yG;
                          end;
                        end;
		end;

		if(nr_free>0) then
			r := sum_free/nr_free
		else
			r := (ub+lb)/2;

		result:= r;
end;


//
// Solver for nu-svm classification and regression
//
// additional constraint: e^T \alpha = constant
//
TYPE
Solver_NU = class(Solver)
private
si: SolutionInfo;
public
procedure   Solve(l: integer; Q: QMatrix; b_: svm_array_double; y_: array of smallint; alpha_: svm_array_double; Cp, Cn, eps: double; si: SolutionInfo; shrinking: integer); override;
function    select_working_set(working_set: array of integer): integer; override;
procedure   do_shrinking(); override;
function    calculate_rho(): double; override;
end;

procedure   Solver_NU.Solve(l: integer; Q: QMatrix; b_: svm_array_double; y_: array of smallint; alpha_: svm_array_double; Cp, Cn, eps: double; si: SolutionInfo; shrinking: integer);
begin
 self.si:= si;
 inherited;
end;

// return 1 if already optimal, return 0 otherwise
function Solver_NU.select_working_set(working_set: array of integer): integer;
var Gmaxp,Gmaxn,Gmaxp2,Gmaxn2: double;
    Gmaxp_idx,Gmaxn_idx,Gmin_idx: integer;
    obj_diff_min: double;
    t: integer;
    ip,in_: integer;

    j: integer;
    Q_ip,Q_in: TVectorData;
    obj_diff,grad_diff,quad_coef: double;
begin
  // return i,j such that y_i = y_j and
  // i: maximizes -y_i * grad(f)_i, i in I_up(\alpha)
  // j: minimizes the decrease of obj value
  //    (if quadratic coefficeint <= 0, replace it with tau)
  //    -y_j*grad(f)_j < -y_i*grad(f)_i, j in I_low(\alpha)
	
  Gmaxp := -INF;
  Gmaxp2 := -INF;
  Gmaxp_idx := -1;
	
  Gmaxn := -INF;
  Gmaxn2 := -INF;
  Gmaxn_idx := -1;
	
  Gmin_idx := -1;
  obj_diff_min := INF;
	
  for t:=0 to pred(active_size) do
          if(y[t]=+1) then
          begin
                  if not(is_upper_bound(t)) then
                          if(-G[t] >= Gmaxp) then
                          begin
                                  Gmaxp := -G[t];
                                  Gmaxp_idx := t;
                          end;
          end
          else
          begin
                  if not(is_lower_bound(t)) then
                          if(G[t] >= Gmaxn) then
                          begin
                                  Gmaxn := G[t];
                                  Gmaxn_idx := t;
                          end;
          end;

  ip := Gmaxp_idx;
  in_ := Gmaxn_idx;
  Q_ip := nil;
  Q_in := nil;
  
  if (ip <> -1) then // null Q_ip not accessed: Gmaxp=-INF if ip=-1
          Q_ip := Q.get_Q(ip,active_size);
  if (in_ <> -1) then
          Q_in := Q.get_Q(in_,active_size);
	
  for j:= 0 to pred(active_size) do
  begin
          if(y[j] = +1) then
          begin
                  if not(is_lower_bound(j)) then
                  begin
                          grad_diff:=Gmaxp+G[j];
                          if (G[j] >= Gmaxp2) then
                                  Gmaxp2 := G[j];
                          if (grad_diff > 0) then
                          begin
                                  //double obj_diff;
                                  quad_coef := Q_ip[ip]+QD[j]-2*Q_ip[j];
                                  if (quad_coef > 0) then
                                          obj_diff := -(grad_diff*grad_diff)/quad_coef
                                  else
                                          obj_diff := -(grad_diff*grad_diff)/1e-12;

                                  if (obj_diff <= obj_diff_min) then
                                  begin
                                          Gmin_idx:=j;
                                          obj_diff_min := obj_diff;
                                  end;
                          end;
                  end;
          end
          else
          begin
                  if not(is_upper_bound(j)) then
                  begin
                          grad_diff:=Gmaxn-G[j];
                          if (-G[j] >= Gmaxn2) then
                                  Gmaxn2 := -G[j];
                          if (grad_diff > 0) then
                          begin
                                  //double obj_diff;
                                  quad_coef := Q_in[in_]+QD[j]-2*Q_in[j];
                                  if (quad_coef > 0) then
                                          obj_diff := -(grad_diff*grad_diff)/quad_coef
                                  else
                                          obj_diff := -(grad_diff*grad_diff)/1e-12;

                                  if (obj_diff <= obj_diff_min) then
                                  begin
                                          Gmin_idx:=j;
                                          obj_diff_min := obj_diff;
                                  end;
                          end;
                  end;
          end;
  end;

  if(Math.max(Gmaxp+Gmaxp2,Gmaxn+Gmaxn2) < eps) then
  begin
          result:= 1;
          exit;
  end;

  if(y[Gmin_idx] = +1) then
          working_set[0] := Gmaxp_idx
  else
          working_set[0] := Gmaxn_idx;
  working_set[1] := Gmin_idx;

  result := 0;
end;

procedure Solver_NU.do_shrinking();
label next_k_one,next_k_two;
var Gmax1,Gmax2,Gmax3,Gmax4: double;
    k: integer;
    Gm1,Gm2,Gm3,Gm4: double;
begin
  Gmax1 := -INF;	// max { -y_i * grad(f)_i | y_i = +1, i in I_up(\alpha) }
  Gmax2 := -INF;	// max { y_i * grad(f)_i | y_i = +1, i in I_low(\alpha) }
  Gmax3 := -INF;	// max { -y_i * grad(f)_i | y_i = -1, i in I_up(\alpha) }
  Gmax4 := -INF;	// max { y_i * grad(f)_i | y_i = -1, i in I_low(\alpha) }
 
  // find maximal violating pair first
  //int k;
  for k:=0 to pred(active_size) do
  begin
          if not(is_upper_bound(k)) then
          begin
                  if(y[k]=+1) then
                  begin
                          if(-G[k] > Gmax1) then Gmax1 := -G[k];
                  end
                  else	if(-G[k] > Gmax3) then Gmax3 := -G[k];
          end;
          if not(is_lower_bound(k)) then
          begin
                  if(y[k]=+1) then
                  begin
                          if(G[k] > Gmax2) then Gmax2 := G[k];
                  end
                  else	if(G[k] > Gmax4) then Gmax4 := G[k];
          end;
  end;

  // shrinking

  Gm1 := -Gmax2;
  Gm2 := -Gmax1;
  Gm3 := -Gmax4;
  Gm4 := -Gmax3;

  k:= 0;
  while (k<active_size) do
  begin
          if(is_lower_bound(k)) then
          begin
                  if(y[k]=+1) then
                  begin
                          if(-G[k] >= Gm1) then goto next_k_one;
                  end
                  else	if(-G[k] >= Gm3) then goto next_k_one
          end
          else if(is_upper_bound(k)) then
          begin
                  if(y[k]=+1) then
                  begin
                          if(G[k] >= Gm2) then goto next_k_one
                  end
                  else	if(G[k] >= Gm4) then goto next_k_one
          end
          else goto next_k_one;

          dec(active_size);
          swap_index(k,active_size);
          dec(k);	// look at the newcomer

  //
  next_k_one:
  inc(k);
  end;

  // unshrink, check all variables again before final iterations

  if(unshrinked) OR (Math.max(-(Gm1+Gm2),-(Gm3+Gm4)) > eps*10) then exit;
	
  unshrinked := true;
  reconstruct_gradient();

  k:= l-1;
  while (k>=active_size) do
  begin
          if(is_lower_bound(k)) then
          begin
                  if(y[k]=+1) then
                  begin
                          if(-G[k] < Gm1) then goto next_k_two;
                  end
                  else	if(-G[k] < Gm3) then goto next_k_two;
          end
          else if(is_upper_bound(k)) then
          begin
                  if(y[k]=+1) then
                  begin
                          if(G[k] < Gm2) then goto next_k_two;
                  end
                  else	if(G[k] < Gm4) then goto next_k_two;
          end
          else goto next_k_two;

          swap_index(k,active_size);
          inc(active_size);
          inc(k);	// look at the newcomer

  next_k_two:
  dec(k);
  end;
end;

function Solver_NU.calculate_rho(): double;
var     nr_free1,nr_free2 : integer;
        ub1,ub2,lb1,lb2,sum_free1,sum_free2 : double;
        i: integer;
        r1,r2: double;

begin
        nr_free1 := 0; nr_free2 := 0;
        ub1 := INF; ub2 := INF;
        lb1 := -INF; lb2 := -INF;
        sum_free1 := 0; sum_free2 := 0;

        for i:=0 to pred(active_size) do
        begin
                if(y[i]=+1) then
                begin
                        if(is_lower_bound(i)) then
                                ub1 := Math.min(ub1,G[i])
                        else if(is_upper_bound(i)) then
                                lb1 := Math.max(lb1,G[i])
                        else
                        begin
                                inc(nr_free1);
                                sum_free1 := sum_free1 + G[i];
                        end;
                end
                else
                begin
                        if(is_lower_bound(i)) then
                                ub2 := Math.min(ub2,G[i])
                        else if(is_upper_bound(i)) then
                                lb2 := Math.max(lb2,G[i])
                        else
                        begin
                                inc(nr_free2);
                                sum_free2 := sum_free2 + G[i];
                        end;
                end;
        end;

        //double r1,r2;
        if(nr_free1 > 0) then
                r1 := sum_free1/nr_free1
        else
                r1 := (ub1+lb1)/2;

        if(nr_free2 > 0) then
                r2 := sum_free2/nr_free2
        else
                r2 := (ub2+lb2)/2;

        si.r := (r1+r2)/2;
        result:= (r1-r2)/2;
end;

//
// Q matrices for various formulations
//
type
SVC_Q = class(Kernel)
private
  y: array of smallint;
  _cache: Cache;
  QD: TVectorData;

public
constructor create(prob: libsvm_svm_problem; param: libsvm_svm_parameter; y_: array of smallint);
function    get_Q(i,len: integer): TVectorData; override;
function    get_QD(): TVectorData; override;
procedure   swap_index(i,j: integer); override;
end;

constructor SVC_Q.create(prob: libsvm_svm_problem; param: libsvm_svm_parameter; y_: array of smallint);
var i: integer;
begin
        inherited create(prob.l, prob.x, param);
        //y = (smallint[])y_.clone();
        setlength(y,length(y_));
        move(y_[0],y[0],length(y_)*sizeof(smallint));
        //cache := Cache.Create(prob.l,(int)(param.cache_size*(1<<20)));
        _cache := Cache.Create(prob.l,trunc(param.cache_size*20));
        
        setLength(QD,prob.l);
        for i:=0 to pred(prob.l) do
                QD[i]:= kernel_function(i,i);
end;

function SVC_Q.get_Q(i,len: integer): TVectorData;
var data: TMatrixData;
    start,j: integer;
begin
        //float[][] data = new float[1][];
        setLength(data,1);
        
        //int start;
        start := _cache.get_data(i,data,len);
        if(start < len) then
        begin
                for j:=start to pred(len) do
                        data[0][j] := (y[i]*y[j]*kernel_function(i,j));
        end;
        result:= data[0];
end;

function SVC_Q.get_QD(): TVectorData;
begin
 result:= QD;
end;

procedure SVC_Q.swap_index(i,j: integer);
var _s: smallint;
    _f: single;
begin
  _cache.swap_index(i,j);
  inherited swap_index(i,j);
  _s:=y[i]; y[i]:=y[j]; y[j]:=_s;
  _f:=QD[i]; QD[i]:=QD[j]; QD[j]:=_f;
end;

TYPE
ONE_CLASS_Q = class(Kernel)
private
 _cache : Cache;
 QD: TVectorData;
public
constructor create(prob: libsvm_svm_problem; param: libsvm_svm_parameter);
function    get_Q(i,len: integer): TVectorData; override;
function    get_QD(): TVectorData; override;
procedure   swap_index(i,j: integer); override;
end;

constructor ONE_CLASS_Q.create(prob: libsvm_svm_problem; param: libsvm_svm_parameter);
var i: integer;
begin
        inherited create(prob.l, prob.x, param);
        //cache = new Cache(prob.l,(int)(param.cache_size*(1<<20)));
        _cache := Cache.create(prob.l,trunc(param.cache_size*20));
        setLength(QD,prob.l);
        for i:=0 to pred(prob.l) do
                QD[i]:= kernel_function(i,i);
end;

function    ONE_CLASS_Q.get_Q(i,len: integer): TVectorData;
var data: TMatrixData;
    start,j: integer;
begin
        //float[][] data = new float[1][];
        setLength(data,1);
        //int start;
        start := _cache.get_data(i,data,len);
        if(start < len) then
        begin
                for j:=start to pred(len) do
                        data[0][j] := kernel_function(i,j);
        end;
        result:= data[0];
end;

function ONE_CLASS_Q.get_QD(): TVectorData;
begin
 result:= QD;
end;

procedure ONE_CLASS_Q.swap_index(i,j: integer);
var _f: single;
begin
  _cache.swap_index(i,j);
  inherited swap_index(i,j);
  _f:=QD[i]; QD[i]:=QD[j]; QD[j]:=_f;
end;

TYPE
SVR_Q = class(Kernel)
private
l: integer;
_cache: Cache;
sign: array of smallint;
index: array of integer;
next_buffer: integer;
buffer: TMatrixData;
QD: TVectorData;
public
constructor create(prob: libsvm_svm_problem; param: libsvm_svm_parameter);
function    get_Q(i,len: integer): TVectorData; override;
function    get_QD(): TVectorData; override;
procedure   swap_index(i,j: integer); override;
end;

constructor SVR_Q.create(prob: libsvm_svm_problem; param: libsvm_svm_parameter);
var k: integer;
begin
        inherited create(prob.l, prob.x, param);
        l := prob.l;
        //cache = new Cache(l,(int)(param.cache_size*(1<<20)));
        _cache := Cache.Create(l,TRUNC(param.cache_size*20));
        setlength(QD,2*l);
        setLength(sign,2*l);
        setLength(index,2*l);
        for k:=0 to pred(l) do
        begin
                sign[k] := 1;
                sign[k+l] := -1;
                index[k] := k;
                index[k+l] := k;
                QD[k] := kernel_function(k,k);
                QD[k+l] := QD[k];
        end;
        //buffer = new float[2][2*l];
        setLength(buffer,2,2*l);
        next_buffer := 0;
end;

procedure   SVR_Q.swap_index(i,j: integer);
var _s: smallint;
    _i: integer;
    _f: single;
begin
        _s:=sign[i]; sign[i]:=sign[j]; sign[j]:=_s;
        _i:=index[i]; index[i]:=index[j]; index[j]:=_i;
        _f:=QD[i]; QD[i]:=QD[j]; QD[j]:=_f;
end;

function    SVR_Q.get_Q(i,len: integer): TVectorData;
var data: TMatrixData;
    buf: TVectorData;
    real_i,j: integer;
    si: smallint;
begin
        //float[][] data = new float[1][];
        setLength(data,1);
        real_i := index[i];
        if(_cache.get_data(real_i,data,l) < l) then
        begin
                for j:=0 to pred(l) do
                        data[0][j] := kernel_function(real_i,j);
        end;

        // reorder and copy
        //float buf[] = buffer[next_buffer];
        buf:= buffer[next_buffer];
        next_buffer := 1 - next_buffer;
        si := sign[i];
        for j:=0 to pred(len) do
                buf[j] := si * sign[j] * data[0][index[j]];
        result:= buf;
end;

function SVR_Q.get_QD(): TVectorData;
begin
 result:= QD;
end;

//
// decision_function
//
TYPE
decision_function= class
        alpha: svm_array_double;
        rho: double;
end;

TYPE
svm = class
private
s: Solver;
procedure solve_c_svc(prob: libsvm_svm_problem; param: libsvm_svm_parameter; alpha: svm_array_double; si: SolutionInfo; Cp,Cn: double);
procedure solve_nu_svc(prob: libsvm_svm_problem; param: libsvm_svm_parameter; alpha: svm_array_double; si: SolutionInfo);
procedure solve_one_class(prob: libsvm_svm_problem; param: libsvm_svm_parameter; alpha: svm_array_double; si: SolutionInfo);
procedure solve_epsilon_svr(prob: libsvm_svm_problem; param: libsvm_svm_parameter; alpha: svm_array_double; si: SolutionInfo);
procedure solve_nu_svr(prob: libsvm_svm_problem; param: libsvm_svm_parameter; alpha: svm_array_double; si: SolutionInfo);
function  svm_train_one(prob: libsvm_svm_problem; param: libsvm_svm_parameter; Cp,Cn: double): decision_function;
procedure sigmoid_train(l: integer; dec_values, labels, probAB: svm_array_double);
function  sigmoid_predict(decision_value, A, B: double): double;
procedure multiclass_probability(k: integer; r: svm_array_array_double; p: svm_array_double);
public
procedure svm_binary_svc_probability(prob: libsvm_svm_problem; param: libsvm_svm_parameter; Cp,Cn: double; probAB: svm_array_double);
function  svm_train(prob: libsvm_svm_problem; param: libsvm_svm_parameter): libsvm_svm_model;
end;

//
// construct and solve various formulations
//
{
private static void solve_c_svc(svm_problem prob, svm_parameter param,
                                double[] alpha, Solver.SolutionInfo si,
                                double Cp, double Cn)
}
procedure svm.solve_c_svc(prob: libsvm_svm_problem; param: libsvm_svm_parameter; alpha: svm_array_double; si: SolutionInfo; Cp,Cn: double);
var l: integer;
    minus_ones: svm_array_double;
    y: array of smallint;
    i: integer;
    sum_alpha: double;
begin
        l := prob.l;
        setLength(minus_ones,l);
        setLength(y,l);

        //int i;
        for i:=0 to pred(l) do
        begin
                alpha[i] := 0;
                minus_ones[i] := -1;
                if(prob.y[i] > 0) then y[i] := +1 else y[i]:=-1;
        end;

        s := Solver.create();
        s.Solve(l, SVC_Q.Create(prob,param,y), minus_ones, y,
                alpha, Cp, Cn, param.eps, si, param.shrinking);

        sum_alpha:=0;
        for i:=0 to pred(l) do
                sum_alpha := sum_alpha + alpha[i];

        //if (Cp=Cn)
        //        System.out.print("nu = "+sum_alpha/(Cp*prob.l)+"\n");

        for i:=0 to pred(l) do
                alpha[i] := alpha[i] * y[i];
end;

//	private static void solve_nu_svc(svm_problem prob, svm_parameter param,
//				 	double[] alpha, Solver.SolutionInfo si)
procedure svm.solve_nu_svc(prob: libsvm_svm_problem; param: libsvm_svm_parameter; alpha: svm_array_double; si: SolutionInfo);
var i,l: integer;
    nu: double;
    y: array of smallint;
    sum_pos,sum_neg: double;
    zeros: svm_array_double;
    r: double;
begin
        //int i;
        l := prob.l;
        nu := param.nu;

        setlength(y,l);

        for i:=0 to pred(l) do
                if(prob.y[i]>0) then
                        y[i] := +1
                else
                        y[i] := -1;

        sum_pos := nu*l/2;
        sum_neg := nu*l/2;

        for i:=0 to pred(l) do
                if(y[i] = +1) then
                begin
                        alpha[i] := Math.min(1.0,sum_pos);
                        sum_pos := sum_pos - alpha[i];
                end
                else
                begin
                        alpha[i] := Math.min(1.0,sum_neg);
                        sum_neg := sum_neg - alpha[i];
                end;

        setlength(zeros,l);

        for i:=0 to pred(l) do
                zeros[i] := 0;

        s := Solver_NU.create();
        s.Solve(l, SVC_Q.Create(prob,param,y), zeros, y, alpha, 1.0, 1.0, param.eps, si, param.shrinking);
        r := si.r;

        //System.out.print("C = "+1/r+"\n");

        for i:=0 to pred(l) do
                alpha[i] := alpha[i] * y[i]/r;

        si.rho := si.rho / r;
        si.obj := si.obj / (r*r);
        si.upper_bound_p := 1/r;
        si.upper_bound_n := 1/r;
end;

//	private static void solve_one_class(svm_problem prob, svm_parameter param,
//				    	double[] alpha, Solver.SolutionInfo si)
procedure svm.solve_one_class(prob: libsvm_svm_problem; param: libsvm_svm_parameter; alpha: svm_array_double; si: SolutionInfo);
var l,i,n: integer;
    zeros: svm_array_double;
    ones: array of smallint;
begin
        l := prob.l;
        setLength(zeros,l);
        setLength(ones,l);
        //int i;

        n := trunc(param.nu*prob.l);	// # of alpha's at upper bound

        for i:=0 to pred(n) do
                alpha[i] := 1;

        if(n<prob.l) then
                alpha[n] := param.nu * prob.l - n;

        for i:=n+1 to pred(l) do
                alpha[i] := 0;

        for i:=0 to pred(l) do
        begin
                zeros[i] := 0;
                ones[i] := 1;
        end;

        s := Solver.create();
        s.Solve(l, ONE_CLASS_Q.create(prob,param), zeros, ones,alpha, 1.0, 1.0, param.eps, si, param.shrinking);
end;

//	private static void solve_epsilon_svr(svm_problem prob, svm_parameter param,
//					double[] alpha, Solver.SolutionInfo si)
procedure svm.solve_epsilon_svr(prob: libsvm_svm_problem; param: libsvm_svm_parameter; alpha: svm_array_double; si: SolutionInfo);
var l,i: integer;
    alpha2,linear_term: svm_array_double;
    y: array of smallint;
    sum_alpha: double;
begin
        l := prob.l;
        setlength(alpha2,2*l);
        setLength(linear_term,2*l);
        setLength(y,2*l);

        //int i;

        for i:=0 to pred(l) do
        begin
                alpha2[i] := 0;
                linear_term[i] := param.p - prob.y[i];
                y[i] := 1;

                alpha2[i+l] := 0;
                linear_term[i+l] := param.p + prob.y[i];
                y[i+l] := -1;
        end;

        s := Solver.create();
        s.Solve(2*l, SVR_Q.create(prob,param), linear_term, y,
                alpha2, param.C, param.C, param.eps, si, param.shrinking);

        sum_alpha := 0;
        for i:=0 to pred(l) do
        begin
                alpha[i] := alpha2[i] - alpha2[i+l];
                sum_alpha := sum_alpha + ABS(alpha[i]);
        end;
        //System.out.print("nu = "+sum_alpha/(param.C*l)+"\n");
end;

//	private static void solve_nu_svr(svm_problem prob, svm_parameter param,
//					double[] alpha, Solver.SolutionInfo si)
procedure svm.solve_nu_svr(prob: libsvm_svm_problem; param: libsvm_svm_parameter; alpha: svm_array_double; si: SolutionInfo);
var l,i: integer;
    alpha2,linear_term: svm_array_double;
    y: array of smallint;
    C,sum: double;
begin
        l := prob.l;
        C := param.C;
        setlength(alpha2,2*l);
        setLength(linear_term,2*l);
        setLength(y,2*l);

        //int i;

        sum := C * param.nu * l / 2;
        for i:=0 to pred(l) do
        begin
                alpha2[i+l] := Math.min(sum,C);
                alpha2[i] := alpha2[i+l];
                sum := sum - alpha2[i];

                linear_term[i] := - prob.y[i];
                y[i] := 1;

                linear_term[i+l] := prob.y[i];
                y[i+l] := -1;
        end;

        s := Solver_NU.Create();
        s.Solve(2*l, SVR_Q.create(prob,param), linear_term, y,alpha2, C, C, param.eps, si, param.shrinking);

        //System.out.print("epsilon = "+(-si.r)+"\n");

        for i:=0 to pred(l) do
                alpha[i] := alpha2[i] - alpha2[i+l];
end;


//	static decision_function svm_train_one(
//		svm_problem prob, svm_parameter param,
//		double Cp, double Cn)

function  svm.svm_train_one(prob: libsvm_svm_problem; param: libsvm_svm_parameter; Cp,Cn: double): decision_function;
var alpha: svm_array_double;
    si: SolutionInfo;
    nSV,nBSV,i: integer;
    f: decision_function;
begin
        setLength(alpha,prob.l);
        si := SolutionInfo.Create();
        //switch(param.svm_type)
        case (param.svm_type) of
          st_C_SVC: solve_c_svc(prob,param,alpha,si,Cp,Cn);
          st_NU_SVC: solve_nu_svc(prob,param,alpha,si);
          st_ONE_CLASS: solve_one_class(prob,param,alpha,si);
          st_EPSILON_SVR: solve_epsilon_svr(prob,param,alpha,si);
          st_NU_SVR:  solve_nu_svr(prob,param,alpha,si);
        end;

        //System.out.print("obj = "+si.obj+", rho = "+si.rho+"\n");

        // output SVs

        nSV := 0;
        nBSV := 0;
        for i:=0 to pred(prob.l) do
        begin
                if(ABS(alpha[i]) > 0) then
                begin
                        inc(nSV);
                        if(prob.y[i] > 0) then
                        begin
                                if(ABS(alpha[i]) >= si.upper_bound_p) then
                                inc(nBSV);
                        end
                        else
                        begin
                                if(ABS(alpha[i]) >= si.upper_bound_n) then
                                        inc(nBSV);
                        end;
                end;
        end;

        //System.out.print("nSV = "+nSV+", nBSV = "+nBSV+"\n");
        TraceLog.WriteToLogFile(format('nSV = %d, nBSV = %d',[nSV,nBSV]));

        f := decision_function.create();
        //f.alpha := alpha;
        setlength(f.alpha,length(alpha));
        Move(alpha[0],f.alpha[0],length(alpha)*sizeof(double));
        f.rho := si.rho;
        result:= f;
end;

// Platt's binary SVM Probablistic Output: an improvement from Lin et al.
//private static void sigmoid_train(int l, double[] dec_values, double[] labels, double[] probAB)
procedure svm.sigmoid_train(l: integer; dec_values, labels, probAB: svm_array_double);
var a,b,prior1,prior0: double;
    i: integer;
    max_iter: integer; 	// Maximal number of iterations
    min_step: double;	// Minimal step taken in line search
    sigma: double;	// For numerically strict PD of Hessian
    eps: double;
    hiTarget: double;
    loTarget: double;
    t: svm_array_double;
    fApB,p,q,h11,h22,h21,g1,g2,det,dA,dB,gd,stepsize: double;
    newA,newB,newf,d1,d2: double;
    iter: integer;
    fval: double;
    
begin
        //double A, B;
        prior1:=0; prior0 := 0;
        //int i;

        for i:=0 to pred(l) do
                if (labels[i] > 0) then prior1:= prior1 + 1
                else prior0:= prior0 +1;

        max_iter:=100; 	// Maximal number of iterations
        min_step:=1e-10;	// Minimal step taken in line search
        sigma:=1e-3;	// For numerically strict PD of Hessian
        eps:=1e-5;
        hiTarget:=(prior1+1.0)/(prior1+2.0);
        loTarget:=1/(prior0+2.0);
        setLength(t,l);
        //double fApB,p,q,h11,h22,h21,g1,g2,det,dA,dB,gd,stepsize;
        //double newA,newB,newf,d1,d2;
        //int iter;

        // Initial Point and Initial Fun Value
        A:=0.0; B:=LN((prior0+1.0)/(prior1+1.0));
        fval := 0.0;

        for i:=0 to pred(l) do
        begin
                if (labels[i]>0) then t[i]:=hiTarget
                else t[i]:=loTarget;
                fApB := dec_values[i]*A+B;
                if (fApB>=0) then
                        fval := fval + t[i]*fApB + LN(1+EXP(-fApB))
                else
                        fval := fval + (t[i] - 1)*fApB +LN(1+EXP(fApB));
        end;
        
        for iter:=0 to pred(max_iter) do
        begin
                // Update Gradient and Hessian (use H' = H + sigma I)
                h11:=sigma; // numerically ensures strict PD
                h22:=sigma;
                h21:=0.0;g1:=0.0;g2:=0.0;
                for i:=0 to pred(l) do
                begin
                        fApB := dec_values[i]*A+B;
                        if (fApB >= 0) then
                        begin
                                p:= exp(-fApB)/(1.0+exp(-fApB));
                                q:=1.0/(1.0+exp(-fApB));
                        end
                        else
                        begin
                                p:=1.0/(1.0+exp(fApB));
                                q:=exp(fApB)/(1.0+exp(fApB));
                        end;
                        
                        d2:=p*q;
                        h11:= h11 +dec_values[i]*dec_values[i]*d2;
                        h22:= h22 +d2;
                        h21:= h21 +dec_values[i]*d2;
                        d1:= t[i]-p;
                        g1:= g1+dec_values[i]*d1;
                        g2:= g2+d1;
                end;

                // Stopping Criteria
                if (abs(g1)<eps) AND (abs(g2)<eps) then
                        break;

                // Finding Newton direction: -inv(H') * g
                det:=h11*h22-h21*h21;
                dA:=-(h22*g1 - h21 * g2) / det;
                dB:=-(-h21*g1+ h11 * g2) / det;
                gd:=g1*dA+g2*dB;


                stepsize := 1; 		// Line Search
                while (stepsize >= min_step) do
                begin
                        newA := A + stepsize * dA;
                        newB := B + stepsize * dB;

                        // New function value
                        newf := 0.0;
                        for i:=0 to pred(l) do
                        begin
                                fApB := dec_values[i]*newA+newB;
                                if (fApB >= 0) then
                                        newf := newf + t[i]*fApB + ln(1+exp(-fApB))
                                else
                                        newf := newf + (t[i] - 1)*fApB +ln(1+exp(fApB));
                        end;

                        // Check sufficient decrease
                        if (newf<fval+0.0001*stepsize*gd) then
                        begin
                                A:=newA;B:=newB;fval:=newf;
                                break;
                        end
                        else
                                stepsize := stepsize / 2.0;
                end;

                if (stepsize < min_step) then
                begin
                        //System.err.print("Line search fails in two-class probability estimates\n");
                        break;
                end;
        end;

        if (iter>=max_iter) then
                //System.err.print("Reaching maximal iterations in two-class probability estimates\n");
                TraceLog.WriteToLogFile('[LIBSVM] Reaching maximal iterations in two-class probability estimates');

        probAB[0]:=A;probAB[1]:=B;
end;



//private static double sigmoid_predict(double decision_value, double A, double B)
function  svm.sigmoid_predict(decision_value, A, B: double): double;
var fApB: double;
begin
        fApB := decision_value*A+B;
        if (fApB >= 0) then
                result:= exp(-fApB)/(1.0+exp(-fApB))
        else
                result:= 1.0/(1+exp(fApB));
end;


// Method 2 from the multiclass_prob paper by Wu, Lin, and Weng
procedure svm.multiclass_probability(k: integer; r: svm_array_array_double; p: svm_array_double);
var t,j: integer;
    iter, max_iter: integer;
    Q: svm_array_array_double;
    Qp: svm_array_double;
    pQp,eps: double;
    diff: double;
    max_error,error: double;
begin
        //int t,j;
        //iter := 0;
        max_iter:=Math.max(100,k);
        setLength(Q,k,k);
        setLength(Qp,k);
        //double pQp,
        eps:=0.005/k;

        for t:=0 to pred(k) do
        begin
                p[t]:=1.0/k;  // Valid if k = 1
                Q[t][t]:=0;
                for j:=0 to pred(t) do
                begin
                        Q[t][t]:= Q[t][t]+r[j][t]*r[j][t];
                        Q[t][j]:=Q[j][t];
                end;

                for j:=t+1 to pred(k) do
                begin
                        Q[t][t]:= Q[t][t]+r[j][t]*r[j][t];
                        Q[t][j]:= -r[j][t]*r[t][j];
                end;
        end;

        for iter:=0 to pred(max_iter) do
        begin
                // stopping condition, recalculate QP,pQP for numerical accuracy
                pQp:=0;
                for t:=0 to pred(k) do
                begin
                        Qp[t]:=0;
                        for j:=0 to pred(k) do
                                Qp[t]:= Qp[t] + Q[t][j]*p[j];
                        pQp:= pQp+p[t]*Qp[t];
                end;
                max_error:= 0;
                for t:=0 to pred(k) do
                begin
                        error:= abs(Qp[t]-pQp);
                        if (error>max_error) then
                                max_error:=error;
                end;
                if (max_error<eps) then break;

                for t:=0 to pred(k) do
                begin
                        diff:=(-Qp[t]+pQp)/Q[t][t];
                        p[t]:= p[t]+diff;
                        pQp:=(pQp+diff*(diff*Q[t][t]+2*Qp[t]))/(1+diff)/(1+diff);
                        for j:=0 to pred(k) do
                        begin
                                Qp[j]:=(Qp[j]+diff*Q[t][j])/(1+diff);
                                p[j]:= p[j]/(1+diff);
                        end;
                end;
        end;

        if (iter>=max_iter) then
                //System.err.print("Exceeds max_iter in multiclass_prob\n");
                TraceLog.WriteToLogFile('[LIBSVM] -- Exceeds max_iter in multiclass_prob');
end;


// Cross-validation decision values for probability estimates
//private static void svm_binary_svc_probability(svm_problem prob, svm_parameter param, double Cp, double Cn, double[] probAB)
procedure svm.svm_binary_svc_probability(prob: libsvm_svm_problem; param: libsvm_svm_parameter; Cp,Cn: double; probAB: svm_array_double);
var i,j,k,_i,nr_fold: integer;
    perm: array of integer;
    dec_values: svm_array_double;
    _begin,_end: integer;
    subprob: libsvm_svm_problem;
    p_count,n_count: integer;
    subparam: libsvm_svm_parameter;
    submodel: libsvm_svm_model;
begin
        //int i;
        nr_fold := 5;
        setLength(perm,prob.l);
        setLength(dec_values,prob.l);

        // random shuffle
        for i:=0 to pred(prob.l) do perm[i]:=i;
        for i:=0 to pred(prob.l) do
        begin
                j := i+trunc(random*(prob.l-i));
                _i:=perm[i]; perm[i]:=perm[j]; perm[j]:=_i;
        end;

        for i:=0 to pred(nr_fold) do
        begin
                _begin := trunc(i*prob.l/nr_fold);
                _end := trunc((i+1)*prob.l/nr_fold);
                //int j,k;
                subprob := libsvm_svm_problem.create();

                subprob.l := prob.l-(_end-_begin);
                //subprob.x := new svm_node[subprob.l][];
                setLength(subprob.x,subprob.l);
                setLength(subprob.y,subprob.l);

                k:=0;
                for j:=0 to pred(_begin) do
                begin
                        subprob.x[k] := prob.x[perm[j]];
                        subprob.y[k] := prob.y[perm[j]];
                        inc(k);
                end;
                
                for j:=_end to pred(prob.l) do
                begin
                        subprob.x[k] := prob.x[perm[j]];
                        subprob.y[k] := prob.y[perm[j]];
                        inc(k);
                end;
                
                p_count:=0;
                n_count:=0;
                
                for j:=0 to pred(k) do
                        if(subprob.y[j]>0) then
                                inc(p_count)
                        else
                                inc(n_count);

                if(p_count=0) and (n_count=0) then
                begin
                        for j:=_begin to pred(_end) do
                                dec_values[perm[j]] := 0;
                end
                else
                 if(p_count > 0) and (n_count = 0) then
                  begin
                        for j:=_begin to pred(_end) do
                                dec_values[perm[j]] := 1;
                  end
                  else if(p_count = 0) and (n_count > 0) then
                        begin
                          for j:=_begin to pred(_end) do
                                  dec_values[perm[j]] := -1;
                        end
                        else
                        begin
                                subparam := param.clone();
                                subparam.probability:=0;
                                subparam.C:=1.0;
                                subparam.nr_weight:=2;
                                setlength(subparam.weight_label,2);
                                setlength(subparam.weight,2);
                                subparam.weight_label[0]:=+1;
                                subparam.weight_label[1]:=-1;
                                subparam.weight[0]:=Cp;
                                subparam.weight[1]:=Cn;
                                submodel := svm_train(subprob,subparam);
                                for j:=_begin to pred(_end) do
                                begin
                                        setlength(dec_values,1);
                                        svm_predict_values(submodel,prob.x[perm[j]],dec_value);
                                        dec_values[perm[j]]:=dec_value[0];
                                        // ensure +1 -1 order; reason not using CV subroutine
                                        dec_values[perm[j]] := dec_values[perm[j]]*submodel._label[0];
                                end;
                        end;
        end;
        sigmoid_train(prob.l,dec_values,prob.y,probAB);
end;

(*

	// Return parameter of a Laplace distribution
	private static double svm_svr_probability(svm_problem prob, svm_parameter param)
	{
		int i;
		int nr_fold = 5;
		double[] ymv = new double[prob.l];
		double mae = 0;

		svm_parameter newparam = (svm_parameter)param.clone();
		newparam.probability = 0;
		svm_cross_validation(prob,newparam,nr_fold,ymv);
		for(i=0;i<prob.l;i++)
		{
			ymv[i]=prob.y[i]-ymv[i];
			mae += Math.abs(ymv[i]);
		}		
		mae /= prob.l;
		double std=Math.sqrt(2*mae*mae);
		int count=0;
		mae=0;
		for(i=0;i<prob.l;i++)
			if (Math.abs(ymv[i]) > 5*std) 
				count=count+1;
			else 
				mae+=Math.abs(ymv[i]);
		mae /= (prob.l-count);
		System.err.print("Prob. model for test data: target value = predicted value + z,\nz: Laplace distribution e^(-|z|/sigma)/(2sigma),sigma="+mae+"\n");
		return mae;
	}

	// label: label name, start: begin of each class, count: #data of classes, perm: indices to the original data
	// perm, length l, must be allocated before calling this subroutine
	private static void svm_group_classes(svm_problem prob, int[] nr_class_ret, int[][] label_ret, int[][] start_ret, int[][] count_ret, int[] perm)
	{
		int l = prob.l;
		int max_nr_class = 16;
		int nr_class = 0;
		int[] label = new int[max_nr_class];
		int[] count = new int[max_nr_class];
		int[] data_label = new int[l];
		int i;

		for(i=0;i<l;i++)
		{
			int this_label = (int)(prob.y[i]);
			int j;
			for(j=0;j<nr_class;j++)
			{
				if(this_label == label[j])
				{
					++count[j];
					break;
				}
			}
			data_label[i] = j;
			if(j == nr_class)
			{
				if(nr_class == max_nr_class)
				{
					max_nr_class *= 2;
					int[] new_data = new int[max_nr_class];
					System.arraycopy(label,0,new_data,0,label.length);
					label = new_data;
					new_data = new int[max_nr_class];
					System.arraycopy(count,0,new_data,0,count.length);
					count = new_data;					
				}
				label[nr_class] = this_label;
				count[nr_class] = 1;
				++nr_class;
			}
		}

		int[] start = new int[nr_class];
		start[0] = 0;
		for(i=1;i<nr_class;i++)
			start[i] = start[i-1]+count[i-1];
		for(i=0;i<l;i++)
		{
			perm[start[data_label[i]]] = i;
			++start[data_label[i]];
		}
		start[0] = 0;
		for(i=1;i<nr_class;i++)
			start[i] = start[i-1]+count[i-1];

		nr_class_ret[0] = nr_class;
		label_ret[0] = label;
		start_ret[0] = start;
		count_ret[0] = count;
	}

	//
	// Interface functions
	//
	public static svm_model svm_train(svm_problem prob, svm_parameter param)
	{
		svm_model model = new svm_model();
		model.param = param;

		if(param.svm_type == svm_parameter.ONE_CLASS ||
		   param.svm_type == svm_parameter.EPSILON_SVR ||
		   param.svm_type == svm_parameter.NU_SVR)
		{
			// regression or one-class-svm
			model.nr_class = 2;
			model.label = null;
			model.nSV = null;
			model.probA = null; model.probB = null;
			model.sv_coef = new double[1][];

			if(param.probability == 1 &&
			   (param.svm_type == svm_parameter.EPSILON_SVR ||
			    param.svm_type == svm_parameter.NU_SVR))
			{
				model.probA = new double[1];
				model.probA[0] = svm_svr_probability(prob,param);
			}

			decision_function f = svm_train_one(prob,param,0,0);
			model.rho = new double[1];
			model.rho[0] = f.rho;

			int nSV = 0;
			int i;
			for(i=0;i<prob.l;i++)
				if(Math.abs(f.alpha[i]) > 0) ++nSV;
			model.l = nSV;
			model.SV = new svm_node[nSV][];
			model.sv_coef[0] = new double[nSV];
			int j = 0;
			for(i=0;i<prob.l;i++)
				if(Math.abs(f.alpha[i]) > 0)
				{
					model.SV[j] = prob.x[i];
					model.sv_coef[0][j] = f.alpha[i];
					++j;
				}
		}
		else
		{
			// classification
			int l = prob.l;
			int[] tmp_nr_class = new int[1];
			int[][] tmp_label = new int[1][];
			int[][] tmp_start = new int[1][];
			int[][] tmp_count = new int[1][];			
			int[] perm = new int[l];

			// group training data of the same class
			svm_group_classes(prob,tmp_nr_class,tmp_label,tmp_start,tmp_count,perm);
			int nr_class = tmp_nr_class[0];			
			int[] label = tmp_label[0];
			int[] start = tmp_start[0];
			int[] count = tmp_count[0];
			svm_node[][] x = new svm_node[l][];
			int i;
			for(i=0;i<l;i++)
				x[i] = prob.x[perm[i]];

			// calculate weighted C

			double[] weighted_C = new double[nr_class];
			for(i=0;i<nr_class;i++)
				weighted_C[i] = param.C;
			for(i=0;i<param.nr_weight;i++)
			{
				int j;
				for(j=0;j<nr_class;j++)
					if(param.weight_label[i] == label[j])
						break;
				if(j == nr_class)
					System.err.print("warning: class label "+param.weight_label[i]+" specified in weight is not found\n");
				else
					weighted_C[j] *= param.weight[i];
			}

			// train k*(k-1)/2 models

			boolean[] nonzero = new boolean[l];
			for(i=0;i<l;i++)
				nonzero[i] = false;
			decision_function[] f = new decision_function[nr_class*(nr_class-1)/2];

			double[] probA=null,probB=null;
			if (param.probability == 1)
			{
				probA=new double[nr_class*(nr_class-1)/2];
				probB=new double[nr_class*(nr_class-1)/2];
			}

			int p = 0;
			for(i=0;i<nr_class;i++)
				for(int j=i+1;j<nr_class;j++)
				{
					svm_problem sub_prob = new svm_problem();
					int si = start[i], sj = start[j];
					int ci = count[i], cj = count[j];
					sub_prob.l = ci+cj;
					sub_prob.x = new svm_node[sub_prob.l][];
					sub_prob.y = new double[sub_prob.l];
					int k;
					for(k=0;k<ci;k++)
					{
						sub_prob.x[k] = x[si+k];
						sub_prob.y[k] = +1;
					}
					for(k=0;k<cj;k++)
					{
						sub_prob.x[ci+k] = x[sj+k];
						sub_prob.y[ci+k] = -1;
					}

					if(param.probability == 1)
					{
						double[] probAB=new double[2];
						svm_binary_svc_probability(sub_prob,param,weighted_C[i],weighted_C[j],probAB);
						probA[p]=probAB[0];
						probB[p]=probAB[1];
					}

					f[p] = svm_train_one(sub_prob,param,weighted_C[i],weighted_C[j]);
					for(k=0;k<ci;k++)
						if(!nonzero[si+k] && Math.abs(f[p].alpha[k]) > 0)
							nonzero[si+k] = true;
					for(k=0;k<cj;k++)
						if(!nonzero[sj+k] && Math.abs(f[p].alpha[ci+k]) > 0)
							nonzero[sj+k] = true;
					++p;
				}

			// build output

			model.nr_class = nr_class;

			model.label = new int[nr_class];
			for(i=0;i<nr_class;i++)
				model.label[i] = label[i];

			model.rho = new double[nr_class*(nr_class-1)/2];
			for(i=0;i<nr_class*(nr_class-1)/2;i++)
				model.rho[i] = f[i].rho;

			if(param.probability == 1)
			{
				model.probA = new double[nr_class*(nr_class-1)/2];
				model.probB = new double[nr_class*(nr_class-1)/2];
				for(i=0;i<nr_class*(nr_class-1)/2;i++)
				{
					model.probA[i] = probA[i];
					model.probB[i] = probB[i];
				}
			}
			else
			{
				model.probA=null;
				model.probB=null;
			}

			int nnz = 0;
			int[] nz_count = new int[nr_class];
			model.nSV = new int[nr_class];
			for(i=0;i<nr_class;i++)
			{
				int nSV = 0;
				for(int j=0;j<count[i];j++)
					if(nonzero[start[i]+j])
					{
						++nSV;
						++nnz;
					}
				model.nSV[i] = nSV;
				nz_count[i] = nSV;
			}

			System.out.print("Total nSV = "+nnz+"\n");

			model.l = nnz;
			model.SV = new svm_node[nnz][];
			p = 0;
			for(i=0;i<l;i++)
				if(nonzero[i]) model.SV[p++] = x[i];

			int[] nz_start = new int[nr_class];
			nz_start[0] = 0;
			for(i=1;i<nr_class;i++)
				nz_start[i] = nz_start[i-1]+nz_count[i-1];

			model.sv_coef = new double[nr_class-1][];
			for(i=0;i<nr_class-1;i++)
				model.sv_coef[i] = new double[nnz];

			p = 0;
			for(i=0;i<nr_class;i++)
				for(int j=i+1;j<nr_class;j++)
				{
					// classifier (i,j): coefficients with
					// i are in sv_coef[j-1][nz_start[i]...],
					// j are in sv_coef[i][nz_start[j]...]

					int si = start[i];
					int sj = start[j];
					int ci = count[i];
					int cj = count[j];

					int q = nz_start[i];
					int k;
					for(k=0;k<ci;k++)
						if(nonzero[si+k])
							model.sv_coef[j-1][q++] = f[p].alpha[k];
					q = nz_start[j];
					for(k=0;k<cj;k++)
						if(nonzero[sj+k])
							model.sv_coef[i][q++] = f[p].alpha[ci+k];
					++p;
				}
		}
		return model;
	}
	
	// Stratified cross validation
	public static void svm_cross_validation(svm_problem prob, svm_parameter param, int nr_fold, double[] target)
	{
		int i;
		int[] fold_start = new int[nr_fold+1];
		int l = prob.l;
		int[] perm = new int[l];
		
		// stratified cv may not give leave-one-out rate
		// Each class to l folds -> some folds may have zero elements
		if((param.svm_type == svm_parameter.C_SVC ||
		    param.svm_type == svm_parameter.NU_SVC) && nr_fold < l)
		{
			int[] tmp_nr_class = new int[1];
			int[][] tmp_label = new int[1][];
			int[][] tmp_start = new int[1][];
			int[][] tmp_count = new int[1][];

			svm_group_classes(prob,tmp_nr_class,tmp_label,tmp_start,tmp_count,perm);

			int nr_class = tmp_nr_class[0];
			int[] label = tmp_label[0];
			int[] start = tmp_start[0];
			int[] count = tmp_count[0]; 		

			// random shuffle and then data grouped by fold using the array perm
			int[] fold_count = new int[nr_fold];
			int c;
			int[] index = new int[l];
			for(i=0;i<l;i++)
				index[i]=perm[i];
			for (c=0; c<nr_class; c++)
				for(i=0;i<count[c];i++)
				{
					int j = i+(int)(Math.random()*(count[c]-i));
					do {int _=index[start[c]+j]; index[start[c]+j]=index[start[c]+i]; index[start[c]+i]=_;} while(false);
				}
			for(i=0;i<nr_fold;i++)
			{
				fold_count[i] = 0;
				for (c=0; c<nr_class;c++)
					fold_count[i]+=(i+1)*count[c]/nr_fold-i*count[c]/nr_fold;
			}
			fold_start[0]=0;
			for (i=1;i<=nr_fold;i++)
				fold_start[i] = fold_start[i-1]+fold_count[i-1];
			for (c=0; c<nr_class;c++)
				for(i=0;i<nr_fold;i++)
				{
					int begin = start[c]+i*count[c]/nr_fold;
					int end = start[c]+(i+1)*count[c]/nr_fold;
					for(int j=begin;j<end;j++)
					{
						perm[fold_start[i]] = index[j];
						fold_start[i]++;
					}
				}
			fold_start[0]=0;
			for (i=1;i<=nr_fold;i++)
				fold_start[i] = fold_start[i-1]+fold_count[i-1];
		}
		else
		{
			for(i=0;i<l;i++) perm[i]=i;
			for(i=0;i<l;i++)
			{
				int j = i+(int)(Math.random()*(l-i));
				do {int _=perm[i]; perm[i]=perm[j]; perm[j]=_;} while(false);
			}
			for(i=0;i<=nr_fold;i++)
				fold_start[i]=i*l/nr_fold;
		}

		for(i=0;i<nr_fold;i++)
		{
			int begin = fold_start[i];
			int end = fold_start[i+1];
			int j,k;
			svm_problem subprob = new svm_problem();

			subprob.l = l-(end-begin);
			subprob.x = new svm_node[subprob.l][];
			subprob.y = new double[subprob.l];

			k=0;
			for(j=0;j<begin;j++)
			{
				subprob.x[k] = prob.x[perm[j]];
				subprob.y[k] = prob.y[perm[j]];
				++k;
			}
			for(j=end;j<l;j++)
			{
				subprob.x[k] = prob.x[perm[j]];
				subprob.y[k] = prob.y[perm[j]];
				++k;
			}
			svm_model submodel = svm_train(subprob,param);
			if(param.probability==1 &&
			   (param.svm_type == svm_parameter.C_SVC ||
			    param.svm_type == svm_parameter.NU_SVC))
			{
				double[] prob_estimates= new double[svm_get_nr_class(submodel)];
				for(j=begin;j<end;j++)
					target[perm[j]] = svm_predict_probability(submodel,prob.x[perm[j]],prob_estimates);
			}
			else
				for(j=begin;j<end;j++)
					target[perm[j]] = svm_predict(submodel,prob.x[perm[j]]);
		}
	}

	public static int svm_get_svm_type(svm_model model)
	{
		return model.param.svm_type;
	}

	public static int svm_get_nr_class(svm_model model)
	{
		return model.nr_class;
	}

	public static void svm_get_labels(svm_model model, int[] label)
	{
		if (model.label != null)
			for(int i=0;i<model.nr_class;i++)
				label[i] = model.label[i];
	}

	public static double svm_get_svr_probability(svm_model model)
	{
		if ((model.param.svm_type == svm_parameter.EPSILON_SVR || model.param.svm_type == svm_parameter.NU_SVR) &&
		    model.probA!=null)
		return model.probA[0];
		else
		{
			System.err.print("Model doesn't contain information for SVR probability inference\n");
			return 0;
		}
	}

	public static void svm_predict_values(svm_model model, svm_node[] x, double[] dec_values)
	{
		if(model.param.svm_type == svm_parameter.ONE_CLASS ||
		   model.param.svm_type == svm_parameter.EPSILON_SVR ||
		   model.param.svm_type == svm_parameter.NU_SVR)
		{
			double[] sv_coef = model.sv_coef[0];
			double sum = 0;
			for(int i=0;i<model.l;i++)
				sum += sv_coef[i] * Kernel.k_function(x,model.SV[i],model.param);
			sum -= model.rho[0];
			dec_values[0] = sum;
		}
		else
		{
			int i;
			int nr_class = model.nr_class;
			int l = model.l;
		
			double[] kvalue = new double[l];
			for(i=0;i<l;i++)
				kvalue[i] = Kernel.k_function(x,model.SV[i],model.param);

			int[] start = new int[nr_class];
			start[0] = 0;
			for(i=1;i<nr_class;i++)
				start[i] = start[i-1]+model.nSV[i-1];

			int p=0;
			int pos=0;
			for(i=0;i<nr_class;i++)
				for(int j=i+1;j<nr_class;j++)
				{
					double sum = 0;
					int si = start[i];
					int sj = start[j];
					int ci = model.nSV[i];
					int cj = model.nSV[j];
				
					int k;
					double[] coef1 = model.sv_coef[j-1];
					double[] coef2 = model.sv_coef[i];
					for(k=0;k<ci;k++)
						sum += coef1[si+k] * kvalue[si+k];
					for(k=0;k<cj;k++)
						sum += coef2[sj+k] * kvalue[sj+k];
					sum -= model.rho[p++];
					dec_values[pos++] = sum;					
				}
		}
	}

	public static double svm_predict(svm_model model, svm_node[] x)
	{
		if(model.param.svm_type == svm_parameter.ONE_CLASS ||
		   model.param.svm_type == svm_parameter.EPSILON_SVR ||
		   model.param.svm_type == svm_parameter.NU_SVR)
		{
			double[] res = new double[1];
			svm_predict_values(model, x, res);

			if(model.param.svm_type == svm_parameter.ONE_CLASS)
				return (res[0]>0)?1:-1;
			else
				return res[0];
		}
		else
		{
			int i;
			int nr_class = model.nr_class;
			double[] dec_values = new double[nr_class*(nr_class-1)/2];
			svm_predict_values(model, x, dec_values);

			int[] vote = new int[nr_class];
			for(i=0;i<nr_class;i++)
				vote[i] = 0;
			int pos=0;
			for(i=0;i<nr_class;i++)
				for(int j=i+1;j<nr_class;j++)
				{
					if(dec_values[pos++] > 0)
						++vote[i];
					else
						++vote[j];
				}

			int vote_max_idx = 0;
			for(i=1;i<nr_class;i++)
				if(vote[i] > vote[vote_max_idx])
					vote_max_idx = i;
			return model.label[vote_max_idx];
		}
	}

	public static double svm_predict_probability(svm_model model, svm_node[] x, double[] prob_estimates)
	{
		if ((model.param.svm_type == svm_parameter.C_SVC || model.param.svm_type == svm_parameter.NU_SVC) &&
		    model.probA!=null && model.probB!=null)
		{
			int i;
			int nr_class = model.nr_class;
			double[] dec_values = new double[nr_class*(nr_class-1)/2];
			svm_predict_values(model, x, dec_values);

			double min_prob=1e-7;
			double[][] pairwise_prob=new double[nr_class][nr_class];
			
			int k=0;
			for(i=0;i<nr_class;i++)
				for(int j=i+1;j<nr_class;j++)
				{
					pairwise_prob[i][j]=Math.min(Math.max(sigmoid_predict(dec_values[k],model.probA[k],model.probB[k]),min_prob),1-min_prob);
					pairwise_prob[j][i]=1-pairwise_prob[i][j];
					k++;
				}
			multiclass_probability(nr_class,pairwise_prob,prob_estimates);

			int prob_max_idx = 0;
			for(i=1;i<nr_class;i++)
				if(prob_estimates[i] > prob_estimates[prob_max_idx])
					prob_max_idx = i;
			return model.label[prob_max_idx];
		}
		else 
			return svm_predict(model, x);
	}

	static final String svm_type_table[] =
	{
		"c_svc","nu_svc","one_class","epsilon_svr","nu_svr",
	};

	static final String kernel_type_table[]=
	{
		"linear","polynomial","rbf","sigmoid",
	};

	private static double atof(String s)
	{
		return Double.valueOf(s).doubleValue();
	}

	private static int atoi(String s)
	{
		return Integer.parseInt(s);
	}

	public static String svm_check_parameter(svm_problem prob, svm_parameter param)
	{
		// svm_type

		int svm_type = param.svm_type;
		if(svm_type != svm_parameter.C_SVC &&
		   svm_type != svm_parameter.NU_SVC &&
		   svm_type != svm_parameter.ONE_CLASS &&
		   svm_type != svm_parameter.EPSILON_SVR &&
		   svm_type != svm_parameter.NU_SVR)
		return "unknown svm type";
	
		// kernel_type
	
		int kernel_type = param.kernel_type;
		if(kernel_type != svm_parameter.LINEAR &&
		   kernel_type != svm_parameter.POLY &&
		   kernel_type != svm_parameter.RBF &&
		   kernel_type != svm_parameter.SIGMOID)
		return "unknown kernel type";

		// cache_size,eps,C,nu,p,shrinking

		if(param.cache_size <= 0)
			return "cache_size <= 0";

		if(param.eps <= 0)
			return "eps <= 0";

		if(svm_type == svm_parameter.C_SVC ||
		   svm_type == svm_parameter.EPSILON_SVR ||
		   svm_type == svm_parameter.NU_SVR)
			if(param.C <= 0)
				return "C <= 0";

		if(svm_type == svm_parameter.NU_SVC ||
		   svm_type == svm_parameter.ONE_CLASS ||
		   svm_type == svm_parameter.NU_SVR)
			if(param.nu <= 0 || param.nu > 1)
				return "nu <= 0 or nu > 1";

		if(svm_type == svm_parameter.EPSILON_SVR)
			if(param.p < 0)
				return "p < 0";

		if(param.shrinking != 0 &&
		   param.shrinking != 1)
			return "shrinking != 0 and shrinking != 1";

		if(param.probability != 0 &&
		   param.probability != 1)
			return "probability != 0 and probability != 1";

		if(param.probability == 1 &&
		   svm_type == svm_parameter.ONE_CLASS)
			return "one-class SVM probability output not supported yet";
		
		// check whether nu-svc is feasible
	
		if(svm_type == svm_parameter.NU_SVC)
		{
			int l = prob.l;
			int max_nr_class = 16;
			int nr_class = 0;
			int[] label = new int[max_nr_class];
			int[] count = new int[max_nr_class];

			int i;
			for(i=0;i<l;i++)
			{
				int this_label = (int)prob.y[i];
				int j;
				for(j=0;j<nr_class;j++)
					if(this_label == label[j])
					{
						++count[j];
						break;
					}

				if(j == nr_class)
				{
					if(nr_class == max_nr_class)
					{
						max_nr_class *= 2;
						int[] new_data = new int[max_nr_class];
						System.arraycopy(label,0,new_data,0,label.length);
						label = new_data;
						
						new_data = new int[max_nr_class];
						System.arraycopy(count,0,new_data,0,count.length);
						count = new_data;
					}
					label[nr_class] = this_label;
					count[nr_class] = 1;
					++nr_class;
				}
			}

			for(i=0;i<nr_class;i++)
			{
				int n1 = count[i];
				for(int j=i+1;j<nr_class;j++)
				{
					int n2 = count[j];
					if(param.nu*(n1+n2)/2 > Math.min(n1,n2))
						return "specified nu is infeasible";
				}
			}
		}

		return null;
	}

	public static int svm_check_probability_model(svm_model model)
	{
		if (((model.param.svm_type == svm_parameter.C_SVC || model.param.svm_type == svm_parameter.NU_SVC) &&
		model.probA!=null && model.probB!=null) ||
		((model.param.svm_type == svm_parameter.EPSILON_SVR || model.param.svm_type == svm_parameter.NU_SVR) &&
		 model.probA!=null))
			return 1;
		else
			return 0;
	}
}

*)
end.

