(**********************************************************************)
(* UCalcLIBSVMSomeClasses.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(**********************************************************************)

{

@abstract(Portage de la classe LIBSVM -- Classes annexes, associes  LIBSVM)
@author(Ricco)
@created(05/01/2006)

//!\ Abandonn les 08 janv. 2006
>>>
Nous allons tester une autre technologie, importer le code programme
 partir d'une DLL. C'est une bonne piste pour intgrer d'autres mthodes  l'avenir,
a permet aussi de voir si cette approche est viable pour enrichir  moindre cot
la bibilothque des mthodes.
<<<

}

unit UCalcLIBSVMSomeClasses;

interface

TYPE
//type de SVM
libsvm_svm_type = (st_C_SVC,st_NU_SVC,st_ONE_CLASS,st_EPSILON_SVR,st_NU_SVR);

//type de kernel
libsvm_kernel_type = (kt_LINEAR,kt_POLY,kt_RBF,kt_SIGMOID);

//paramtre d'un SVM
libsvm_svm_parameter = class
        public
        //parameters
	svm_type : libsvm_svm_type;
	kernel_type : libsvm_kernel_type;
	degree: double;	// for poly
	gamma: double;	// for poly/rbf/sigmoid
	coef0: double;	// for poly/sigmoid
	// these are for training only
	cache_size: double; // in MB
	eps: double;	// stopping criteria
	C: double;	// for C_SVC, EPSILON_SVR and NU_SVR
	nr_weight: integer;		// for C_SVC
	weight_label: array of integer;	// for C_SVC
	weight: array of double;		// for C_SVC
	nu: double;	// for NU_SVC, ONE_CLASS, and NU_SVR
	p: double;	// for EPSILON_SVR
	shrinking: integer;	// use the shrinking heuristics
	probability: integer; // do probability estimates
        //mthode
        function clone(): libsvm_svm_parameter;
        end;

//noeud svm
libsvm_svm_node = class
        public
	index: integer;
	value: double;
        end;

//tableau de SVMNode
array_svm_node = array of libsvm_svm_node;

//tableau de tableau
array_array_svm_node = array of array_svm_node;

//model SVM
libsvm_svm_model = class
        public
	param: libsvm_svm_parameter;	// parameter
	nr_class: integer;		// number of classes, = 2 in regression/one class svm
	l: integer;			// total #SV
	SV: array_array_svm_node;	// SVs (SV[l])
	sv_coef: array of array of double;	// coefficients for SVs in decision functions (sv_coef[n-1][l])
	rho: array of double;		// constants in decision functions (rho[n*(n-1)/2])
	probA: array of double;         // pariwise probability information
	probB: array of double;
	// for classification only
	_label: array of integer;		// label of each class (label[n])
	nSV: array of integer;		// number of SVs for each class (nSV[n])
				// nSV[0] + nSV[1] + ... + nSV[n-1] = l
        end;

libsvm_svm_problem = class
        public
	l: integer;
	y: array of double;
	x: array_array_svm_node;
        end;

implementation

{ libsvm_svm_parameter }

function libsvm_svm_parameter.clone: libsvm_svm_parameter;
var output: libsvm_svm_parameter;
begin
 output:= libsvm_svm_parameter.create();
 output.svm_type:= self.svm_type;
 output.kernel_type:= self.kernel_type;
 output.degree:= self.degree;	// for poly
 output.gamma:= self.gamma;	// for poly/rbf/sigmoid
 output.coef0:= self.coef0;	// for poly/sigmoid
	// these are for training only
 output.cache_size:= self.cache_size; // in MB
 output.eps:= self.eps;	// stopping criteria
 output.C:= self.C;	// for C_SVC, EPSILON_SVR and NU_SVR
 output.nr_weight:= self.nr_weight;		// for C_SVC
 //!\\ah l l, heureusement qu'il y a un compteur de rfrence sur les tableaux dynamiques !!!
 output.weight_label:= self.weight_label;	// for C_SVC
 output.weight:= self.weight;		// for C_SVC
 //** suite normale **
 output.nu:= self.nu;	// for NU_SVC, ONE_CLASS, and NU_SVR
 output.p:= self.p;	// for EPSILON_SVR
 output.shrinking:= self.shrinking;	// use the shrinking heuristics
 output.probability:= self.probability; // do probability estimates
 //and then...
 result:= output;
end;

end.
