(********************************************************************)
(* UCalcSpvMLPStructure.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(********************************************************************)

{
@abstract(Structure d'un perceptron multi-couches)
@author(Ricco)
@created(12/01/2004)
Mieux vaut externaliser, on pourra vraisemblement en rutiliser une partie pour la suite,
cf. par exemple un RBF
}
unit UCalcSpvMLPStructure;

interface

USES
        UDatasetDefinition;

TYPE
        {le type de donnes pour les poids dans le rseau}
        TypeNeuronWeight = double;

CONST
        {taille du poids}
        SIZE_NEURON_WEIGHT = sizeof(TypeNeuronWeight);

        {nombre de couches max}
        MAX_NB_LAYERS_MLP = 3;//input, hidden, output

TYPE
        {poids (coef.) associs  un neurone, il s'agit de poids en entre, l'indice 0 est pour la constante}
        TWeight = array[0..MAX_NB_VALUES_CATEGORICAL] of TypeNeuronWeight;
        TPtrWeight = ^TWeight;

        {un neurone}
        TNeuron = record
                   Weight : TPtrWeight;
                   OutputValue: TypeNeuronWeight;
                   ErrorValue: TypeNeuronWeight;
                  end;

        {une couche du rseau MLP}
        TNNLayer = array[1..MAX_NB_ATTRIBUTES] of TNeuron;
        TPtrNNLayer = ^TNNLayer;

        {la structure de rseau - 3 couches au max.}
        TNNStructure = array[1..MAX_NB_LAYERS_MLP] of TPtrNNLayer;
        TPtrNNStructure = ^TNNStructure;

implementation

end.
