(***************************************************************)
(* UDlgOpPrmSpvMLP.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(***************************************************************)

unit UDlgOpPrmSpvMLP;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, StdCtrls, CheckLst, ComCtrls,
  ExtCtrls, lmdstdcA, LMDCustomControl, LMDCustomPanel,
  LMDCustomBevelPanel, LMDBaseEdit, LMDCustomEdit, LMDCustomMaskEdit,
  LMDMaskEdit;

type
  TDlgOpPrmSpvMLP = class(TDlgBaseOperatorParameter)
    PageControl1: TPageControl;
    tabNetwork: TTabSheet;
    tabLearning: TTabSheet;
    tabStop: TTabSheet;
    chkHiddenLayer: TCheckBox;
    Label1: TLabel;
    spinHiddenNeurons: TLMDSpinEdit;
    Label2: TLabel;
    edLRate: TLMDMaskEdit;
    edTestSample: TLMDMaskEdit;
    Label3: TLabel;
    rgAtt: TRadioGroup;
    Label4: TLabel;
    Label5: TLabel;
    chkErrStagnation: TCheckBox;
    spinMaxIter: TLMDSpinEdit;
    edThresoldError: TLMDMaskEdit;
    spinGapTestStagnation: TLMDSpinEdit;
    Label6: TLabel;
  private
  public
  procedure   ApplyModifications(); override;
  procedure   SetParameters(); override;
  end;

var
  DlgOpPrmSpvMLP: TDlgOpPrmSpvMLP;

implementation

uses UCompSpvMLPerceptron;

{$R *.dfm}

{ TDlgOpPrmSpvMLP }

procedure TDlgOpPrmSpvMLP.ApplyModifications;
var prm: TOpPrmSpvMLP;
begin
 prm:= OpPrm as TOpPrmSpvMLP;
 //enquiller inverse
 prm.UseHiddenLayer:= self.chkHiddenLayer.Checked;
 prm.NbHiddenNeurons:= self.spinHiddenNeurons.Value;
 prm.LearningRate:= StrToFloat(self.edLRate.Text);
 prm.PropTestSample:= strtofloat(self.edTestSample.Text);
 prm.AttTransform:= self.rgAtt.ItemIndex;
 prm.MaxIteration:= self.spinMaxIter.Value;
 prm.ThresoldErrorRate:= strtofloat(self.edThresoldError.Text);
 prm.UseTestErrStagnation:= self.chkErrStagnation.Checked;
 prm.NbTestErrStagnation:= self.spinGapTestStagnation.Value;
end;

procedure TDlgOpPrmSpvMLP.SetParameters;
var prm: TOpPrmSpvMLP;
begin
 prm:= OpPrm as TOpPrmSpvMLP;
 //enquiller
 self.chkHiddenLayer.Checked:= prm.UseHiddenLayer;
 self.spinHiddenNeurons.Value:= prm.NbHiddenNeurons;
 self.edLRate.Text:= format('%.4f',[prm.LearningRate]);
 self.edTestSample.Text:= format('%.2f',[prm.PropTestSample]);
 self.rgAtt.ItemIndex:= prm.AttTransform;
 self.spinMaxIter.Value:= prm.MaxIteration;
 self.edThresoldError.Text:= format('%.2f',[prm.ThresoldErrorRate]);
 self.chkErrStagnation.Checked:= prm.UseTestErrStagnation;
 self.spinGapTestStagnation.Value:= prm.NbTestErrStagnation;
end;

end.
