(*************************************************************************)
(* UCalcSpvMutlinomialLogReg.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(*************************************************************************)

{
@abstract(Rgression logistique multinomiale -- Classe de calcul)
@author(Ricco)
@created(18/04/2005)

Traduction directe de Logistic.java de WEKA (3-4-4)
>> Revision : 1.32

La procdure d'optimisation est diffrente en revanche, on utilise les procdures de la bibliothque ATHANOR pour l'instant
Il est possible avec l'inverse de la matrice hessienne d'obtenir des stats si l'on veut ( voir...)

}
unit UCalcSpvMutlinomialLogReg;

interface

USES
   UDatasetExamples,
   UCompSpvLDefinition,
   UDatasetDefinition,
   UCalcDistribution,
   UCalcSpvStructScore,
   d6_matrices, d6_fmath;

TYPE

 //type d'optimisation
 TEnumOptLogistic = (optMLR_Marquardt, optMLR_BFGS, optMLR_BFGSGradient, optMLR_ConjugateGradient);

CONST
 //chanes de description
 STR_OPT_LOGISTIC : array[TEnumOptLogistic] of string = ('Marquardt','BFGS','BFGS with supplied gradient','Conjugate gradient');

TYPE
 //classe de calcul
 TLogistic = class(TCalcSpvLearning)
  private
  //mthode d'optimisation utilise
  FOptMethod: TEnumOptLogistic;
  //Code d'erreur renvoye par la procdure d'optimisation
  FErrCodeOptimization: integer;
  //compteur de nombde d'appels de la fonction de vraisemblance
  FLLCall: integer;
  //****
  //**** variables temporaires pour viter les allocs. dsallocs
  //****
  //Tableau pour coefs.
  FTempExpo: TVector;
  //** The coefficients (optimized parameters) of the model -- protected double [][] m_Par;
  m_Par: TMatrix;
  //** The data saved as a matrix --  protected double [][] m_Data;
  m_Data: TMatrix;
  //** The number of attributes in the model -- protected int m_NumPredictors;
  //R.R. attention, pour lui cela inclut l'attribut-classe
  m_NumPredictors: integer;
  //** The index of the class attribute -- protected int m_ClassIndex;
  //** The number of the class labels -- protected int m_NumClasses;
  m_NumClasses: integer;
  //* An attribute filter -- private RemoveUseless m_AttFilter;
  //** The filter used to make attributes numeric. -- private NominalToBinary m_NominalToBinary;
  //** The filter used to get rid of missing values. -- private ReplaceMissingValues m_ReplaceMissingValues;
  //** Debugging output -- protected boolean m_Debug;
  //** Log-likelihood of the searched model --  protected double m_LL;
  m_LL: float;
  //******* PARAMETRES DE L'ALGO *************************************
  //** The ridge parameter. -- protected double m_Ridge = 1e-8;
  m_Ridge: double;
  //** The maximum number of iterations. -- private int m_MaxIts = -1;
  m_MaxIts: integer;
  //******************************************************************
  //private double[] evaluateProbability(double[] data)
  function evaluateProbability(const data: TVector): TVector;
  //protected double[] evaluateGradient(double[] x)
  //new -- 20/04/2005 -- moins efficace que la drivation empirique approche ???
  procedure evaluateGradient(Func: TFuncNVar; X: TVector; Lbound, Ubound: Integer; Grad: TVector);
  protected
  //class labels
  Y: array of integer;
  //coefficients
  FCoef: TVector;
  //l'inverse de la matrice hessienne
  FHInv: TMatrix;
  //vider les structures
  procedure   destroyStructures(); override;
  //public double [] distributionForInstance(Instance instance)
  function distributionForInstance(instance: integer): TVector;
  ////protected double objectiveFunction(double[] x) -- la fonction objectif  optimiser
  function objectiveFunction(X: TVector): float;
  //standard  surcharger dans les structures TANAGRA
  function    coreLearning(examples: TExamples): boolean; override;
  public
  procedure   getScore(example: integer; var postProba: TTabScore); override;
  function    getHTMLResults(): string; override;
 end;

implementation

USES
   Sysutils, Windows,
   Math, d6_optim, ULogFile, UCompSpvMultinomialLogReg, UConstConfiguration;

CONST
        //tolrance pour l'optimisation
        TOLERANCE_OPTIMIZATION_LOGISTIC = 1.0e-6;
        //en-dea de cette valeur, on considre que l'cart-type est null -- cas extrme, a vite les plantages
        EPSILON_FOR_STD_DEV_COMPUTED = 1.0e-5;

{ TLogistic }

function TLogistic.distributionForInstance(
  instance: integer): TVector;
var instDat: TVector;
    distribution: TVector;
    j,k: integer;
begin

 // Extract the predictor columns into an array
 setLength(instDat,m_NumPredictors + 1);
 
 j:= 1;
 instDat[0]:= 1.0;

 for k:= 0 to pred(m_NumPredictors) do
  begin
   instDat[j]:= self.Descriptors.Attribute[k].cValue[instance];
   inc(j);
  end;

 distribution:= self.evaluateProbability(instDat);
 result:= distribution;

 //par acquit de conscience... de toute manire le compteur de rfrence devrait faire son boulot
 Finalize(instDat);

end;

function TLogistic.evaluateProbability(const data: TVector): TVector;
var prob, v: TVector;
    j,k,m,n: integer;
    //sum: double;
    sum: extended;
    proba: extended;
begin
  setLength(prob,m_NumClasses);
  setLength(v,m_NumClasses);

  // Log-posterior before normalizing
  for j:= 0 to m_NumClasses-2 do
   begin
    for k:= 0 to m_NumPredictors do
     begin
      v[j]:= v[j]+m_Par[k,j]*data[k];
     end;
   end;

  v[m_NumClasses-1] := 0;

  // Do so to avoid scaling problems
  for m:= 0 to pred(m_NumClasses) do
   begin
    sum:= 0.0;
    for n:= 0 to m_NumClasses-2 do
     sum:= sum+EXP(v[n]-v[m]);
    //calcul temporaire dans un cadre plus grand
    proba:= 1.0/(sum+EXP(-1.0*v[m]));
    //pour le cast agisse rellement en dernier lieu
    prob[m]:= proba;
   end;

  //vider explicitement pour moi
  Finalize(v);

  //and then...
  result:= prob;

end;

function TLogistic.objectiveFunction(X: TVector): float;
var //nll: double;
    dim: integer;
    i,j,index,offset,r: integer;
    //expo: TVector;
    //max,num,denom: double;
    //pour reculer l'apparition des dbordements
    nll: extended;
    max,num,denom: extended;

    function maxIndex(const tab: TVector): integer;
    var newMax: double;
        id: integer;
    begin
     result:= 0;
     newMax:= tab[0];
     for id:= succ(low(tab)) to high(tab) do
      begin
       if (tab[id]>newMax)
        then
         begin
          newMax:= tab[id];
          result:= id;
         end;
      end;
    end;
    
begin
      //pour viter les messages "warning" du compilateur
      max:= 0.0;
      denom:= 0.0;

      //incrmenter le nombre d'appel  la fonction de vraisemblance
      inc(FLLCall);

TRY
      nll := 0.0; // -LogLikelihood
      dim := m_NumPredictors+1; // Number of variables per class

      //for i-th instance
      for i:=0 to pred(Length(Y)) do
      begin
       
       //mettre  zro toutes les valeurs -- rz
       //for j:= low(FTempExpo) to high(FTempExpo) do FTempExpo[j]:= 0.0;
       FillChar(FTempExpo[0],sizeof(float)*pred(m_NumClasses),0);

       //produit scalaire
       for offset:= 0 to m_NumClasses-2 do
       begin
	  	index := offset * dim;
       for j:= 0 to pred(dim) do
	    	FTempExpo[offset] := FTempExpo[offset] + m_Data[i][j]*x[index + j];
		end;
		
	   max := FTempExpo[maxIndex(FTempExpo)];

      //danger de dbordement de capacit
      //#ToDo1 -- comment protger sans gner l'optimisation ? -- on est pass  des EXTENDED ! 20/04/2005
      denom := SYSTEM.EXP(-max);

	   
	   if (Y[i] = m_NumClasses - 1)
      then
      begin
	    // Class of this instance
	    num := -max;
      end
	   else
      begin
	    num := FTempExpo[Y[i]] - max;
      end;
	    
      for offset:= 0 to m_NumClasses-2 do
      begin
	  	denom := denom + SYSTEM.EXP(FTempExpo[offset] - max);
      end;

      if(denom>0)
      then nll := nll - 1.0*(num - LN(denom)); // Weighted NLL
       
      end;
	    
      // Ridge: note that intercepts NOT included
      for offset:= 0 to m_NumClasses-2 do
      begin
       for r:= 1 to pred(dim) do
	  	 nll := nll + m_Ridge*x[offset*dim+r]*x[offset*dim+r];
      end;

      result:= nll;

EXCEPT

      on e: exception do
       begin
       TraceLog.WriteToLogFile(Format('[MLR] error LL function == %s at call = %d (max:%.4f, denom:%.4f)',[e.Message,FLLCall,max,denom]));
       result:= 0.0001*MATH.MaxDouble;
       end;

END;


end;

function TLogistic.coreLearning(examples: TExamples): boolean;
var nK,nR,nC: integer;
    xMean,xSD,sY: array of double;
    i,j,k: integer;
    value: double;
    p,q,offset: integer;
    tps: cardinal;
    err_optim: boolean;
begin

    //TraceLog.WriteToLogFile('[MLR] >> appel CORE_LEARNING');

TRY
    //*** rcupration des paramtres **************
    m_MaxIts:= (self.OpPrmSpv as TOpPrmSpvMLR).MaxIteration;
    m_Ridge:= (self.OpPrmSpv as TOpPrmSpvMLR).Ridge;
    FOptMethod:= (self.OpPrmSpv as TOpPrmSpvMLR).OptMethod;
    //**********************************************

    tps:= GetTickCount();

    // Extract data
    m_NumClasses := self.ClassAttribute.nbValues;
    m_NumPredictors:= self.Descriptors.Count;

    //nK = m_NumClasses - 1;                     // Only K-1 class labels needed
    nK:= m_NumClasses - 1;
    //nR = m_NumPredictors = train.numAttributes() - 1;
    nR:= m_NumPredictors;
    //int nC = train.numInstances();
    nC:= examples.Size;

    //m_Data = new double[nC][nR + 1];               // Data values
    setLength(m_Data,nC,nR+1);
    //int [] Y  = new int[nC];                       // Class labels
    setLength(Y,nC);
    //double [] xMean= new double[nR + 1];           // Attribute means
    setLength(xMean,nR+1);
    //double [] xSD  = new double[nR + 1];           // Attribute stddev's
    setLength(xSD,nR+1);
    //double [] sY = new double[nK + 1];             // Number of classes
    setLength(sY,nK+1);
    //double [] weights = new double[nC];            // Weights of instances
    //double totWeights = 0;                         // Total weights of the instances
    //m_Par = new double[nR + 1][nK];                // Optimized parameter values
    setLength(m_Par,nR+1,nK);

    //for (int i = 0; i < nC; i++) {
	 for i:= 0 to pred(NC) do
    begin
      // initialize X[][]
      //Instance current = train.instance(i);
      //Y[i] = (int)current.classValue();  // Class value starts from 0
      Y[i]:= pred(self.ClassAttribute.dValue[examples.Number[succ(i)]]);
      //weights[i] = current.weight();     // Dealing with weights
      //totWeights += weights[i];

      m_Data[i][0] := 1;
      j := 1;

      //for (int k = 0; k <= nR; k++) {
      for k:= 0 to pred(nR) do
      begin
       value:= self.Descriptors.Attribute[k].cValue[examples.Number[succ(i)]];
       m_Data[i][j]:= value;
       xMean[j]:= xMean[j]+value;
       xSD[j]:= xSD[j]+value*value;

       inc(j);
      end;

      // Class count
      //sY[Y[i]]++;
      sY[Y[i]]:= sY[Y[i]] + 1.0; 	
    end;
	
    xMean[0] := 0; xSD[0] := 1;
    for j:= 1 to nR do
     begin
      xMean[j]:= xMean[j]/(1.0*nC);
      xSD[j]:= SQRT(ABS(xSD[j]-1.0*nC*xMean[j]*xMean[j])/(-1.0+nC));
     end;

	
    // Normalise input data
    for i:= 0 to pred(nC) do
     begin
      for j:= 0 to nR do
       if (xSD[j] > EPSILON_FOR_STD_DEV_COMPUTED)
        then m_data[i][j]:= (m_Data[i][j] - xMean[j])/xSD[j]
        else m_data[i][j]:= 0.0;
     end;

    //prparer les paramtres de l'optimisation
    setLength(FCoef,(nR+1)*nK);

    // Initialize
    for p:= 0 to pred(nK) do
     begin
      offset:= p*(nR+1);
      FCoef[offset] :=  LN(sY[p]+1.0) - LN(sY[nK]+1.0); // Null model
      for q:= 1 to nR do
       begin
	     FCoef[offset+q] := 0.0;
       end;
     end;

    //ouah... j'ai peur... mais bon  moins de tout r-crire la procdure d'optimisation... 
    setLength(FHInv,(nR+1)*nK,(nR+1)*nK);

    tps:= GetTickCount()-tps;
    TraceLog.WriteToLogFile(Format('[MLR] prepa data duration = %d ms.',[tps]));

    tps:= GetTickCount();
    //****** lancer l'optimisation  partir d'ici ********
    FLLCall:= 0;
    setLength(FTempExpo,m_NumClasses-1);
    //run...
    TRY
    err_optim:= false;
    //slectionner la bonne mthode d'optimisation
    case FOptMethod of
     optMLR_BFGS : FErrCodeOptimization:= d6_optim.BFGS(objectiveFunction,d6_optim.NumGradient,FCoef,0,(nR+1)*nK-1,m_MaxIts,TOLERANCE_OPTIMIZATION_LOGISTIC,m_LL,FHInv);
     optMLR_BFGSGradient : FErrCodeOptimization:= d6_optim.BFGS_OBJECT(objectiveFunction,evaluateGradient,FCoef,0,(nR+1)*nK-1,m_MaxIts,TOLERANCE_OPTIMIZATION_LOGISTIC,m_LL,FHInv);
     optMLR_ConjugateGradient : d6_optim.NASH_CONJUGATE_GRADIENT(objectiveFunction,d6_optim.NumGradient,FCoef,0,(nR+1)*nK-1,m_MaxIts,TOLERANCE_OPTIMIZATION_LOGISTIC,m_LL)
     else FErrCodeOptimization:= d6_optim.Marquardt(objectiveFunction,d6_optim.NumHessGrad,FCoef,0,(nR+1)*nK-1,m_MaxIts,TOLERANCE_OPTIMIZATION_LOGISTIC,m_LL,FHInv);
    end;
    EXCEPT
    on e: Exception do
     begin
     TraceLog.WriteToLogFile(format('[MLR] error during >> optimization << call == %s',[e.Message]));
     err_optim:= true;
     end;
    END;

    //and then...
    tps:= GetTickCount()-tps;
    TraceLog.WriteToLogFile(format('[MLR] number of likelihood call = %d, optimisation duration = %d ms.',[FLLCall,tps]));

    // Don't need data matrix anymore
    Finalize(m_Data);
    Finalize(FTempExpo);

    //sortie directe si erreur  l'optimisation
    if err_optim
     then
      begin
       Result:= FALSE;
       EXIT;
      end;


    //m_Par = new double[nR + 1][nK];                // Optimized parameter values
    setLength(m_Par,nR+1,nK);
    // Convert coefficients back to non-normalized attribute units

    for i:= 0 to pred(nK) do
     begin
      m_Par[0][i]:= FCoef[i*(nR+1)];
      for j:= 1 to nR do
       begin
        m_Par[j][i] := FCoef[i*(nR+1)+j];
        if (xSD[j]> EPSILON_FOR_STD_DEV_COMPUTED)
         then
          begin
            m_Par[j][i] := m_Par[j][i]/xSD[j];
            m_Par[0][i] := m_Par[0][i] - m_Par[j][i] * xMean[j];
          end
         else m_Par[j][i] := 0.0;//puisqu'il n'a pas particip  l'apprentissage
       end;
     end;

    //and then....
    Result:= TRUE;
    //TraceLog.WriteToLogFile('[MLR] << CORE_LEARNING success');
EXCEPT
on e: exception do
 begin
   TraceLog.WriteToLogFile(format('[MLR] error during >> corelearning << call == %s',[e.Message]));
   Result:= FALSE;
 end;
END;

end;

procedure TLogistic.destroyStructures;
begin
 Finalize(FCoef);
 Finalize(FHInv);
end;

procedure TLogistic.getScore(example: integer; var postProba: TTabScore);
var prob: TVector;
    k: integer;
begin
 prob:= self.distributionForInstance(example);
 //calculer la proba d'affectation
 for k:= 0 to pred(self.m_NumClasses) do
  postProba[succ(k)]:= prob[k];
 //vider
 Finalize(prob);
end;

function TLogistic.getHTMLResults: string;
var s: string;
    k,j: integer;
    orC: double;
begin
 s:= '';
 if (FErrCodeOptimization = OPT_NON_CONV)
  then s:= Format('<BLINK>Carreful -- No convergence after %d iterations </BLINK>',[m_MaxIts]);

 s:= s+'<H3>Results</H3>'; 
 s:= s+HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_DATA_BLUE+format('<TD>Class attribute</TD><TD>%s</TD></TR>',[ClassAttribute.Name]);
 s:= s+HTML_TABLE_COLOR_DATA_BLUE+format('<TD>Class-value reference</TD><TD>%s</TD></TR>',[ClassAttribute.LstValues.getDescription(ClassAttribute.nbValues)]);
 s:= s+HTML_TABLE_COLOR_DATA_BLUE+'<TD>-2 Log Likelihood</TD>'+format('<TD>'+STR_FORMAT_VIEW_STAT_ACCURACY+'</TD></TR>',[2.0*m_LL]);
 s:= s+'</table>';

 //***********************************************************************************************//
 //description des coefficients pour chaque modalit de Y, sauf la dernire qui est la rfrence  //
 //***********************************************************************************************//

 s:= s+'<H3>Coefficients</H3>';
 s:= s+HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<TD>Descriptor</TD>';
 for k:= 1 to pred(m_NumClasses) do
  s:= s+format('<TD>Value = %s</TD>',[ClassAttribute.LstValues.getDescription(k)]);
 s:= s+'</TR>';

 //les variables
 for j:= 1 to m_NumPredictors do
  begin
   s:= s+HTML_TABLE_COLOR_DATA_GRAY;
   s:= s+format('<TD>%s</TD>',[self.Descriptors.Attribute[pred(j)].Name]);
   for k:= 1 to pred(m_NumClasses) do
    s:= s+format('<TD align=right>%.4f</TD>',[m_Par[j][pred(k)]]);
   s:= s+'</TR>';
  end;
 //la constante
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+'<TD>Intercept</TD>';
 for k:= 1 to pred(m_NumClasses) do
  s:= s+format('<TD align=right>%.4f</TD>',[m_Par[0][pred(k)]]);
 s:= s+'</table>';

 //**********************************************************************************************//
 //description des odds ratios pour chaque modalit de Y, sauf la dernire qui est la rfrence  //
 //**********************************************************************************************//

 s:= s+'<H3>Odds Ratios</H3>';
 s:= s+HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<TD>Descriptor</TD>';
 for k:= 1 to pred(m_NumClasses) do
  s:= s+format('<TD>Value = %s</TD>',[ClassAttribute.LstValues.getDescription(k)]);
 s:= s+'</TR>';

 //les variables
 for j:= 1 to m_NumPredictors do
  begin
   s:= s+HTML_TABLE_COLOR_DATA_GRAY;
   s:= s+format('<TD>%s</TD>',[self.Descriptors.Attribute[pred(j)].Name]);
   for k:= 1 to pred(m_NumClasses) do
    begin
     //protgeons
     if (m_Par[j][pred(k)] > 709)
      then orC:= 1e+11
      else orC:= EXP(m_Par[j][pred(k)]);
     //encore...
     if (orC>1e+10)
      then s:= s+'<TD align=right>">1.0e+10"</TD>'
      else s:= s+format('<TD align=right>%.4f</TD>',[orC]);
    end;
   s:= s+'</TR>';
  end;
 s:= s+'</table>';

 result:= s;
end;

procedure TLogistic.evaluateGradient(Func: TFuncNVar; X: TVector; Lbound,
  Ubound: Integer; Grad: TVector);
var dim,i,index,offset,j,q,p,r: integer;
    num: TVector;
    _exp,max,denom,firstterm: extended;


    //Utils.maxIndex
    function maxIndex(const tab: TVector): integer;
    var newMax: double;
        id: integer;
    begin
     result:= 0;
     newMax:= tab[0];
     for id:= succ(low(tab)) to high(tab) do
      begin
       if (tab[id]>newMax)
        then
         begin
          newMax:= tab[id];
          result:= id;
         end;
      end;
    end;

  //Utils.normalize
  procedure normalize(var doubles: TVector; sum: extended);
  var id: integer; 
  begin

    if (sum <> 0)
     then
      begin
       for id:= low(doubles) to high(doubles) do
        doubles[id]:= doubles[id]/sum;
      end;
  end;

begin
      TRY
      //
      setLength(num,m_NumClasses-1);

      //double[] grad = new double[x.length];
      FillChar(grad[0],sizeof(float)*pred(length(x)),0);
      
      dim := m_NumPredictors+1; // Number of variables per class

      for i:= 0 to pred(Length(Y)) do
      begin // ith instance
		//double[] num=new double[m_NumClasses-1]; // numerator of [-log(1+sum(exp))]'
       FillChar(num[0],sizeof(float)*pred(m_NumClasses),0);

		//int index;
		//for(int offset=0; offset<m_NumClasses-1; offset++)
       for offset:= 0 to m_NumClasses-2 do
       begin// Which part of x
	  		_exp:= 0.0;
	  		index := offset * dim;
	  		//for(int j=0; j<dim; j++)
           for j:= 0 to pred(dim) do
	    		//exp += m_Data[i][j]*x[index + j];
               _exp:= _exp+m_Data[i][j]*x[index + j];
	  		num[offset] := _exp;
		end;

		max := num[maxIndex(num)];
		denom := EXP(-max); // Denominator of [-log(1+sum(exp))]'
       
		//for(int offset=0; offset<m_NumClasses-1; offset++)
       for offset:= 0 to m_NumClasses-2 do
		begin
	  		num[offset] := EXP(num[offset] - max);
	  		//denom += num[offset];
           denom:= denom+num[offset];
		end;

		normalize(num, denom);

		// Update denominator of the gradient of -log(Posterior)
		//double firstTerm;
		//for(int offset=0; offset<m_NumClasses-1; offset++)
       for offset:= 0 to m_NumClasses-2 do
		begin // Which part of x
	  		index := offset * dim;
	  		//firstTerm = weights[i] * num[offset];
           firstTerm := 1.0 * num[offset];
	  		//for(int q=0; q<dim; q++)
           for q:= 0 to pred(dim) do
	  		begin
	    		grad[index + q]:= grad[index + q] + firstTerm * m_Data[i][q];
	  		end;
		end;

		if(Y[i] <> m_NumClasses-1)
       then
		begin 	// Not the last class
	  		//for(int p=0; p<dim; p++)
           for p:= 0 to pred(dim) do
	  		begin
	    		grad[Y[i]*dim+p]:= grad[Y[i]*dim+p] - 1.0*m_Data[i][p];
	  		end;
		end;

      end;//du for i

      // Ridge: note that intercepts NOT included
      //for(int offset=0; offset<m_NumClasses-1; offset++)
      for offset:= 0 to m_NumClasses-2 do
      begin
		//for(int r=1; r<dim; r++)
       for r:= 1 to pred(dim) do
	  		grad[offset*dim+r]:= grad[offset*dim+r] + 2.0*m_Ridge*x[offset*dim+r];
      end;

      // ****************************************************************************************************
      // new -- 20/04/2005 -- R.R.
      // new -- changement de la dfinition de la direction pour tre compatible avec la bibliothque ATHANOR
      // ****************************************************************************************************
      for offset:= 0 to m_NumClasses-2 do
      begin
       for r:= 0 to pred(dim) do
	  		grad[offset*dim+r]:= -1.0*grad[offset*dim+r];
      end;
      // ****************************************************************************************************

      //return grad;
      Finalize(num);

      EXCEPT
       on e: exception do
        TraceLog.WriteToLogFile(format('[MLR] error in Gradient Evaluation == %s',[e.Message]));
      END;

end;

end.

