unit UDlgOpPrmSpvNaiveBayes;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, ComCtrls, StdCtrls, ExtCtrls;

type
  TDlgOpPrmSpvNaiveBayes = class(TDlgBaseOperatorParameter)
    chkShowCondDist: TCheckBox;
    rgUseLaplacian: TRadioGroup;
    edLambda: TEdit;
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    procedure   ApplyModifications(); override;
    procedure   SetParameters(); override;    
  end;

var
  DlgOpPrmSpvNaiveBayes: TDlgOpPrmSpvNaiveBayes;

implementation

uses UCompSpvNaiveBayes;

{$R *.dfm}

{ TDlgOpPrmSpvNaiveBayes }

procedure TDlgOpPrmSpvNaiveBayes.ApplyModifications;
begin
 (self.OpPrm as TOpPrmNaiveBayes).showCondDist:= self.chkShowCondDist.Checked;
 (self.OpPrm as TOpPrmNaiveBayes).useLaplacian:= self.rgUseLaplacian.ItemIndex;
 TRY
 (self.OpPrm as TOpPrmNaiveBayes).lambdaLaplacian:= StrToFloat(self.edLambda.Text);
 EXCEPT
 (self.OpPrm as TOpPrmNaiveBayes).lambdaLaplacian:= 1.0;
 END;
end;

procedure TDlgOpPrmSpvNaiveBayes.SetParameters;
begin
 self.chkShowCondDist.Checked:= (self.OpPrm as TOpPrmNaiveBayes).showCondDist;
 self.rgUseLaplacian.ItemIndex:= (self.OpPrm as TOpPrmNaiveBayes).useLaplacian;
 self.edLambda.Text:= FloatToStr((self.OpPrm as TOpPrmNaiveBayes).lambdaLaplacian);
end;

end.
