(************************************************************)
(* UCompSpvCPLS.pas - Copyright (c) 2006 Ricco RAKOTOMALALA *)
(************************************************************)

{
@abstract(PLS pour la discrimination)
@author(Ricco)
@created(08/03/2006)

La rgression PLS est dfinie pour la rgression, on peut en driver facilement,
tout comme la rgression linaire multiple d'ailleurs, un algorithme d'apprentissage
adapt pour la discrimination.

Utilisation de la classe de calcul PLS implmente par Jean-Franois Grange (JFGCalcPLS.pas)

}

unit UCompSpvCPLS;

interface

USES
       Classes, Forms, IniFiles,
       UCompDefinition,
       UCompSpvLDefinition,
       UOperatorDefinition,
       UDatasetImplementation,
       UDatasetExamples, UCalcSpvStructScore, UDatasetDefinition,
       JFGCalcPLS;

TYPE
       TMLGCompSpvCPLS = class(TMLGenCompSpvLearning)
                        public
                        function    GetClassMLComponent: TClassMLComponent; override;
                        end;

       TMLCompSpvCPLS = class(TMLCompSpvLearning)
                       protected
                       function    getClassOperator: TClassOperator; override;
                       function    GetLogResultDescription(): string; override;
                       end;

       TOpSpvCPLS = class(TOpSpvLearningContinuous)
                   protected
                   function    getClassParameter: TClassOperatorParameter; override;
                   function    getClassSpvLearning(): TClassCalcSpvLearning; override;
                   function    ConnectDescriptors(prmData: TMLDataset): boolean; override;
                   end;

       TOpPrmCPLS = class(TOpPrmSpvLearning)
                   private
                   //nombre d'axes  retenir
                   FNbAxis: integer;
                   protected
                   function    CreateDlgParameters(): TForm; override;
                   procedure   SetDefaultParameters(); override;
                   public
                   function    getHTMLParameters(): string; override;
                   procedure   LoadFromStream(prmStream: TStream); override;
                   procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                   procedure   SaveToStream(prmStream: TStream); override;
                   procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                   property    NbAxis: integer read FNbAxis write FNbAxis;
                   end;

       //classe de calcul, son rle est d'appeler la classe de JFG
       TCalcSpvPLS = class(TCalcSpvLearning)
                     private
                     //oprateur de calcul
                     FCalc: TCalcPLS;
                     //liste factice pour l'attribut classe
                     FLstClassAtt: TLstAttributes;
                     //tableaux intermdiaires pour le classement
                     FTabY: TVectorPLS;
                     protected
                     procedure   createStructures(); override;
                     procedure   destroyStructures(); override;
                     public
                     //surcharge normale dans la hirachie
                     function    coreLearning(examples: TExamples): boolean; override;
                     //prospective totale -- utiliser une fonction logistique sur la sortie
                     procedure   getScore(example: integer; var postProba: TTabScore); override;
                     //comparer au seuil 0 (si output <= 0 alors c = 1 sinon c = 2
                     procedure   classification(example: integer; var response: TTypeDiscrete); override;
                     //description des rsultats
                     function    getHTMLResults(): string; override;
                     end;



implementation

USES
    Math,
    Sysutils, UConstConfiguration, UDlgOpPrmSVM, UDlgOpPrmSpvCPLS;

{ TMLGCompSpvCPLS }

function TMLGCompSpvCPLS.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSpvCPLS;
end;

{ TMLCompSpvCPLS }

function TMLCompSpvCPLS.getClassOperator: TClassOperator;
begin
 result:= TOpSpvCPLS;
end;

function TMLCompSpvCPLS.GetLogResultDescription: string;
begin
 result:= format('CPLS result generated [%s]',[self.Description]);
end;

{ TOpSpvCPLS }

function TOpSpvCPLS.ConnectDescriptors(prmData: TMLDataset): boolean;
var ok: boolean;
begin
 TRY
 //accepter les prdicteurs quasi-continus, i.e. continus ou discrets binaires
 ok:= (prmData.LstAtts[asInput].Count > 0) AND (prmData.LstAtts[asInput].isAllCategory(caQuasiContinue));
 if ok then FDescriptorsAtt:= prmData.LstAtts[asInput];//branchement direct, pas de recopie locale
 //uniquement pbm binaire rsolu !
 ok:= ok and (self.ClassAttribute.nbValues = 2);
 EXCEPT
 ok:= FALSE;
 END;
 //and then...
 result:= ok;
end;

function TOpSpvCPLS.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmCPLS;
end;

function TOpSpvCPLS.getClassSpvLearning: TClassCalcSpvLearning;
begin
 result:= TCalcSpvPLS;
end;

{ TOpPrmCPLS }

function TOpPrmCPLS.CreateDlgParameters: TForm;
begin
 result:= TdlgOpPrmSpvCPLS.CreateFromOpPrm(self);
end;

function TOpPrmCPLS.getHTMLParameters: string;
var s: string;
begin
 s:= HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<TH colspan=2>C-PLS parameters</TH></TR>';
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+'<TD>Att. transformation</TD><TD align=right>Standardize</TD></TR>';
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD># axis</TD><TD align=right>%d</TD></TR>',[FNbAxis]);
 s:= s+'</table>';
 result:= s;
end;

procedure TOpPrmCPLS.LoadFromINI(prmSection: string; prmINI: TMemIniFile);
begin
 FNbAxis:= prmINI.ReadInteger(prmSection,'nb_axis',FNbAxis);
end;

procedure TOpPrmCPLS.LoadFromStream(prmStream: TStream);
begin
 prmStream.ReadBuffer(FNbAxis,sizeof(FNbAxis));
end;

procedure TOpPrmCPLS.SaveToINI(prmSection: string; prmINI: TMemIniFile);
begin
 prmINI.WriteInteger(prmSection,'nb_axis',FNbAxis);
end;

procedure TOpPrmCPLS.SaveToStream(prmStream: TStream);
begin
 prmStream.WriteBuffer(FNbAxis,sizeof(FNbAxis));
end;

procedure TOpPrmCPLS.SetDefaultParameters;
begin
 FNbAxis:= 5;
end;

{ TCalcSpvPLS }

procedure TCalcSpvPLS.classification(example: integer;
  var response: TTypeDiscrete);
begin
 //new -- 10/03/2006 -- passer directement les valeurs de la liste de variables
 FCalc.projectionOnLstX(example,self.Descriptors,FTabY);
 //grer la rponse maintenant -- "0" car il n'y a qu'une seule sortie
 response:= 1 + ord(FTabY[0] > FCalc.StatPLS.AvgY[0]);
end;

function TCalcSpvPLS.coreLearning(examples: TExamples): boolean;
begin
 if assigned(FCalc) then FreeAndNil(FCalc);
 TRY
 //lancer l'affaire
 FCalc:= TCalcPLS.create(self.Descriptors,FLstClassAtt,examples,true,MATH.MIN((self.OpPrmSpv as TOpPrmCPLS).FNbAxis,self.descriptors.count),FALSE);
 FCalc.runAnalysis(examples);
 result:= true;
 EXCEPT
 result:= false;
 END;
end;

procedure TCalcSpvPLS.createStructures;
begin
 //petite feinte pour lui faire croire qu'on est dans le cadre de la rgression
 FLstClassAtt:= TLstAttributes.Create(false,self.ClassAttribute.Size);
 FLstClassAtt.Add(self.ClassAttribute);
 //tableaux intermdiaires pour le classement
 setLength(FTabY,FLstClassAtt.Count);//"1" quoi
end;

procedure TCalcSpvPLS.destroyStructures;
begin
 finalize(FTabY);
 if assigned(FCalc) then FreeAndNil(FCalc);
 if assigned(FLstClassAtt) then FreeAndNil(FLstClassAtt); 
end;

function TCalcSpvPLS.getHTMLResults: string;
begin
 result:= FCalc.getHTMLResults();
end;

procedure TCalcSpvPLS.getScore(example: integer; var postProba: TTabScore);
var value: double;
begin
  //new -- 10/03/2006 -- passer directement les valeurs de la liste de variables
 FCalc.projectionOnLstX(example,self.Descriptors,FTabY);
 //calculer l'cart  la moyenne
 value:= FTabY[0] - FCalc.StatPLS.AvgY[0];
 //et appliquer une fonction logistique (hum, hum, mais faute de mieux...)
 postProba[0]:= 1.0;
 postProba[2]:= 1.0 / (1.0 + exp(-1.0*value));
 postProba[1]:= 1.0 - postProba[2];
end;

initialization
 CLASSES.RegisterClass(TMLGCompSpvCPLS);
end.
