(***********************************************************************)
(* UDlgOpPrmSpvPrototypeNN.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(***********************************************************************)

unit UDlgOpPrmSpvPrototypeNN;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, StdCtrls, CheckLst, ComCtrls,
  ExtCtrls;

type
  TDlgOpPrmSpvPrototypeNN = class(TDlgBaseOperatorParameter)
    Label1: TLabel;
    cmbProtoAttribute: TComboBox;
    rgNormalization: TRadioGroup;
  private
  public
  procedure   ApplyModifications(); override;
  procedure   SetParameters(); override;
  end;

var
  DlgOpPrmSpvPrototypeNN: TDlgOpPrmSpvPrototypeNN;

implementation

uses UCompSpvPrototypeNN, UDatasetDefinition, UCompSpvLDefinition,
  UDatasetImplementation;

{$R *.dfm}

{ TDlgOpPrmSpvPrototypeNN }

procedure TDlgOpPrmSpvPrototypeNN.ApplyModifications;
var prm: TOpPrmProtoNN;
begin
 prm:= OpPrm as TOpPrmProtoNN;
 prm.Normalization:= self.rgNormalization.ItemIndex;
 prm.AttClusterName:= self.cmbProtoAttribute.Text;
end;

procedure TDlgOpPrmSpvPrototypeNN.SetParameters;
var prm: TOpPrmProtoNN;
    i: integer;
    att: TAttribute;
    lstAtt: TLstAttributes;
begin
 prm:= OpPrm as TOpPrmProtoNN;
 self.rgNormalization.ItemIndex:= prm.Normalization;
 //liste des attributs
 self.cmbProtoAttribute.Items.Clear;
 //ouahhh !!!
 lstAtt:= (((prm.Operator as TOpSpvLearning).MLOwner as TMLCompSpvLearning).MetaSpvL.Operator as TOpMetaSpvLearning).WorkData.LstAtts[asAll];
 for i:= 0 to pred(lstAtt.Count) do
  begin
   att:= lstAtt.Attribute[i];
   if att.isCategory(caDiscrete)
    then self.cmbProtoAttribute.Items.Add(att.Name);
  end;
 //puis affecter la slection courante
 self.cmbProtoAttribute.Text:= prm.AttClusterName;
end;

end.
