(***************************************************************)
(* UDlgOpPrmSpvRBF.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(***************************************************************)

unit UDlgOpPrmSpvRBF;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, StdCtrls, CheckLst, ComCtrls,
  ExtCtrls, lmdstdcA, LMDCustomControl, LMDCustomPanel,
  LMDCustomBevelPanel, LMDBaseEdit, LMDCustomEdit, LMDCustomMaskEdit,
  LMDMaskEdit;

type
  TDlgOpPrmSpvRBF = class(TDlgBaseOperatorParameter)
    PageControl1: TPageControl;
    tabLearning: TTabSheet;
    Label2: TLabel;
    Label3: TLabel;
    edLRate: TLMDMaskEdit;
    edTestSample: TLMDMaskEdit;
    tabStop: TTabSheet;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    chkErrStagnation: TCheckBox;
    spinMaxIter: TLMDSpinEdit;
    edThresoldError: TLMDMaskEdit;
    spinGapTestStagnation: TLMDSpinEdit;
    Label1: TLabel;
    cmbAttRBF: TComboBox;
  private
  public
  procedure   ApplyModifications(); override;
  procedure   SetParameters(); override;
  end;

var
  DlgOpPrmSpvRBF: TDlgOpPrmSpvRBF;

implementation

uses UCompSpvRBF, UDatasetDefinition, UCompSpvLDefinition,
  UDatasetImplementation;

{$R *.dfm}

{ TDlgBaseOperatorParameter1 }

procedure TDlgOpPrmSpvRBF.ApplyModifications;
var prm: TOpPrmSpvRBF;
begin
 prm:= OpPrm as TOpPrmSpvRBF;
 //enquiller inverse
 prm.LearningRate:= StrToFloat(self.edLRate.Text);
 prm.PropTestSample:= strtofloat(self.edTestSample.Text);
 prm.MaxIteration:= self.spinMaxIter.Value;
 prm.ThresoldErrorRate:= strtofloat(self.edThresoldError.Text);
 prm.UseTestErrStagnation:= self.chkErrStagnation.Checked;
 prm.NbTestErrStagnation:= self.spinGapTestStagnation.Value;
 //et l'attribut de cluster RBF
 prm.AttRBFNodeName:= self.cmbAttRBF.Text;
end;

procedure TDlgOpPrmSpvRBF.SetParameters;
var prm: TOpPrmSpvRBF;
    lstAtt: TLstAttributes;
    att: TAttribute;
    i: integer;
begin
 prm:= OpPrm as TOpPrmSpvRBF;
 //enquiller
 self.edLRate.Text:= format('%.4f',[prm.LearningRate]);
 self.edTestSample.Text:= format('%.2f',[prm.PropTestSample]);
 self.spinMaxIter.Value:= prm.MaxIteration;
 self.edThresoldError.Text:= format('%.2f',[prm.ThresoldErrorRate]);
 self.chkErrStagnation.Checked:= prm.UseTestErrStagnation;
 self.spinGapTestStagnation.Value:= prm.NbTestErrStagnation;
 //liste des attributs
 self.cmbAttRBF.Items.Clear;
 //ouahhh !!!
 lstAtt:= (((prm.Operator as TOpSpvLearning).MLOwner as TMLCompSpvLearning).MetaSpvL.Operator as TOpMetaSpvLearning).WorkData.LstAtts[asAll];
 for i:= 0 to pred(lstAtt.Count) do
  begin
   att:= lstAtt.Attribute[i];
   if att.isCategory(caDiscrete)
    then self.cmbAttRBF.Items.Add(att.Name);
  end;
 //puis affecter la slection courante
 self.cmbAttRBF.Text:= prm.AttRBFNodeName;
end;

end.
