(***********************************************************)
(* UCompSpvSVM.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(***********************************************************)

{
@abstract(Support vector machine)
@author(Ricco)
@created(11/04/2005)

Copie et adaptation de l'implmentation WEKA. On ne reproduit
que le BinarySVM. La gnration au cas multi-classes passera par une composant
plus gnrique qui permettra de grer les autres mthodes (rg. logistique, etc.).

Copie vraiment bte et mchante du code JAVA, les structures sont reprises telles quelles !!!

Suivi des versions :
--------------------
> Copie de la version 3-4-3 (SMO.JAVA) -> revision 1.51
> Aucune modif. fondamentale n'a t faite dans la version 3-4-4 -> revision 1.53.2.1
}

unit UCompSpvSVM;

interface

USES
       Classes, Forms, IniFiles,
       UCompDefinition,
       UCompSpvLDefinition,
       UOperatorDefinition,
       UCalcSpvSVMBinarySMO,
       UCalcSpvSMOAttTransformation,
       UDatasetImplementation;

TYPE
       TMLGCompSpvSVM = class(TMLGenCompSpvLearning)
                        public
                        function    GetClassMLComponent: TClassMLComponent; override;
                        end;

       TMLCompSpvSVM = class(TMLCompSpvLearning)
                       protected
                       function    getClassOperator: TClassOperator; override;
                       function    GetLogResultDescription(): string; override;
                       end;

       TOpSpvSVM = class(TOpSpvLearningContinuous)
                   protected
                   function    getClassParameter: TClassOperatorParameter; override;
                   function    getClassSpvLearning(): TClassCalcSpvLearning; override;
                   function    ConnectDescriptors(prmData: TMLDataset): boolean; override;
                   end;

       TOpPrmSVM = class(TOpPrmSpvLearning)
                   private
                   //puissance pour les Kernel en polynome -- on prend uniquement des entiers
                   FExponent: integer;
                   //utilisation d'un polynome normalis
                   FFeatureSpaceNormalization: boolean;
                   //filtre de transformation des donnes
                   FFilterType: TEnumAttTransformSVM;
                   //utilisation du noyau RBF
                   FUseRBF: boolean;
                   //Gamma du noyau RBF
                   FGamma: double;
                   //Complexity parameter
                   FComplexity: double;
                   //Epsilon for rounding
                   FEpsilon: double;
                   //Tolerance for accuracy
                   FTolerance: double;
                   protected
                   function    CreateDlgParameters(): TForm; override;
                   procedure   SetDefaultParameters(); override;
                   public
                   //affichage
                   function    getHTMLParameters(): string; override;
                   //I-O
                   procedure   LoadFromStream(prmStream: TStream); override;
                   procedure   SaveToStream(prmStream: TStream); override;
                   procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                   procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                   //properties
                   property    Exponent: integer read FExponent write FExponent;
                   property    FeatureSpaceNormalization: boolean read FFeatureSpaceNormalization write FFeatureSpaceNormalization;
                   property    FilterType: TEnumAttTransformSVM read FFilterType write FFilterType;
                   property    UseRBF: boolean read FUseRBF write FUseRBF;
                   property    Gamma: double read FGamma write FGamma;
                   property    Complexity: double read FComplexity write FComplexity;
                   property    Epsilon: double read FEpsilon write FEpsilon;
                   property    Tolerance: double read FTolerance write FTolerance;
                   end;



implementation

USES
       Sysutils, UConstConfiguration, UDlgOpPrmSVM, UDatasetDefinition;

{ TMLGCompSpvSVM }

function TMLGCompSpvSVM.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSpvSVM;
end;

{ TMLCompSpvSVM }

function TMLCompSpvSVM.getClassOperator: TClassOperator;
begin
 result:= TOpSpvSVM;
end;

function TMLCompSpvSVM.GetLogResultDescription: string;
begin
 result:= format('SVM result generated [%s]',[self.Description]);
end;

{ TOpSpvSVM }

function TOpSpvSVM.ConnectDescriptors(prmData: TMLDataset): boolean;
var ok: boolean;
begin
 //ok:= inherited ConnectDescriptors(prmData);
 //new -- 26/12/2005 -- accepter les prdicteurs quasi-continus, i.e. continus ou discrets binaires
 ok:= (prmData.LstAtts[asInput].Count > 0) AND (prmData.LstAtts[asInput].isAllCategory(caQuasiContinue));
 if ok then FDescriptorsAtt:= prmData.LstAtts[asInput];//branchement direct, pas de recopie locale
 //uniquement pbm binaire rsolu !
 ok:= ok and (self.ClassAttribute.nbValues = 2);
 //and then...
 result:= ok;
end;

function TOpSpvSVM.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmSVM;
end;

function TOpSpvSVM.getClassSpvLearning: TClassCalcSpvLearning;
begin
 result:= TBinarySMO; 
end;

{ TOpPrmSVM }

function TOpPrmSVM.CreateDlgParameters: TForm;
begin
 result:= TdlgOpPrmSpvSVM.CreateFromOpPrm(self);
end;

function TOpPrmSVM.getHTMLParameters: string;
var s: string;
begin
 s:= HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<TH colspan=2>SVM Parameters</TH></TR>';
 //begin...
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Exponent</TD><TD align="right">%d</TD></TR>',[FExponent]);
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Filter type</TD><TD align="right">%s</TD></TR>',[STR_ATT_TRANSFORM_SVM[FFilterType]]);
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Use polynom space normalization</TD><TD align="right">%d</TD></TR>',[ord(FFeatureSpaceNormalization)]);
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Use RBF kernel</TD><TD align="right">%d</TD></TR>',[ord(FUseRBF)]);
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Gamma for RBF kernel</TD><TD align="right">%.4f</TD></TR>',[FGamma]);
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Complexity</TD><TD align="right">%.4f</TD></TR>',[FComplexity]);
 //
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+'<TH colspan=2>Calculation parameter</TH></TR>';
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Epsilon for rounding</TD><TD align="right">%.2e</TD></TR>',[FEpsilon]);
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Tolerance for accuracy</TD><TD align="right">%.2e</TD></TR>',[FTolerance]);
 //...end
 s:= s+'</table>';
 //and then...
 result:= s;
end;

procedure TOpPrmSVM.LoadFromINI(prmSection: string; prmINI: TMemIniFile);
begin
 FExponent:= prmINI.ReadInteger(prmSection,'exponent',FExponent);
 FFilterType:= TEnumAttTransformSVM(prmINI.ReadInteger(prmSection,'filter_type',ord(FFilterType)));
 FFeatureSpaceNormalization:= prmINI.ReadBool(prmSection,'poly_space_normalization',FFeatureSpaceNormalization);
 FUseRBF:= prmINI.ReadBool(prmSection,'use_rbf',FUseRBF);
 FGamma:= prmINI.ReadFloat(prmSection,'gamma',FGamma);
 //
 FComplexity:= prmINI.ReadFloat(prmSection,'complexity',FComplexity);
 FEpsilon:= prmINI.ReadFloat(prmSection,'epsilon',FEpsilon);
 FTolerance:= prmINI.ReadFloat(prmSection,'tolerance',FTolerance);
 //...
end;

procedure TOpPrmSVM.LoadFromStream(prmStream: TStream);
begin
 prmStream.ReadBuffer(FExponent,sizeof(FExponent));
 prmStream.ReadBuffer(FFilterType,sizeof(FFilterType));
 prmStream.ReadBuffer(FFeatureSpaceNormalization,sizeof(FFeatureSpaceNormalization));
 prmStream.ReadBuffer(FUseRBF,sizeof(FUseRBF));
 prmStream.ReadBuffer(FGamma,sizeof(FGamma));
 //
 prmStream.ReadBuffer(FComplexity,sizeof(FComplexity));
 prmStream.ReadBuffer(FEpsilon,sizeof(FEpsilon));
 prmStream.ReadBuffer(FTolerance,sizeof(FTolerance));
 //...
end;

procedure TOpPrmSVM.SaveToINI(prmSection: string; prmINI: TMemIniFile);
begin
 prmINI.WriteInteger(prmSection,'exponent',FExponent);
 prmINI.WriteInteger(prmSection,'filter_type',ord(FFilterType));
 prmINI.WriteBool(prmSection,'poly_space_normalization',FFeatureSpaceNormalization);
 prmINI.WriteBool(prmSection,'use_rbf',FUseRBF);
 prmINI.WriteFloat(prmSection,'gamma',FGamma);
 //
 prmINI.WriteFloat(prmSection,'complexity',FComplexity);
 prmINI.WriteFloat(prmSection,'epsilon',FEpsilon);
 prmINI.WriteFloat(prmSection,'tolerance',FTolerance);
 //...
end;

procedure TOpPrmSVM.SaveToStream(prmStream: TStream);
begin
 prmStream.WriteBuffer(FExponent,sizeof(FExponent));
 prmStream.WriteBuffer(FFilterType,sizeof(FFilterType));
 prmStream.WriteBuffer(FFeatureSpaceNormalization,sizeof(FFeatureSpaceNormalization));
 prmStream.WriteBuffer(FUseRBF,sizeof(FUseRBF));
 prmStream.WriteBuffer(FGamma,sizeof(FGamma));
 //
 prmStream.WriteBuffer(FComplexity,sizeof(FComplexity));
 prmStream.WriteBuffer(FEpsilon,sizeof(FEpsilon));
 prmStream.WriteBuffer(FTolerance,sizeof(FTolerance));
 //...
end;

procedure TOpPrmSVM.SetDefaultParameters;
begin
  //** The exponent for the polynomial kernel. -- private double m_exponent = 1.0;
  FExponent:= 1;
  //** Use lower-order terms? -- private boolean m_lowerOrder = false;
  //** The complexity parameter. -- private double m_C = 1.0;
  FComplexity:= 1.0;
  //** Epsilon for rounding. -- private double m_eps = 1.0e-12;
  FEpsilon:= +1.0e-12;
  //** Tolerance for accuracy of result. -- private double m_tol = 1.0e-3;
  FTolerance:= +1.0e-3;
  //** Whether to normalize/standardize/neither attributes -- m_filterType := atSVM_NORMALIZE;
  FFilterType:= atSVM_NORMALIZE;
  //** Feature-space normalization for Kernel ? -- private boolean m_featureSpaceNormalization = false;
  FFeatureSpaceNormalization:= false;
  //** Use RBF kernel? (default: poly) -- private boolean m_useRBF = false;
  FUseRBF:= false;
  //** Gamma for the RBF kernel. -- private double m_gamma = 0.01;
  FGamma:= 0.01;
  //** The size of the cache (a prime number) -- private int m_cacheSize = 1000003;
  //** Precision constant for updating sets -- private static double m_Del = 1000 * Double.MIN_VALUE;
  //** The random number seed  -- private int m_randomSeed = 1;
end;

initialization
 RegisterClass(TMLGCompSpvSVM);
end.
