unit UDlgOpPrmSpvAssesBootstrap;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, ComCtrls, StdCtrls, ExtCtrls,
  LMDCustomControl, LMDCustomPanel, LMDCustomBevelPanel, LMDBaseEdit,
  LMDCustomEdit, LMDCustomBrowseEdit, LMDFileSaveEdit, lmdstdcA;

type
  TdlgOpPrmSpvAssesBootstrap = class(TDlgBaseOperatorParameter)
    GroupBox1: TGroupBox;
    chkSave: TCheckBox;
    edSave: TLMDFileSaveEdit;
    Label1: TLabel;
    spinReplications: TLMDSpinEdit;
    procedure chkSaveClick(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  procedure   ApplyModifications(); override;
  procedure   SetParameters(); override;    
  end;

var
  dlgOpPrmSpvAssesBootstrap: TdlgOpPrmSpvAssesBootstrap;

implementation

uses UCompSpvAssesBootstrap;

{$R *.dfm}

{ TdlgOpPrmSpvAssesBootstrap }

procedure TdlgOpPrmSpvAssesBootstrap.ApplyModifications;
var prm: TOpPrmAssesBootstrap;
begin
 prm:= OpPrm as TOpPrmAssesBootstrap;
 prm.SaveResults:= self.chkSave.Checked;
 prm.FileNameResults:= self.edSave.Filename;
end;

procedure TdlgOpPrmSpvAssesBootstrap.SetParameters;
var prm: TOpPrmAssesBootstrap;
begin
 prm:= OpPrm as TOpPrmAssesBootstrap;
 self.spinReplications.Value:= prm.NbReplications;
 //copier/coller de CV
 self.chkSave.Checked:= prm.SaveResults;
 self.edSave.Filename:= prm.FileNameResults;
 self.chkSaveClick(NIL);
end;

procedure TdlgOpPrmSpvAssesBootstrap.chkSaveClick(Sender: TObject);
begin
 if self.chkSave.Checked
  then self.edSave.Enabled:= TRUE
  else self.edSave.Enabled:= FALSE;
end;

end.
