(******************************************************************)
(* UDlgOpPrmTrainTest.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(******************************************************************)

unit UDlgOpPrmTrainTest;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, StdCtrls, CheckLst, ComCtrls,
  ExtCtrls, LMDCustomControl, LMDCustomPanel, LMDCustomBevelPanel,
  LMDBaseEdit, LMDCustomEdit, LMDCustomMaskEdit, LMDMaskEdit, lmdstdcA,
  LMDCustomBrowseEdit, LMDFileSaveEdit;

type
  TDlgOpPrmAssesTrainTest = class(TDlgBaseOperatorParameter)
    Label1: TLabel;
    edTrainSet: TLMDMaskEdit;
    spinRepetition: TLMDSpinEdit;
    Label2: TLabel;
    GroupBox1: TGroupBox;
    chkSave: TCheckBox;
    edSave: TLMDFileSaveEdit;
    procedure chkSaveClick(Sender: TObject);
  private
  public
  procedure   ApplyModifications(); override;
  procedure   SetParameters(); override;
  end;

var
  DlgOpPrmAssesTrainTest: TDlgOpPrmAssesTrainTest;

implementation

uses UCompSpvAssesTrainTest;

{$R *.dfm}

{ TDlgOpPrmAssesTrainTest }

procedure TDlgOpPrmAssesTrainTest.ApplyModifications;
var prm: TOpPrmAssesTrainTest;
begin
 prm:= OpPrm as TOpPrmAssesTrainTest;
 prm.ProportionTrainSet:= strtofloat(self.edTrainSet.Text);
 prm.NbRepetitions:= self.spinRepetition.Value;
 prm.SaveResults:= self.chkSave.Checked;
 prm.FileNameResults:= self.edSave.Filename;
end;

procedure TDlgOpPrmAssesTrainTest.SetParameters;
var prm: TOpPrmAssesTrainTest;
begin
 prm:= OpPrm as TOpPrmAssesTrainTest;
 self.spinRepetition.Value:= prm.NbRepetitions;
 self.edTrainSet.Text:= formatfloat('0.0000',prm.ProportionTrainSet);
 self.chkSave.Checked:= prm.SaveResults;
 self.edSave.Filename:= prm.FileNameResults;
 //
 self.chkSaveClick(NIL);
end;

procedure TDlgOpPrmAssesTrainTest.chkSaveClick(Sender: TObject);
begin
 if self.chkSave.Checked
  then self.edSave.Enabled:= TRUE
  else self.edSave.Enabled:= FALSE;
end;

end.
