(********************************************************************)
(* UCompSpvAssesTestSet.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(********************************************************************)

{
@abstract(Evaluation d'une sries d'algo sur un chantillon prdfini [Gnralement test set])
@author(Ricco)
@created(18/07/2005)

L'ide est de construire une matrice de confusion  partir de confrontations "observed vs. predicted".
L'ensemble de donnes peut tre soit les "selected" (learning set) soit les "unselected" (test set)

Ce composant est trs proche des composants "Scoring Lift" et "Roc" dans son principe,  savoir que
l'on se contente de croiser valeurs observes et prdites sans demander un nouvel apprentissage. De ce point
de vue, il diffre des composants classiques SPV ASSES.

On pourrait obtenir les mmes rsultats en plaant un tableau crois (table de contingence)  la place !

Deux ides essentielles ici :
-----------------------------
(1) valuer l'algo sur des individus tests dfini par l'utilisateur
(2) pouvoir comparer les algos sur ces individus

}

unit UCompSpvAssesTestSet;

interface

USES
   Forms, IniFiles, Classes, Contnrs,
   UCompDefinition,
   UCompManageDataset,
   UOperatorDefinition,
   UDatasetDefinition,
   UDatasetImplementation,
   UDatasetExamples,
   UCompSpvLDefinition;

TYPE
   //individus slectionnes pour l'valuation -- Selected ou Unselected
   TEnumEvaluationSet = (evalSetLearning, evalSetTest);

CONST
   //description des options
   SPV_ASSES_EVALUATION_SET: array [TEnumEvaluationSet] of string = ('selected','unselected');

TYPE
   //***********************
   //gnrateur de composant
   //***********************
   TMLGenCompSpvAssesTestSet = class(TMLGenComp)
                               protected
                               procedure   GenCompInitializations(); override;
                               public
                               function    GetClassMLComponent: TClassMLComponent; override;
                               end;

   //*********
   //composant
   //*********
   //!\ attention  l'hritage, c'est pas bien sa spcificit -- le diagramme n'est pas r-excut
   //il est inutile donc de reprendre l'arsenal des composants "Spv Asses"
   TMLCompSpvAssesTestSet = class(TMLCompLocalData)
                            protected
                            function    getClassOperator: TClassOperator; override;
                            end;

   //**********************************************
   //oprateur -- idem pour le mcanisme d'hritage
   //**********************************************
   TOpSpvAssesTestSet =  class(TOpLocalData)
                         private
                         //les individus utiliss pour l'valuation
                         FUsedExamples: TExamples;
                         //liste des matrices de confusion utilises pour l'valuation (1 pour chaque prdiction)
                         FLstConfMatrix: TObjectList;
                         protected
                         //classe de paramtres assoicie
                         function    getClassParameter: TClassOperatorParameter; override;
                         //checker les attributs  utiliser
                         function    CheckAttributes(): boolean; override;
                         //checker les exemples  utiliser -- les rcuprer au passage
                         function   CheckExamples(): boolean; override;
                         //lancer le calcul des matrices de confusion
                         function    CoreExecute(): boolean; override;
                         public
                         //constructeur
                         constructor Create(AOwner: TObject); override;
                         //destructeur
                         destructor  destroy(); override;
                         //envoyer le rsultat des calculs
                         function    getHTMLResultsSummary(): string; override;
                         end;

   //***********
   //paramtrage
   //***********
   TPrmOpSpvAssesTestSet = class(TOperatorParameter)
                           protected
                           //ensemble d'individus utiliss
                           FSelExamples: TEnumEvaluationSet;
                           procedure   SetDefaultParameters(); override;
                           function    CreateDlgParameters(): TForm; override;
                           public
                           function    getHTMLParameters(): string; override;
                           procedure   LoadFromStream(prmStream: TStream); override;
                           procedure   SaveToStream(prmStream: TStream); override;
                           procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                           procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                           //proprits
                           property    SelExamples: TEnumEvaluationSet read FSelExamples write FSelExamples;
                           end;

implementation

USES
   Sysutils, UConstConfiguration, UDlgOpPrmSpvAssesTestSet, ULogFile, Windows;

CONST
   //en-dessous, on refuse d'valuer
   SPV_ASSES_MIN_EVALUATION_SET_SIZE = 5;

{ TMLGenCompSpvAssesTestSet }

procedure TMLGenCompSpvAssesTestSet.GenCompInitializations;
begin
 FMLComp:= mlcSpvAssessment;
end;

function TMLGenCompSpvAssesTestSet.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSpvAssesTestSet;
end;

{ TMLCompSpvAssesTestSet }

function TMLCompSpvAssesTestSet.getClassOperator: TClassOperator;
begin
 result:= TOpSpvAssesTestSet;
end;

{ TOpSpvAssesTestSet }

function TOpSpvAssesTestSet.CheckAttributes: boolean;
var ok: boolean;
begin
 //un seul target et il doit tre discret
 ok:= (self.WorkData.LstAtts[asTarget].Count = 1) and (self.WorkData.LstAtts[asTarget].Attribute[0].isCategory(caDiscrete));
 //et tous les input doivent tre discrets -- le test de conformit sera ralis lors du calcul
 ok:= ok and ((self.WorkData.LstAtts[asInput].Count > 0) and (self.WorkData.LstAtts[asInput].isAllCategory(caDiscrete)));
 //and then...
 result:= ok;
end;

function TOpSpvAssesTestSet.CheckExamples: boolean;
var tps: cardinal;
begin
 if assigned(FUsedExamples) then FUsedExamples.Free();
 tps:= GetTickCount();
 TraceLog.WriteToLogFile('[ASSES-TEST] begin check examples');
 //dterminer les individus  utiliser
 case (self.PrmOp as TPrmOpSpvAssesTestSet).SelExamples of
  evalSetTest:
   begin
    //complmentaire des individus slectionn  la taille de la base --> c'est bien les individus non-slectionns
    FUsedExamples:= self.WorkData.Examples.getComplementaire(self.WorkData.LstAtts[asAll].Size);
   end
  else
   begin
    FUsedExamples:= TExamples.Create(self.WorkData.Examples.Size);
    FUsedExamples.Copy(self.WorkData.Examples);
   end;
 end;
 tps:= GetTickCount() - tps;
 TraceLog.WriteToLogFile(format('[ASSES-TEST] end check examples = %d ms.',[tps]));
 //tester si la taille convient
 result:= (FUsedExamples.Size >= SPV_ASSES_MIN_EVALUATION_SET_SIZE);
end;

function TOpSpvAssesTestSet.CoreExecute: boolean;
var attObs, attPred: TAttribute;
    j: integer;
    curConf: TConfusionMatrix;

    //vrifier la concordance des modalits pour 2 attributs
    function isValuesCompatible(att1,att2: TAttribute): boolean;
    var k: byte;
        OK: boolean;
    begin
     if (att1.nbValues <> att2.nbValues)
      //pas besoin de continuer dans ce cas...
      then result:= FALSE
      else
       begin
        //vrifier que les descriptions sont conformes
        //ce qui est le cas si la seconde est bien une prdiction de la premire
        OK:= TRUE;
        for k:= 1 to att1.nbValues do
         OK:= OK and (att1.LstValues.getDescription(k) = att2.LstValues.getDescription(k));
        //and then...
        result:= OK;
       end;
    end;

begin
 TRY
 //vider la liste courante
 FLstConfMatrix.Clear();
 //Y observ
 attObs:= self.WorkData.LstAtts[asTarget].Attribute[0];
 //pour chaque Y prdit
 for j:= 0 to pred(self.WorkData.LstAtts[asInput].Count) do
  begin
   attPred:= self.WorkData.LstAtts[asInput].Attribute[j];
   //vrifier la concordance des modalits
   if isValuesCompatible(attObs,attPred)
    then
     begin
      curConf:= TConfusionMatrix.create(attObs,attPred,FUsedExamples);
      //ajouter dans la liste
      FLstConfMatrix.Add(curConf);
     end;
  end;
 result:= TRUE;
 EXCEPT
 result:= FALSE;
 END;
end;

constructor TOpSpvAssesTestSet.Create(AOwner: TObject);
begin
 inherited Create(AOwner);
 //liste propritaire
 FLstConfMatrix:= TObjectList.Create(TRUE);
end;

destructor TOpSpvAssesTestSet.destroy;
begin
 //dtruire les matrices de confusion
 FLstConfMatrix.Free();
 //dtruire les individus
 if assigned(FUsedExamples) then FUsedExamples.Free();
 //suite...
 inherited destroy();
end;

function TOpSpvAssesTestSet.getClassParameter: TClassOperatorParameter;
begin
 result:= TPrmOpSpvAssesTestSet;
end;

function TOpSpvAssesTestSet.getHTMLResultsSummary: string;
var s: string;
    j: integer;   
    curConf: TConfusionMatrix;
begin
 s:= HTML_HEADER_TABLE_RESULT;
 //afficher la srie de matrice de confusion
 for j:= 0 to pred(FLstConfMatrix.Count) do
  begin
   curConf:= FLstConfMatrix.Items[j] as TConfusionMatrix;
   //donner le nom de la variable
   s:= s + HTML_TABLE_COLOR_HEADER_BLUE+format('<TH>%s</TH></TR>',[curConf.PredAttribute.Name]);
   //rcuprer la description
   s:= s + HTML_TABLE_COLOR_DATA_GRAY+format('<TD>%s</TD></TR>',[curConf.getHTMLResults()]);
  end;
 //finaliser le tableau
 s:= s+'</TABLE>';
 //tout simplement
 result:= s;
end;

{ TPrmOpSpvAssesTestSet }

function TPrmOpSpvAssesTestSet.CreateDlgParameters: TForm;
begin
 result:= TdlgOpPrmSpvAssesTestSet.CreateFromOpPrm(self);
end;

function TPrmOpSpvAssesTestSet.getHTMLParameters: string;
begin
 result:= format('Evaluation set : <b>%s</b> examples',[SPV_ASSES_EVALUATION_SET[FSelExamples]]);
end;

procedure TPrmOpSpvAssesTestSet.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 FSelExamples:= TEnumEvaluationSet(prmINI.ReadInteger(prmSection,'examples',ord(FSelExamples)));
end;

procedure TPrmOpSpvAssesTestSet.LoadFromStream(prmStream: TStream);
begin
 prmStream.ReadBuffer(FSelExamples,sizeof(FSelExamples));
end;

procedure TPrmOpSpvAssesTestSet.SaveToINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 prmINI.WriteInteger(prmSection,'examples',ord(FSelExamples));
end;

procedure TPrmOpSpvAssesTestSet.SaveToStream(prmStream: TStream);
begin
 prmStream.WriteBuffer(FSelExamples,sizeof(FSelExamples));
end;

procedure TPrmOpSpvAssesTestSet.SetDefaultParameters;
begin
 //par dfaut, on prend comme "test set" les "unselected"
 FSelExamples:= evalSetTest;
end;

initialization
 CLASSES.RegisterClass(TMLGenCompSpvAssesTestSet);
end.
