(*************************************************************)
(* UCompSpvLTest.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*************************************************************)

{
@abstract(Tester le fonctionnement du composant Supervised Learning)
@author(Ricco)
@created(12/01/2004)
Cette unit devra tre vire du projet plus tard lorsque le fonctionnement sera stabilis.
}
unit UCompSpvLTest;

interface

USES
        Forms,
        UCompDefinition,
        UCompSpvLDefinition,
        UOperatorDefinition,
        UDatasetDefinition,
        UDatasetImplementation,
        UDatasetExamples,
        UCalcStatDesCrossTab,
        UCalcDistribution;

TYPE
        {gnrateur de composant meta}
        TMLGenCompMSLTest = class(TMLGenComp)
                            protected
                            procedure   GenCompInitializations(); override;
                            public
                            function    GetClassMLComponent: TClassMLComponent; override;
                            end;

        {le composant meta, singe un single learning}
        TMLCompMSLTest = class(TMLCompMetaSpvLearning)
                         protected
                         function    ShortMLCompName(): string; override;
                         function    getClassOperator: TClassOperator; override;
                         function    GetLogResultDescription(): string; override;
                         end;

        {l'oprateur meta}
        TOpMSLTest = class(TOpMetaSpvLearning)
                     private
                     {un seul classifieur}
                     FClassifier: TCalcSpvLearning;   
                     protected
                     function    getClassParameter: TClassOperatorParameter; override;
                     procedure   RunLearning(); override;
                     procedure   ReInitialize(); override;
                     procedure   ClassifyExample(example: integer; var response: TTypeDiscrete); override;
                     public
                     destructor  destroy; override;
                     end;

        {paramtre d'oprateur meta}
        TOpPrmMSLTest = class(TOpPrmMetaSpvLearning)
                        protected
                        function    CreateDlgParameters(): TForm; override;
                        end;

        {le gnrateur de composant Supervised}
        TMLGenCompSLTest = class(TMLGenCompSpvLearning)
                           protected
                           procedure   GenCompInitializations(); override;
                           public
                           function    GetClassMLComponent: TClassMLComponent; override;
                           end;

        {le composant Spv}
        TMLCompSLTest = class(TMLCompSpvLearning)
                        protected
                        function    getClassOperator: TClassOperator; override;
                        function    GetLogResultDescription(): string; override;
                        end;

        {l'oprateur}
        TOpSLTest = class(TOpSpvLearning)
                    protected
                    function    getClassParameter: TClassOperatorParameter; override;
                    function    getClassSpvLearning(): TClassCalcSpvLearning; override;
                    function    ConnectDescriptors(prmData: TMLDataset): boolean; override;
                    end;

        {paramtrage de l'oprateur}
        TOpPrmSLTest = class(TOpPrmSpvLearning)
                       protected
                       function    CreateDlgParameters(): TForm; override;
                       end;

        {la classe de calcul, un petit baysien naf fera l'affaire, on prend le produit simple !!!}
        TCalcSLTest = class(TCalcSpvLearning)
                      protected
                      {distribution des classe}
                      FDistClass: TTabFrequence;
                      {liste des stats de croisement}
                      FStatCross: TLstCalcStatDesCrossTab;
                      {crer la liste}
                      procedure   createStructures(); override;
                      {vider la liste}
                      procedure   destroyStructures(); override;
                      {apprentissage proprement dit}
                      function    coreLearning(examples: TExamples): boolean; override;
                      public
                      procedure   classification(example: integer; var response: TTypeDiscrete); override;
                      end;  


implementation

uses
        Sysutils,
        UDlgMetaSpvTest, UDlgSpvTest, UDlgBaseOperatorParameter, ULogFile;

{ TMLGenCompMSLTest }

procedure TMLGenCompMSLTest.GenCompInitializations;
begin
 FMLComp:= mlcMetaSpvLearning;
 FMLNumIcon:= 16;
 FMLCompName:= 'MetaSpv Test';
end;

function TMLGenCompMSLTest.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompMSLTest;
end;

{ TMLGenCompSLTest }

procedure TMLGenCompSLTest.GenCompInitializations;
begin
 FMLComp:= mlcSpvLearning;
 FMLNumIcon:= 15;
 FMLCompName:= 'Supervised Test';
end;

function TMLGenCompSLTest.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSLTest;
end;

{ TMLCompMSLTest }

function TMLCompMSLTest.getClassOperator: TClassOperator;
begin
 result:= TOpMSLTest;
end;

function TMLCompMSLTest.GetLogResultDescription: string;
begin
 result:= 'component meta supervised  test executed';
end;

function TMLCompMSLTest.ShortMLCompName: string;
begin
 result:= 'spv_meta_test';
end;

{ TOpMSLTest }

procedure TOpMSLTest.ClassifyExample(example: integer;
  var response: TTypeDiscrete);
begin
 FClassifier.classification(example,response);
end;

destructor TOpMSLTest.destroy;
begin
 inherited;
 if assigned(FClassifier)
  then freeandnil(FClassifier);
end;

function TOpMSLTest.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmMSLTest;
end;

procedure TOpMSLTest.ReInitialize;
begin
 inherited ReInitialize();
 if assigned(FClassifier)
  then FreeAndNil(FClassifier);
end;

procedure TOpMSLTest.RunLearning;
begin
 if assigned(FClassifier)
  then FClassifier.Free;
 //cration de l'instance
 FClassifier:= OpMLSpv.getInstanceSpvLearning();
 //apprentissage en envoyant les bons exemples
 if not(FClassifier.learning(workdata.Examples))
  then raise Exception.Create(format('collapse creation during %s learning',[FClassifier.ClassName]));
end;

{ TMLCompSLTest }

function TMLCompSLTest.getClassOperator: TClassOperator;
begin
 result:= TOpSLTest;
end;

function TMLCompSLTest.GetLogResultDescription: string;
begin
 result:= 'component supervised test executed';
end;

{ TOpSLTest }

function TOpSLTest.getClassSpvLearning: TClassCalcSpvLearning;
begin
 result:= TCalcSLTest;
end;

function TOpSLTest.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmSLTest; 
end;

function TOpSLTest.ConnectDescriptors(prmData: TMLDataset): boolean;
var ok: boolean;
    att: TAttribute;
    i: integer;
begin
 ok:= (prmData.LstAtts[asInput].Count>0);
 if ok
  then
   begin
    for i:= 0 to pred(prmData.LstAtts[asInput].Count) do
     begin
      att:= prmData.LstAtts[asInput].Attribute[i];
      ok:= ok and att.isCategory(caDiscrete);
     end;
    if ok
     then FDescriptorsAtt:= prmData.LstAtts[asInput];//branchement direct, pas de recopie locale
   end;
 result:= ok;
end;

{ TOpPrmMSLTest }

function TOpPrmMSLTest.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmMetaSpvTest.CreateFromOpPrm(self);
end;

{ TOpPrmSLTest }

function TOpPrmSLTest.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmSpv.CreateFromOpPrm(self);
end;

{ TCalcSLTest }

procedure TCalcSLTest.classification(example: integer;
  var response: TTypeDiscrete);
var s,smax,v: double;
    i,j,k,imax: integer;
    stat: TCalcSDCrossTab;
    att: TAttribute;
begin
 smax:= -1.0e308;
 imax:= -1;
 //pour chaque modalit de l'endogne
 for i:= 1 to ClassAttribute.nbValues do
  begin
   s:= FDistClass.Frequence[i];
   for j:= 0 to pred(FStatCross.Count) do
    begin
     stat:= TCalcSDCrossTab(FStatCross.Stat(j));
     att:= Descriptors.Attribute[j];
     if (stat.ColAtt<>att)
      then
       begin
       exception.Create(format('collapse creation CALCSLTEST.CLASSIFICATION, no attribute concordance %s and %s',[stat.ColAtt.Name,att.Name]));
       TraceLog.WriteToLogFile(format('collapse creation CALCSLTEST.CLASSIFICATION, no attribute concordance %s and %s',[stat.ColAtt.Name,att.Name]));
       end;
     //la modalit  activer
     k:= att.dValue[example];
     //la valeur du profil ligne
     v:= stat.CrossTab.RowFreq[i,k];
     //le produit
     s:= s*v;
    end;
   //tester le max
   if (s>smax)
    then
     begin
      smax:= s;
      imax:= i;
     end;
  end;
 response:= imax;
end;

function TCalcSLTest.coreLearning(examples: TExamples): boolean;
begin
 result:= true;
 try
 FDistClass.Refresh(examples);
 FStatCross.RefreshStat(examples);
 except
 result:= false;
 end;
end;

procedure TCalcSLTest.createStructures;
var stat: TCalcSDCrossTab;
    j: integer;
    y,x: TAttribute;
begin
 //distribution de l'endogne
 y:= ClassAttribute;
 FDistClass:= TTabFrequence.CreateFromAtt(y,NIL);
 //les stats croises
 FStatCross:= TLstCalcStatDesCrossTab.Create(NIL,NIL);
 for j:= 0 to pred(Descriptors.Count) do
  begin
   x:= Descriptors.Attribute[j];
   stat:= TCalcSDCrossTab.Create(y,x,nil);
   FStatCross.AddStat(stat);
  end;
end;

procedure TCalcSLTest.destroyStructures;
begin
 FDistClass.Free;
 FStatCross.FreeAll;//inutile mais a rassure
 FStatCross.Free;
end;

end.
