(***************************************************************)
(* UCompDefinition.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(***************************************************************)

{
@abstract(Dfinition d'un composant ML)
@author(Ricco)
@created(12/01/2004)
Cette unit dfinit les objets de base destins  implmenter les composants
machine learning. La classe de gnration de composant y est aussi implmente, en effet,
on en a besoin lors de la cration des connexions.
On y trouve galement la classe principale de l'application qui gre l'instaciation d'un diagramme de traitement.
Un peu fouillis peut tre mais a vite les rfrences croises.

<P> Les gestionnaires d'vnements sur le TreeView ont t ports dans TMLDiagram (26/07/03)

<P> Le format de fichier de sauvegarde peut ^tre aussi un fichier texte au format INI (de fait,
les donnes sont toujours externes, cela permet de relancer automatiquement le programme
sur des donnes actualises) -- 06/09/03

}
unit UCompDefinition;

interface

USES
        UFrmBase, Classes, Contnrs, Types,
        ComCtrls, Controls, Menus, Graphics,
        UDatasetDefinition, UOperatorDefinition,
        UStringsResources, IniFiles,
        UDataAccessDefinition,
        UDataAccessInfoDownload;

TYPE
        {catgorie de composants - attention si les accs aux donnes sont bien des composants ML, il ne sont pas gnrs
        par un gnrateur issu de la palette de composants}
        TEnumMLComp = (mlcDataView,mlcDescriptiveStat,mlcNonParametricStatistics,
                       mlcInstanceSelection,
                       mlcFeatureConstruction,mlcFeatureSelection,mlcRegression,mlcFactorialAnalysis,
                       mlcPLS,
                       mlcClustering,mlcSpvLearning,mlcMetaSpvLearning,mlcSpvAssessment,mlcSpvScoring,
                       mlcAssociation);

CONST

        {Chanes de caractres associes aux composants}
        STR_MLCOMP : array[TEnumMLComp] of string =
                     (str_comp_group_data_visualization,str_comp_group_desc_statistics,str_comp_grpup_non_param_stats,
                      str_comp_group_instance_selection,
                      str_comp_group_feature_construction,str_comp_group_feature_selection,str_comp_group_regression,str_comp_group_factorial_analysis,
                      str_comp_group_pls,
                      str_comp_group_clustering,str_comp_group_spv_learning,str_comp_group_meta_spv_learning,str_comp_group_spv_assesment,str_comp_group_spv_scoring,
                      str_comp_group_association);

TYPE

        {forward - composant}
        TMLComponent = class;

        {classe de TMLComponent}
        TClassMLComponent = class of TMLComponent;

        {Gnrateur de composant. Son rle consiste  produire un composant ML aprs avoir vrifi
        qu'il peut tre connect ou intgr dans le composant de destination}
        TMLGenComp = class(TPersistent)
                     protected
                     {catgorie du composant - redfinie pour chaque composant}
                     FMLComp: TEnumMLComp;
                     {numro d'icne associe au composant}
                     FMLNumIcon: Integer;
                     {Nom gnrique du composant}
                     FMLCompName: string;
                     {Description du composant}
                     FMLCompDescription: string;
                     {Nom du fichier bitmap associ}
                     FMLBitmapFileName: string;
                     {le bitmap associ}
                     FMLBitmap: TBitmap;
                     {initialisation des paramtres internes: catgorie, num. d'icne, etc. - la surcharge est obligatoire}
                     procedure   GenCompInitializations(); virtual; abstract;
                     {charger le bitmap en mmoire}
                     procedure   GetBitmap();
                     public
                     constructor Create(prmName,prmBitmap,prmDescription: string); virtual;
                     destructor  Destroy(); override;
                     {la classe du gnrateur de composant demand,  surcharger toujours}
                     function    GetClassMLComponent: TClassMLComponent; virtual; abstract;
                     {Type de traitement du composant produit par le gnrateur}
                     property    MLComp: TEnumMLComp read FMLComp;
                     {Nom interne du composant}
                     property    MLCompName: string read FMLCompName;
                     {Description du composant}
                     property    MLCompDescription: string read FMLCompDescription;
                     {Numro d'icne du composant}
                     property    MLNumIcon: Integer read FMLNumIcon write FMLNumIcon;
                     {nom du fichier bitmap}
                     property    MLBitmapFileName: string read FMLBitmapFileName;
                     {image bitmap}
                     property    MLBitmap: TBitmap read FMLBitmap;
                     end;

        {classe de TMLGenComp}
        TClassMLGenComp = class of TMLGenComp;

        {dclaration forward}
        TMLDiagram = class;

        {Un composant machine learning - le coeur de l'affaire}
        TMLComponent = class(TObject)
                       private
                       {L'oprateur associ}
                       FOperator: TOperator;
                       {La filire auquelle elle est rattache}
                       FDiagram: TMLDiagram;
                       {Le noeud TTREEVIEW auquel est rattach le composant}
                       FTreeNode: TTreeNode;
                       {Le menu associ  l'objet}
                       FPopupMenu: TPopupMenu;
                       {Numro d'icne d'tat utilis pour les composant embedded}
                       FNumIconState: Integer;
                       {le composant pre}
                       FPredecessor: TMLComponent;
                       {les ventuels successeurs - list not propertary}
                       FSuccessors: TObjectList;
                       {Le numro interne dans la liste des composants}
                       FNumber: Integer;
                       {Dure d'excution}
                       FExecDuration: cardinal;
                       {affetation d'un diagramme}
                       procedure setDiagram(prmDiagram: TMLDiagram);
                       {Nombre de composants successeurs}
                       function  getNbSuccessors(): Integer;
                       {accder  un des enfants}
                       function  getSuccessor(i: Integer): TMLComponent;
                       {modifier le numro interne, ce qui modifie galement la description affiche}
                       procedure SetNumber(prmNumber: Integer);
                       {tester si le composant est dispo pour la visualisation}
                       function  isAvailable(): boolean;
                       {demander si le prcdent est excut}
                       function  AskPredecessorExecution(prmForceExec: boolean): boolean;
                       {coeur de l'excution}
                       function  CoreExecution(): boolean;
                       {ajouter un menu HTML, 2 paramtres : l'ancre et le texte associ}
                       function  AddHTMLMenu(prmAnchor,prmDesc: string): string;
                       {idem sauf que la table complte est construite}
                       function  AddHTMLTitle(prmAnchor,prmDesc: string): string;
                       {rcuprer la description des paramtres}
                       function  getHTMLParameters(): string;
                       {rcuprer le rsum des rsultats}
                       function  getHTMLResultsSummary(): string;
                       {rcuprer un nom de fichier sans ses extensions}
                       function  getCoreFileName(prmFileName: string): string;
                       protected
                       {Description du composant}
                       FDescription: string;
                       {Numro d'icne}
                       FNumIcon: integer;
                       {nom de la classe gnratrice}
                       FMLGenClassName: shortstring;
                       {identifiant indiquant si le composant recquiert systmatiquement
                       l'excution de ses prdcesseurs - c'est le cas de la validation croise par exemple}
                       FForcePredecessorExecute: Boolean;
                       {prparer l'excution}
                       function  BeforeExecution(): boolean; virtual;
                       {aprs l'excution}
                       function  AfterExecution(): boolean; virtual;
                       {renvoie un rsum de l'excution  destination du fichier log -  surcharger pour chaque mthode}
                       function  GetLogResultDescription(): string; virtual;
                       {qqs initialisations internes, peu surcharg a priori}
                       procedure   Initializations(); virtual;
                       {cration des menus}
                       procedure   InitMenus();
                       {cration de menus du haut, i.e. les paramtres, trs peu surcharg, sauf dans le supervised}
                       procedure   InitMenusParameters(); virtual;
                       {montrer la bote de paramtres}
                       procedure   OnMenuParameters(Sender: TObject); virtual;
                       {montrer la fiche de rsultats}
                       procedure OnMenuView(Sender: TObject); virtual;
                       {lancer l'excution}
                       procedure OnMenuExecute(Sender: TObject); virtual;
                       {cration des menus du bas, i.e. les menus execute et view}
                       procedure   InitMenusRun();
                       {rcuprer les infos du gnrateur de composant}
                       procedure   getInfosGenerator(prmGen: TMLGenComp); virtual;
                       {standard sauf pour les composants embedded et le premier composant
                       --> c'est le composant courant que l'on veut ajouter  "prmPred"}
                       procedure   InsertIntoDiagram(prmDiagram: TMLDiagram; prmPred: TMLComponent); virtual;
                       {La classe operateur associ au MLComposant -  surcharger toujours}
                       function    getClassOperator: TClassOperator; virtual; abstract;
                       {initialiser l'oprateur de calcul}
                       procedure   initializeOperator(); virtual;
                       {appel en dernier dans le create pour des ventuels ajouts}
                       procedure   InitializationsAfterInsertion(); virtual;
                       {rafrachir la sortie le cas chant - ds la connexion}
                       procedure   RefreshOutput(); virtual; abstract;
                       {sauver les infos sur le composant - surchargeable}
                       procedure   SaveComponentInfoToStream(prmStream: TStream); virtual;
                       {sauver les infos du composant dans un fichier INI - surchargeable}
                       procedure   SaveComponentInfoToINI(prmINI: TMemIniFile); virtual;
                       {sauver les infos sur l'oprateur associ - not surchargeable}
                       procedure   SaveOperatorInfoToStream(prmStream: TStream);
                       {sauver les infos sur l'oprateur associ dans un fichier INI - not surchargeable}
                       procedure   SaveOperatorInfoToINI(prmINI: TMemIniFile);
                       {charger les infos sur le composant - surchargeable}
                       procedure   LoadComponentInfoFromStream(prmStream: TStream); virtual;
                       {charger les infos sur l'oprateur associ - not surchargeable}
                       procedure   LoadOperatorInfoFromStream(prmStream: TStream);
                       {charger les infos d'un composant  partir d'un fichier INI}
                       procedure   LoadComponentInfoFromINI(prmSection: string; prmINI: TMemIniFile); virtual;
                       {charger les infos de l'oprateur  partir du fichier INI}
                       procedure   LoadOperatorInfoFromINI(prmSection: string; prmINI: TMemIniFile);
                       public
                       {construction et surtout passage de quelques paramtres importants
                       (1) le diagramme auquel il appartient,
                       (2) le gnrateur de composant associ,
                       (3) son prdecesseur (ce dernier est  nil si l'on cre pour la premire fois une filire}
                       constructor CreateMLComponent(prmDiagram: TMLDiagram; prmGen: TMLGenComp; prmPred: TMLComponent); virtual;
                       {destruction - virer les listes autres gnrations locales}
                       destructor  Destroy; override;
                       {sauvegarde dans un flux (bis) - seule le numro d'icne est sauvegard pour l'instant}
                       procedure   SaveToStream(prmStream: TStream);
                       {sauvegarde dans in fichier INI}
                       procedure   SaveToIniFile(prmIni: TMemIniFile);
                       {chargement  partir d'un flux}
                       procedure   LoadFromStream(prmStream: TStream);
                       {cahrgement  partir d'un fichier INI}
                       procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile);
                       {Vrifie que la connexion est possible
                       --> "prmGen" est le gnrateur du composant que l'on veut insrer  la suite du composant courant}
                       function    isConnectable(prmGen: TMLGenComp): boolean; virtual;
                       {vrifie que c'est une feuille}
                       function    isLeaf(): boolean;
                       {tester si le composant est en cours de visualisation}
                       function    isShowing(): boolean;
                       {montrer automatiquement la bote de dialogue de paramtres}
                       procedure   ShowDlgParameters();
                       {envoyer un message  l'utilisateur}
                       procedure   SendUserMessage(prmStr: string); virtual;
                       {envoyer un message d'excution}
                       procedure   SendExecutionMessage(prmStr: string);
                       {fermer message d'excution}
                       procedure   CloseExecutionMessage();
                       {ajouter des infos  la description du composant}
                       procedure   AddInfosDescription(prmStr: string);
                       {invalider le composant et ses successeurs}
                       procedure Invalidate(); virtual;
                       {invalider les successeurs pour cause d'excution}
                       procedure InvalidateForExecution(); virtual;
                       {execution du composant}
                       function  Execute(prmForce: boolean): boolean; virtual;
                       {obtenir le nom de frame HTML du composant}
                       function    getHTMLFrameName(): string;
                       {obtenir le nom de menu HTML du composant}
                       function    getHTMLMenuName(): string;
                       {obtenir le nom de descriptif HTML du composant}
                       function    getHTMLDescriptionName(): string;
                       {obtenir le contenu du frame de composant}
                       function    getHTMLFrameContents(): string;
                       {obtenir le contenu du menu de composant}
                       function    getHTMLMenuContents(): string;
                       {obtenir la description des rsulats de composant}
                       function    getHTMLDescriptionContents(): string;
                       {renvoie la section INI corresp au composant}
                       function    sectionINI(): string; virtual;
                       {new -- 11/05/2006 -- se copier sous un composant de destination}
                       procedure   copySubTree(prmDestination: TMLComponent);
                       {new -- 11/05/2006 -- cloner l'embedded dans le composant, le cas chant, surcharg dans la meta-spv, rien ici}
                       procedure   cloneEmbedded(prmComponentSource: TMLComponent); virtual;
                       {new -- 11/05/2006 -- dupliquer les paramtres d'un composant source}
                       procedure   duplicateParameters(prmSource: TMLComponent);
                       {Description du composant}
                       property Description: string read FDescription;
                       {le composant pre}
                       property Predecessor: TMLComponent read FPredecessor write FPredecessor;
                       {Le nombre de successeus, composants enfants}
                       property NbSuccessors: Integer read getNbSuccessors;
                       {les successeurs, attention zro based}
                       property Successeur[i: Integer]: TMLComponent read getSuccessor;
                       {pointeur sur la liste des successeurs - utilis pour les ajouts/suppressions}
                       property Successors: TObjectList read FSuccessors;
                       {le noeud dans le treeview}
                       property TvNode: TTreeNode read FTreeNode;
                       {numro d'icne pour l'tat cf. composant embedded}
                       property NumIconState: integer read FNumIconState write FNumIconState;
                       {le popup menu associ}
                       property PopMenu: TPopupMenu read FPopupMenu;
                       {l'oprateur associ}
                       property Operator: TOperator read FOperator;
                       {numro interne}
                       property Number: Integer read FNumber write SetNumber;
                       {nom de la classe gnratrice}
                       property MLGenClassName: shortstring read FMLGenClassName;
                       {diagramme associ}
                       property Diagram: TMLDiagram read FDiagram write setDiagram;
                       end;

        {Le gestionnaire de diagramme (filire, stream, etc.) - Le coeur de l'affaire (bis) !!!}
        TMLDiagram = class(TObject)
                     private
                     {composant courant pour le dposer}
                     FMLComp: TMLComponent;
                     {Gnrateur courant  traiter}
                     FItemGen: TMLGenComp;
                     {Fiche dans laquelle est dock le composant}
                     FOwner: TComponent;
                     {pour cause de rf. croise, on ne le type pas compltement ici}
                     FFrmMLDiag: TFrmBase;
                     {Le treeview auquel est rattach le diagramme}
                     FTreeView: TTreeView;
                     {La source d'images pour les icnes de description}
                     FImages: TImageList;
                     {La source d'images pour les icnes supervised learning, et plus gnralement pour les afficheur d'tat}
                     FStateImages: TImageList;
                     {liste de composants du diagramme de traitement - list propertary}
                     FLstMLComp: TObjectList;
                     {L'ensemble de donnes associe au diagramme}
                     FDataset: TLstAttributes;
                     {Le premier composant qui est forcment un accs aux donnes,
                     sa cration passe galement par un processus diffrent des autres.
                     Il sera toujours premier dans la liste des composants}
                     FRootMLComp: TMLComponent;
                     {Nom du fichier de connexion}
                     FDatabaseName: string;
                     {Titre de l'analyse}
                     FTitle: string;
                     {nom du fichier de sauvegarde du diagramme}
                     FFileName: string;
                     {nom du fichier HTML pour les rapports}
                     FHTMLFileName: string;
                     {objet info. sur le processus de chargement des donnes}
                     FHTMLAccessInfos: TAccessDataInfo;
                     {new -- 20/06/2005 -- indicateur spcifique pour les procdures de validation dans le diagramme (ex. CV, Bootstrap, etc.}
                     FAssessmentProcessing: boolean;
                     {new -- 11/05/2006 -- pile courante des composants  copier, pour viter les duplications sauvages  l'infini de squences d'arbres}
                     FLstCompDuplicated: TObjectList;
                     {modifier la valeur de l'indicateur "en-cours d'valuation"}
                     procedure   setAssessmentProcessing(newValue: boolean);
                     {modifer le nom du fichier HTML}
                     procedure   setHTMLFileName(prmNewName: string);
                     {initialisation de la fiche de gestion}
                     procedure   InitializeForm(AOwner: TComponent);
                     {autres diverses initialisations - listes, etc.}
                     procedure   OtherInitializations();
                     {connexion avec les donnes puis chargement  la vole
                     renvoie true si tout est ok !!!}
                     function    ConnectDataset(): Boolean;
                     {crer le composant d'accs aux donnes}
                     function    CreateFirstComponent(): Boolean;
                     {fermer le diagramme, pralable  toute destruction}
                     procedure   Close();
                     {chargement  partir d'un flux}
                     procedure   LoadFromStream(prmStream: TStream);
                     {chargement  partir d'un fichier INI}
                     procedure   LoadFromIniFile(prmINI: TMemIniFile);
                     {accs au composant ni}
                     function    GetMLComponent(i: Integer): TMLComponent;
                     {supprimer un composant et sa branche si elle existe}
                     procedure   DeleteMLComponent(prmMLComp: TMLComponent);
                     {gestion du popup menu sur le diagramme}
                     procedure   OnContextPopup(Sender: TObject; MousePos: TPoint; var Handled: Boolean);
                     {demander si le dpt d'un composant sur le diagramme est accept ;
                     new -- 11/05/2006 -- accepter aussi le copier-coller dans l'arbre}
                     procedure   OnDragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
                     {dposer un composant  la suite (ou en dedans) d'un autre}
                     procedure   OnDragDrop(Sender, Source: TObject; X, Y: Integer);
                     {visualiser le composant suite  un double-clic}
                     procedure   OnDblClick(Sender: TObject);
                     {new -- 13/06/2005 -- affichage des tats du composant courant}
                     procedure   OnAdvancedCustomDrawItem(Sender: TCustomTreeView; Node: TTreeNode; State: TCustomDrawState; Stage: TCustomDrawStage; var PaintImages, DefaultDraw: Boolean);
                     {sauvegarde simplissime des composants dans un flux}
                     procedure   SaveComponentsToStream(prmComp: TMLComponent; prmStream: TStream);
                     {sauvegarde simplissime des composants dans un fichier au format INI}
                     procedure   SaveComponentsToMemINI(prmComp: TMLComponent; prmINI: TMemIniFile); 
                     {chargement simplissime des composants dans un flux}
                     procedure   LoadComponentsFromStream(prmPred: TMLComponent; prmStream: TStream);
                     {chargement  partir d'un fichier INI}
                     procedure   LoadComponentsFromIniFile(prmSection: string; prmPred: TMLComponent; prmINI: TMemIniFile);
                     {sauvegarde dans un fichier binaire}
                     procedure   SaveToBinaryFile(prmFileName: string = ''); virtual;
                     {new - 06/09/3 - sauver le tout dans un fichier au format INI}
                     procedure   SaveToINIFile(prmFileName: string = ''); virtual;
                     {rcuprer  partir d'un flux}
                     procedure   GetFromStream(prmFilename: string);
                     {rcuprer  partir d'un fichier INI}
                     procedure   GetFromINI(prmFileName: string);
                     {rcuprer le chemin du fichier HTML du diagramme}
                     function    GetHTMLFilePath(): string;
                     public
                     {attention, le deuxime paramtre sert  vrifier que tout est ok
                     i.e. connexion aux donnes et cration du premier composant dataset}
                     constructor Create(AOwner: TComponent; prmImages: TImageList; prmStateImages: TImageList; var prmOk: Boolean);
                     {chargement  partir d'un fichier}
                     constructor CreateFromFile(AOwner: TComponent; prmImages: TImageList; prmFileName: string);
                     {sauvegarde des composants dans un flux}
                     procedure   SaveToStream(prmStream: TStream);
                     {sauvegarde gnrique qui teste le type de fichier  grer}
                     procedure   SaveToFile(prmFileName: string = '');
                     {crire les informations dans un fichier INI}
                     procedure  SaveToMemINI(prmINI: TMemINIFile);
                     {destructor}
                     destructor  Destroy; override;
                     {ajouter un composant dans la liste, avec qq tests}
                     procedure   AddMLComponent(prmMLComp: TMLComponent);
                     {lancer l'excution sur l'ensemble des feuilles}
                     procedure   FullExecute();
                     {rcuprer le nom de frame associ au diagramme}
                     function    getHTMLFrameName(): string;
                     {supprimer le composant slectionn et ses descendants}
                     procedure   DelCurMLComponent();
                     {rcuprer l'instance de lecture des fichiers de donnes externes -- utilise l'extension de fichier}
                     function    getInstanceReaderFile(fileName: string; prmLstAtt: TLstAttributes): TAccessAbstract;
                     {la liste des composants du diagramme}
                     property    LstMLComp: TObjectList read FLstMLComp;
                     {composant ni}
                     property    MLComponent[i: integer]: TMLComponent read GetMLComponent;
                     {premier composant, la racine}
                     property    RootMLComp: TMLComponent read FRootMLComp;
                     {le treeview associ}
                     property    TreeView: TTreeView read FTreeView;
                     {la fiche associe au diagramme}
                     property    FrmMLDiagram: TFrmBase read FFrmMLDiag;
                     {ensemble de donnes trait}
                     property    Dataset: TLstAttributes read FDataset;
                     {nom du fichier charg}
                     property    DatabaseName: string read FDatabaseName;
                     {titre du diagramme}
                     property    Title: string read FTitle;
                     {nom du rapport HTML}
                     property    HTMLFileName: string read FHTMLFileName write setHTMLFileName;
                     {rpertoire du rapport HTML}
                     property    HTMLFilePath: string read getHTMLFilePath;
                     {nom du fichier de diagramme}
                     property    FileName: string read FFileName;
                     {infos sur les chargements de donnes}
                     property    HTMLAccessInfos: TAccessDataInfo read FHTMLAccessInfos;
                     {infos sur une valuation courante dans le diagramme}
                     property    AssessmentProcessing: boolean read FAssessmentProcessing write setAssessmentProcessing;
                     end;

implementation

uses
        SysUtils, Forms, Windows, ImgList, Dialogs,
        UFrmDiagramManager, UFrmMainForm, UDlgDatasetDownload, UCompDataset,
        ULogFile, UConstConfiguration, UPaletteGenCompDefinition,
        UMLDiagramReport, UFrmPaletteGenComponents, UDataAccessTextFile,
        UBatchExecution, UDataAccessWEKAFile, UDataAccessExcelFile,
        UCompSpvScoring, UCompSpvAssesTestSet;

const
        {signet pour le paramtrage}
        HTML_ANCHOR_PARAMETERS='Parameters';

        {signet pour le rsum des rsultats}
        HTML_ANCHOR_SUMMARY = 'Summary';

        {section dans le fichier}
        dgm_ini_section = 'Diagram';

{ TMLGenComp }

constructor TMLGenComp.Create(prmName,prmBitmap,prmDescription: string);
begin
 inherited Create();
 self.GenCompInitializations();
 //rcuprer les paramtres
 if (prmName<>'') then self.FMLCompName:= prmName;
 if (prmBitmap<>'') then self.FMLBitmapFileName:= prmBitmap;
 if (prmDescription<>'') then self.FMLCompDescription:= prmDescription;
 //charger le fichier bitmap
 self.GetBitmap();
end;

destructor TMLGenComp.Destroy;
begin
 FMLBitmap.Free;
 inherited Destroy();
end;

procedure TMLGenComp.GetBitmap;
var fbm: string;
begin
 //construire le chemin de recherche des bitmaps
 fbm:= S_PATH_EXE+ML_COMPONENTS_BITMAP_SUB_DIR+'\';
 //puis le nom complet
 fbm:= fbm+self.MLBitmapFileName;
 //tester l'existence du fichier
 if FileExists(fbm)
  then
   //chargement
   begin
    FMLBitmap:= Graphics.TBitmap.Create();
    FMLBitmap.LoadFromFile(fbm);
   end
  else
   //rcupration de l'icne de l'appli
   begin
    FMLBitmap:= Graphics.TBitmap.Create();
    FrmPaletteComp.ImageListSecours.GetBitmap(0,FMLBitmap);
   end;
end;

{ TMLComponent }

function TMLComponent.AfterExecution: boolean;
begin
 //rafrachir la sortie
 self.RefreshOutput();
 //affichage
 //self.FTreeNode.TreeView.Canvas.Font.Color:= DGM_FONT_COLOR;
 //self.FTreeNode.TreeView.Refresh();
 self.CloseExecutionMessage();
 //toujours ok ????
 result:= true;
end;

function TMLComponent.AskPredecessorExecution(prmForceExec: boolean): boolean;
var dispo: boolean;
begin
 dispo:= self.isAvailable();
 //si non(dispo) OU execution force -> on execute
 if not(dispo) or prmForceExec
  then result:= self.Execute(prmForceExec or self.FForcePredecessorExecute)
  //ici -> dispo et pas d'execution force
  else result:= true;
end;

function TMLComponent.BeforeExecution: boolean;
begin
 //invalider les noeuds successeurs
 self.InvalidateForExecution();
 //trs moche mais a marche...
 //self.FTreeNode.TreeView.Canvas.Font.Color:= DGM_FONT_COLOR_EXECUTION;
 //self.FTreeNode.TreeView.Canvas.TextOut(self.FTreeNode.DisplayRect(TRUE).Left+1,self.FTreeNode.DisplayRect(TRUE).Top+1,self.FTreeNode.Text);
 //self.FTreeNode.Selected:= TRUE;
 self.SendExecutionMessage('execution...');
 application.ProcessMessages();
 //toujours ok pour l'instant, pas de cas o a peut planter ?
 result:= true;
end;

function TMLComponent.CoreExecution: boolean;
//var heapBefore, heapAfter: THeapStatus;
begin
 FExecDuration:= GetTickCount();
 //heapBefore:= GetHeapStatus();
 result:= FOperator.Execute();
 //heapAfter:= GetHeapStatus();
 FExecDuration:= GetTickCount()-FExecDuration;
 //difHeap:= heapAfter.TotalAllocated-heapBefore.TotalAllocated;
 //if (difHeap<0) then difHeap:= 0;
 TraceLog.WriteToLogFile('---------------------------------');
 TraceLog.WriteToLogFile(Format('CORE_EXECUTE DURATION -->> "%s" : %d ms.',[self.Description,FExecDuration]));
 TraceLog.WriteToLogFile(Format('CORE_EXECUTE RESULTS  -->> "%s" : %s',[self.Description,self.GetLogResultDescription()]));
 TraceLog.WriteToLogFile('---------------------------------');
end;

constructor TMLComponent.CreateMLComponent(prmDiagram: TMLDiagram;
  prmGen: TMLGenComp; prmPred: TMLComponent);
begin
 inherited Create();
 self.Initializations();
 self.GetInfosGenerator(prmGen);
 self.InsertIntoDiagram(prmDiagram,prmPred);
 self.InitializationsAfterInsertion();
 self.RefreshOutput();
end;

destructor TMLComponent.Destroy;
begin
 TRY
 //new -- 13/06/2005 -- se dconnecter du treeview
 self.FTreeNode:= NIL;
 //
 FSuccessors.Free;
 //TraceLog.WriteToLogFile('** begin destroy operator >> '+FOperator.ClassName);
 FOperator.Free;
 TraceLog.WriteToLogFile(format('[DESTROY ML_COMP] ok end destroy operator ** %s **',[self.ClassName]));
 EXCEPT
 TraceLog.WriteToLogFile(format('[DESTROY ML_COMP] !!! ERROR !!! DESTROY >> ** %s **',[self.ClassName]));
 END;
 inherited destroy();
end;

function TMLComponent.Execute(prmForce: boolean): boolean;
var ok: boolean;
    sMsg: string;
begin
 //vrifier si affichage en cours
 if self.isShowing
  then self.Operator.ReleaseForm;
 //on lance...
 ok:= true;
 TRY
 //si dispo et pas de demande d'excution force
 if not(self.isAvailable()) or prmForce
  then
   begin
    //vrifer si prdcesseur execut
    if assigned(self.FPredecessor)
     then ok:= self.Predecessor.AskPredecessorExecution(prmForce or self.FForcePredecessorExecute);
    //si les prdcesseurs sont ok
    if ok
     then
      begin
       TraceLog.WriteToLogFile(format('{%s} running....',[self.ClassName]));
       //prparer l'execution et si bon, lancer l'execution et finir
       //valuation de gauche  droite, il suffit que l'un d'eux craque
       //et le lancement de la procdure suivante est annule
       {$B-}
       ok:= self.BeforeExecution();
       if ok then sMsg:= '<< before --- ';
       ok:= ok and self.CoreExecution();
       if ok then sMsg:= sMsg+'core --- ';
       ok:= ok and self.AfterExecution();
       if ok then sMsg:= sMsg+'after >>';
       TraceLog.WriteToLogFile(sMsg);
       //new -- 13/06/2005 -- demander le rafrachissement du treeview pour que l'tat soit visible
       //self.FTreeNode.TreeView.Refresh();
      end;
   end;
 //renvoyer l'tat de l'xecution
 EXCEPT
 On E: Exception Do
  TraceLog.WriteToLogFile(format('[EXECUTE ML_COMP] !!! ERROR !!! >> classname = %s ** msg = %s',[self.ClassName,E.Message]));
 END;
 result:= ok;
end;

procedure TMLComponent.getInfosGenerator(prmGen: TMLGenComp);
begin
 FNumIcon:= prmGen.MLNumIcon;
 FDescription:= prmGen.MLCompName;
 FMLGenClassName:= prmGen.ClassName;
end;

function TMLComponent.getNbSuccessors: Integer;
begin
 result:= FSuccessors.Count;
end;

function TMLComponent.getSuccessor(i: Integer): TMLComponent;
begin
 result:= FSuccessors.Items[i] as TMLComponent;
end;

procedure TMLComponent.Initializations;
begin
 FNumIconState:= -1;//pour l'instant, et dans la plupart des cas
 //les listes associes
 FSuccessors:= TObjectList.Create(FALSE);
 //le menu contextuel associ
 FPopupMenu:= TPopupMenu.Create(NIL);
 self.InitMenus();
 //on n'est pas du genre compliqu pour l'instant
 FForcePredecessorExecute:= FALSE;
end;

procedure TMLComponent.InsertIntoDiagram(prmDiagram: TMLDiagram;
  prmPred: TMLComponent);
begin
 TRY
 //brancher le diagramme
 FDiagram:= prmDiagram;
 //ajouter dans la liste des composants
 FDiagram.AddMLComponent(self);
 //ajouter dans la liste des successeurs
 if (prmPred<>nil)
  then
   begin
    prmPred.Successors.Add(self);
    self.Predecessor:= prmPred;
    self.FTreeNode:= FDiagram.TreeView.Items.AddChild(prmPred.TvNode,self.FDescription);
   end
  else self.FTreeNode:= FDiagram.TreeView.Items.Add(nil,self.FDescription);
 //l'icne de description
 self.FTreeNode.ImageIndex:= self.FNumIcon;
 self.FTreeNode.SelectedIndex:= self.FNumIcon;
 self.FTreeNode.Data:= self;
 EXCEPT
 TraceLog.WriteToLogFile('!!! ERROR !!! >> MLCOMP -- INSERT_INTO_DIAGRAM ::: '+ self.ClassName);
 Exception.Create('unexpected error insert_into_diagram : >>'+self.ClassName+'<<, restart TANAGRA');
 END;
end;

procedure TMLComponent.Invalidate;
var i: integer;
begin
 //avant execution ou successivement  un nouveau paramtrage
 self.FOperator.IsAvailable:= FALSE;//ferme par la mme occasion les fiches
 for i:= 0 to pred(self.Successors.Count) do
  self.Successeur[i].Invalidate();
end;

function TMLComponent.isAvailable: boolean;
begin
 result:= FOperator.IsAvailable;
end;

function TMLComponent.isConnectable(prmGen: TMLGenComp): boolean;
var ok: boolean;
begin
 //tout peut tre connect  la suite sauf... (QUESTION [18/07/2005] --> un peu bricolage tout a, ce ne serait pas mieux que ce soit celui qui se connecte qui demande la permission ?)
 //le supervis qui doit tre embedded
 //ok:= (prmGen.MLComp <> mlcSpvLearning);
 //>>new -- 06/03/2006 -- pourvoir insrer directement un Supervised (mais une gestion  part)
 ok:= TRUE;
 //assessment qui ne peut tre que conscutif  un MetaSupervised -- new, 18/07/2005 --> sauf le cas de Assesment sur Test set o le contrle est ralis avec CheckAttributes (lors de l'excution)
 ok:= ok and ((prmGen.MLComp <> mlcSpvAssessment) OR ((prmGen.MLComp = mlcSpvAssessment) AND (prmGen.ClassType = TMLGenCompSpvAssesTestSet)));
 //un compute-score qui ne peut tre galement que conscutif  un MetaSupervised
 ok:= ok and not((prmgen.MLComp = mlcSpvScoring) and (prmgen.ClassType = TMLGenComputeScore));
 //and then...
 result:= ok;
end;


procedure TMLComponent.OnMenuExecute(Sender: TObject);
begin
 self.Execute(self.FForcePredecessorExecute);
 //si demande par menu -- rafrachissement affichage diagramme
 if (sender <> nil)
  then self.Diagram.TreeView.Refresh();
end;

procedure TMLComponent.OnMenuParameters(Sender: TObject);
begin
 //vrifier si la fiche est en cours de visualisation
 //la deuxime condition est trs moche mais on ne va pas tout r-crire pour une classe
 if assigned(Operator.Form) and (self.ClassType<>TMLCompDataset)
  then Operator.ReleaseForm();
 //ok, on peut montrer, si modif des paramtres, tous les composants successeurs sont invalids
 if self.FOperator.PrmOp.AskParameter()
  then self.Invalidate();
 //new -- 13/06/2005 -- rafrachir l'tat visuel des composants
 self.Diagram.TreeView.Refresh();
end;

procedure TMLComponent.OnMenuView(Sender: TObject);
begin
 {$B-}
 if self.isAvailable or self.Execute(FForcePredecessorExecute)
  then
   begin
    self.FOperator.ShowForm();
    //et remettre en tat l'aspect visuel du diagramme
    if (sender <> nil)
     then self.Diagram.TreeView.Refresh();
   end;
end;

procedure TMLComponent.InitializationsAfterInsertion();
begin
 //initaliser l'oprateur qui a besoin des infos du predecesseur
 self.InitializeOperator();
end;

procedure TMLComponent.SetNumber(prmNumber: Integer);
begin
 FNumber:= prmNumber;
 FDescription:= FDescription+' '+IntToStr(FNumber);
end;

function TMLComponent.GetLogResultDescription: string;
begin
 result:= format('[%s] generated',[self.ClassName]);
end;

function TMLComponent.isLeaf: boolean;
begin
 result:= (self.Successors.Count=0);
end;

function TMLComponent.isShowing: boolean;
begin
 result:= assigned(self.Operator.Form);
end;

function TMLComponent.getHTMLDescriptionName: string;
begin
 result:= self.FDiagram.HTMLFilePath+self.getCoreFileName(self.FDiagram.HTMLFileName)+'_'+Format('description_%s.html',[self.Description]);
end;

function TMLComponent.getHTMLFrameName: string;
begin
 result:= self.FDiagram.HTMLFilePath+self.getCoreFileName(self.FDiagram.HTMLFileName)+'_'+Format('frame_%s.html',[self.Description]);
end;

function TMLComponent.getHTMLMenuName: string;
begin
 result:= self.FDiagram.HTMLFilePath+self.getCoreFileName(self.FDiagram.HTMLFileName)+'_'+Format('menu_%s.html',[self.Description]);
end;

function TMLComponent.getHTMLFrameContents: string;
var s: string;
begin
 s:= '<HTML><FRAMESET ROWS="100%,0%">';

 //virer le frame du dessus
 //s:= s+Format('<FRAME NAME="%s" SRC="%s">',[REPORT_FRAME_MLCOMPONENT_MENU_NAME,self.getHTMLMenuName()]);
 s:= s+Format('<FRAME NAME="%s" SRC="%s">',[REPORT_FRAME_MLCOMPONENT_DESCRIPTION_NAME,ExtractFileName(self.getHTMLDescriptionName())]);

 s:= s+'</FRAMESET></HTML>';
 result:= s;
end;

function TMLComponent.getHTMLMenuContents: string;
var s: string;
begin
 s:= '<HTML><HEAD>'+HTML_REPORT_CLASS_STYLE+'</HEAD>';
 s:= s+'<BODY class="BodyStyle">';
 s:= s+HTML_REPORT_FONT_STYLE;
 //le menu
 s:= s+format('<table width="%s" cellspacing="1">',[HTML_BUTTON_TITLE_WIDTH]);
 //les lments systmatiquement envoys dans le rapport
 //nom du composant
 s:= s+Format('<tr><td bgcolor="%s">%s</td></tr>',[HTML_BGCOLOR_MAIN_MENU,self.Description]);
 //paramtrage
 s:= s+self.AddHTMLMenu(HTML_ANCHOR_PARAMETERS,html_header_global_text_parameters);
 //rsum des rsultats
 s:= s+self.AddHTMLMenu(HTML_ANCHOR_SUMMARY,html_header_global_text_summary);
 //les lments optionnels du rapport
 //il y a une boucle  grer ici

 //??? voir l'insrtion des lments optionnels dans le menu HTML
 //ide mise de ct pour l'instant

 //finir la table et la page html
 s:= s+'</table></body></html>';
 //renvoyer le tout
 result:= s;
end;

function TMLComponent.getHTMLDescriptionContents: string;
var s: string;
begin
 s:= '<HTML><HEAD>'+HTML_REPORT_CLASS_STYLE+'</HEAD>';
 s:= s+'<BODY class="BodyStyle">';
 s:= s+HTML_REPORT_FONT_STYLE;

 if self.isAvailable
  then
   begin
     //mettre un titre, celui du composant
     s:= s+Format('<table width="%s"><tr><th bgcolor="%s">%s</th></tr></table>',[HTML_BUTTON_TITLE_WIDTH,HTML_BGCOLOR_MAIN_MENU,self.Description]);
     //description des paramtres
     s:= s+getHTMLParameters();
     s:= s+'<HR>';
     //rcupration des rsums de rsultats
     s:= s+getHTMLResultsSummary();
     s:= s+'<HR>';
     //pour chaque item slectionn, l'ajouter dans le rapport
     //les items de rapports sont standardiss pour le moment
   end
  else s:= s+'<H1>not available, execute before...</H1>';

 //insrer la dure d'excution
 s:= s+Format('Computation time : %d ms.<BR>',[FExecDuration]); 
 //insrer la date de cration
 s:= s+'Created at '+DateTimeToStr(Now());
 //finir la page
 s:= s+'</body></html>';
 result:= s;
end;

function TMLComponent.AddHTMLMenu(prmAnchor, prmDesc: string): string;
begin
 //??? extractfilename justifi ici ???
 result:= Format('<tr><td class="%s"> <a href="%s#%s" target="%s" class="%s">%s</a></td></tr>',[HTML_LINK_MENU_CLASS,ExtractFileName(self.getHTMLDescriptionName()),prmAnchor,REPORT_FRAME_MLCOMPONENT_DESCRIPTION_NAME,HTML_LINK_MENU_CLASS,prmDesc]);
end;

function TMLComponent.getHTMLParameters: string;
var s: string;
begin
 s:= self.AddHTMLTitle(HTML_ANCHOR_PARAMETERS,html_header_global_text_parameters);
 result:= s+'<P>'+self.Operator.getHTMLParameters();
end;

function TMLComponent.getHTMLResultsSummary: string;
var s: string;
begin
 s:= self.AddHTMLTitle(HTML_ANCHOR_SUMMARY,html_header_global_text_summary);
 result:= s+'<P>'+self.Operator.getHTMLResultsSummary();
end;

function TMLComponent.AddHTMLTitle(prmAnchor, prmDesc: string): string;
var s: string;
begin
 s:= Format('<A NAME="%s">',[prmAnchor]);
 s:= s+Format('<table width="%s"><tr><th bgcolor="%s">%s</th></tr></table>',[HTML_BUTTON_TITLE_WIDTH,HTML_BGCOLOR_LINK_MENU,prmDesc]);
 s:= s+'</A>';
 result:= s;
end;

procedure TMLComponent.ShowDlgParameters;
begin
 self.OnMenuParameters(NIL);
end;

procedure TMLComponent.SendUserMessage(prmStr: string);
var Rcoord: TRect;
    Pcoord: TPoint;
begin
 IF not(BATCH_MODE_EXECUTION)
  then
   begin
     Rcoord:= self.FTreeNode.DisplayRect(TRUE);
     Pcoord:= Rcoord.TopLeft;
     Pcoord:= self.FDiagram.TreeView.ClientToScreen(pcoord);
     Pcoord.Y:= Pcoord.Y+(Rcoord.Bottom-Rcoord.Top) div 2;
     (self.FDiagram.FrmMLDiagram as TFrmDiagramManager).dgmMsgHint.ShowMessage(Format('%s : %s',[self.Description,prmStr]),Pcoord.X,Pcoord.Y);
   end
  else
   begin
    Application.Title:= Format('%s : %s',[self.Description,prmStr]);
    //Application.ProcessMessages();//pour assurer le rafrachissement ?...
   end;
end;

procedure TMLComponent.InitMenus;
begin
 self.InitMenusParameters();
 self.InitMenusRun();
end;

procedure TMLComponent.InitMenusParameters;
var menu: TMenuItem;
begin
 //menu parameters
 menu:= TMenuItem.Create(FPopupMenu);
 menu.Caption:= 'Parameters...';
 menu.OnClick:= OnMenuParameters;
 FPopupMenu.Items.Add(menu);
end;

procedure TMLComponent.InitMenusRun;
var menu: TMenuItem;
begin
 //menu rien du tout
 menu:= TMenuItem.Create(FPopupMenu);
 menu.Caption:= '-';
 FPopupMenu.Items.Add(menu);
 //menu execute
 menu:= TMenuItem.Create(FPopupMenu);
 menu.Caption:= 'Execute';
 menu.OnClick:= OnMenuExecute;
 FPopupMenu.Items.Add(menu);
 //menu view
 menu:= TMenuItem.Create(FPopupMenu);
 menu.Caption:= 'View';
 menu.OnClick:= OnMenuView;
 FPopupMenu.Items.Add(menu);
end;

procedure TMLComponent.initializeOperator();
var classOp: TClassOperator;
begin
 //l'oprateur associ
 classOp:= self.getClassOperator();
 FOperator:= classOp.Create(self);
end;

procedure TMLComponent.AddInfosDescription(prmStr: string);
begin
 FDescription:= format('%s (%s)',[self.Description,prmStr]);
 self.TvNode.Text:= self.Description;
end;

procedure TMLComponent.InvalidateForExecution;
var i: integer;
begin
 //avant execution ou successivement  un nouveau paramtrage
 self.FOperator.IsAvailable:= FALSE;//ferme par la mme occasion les fiches
 //new -- 20/06/2005 -- attention, si assessment en cours, pas de propagation aux autres branches !!!
 if not(self.Diagram.AssessmentProcessing)
  then
   begin
     for i:= 0 to pred(self.Successors.Count) do
      self.Successeur[i].InvalidateForExecution();
   end;
end;

procedure TMLComponent.CloseExecutionMessage;
begin
 (self.FDiagram.FrmMLDiagram as TFrmDiagramManager).dgmMsgHint.HideMessage;
end;

procedure TMLComponent.SendExecutionMessage(prmStr: string);
begin
 (self.FDiagram.FrmMLDiagram as TFrmDiagramManager).dgmMsgHint.Color:= clMoneyGreen;
 self.SendUserMessage(prmStr);
end;

procedure TMLComponent.SaveToStream(prmStream: TStream);
//var nIcon: integer;
begin
 //numro d'icne
 //nIcon:= self.FNumIcon;
 //prmStream.WriteBuffer(nIcon,sizeof(nIcon));
 prmStream.WriteBuffer(FMLGenClassName,sizeof(FMLGenClassName));
 //std
 self.SaveComponentInfoToStream(prmStream);
 self.SaveOperatorInfoToStream(prmStream);
end;

procedure TMLComponent.SaveToIniFile(prmIni: TMemIniFile);
//var nIcon: integer;
begin
 //nIcon:= self.FNumIcon;
 //prmINI.WriteInteger(self.sectionINI(),'icon',nIcon);
 prmINI.WriteString(self.sectionINI(),'MLClassGenerator',self.MLGenClassName);
 //puis les sauvegardes standard
 self.SaveComponentInfoToINI(prmINI);
 self.SaveOperatorInfoToINI(prmINI);
end;

procedure TMLComponent.LoadComponentInfoFromStream(prmStream: TStream);
begin
 //nothing
end;

procedure TMLComponent.LoadOperatorInfoFromStream(prmStream: TStream);
begin
 FOperator.LoadFromStream(prmStream);
end;

procedure TMLComponent.SaveComponentInfoToStream(prmStream: TStream);
begin
 //nothing au dpart
end;

procedure TMLComponent.SaveOperatorInfoToStream(prmStream: TStream);
begin
 FOperator.SaveToStream(prmStream);
end;

procedure TMLComponent.LoadFromStream(prmStream: TStream);
begin
 //le numro d'icne a t charg par MLDiagram
 //le nom de classe gnratrice a t charg par MLDiagram
 //direct std
 self.LoadComponentInfoFromStream(prmStream);
 self.LoadOperatorInfoFromStream(prmStream);
end;

function TMLComponent.sectionINI: string;
begin
 result:= self.Description;
end;

procedure TMLComponent.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 //le numro d'icne a t charg par MLDiagram
 //le nom de la classe gnratrice a t charg par MLDiagram
 //suite chargement
 self.LoadComponentInfoFromINI(prmSection,prmINI);
 self.LoadOperatorInfoFromINI(prmSection,prmINI);
end;

procedure TMLComponent.SaveComponentInfoToINI(prmINI: TMemIniFile);
begin
 //nothing
end;

procedure TMLComponent.SaveOperatorInfoToINI(prmINI: TMemIniFile);
begin
 FOperator.SaveToINI(self.sectionINI(),prmINI);
end;

procedure TMLComponent.LoadComponentInfoFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 //nothing
end;

procedure TMLComponent.LoadOperatorInfoFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 FOperator.LoadFromINI(prmSection,prmINI);
end;

function TMLComponent.getCoreFileName(prmFileName: string): string;
var sExt,sCore: string;
begin
 sCore:= ExtractFileName(prmFileName);
 sExt:= ExtractFileExt(sCore);
 result:= Copy(sCore,1,Pos(sExt,sCore)-1);
end;

procedure TMLComponent.setDiagram(prmDiagram: TMLDiagram);
begin
 self.FDiagram:= prmDiagram;
end;

procedure TMLComponent.copySubTree(prmDestination: TMLComponent);
var srcItemGen: TMLGenComp;
    newComp: TMLComponent;
    i: integer;
begin
 //vrifier si on n'a pas t dj dupliqu, on peut y aller
 if (self.FDiagram.FLstCompDuplicated.IndexOf(self) < 0)
  then
   begin
    //gnrateur
    srcItemGen:= globalLstGenComp.getGenComp(self.FMLGenClassName);
    //si pas de gnrateur, laisse tomber...
    if assigned(srcItemGen)
     then
      begin
       //crer et insrer dans le diagramme,  destination, un clone du composant courant
       newComp:= srcItemGen.GetClassMLComponent.CreateMLComponent(prmDestination.Diagram,srcItemGen,prmDestination);
       //copier les paramtres
       newComp.duplicateParameters(self);
       //!\ajouter ce composant dans la liste des composants  ne pas dupliquer
       self.FDiagram.FLstCompDuplicated.Add(newcomp);
       //>> gestion spcifique pour les ventuels embedded...
       newComp.cloneEmbedded(self);
       //y a-t-il des successeurs  cloner aussi ?
       if (self.getNbSuccessors() > 0)
        then
         begin
          //appel rcursif sur les sommets successeurs
          for i:= 0 to pred(self.getNbSuccessors()) do
           self.getSuccessor(i).copySubTree(newComp);
         end;
      end;
   end;
end;

procedure TMLComponent.cloneEmbedded(prmComponentSource: TMLComponent);
begin
 //nothing...
end;

procedure TMLComponent.duplicateParameters(prmSource: TMLComponent);
var stream: TMemoryStream;
begin
 stream:= TMemoryStream.Create();
 //sauver les paramtres du composant source
 prmSource.Operator.PrmOp.SaveToStream(stream);
 //rcuprer ces paramtres
 stream.Seek(soFromBeginning,0);
 self.Operator.PrmOp.LoadFromStream(stream);
 //fin...
 stream.Free();
end;

{ TMLDiagram }

procedure TMLDiagram.AddMLComponent(prmMLComp: TMLComponent);
var i: Integer;
    maxnum: integer;
    mlc: TMLComponent;
begin
 //tester pour la numrotation
 if (self.FLstMLComp.Count = 0)
  //c'est le premier
  then self.FRootMLComp:= prmMLComp
  else
   //on lui attribue un numro interne
   begin
    maxnum:= 0;
    for i:= 0 to pred(self.FLstMLComp.Count) do
     begin
      mlc:= self.FLstMLComp.Items[i] as TMLComponent;
      if (mlc.ClassName = prmMlComp.ClassName) and (mlc.Number>maxnum)
       then maxnum:= mlc.Number;
     end;
    prmMLComp.Number:= succ(maxnum);
   end;
 //ajout dans la liste
 self.FLstMLComp.Add(prmMLComp);
end;

procedure TMLDiagram.Close;
begin
 //fermer la fiche
 if assigned(FFrmMLDiag)
  then
   begin
    (FOwner as TFrmMain).pnlMLDiagramDisplay.RemoveForm(FFrmMLDiag,FALSE);
    FFrmMLDiag.Release;
   end;
end;

function TMLDiagram.ConnectDataset: boolean;
var ok: boolean;
begin
 //cration de l'ensemble de donnes - fictif
 FDataset:= TLstAttributes.Create(TRUE,1);
 //faire apparatre la bote de chargement et lance le chargement demand
 with TDlgDatasetDownload.CreateFromDiagram(self,FDataset) do
  begin
   ok:= getDataset();
   //rcupration des infos
   FDatabaseName:= FileOpenEdit.Filename;
   FTitle:= edTitle.Text;
   FFileName:= DiagramSaveEdit.Filename;
   //destruction auto de la bote de chargement
   Release();
  end;
 //tester avant de sortir afin de librer le cas chant
 if not(ok)
  then
  begin
   FDataset.Free;
   FDataset:= NIL;
  end;
 result:= ok;
end;

constructor TMLDiagram.Create(AOwner: TComponent; prmImages: TImageList; prmStateImages: TImageList; var prmOk: Boolean);
begin
 inherited Create();
 FImages:= prmImages;
 FStateImages:= prmStateImages;
 self.InitializeForm(AOwner);
 self.OtherInitializations();
 prmOk:= self.ConnectDataset();
 if prmOk
  then prmOk:= self.CreateFirstComponent(); //un MLDataset bien sr
end;

function TMLDiagram.CreateFirstComponent: Boolean;
var CompDataset: TMLCompDataset;
begin
 result:= TRUE;
 TRY
 CompDataset:= TMLCompDataset.CreateMLComponent(self,NIL,NIL);
 //montrer la fiche de rsultat directement
 CompDataset.Operator.ShowForm();
 EXCEPT
 result:= FALSE;
 END;
end;

constructor TMLDiagram.CreateFromFile(AOwner: TComponent;
  prmImages: TImageList; prmFileName: string);
var sExt: string;
begin
 inherited Create();
 FImages:= prmImages;
 self.InitializeForm(AOwner);
 self.OtherInitializations();
 //connexion au fichier
 FFileName:= prmFileName;
 //RAZ la liste des infos pour le chargement
 self.FHTMLAccessInfos.reInitializeInfos();
 //chargement
 sExt:= UPPERCASE(ExtractFileExt(prmFileName));
 if (sExt='.BDM')
  then self.GetFromStream(FFileName)
  else self.GetFromINI(FFileName);
end;

procedure TMLDiagram.DelCurMLComponent;
var curComp: TMLComponent;
begin
 //rcuprer le composant courant
 curComp:= TMLComponent(FTreeView.Selected.Data);
 if assigned(curComp)
  then
   begin
    //on ne peut pas dtruire la racine du diagramme
    if (curComp<>FRootMLComp)
     then
      begin
        //dtruire la branche si elle existe, avant de se supprimer soi-mme
        self.DeleteMLComponent(curComp);
        //redessiner le treeview
        self.FTreeView.Refresh;
      end
     else FRootMLComp.SendUserMessage('Root component cannot be deleted');
   end;
end;

procedure TMLDiagram.DeleteMLComponent(prmMLComp: TMLComponent);
var i: integer;
    cComp: TMLComponent;
begin
 if not(prmMLComp.isLeaf)
  then
   begin
    //supprimer ses descendants
    for i:= pred(prmMLComp.NbSuccessors) downto 0 do
     begin
      cComp:= prmMLComp.Successeur[i];
      self.DeleteMLComponent(cComp);
     end;
    //donc maintenant, il doit tre une feuille
   end;
 //se supprimer de la liste de son pre
 if assigned(prmMLComp.Predecessor)
  then prmMLComp.Predecessor.Successors.Extract(prmMLComp);
 //se supprimer de la liste globale
 self.FLstMLComp.Extract(prmMLComp);
 //se supprimer du treeview
 self.FTreeView.Items.Delete(prmMLComp.TvNode);
 //de suicider enfin
 prmMLComp.Free;
end;

destructor TMLDiagram.Destroy;
begin
 //new -- 11/05/2006 -- liste temporaire pour les copier/coller
 if assigned(FLstCompDuplicated)
  then FLstCompDuplicated.Free();
 //new -- 13/06/2005 -- dconnecter le treeview
 self.FTreeView:= NIL;
 //fermer d'abord
 self.Close();
 //librer la liste des infos
 if assigned(FHTMLAccessInfos)
  then FHTMLAccessInfos.Free();
 //librer les composants
 if assigned(FLstMLComp)
  then FLstMLComp.Free;
 //librer les donnes
 if assigned(FDataset)
  then FreeAndNil(FDataset);
 //suite
 inherited Destroy;
end;

procedure TMLDiagram.FullExecute;
var i: integer;
    mlc: TMLComponent;
begin
 mlc:= nil;
 // executer toutes les feuilles
 for i:= 0 to pred(self.LstMLComp.Count) do
  begin
   mlc:= self.MLComponent[i];
   if mlc.isLeaf
    then mlc.OnMenuExecute(NIL);
  end;
 //montrer tous les sommets ???
 //new -- 20/06/2005 -- montrer la dernire fentre simplement
 if (mlc <> nil)
  then mlc.OnMenuView(NIL);
 (*
 for i:= 0 to pred(self.LstMLComp.Count) do
  begin
   mlc:= self.MLComponent[i];
   mlc.OnMenuView(NIL);
  end;
 *)
 //rafrachir affichage diagramme
 self.FTreeView.Refresh();
end;

procedure TMLDiagram.GetFromINI(prmFileName: string);
var fINI: TMemIniFile;
begin
 fINI:= TMemIniFile.Create(FFileName);
 self.LoadFromIniFile(fINI);
 fINI.Free;
end;

procedure TMLDiagram.GetFromStream(prmFilename: string);
var st: TFileStream;
begin
 st:= TFileStream.Create(FFileName,fmOpenRead);
 TRY
 self.LoadFromStream(st);
 FINALLY
 st.Free;
 END;
end;

function TMLDiagram.GetHTMLFilePath: string;
begin
 result:= ExtractFilePath(self.HTMLFileName);
end;

function TMLDiagram.getHTMLFrameName(): string;
var sPath: string;
begin
 FHTMLFileName:= ExpandUNCFileName(FHTMLFileName);
 sPath:= ExtractFilePath(FHTMLFileName);
 result:= sPath+'menu'+ExtractFileName(FHTMLFileName);
end;

function TMLDiagram.getInstanceReaderFile(fileName: string; prmLstAtt: TLstAttributes): TAccessAbstract;
var sExt: string;
begin
 sExt:= UPPERCASE(EXTRACTFILEEXT(filename));
 
 //ARFF ???
 if (sExt = '.ARFF')
  then result:= TAccessWekaFile.Create(prmLstAtt)
  //XLS ?
  else
   begin
    if (sExt = '.XLS')
     then result:= TAccessXlsFile.Create(prmLstAtt)
     //TXT donc.
     else result:= TAccessTextFile.Create(prmLstAtt);
   end;

end;

function TMLDiagram.GetMLComponent(i: Integer): TMLComponent;
begin
 result:= self.LstMLComp.Items[i] as TMLComponent;
end;

procedure TMLDiagram.InitializeForm(AOwner: TComponent);
begin
 FOwner:= AOwner;
 //construire la fiche de visualisation et sa connexion avec l'appli principale
 FFrmMLDiag:= TFrmDiagramManager.CreateFromDiagram(AOwner,self);
 (AOwner as TFrmMain).pnlMLDiagramDisplay.AddForm(FFrmMLDiag,TRUE);
 self.FTreeView:= (FFrmMLDiag as TFrmDiagramManager).tvMLDiagram;
 self.FTreeView.Images:= FImages;
 self.FTreeView.StateImages:= FImages;
 self.FTreeView.HideSelection:= FALSE;
 self.FTreeView.ReadOnly:= TRUE;
 self.FTreeView.Font.Name:= DGM_FONT_NAME;
 self.FTreeView.Font.Size:= DGM_FONT_SIZE;
 self.FTreeView.Font.Color:= DGM_FONT_COLOR;
 self.FTreeView.Color:= DGM_BACK_COLOR;
 //les gestionnaires d'vnements
 self.FTreeView.OnContextPopup:= OnContextPopup;
 self.FTreeView.OnDragOver:= OnDragOver;
 self.FTreeView.OnDragDrop:= OnDragDrop;
 self.FTreeView.OnDblClick:= OnDblClick;
 //new -- ??? -- 20/06/2005 -- gestion des tats du composant
 self.FTreeView.OnAdvancedCustomDrawItem:= OnAdvancedCustomDrawItem;
 //new -- 11/05/2006 -- gestion du copier-coller
 self.FTreeView.DragMode:= dmAutomatic; 
end;

procedure TMLDiagram.LoadComponentsFromIniFile(prmSection: string; prmPred: TMLComponent;
  prmINI: TMemIniFile);
var n,i: integer;
    GenComp: TMLGenComp;
    comp: TMLComponent;
    section: string;
    sClassGen: shortstring;
begin
 //numIcon:= prmINI.ReadInteger(prmSection,'icon',0);
 //if (numIcon<>0)
 sClassGen:=  prmINI.ReadString(prmSection,'MLClassGenerator',DATASET_GEN_CLASS_NAME);
 if (sClassGen<>DATASET_GEN_CLASS_NAME)
  then
   //ce n'est pas un dataset, donc on le gnre
   begin
    //la liste globale (globalLstGenComp) contient la description de tous les gnrateurs de composants
    //GenComp:= globalLstGenComp.getGenComp(numIcon);
    GenComp:= globalLstGenComp.getGenComp(sClassGen);
    comp:= GenComp.GetClassMLComponent.CreateMLComponent(self,GenComp,prmPred);
    comp.LoadFromINI(prmSection,prmINI);
   end
  else comp:= prmPred;
 //les enfants
 n:= prmINI.ReadInteger(prmSection,'successors',0);
 for i:= 1 to n do
  begin
   section:= prmINI.ReadString(prmSection,'succ_'+inttostr(i),'');
   if (section<>'')
    then self.LoadComponentsFromIniFile(section,comp,prmINI);
  end;
end;

procedure TMLDiagram.LoadComponentsFromStream(prmPred: TMLComponent;
  prmStream: TStream);
var n,i: integer;
    GenComp: TMLGenComp;
    comp: TMLComponent;
    sClassGen: shortstring;
    //heap: THeapStatus;
begin
 //prmStream.ReadBuffer(numIcon,sizeof(numIcon));
 //if (numIcon<>0)
 prmStream.ReadBuffer(sClassGen,sizeof(sClassGen));
 if (sClassGen<>DATASET_GEN_CLASS_NAME)
  then
   //ce n'est pas un dataset, donc on le gnre
   begin
    //la liste globale (globalLstGenComp) contient la description de tous les gnrateurs de composants
    //GenComp:= globalLstGenComp.getGenComp(numIcon);
    GenComp:= globalLstGenComp.getGenComp(sClassGen);
    comp:= GenComp.GetClassMLComponent.CreateMLComponent(self,GenComp,prmPred);
    comp.LoadFromStream(prmStream);
    //-- surveillance mmoire --
    //heap:= GetHeapStatus();
    //TraceLog.WriteToLogFile(format('%s --> %d',[sClassGen,heap.TotalAllocated]));
   end
  else comp:= prmPred;
 //rcuprer le nombre d'enfants
 prmStream.ReadBuffer(n,sizeof(n));
 for i:= 0 to pred(n) do
  self.LoadComponentsFromStream(comp,prmStream);
end;

procedure TMLDiagram.LoadFromIniFile(prmINI: TMemIniFile);
var FReader: TAccessAbstract;
begin
 FTitle:= prmINI.ReadString(dgm_ini_section,'Title','');
 FDatabaseName:= prmINI.ReadString(dgm_ini_section,'Database','');
 
 //rcuprer les donnes
 if assigned(FDataset) then FDataset.Free;
 FDataset:= TLstAttributes.Create(TRUE,0);


 //FReader:= TAccessTextFile.Create(FDataset);
 //*** 27/12/2004 *** largir le champ des formats de fichiers de donnes ***
 FReader:= self.getInstanceReaderFile(FDatabaseName,FDataset);
 //***
 if NOT(FReader.Connecting(FDatabaseName) and FReader.Download(NIL))
  then Raise Exception.Create('error dataset download');
 //rcuprer les infos ventuelles du reader
 self.FHTMLAccessInfos.recupInfosHTML(FReader.getLstInfosHTML());
 //librer (enfin) le reader
 FReader.Free;

 //crer le premier composant
 self.CreateFirstComponent();
 //charger les composants - la premire section est toujours 'Dataset' i.e. les donnes
 self.LoadComponentsFromIniFile('Dataset',FRootMLComp,prmINI);
 self.TreeView.FullExpand();
end;

procedure TMLDiagram.LoadFromStream(prmStream: TStream);
var l: integer;
    tps: cardinal;
    heap: THeapStatus;
    curMem: cardinal;
begin
 tps:= GetTickCount();
 //on charge uniquement les donnes, puis on cre le premier composant
 //lire le titre du diagramme
 prmStream.ReadBuffer(l,sizeof(l));
 setLength(FTitle,l);
 prmStream.ReadBuffer(FTitle[1],l);
 //lire le nom de la base
 prmStream.ReadBuffer(l,sizeof(l));
 setLength(FDatabaseName,l);
 prmStream.ReadBuffer(FDatabaseName[1],l);
 //lire les donnes
 if assigned(FDataset)
  then FDataset.Free;
 //mmoire avant chargement
 heap:= GetHeapStatus();
 curMem:= heap.TotalAllocated;
 //---------------------------------------------------
 FDataset:= TLstAttributes.CreateFromStream(prmStream);
 //---------------------------------------------------
 heap:= GetHeapStatus();
 //sMsgLog:= format('[DOWNLOAD -- MEMORY ALLOCATED] used mem for data = %d Ko ** ',[(heap.TotalAllocated-curMem) div 1024]);

 //afficher le temps de chargement des donnes et taille mmoire alloue
 tps:= GetTickCount() - tps;
 self.FHTMLAccessInfos.addInfoHTML(HTML_TABLE_COLOR_HEADER_GRAY+'<TH colspan=2>Datasource processing</TH></TR>');
 self.FHTMLAccessInfos.addInfoHTML(HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Computation time</TD><TD align="right">%d ms.</TD></TR>',[tps]));
 self.FHTMLAccessInfos.addInfoHTML(HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Allocated memory</TD><TD align="right">%d KB</TD></TR>',[(heap.TotalAllocated-curMem) div 1024]));

 //curMem:= heap.TotalAllocated;
 //crer le premier composant - rflchir  une option o l'on chargerait les donnes ou pas au dmarrage
 self.CreateFirstComponent();
 //charger les composants
 self.LoadComponentsFromStream(FRootMLComp,prmStream);
 //---------------------------------------------------
 //heap:= GetHeapStatus();
 //TraceLog.WriteToLogFile(format('Mmoire dispo et alloue aprs chargement des composants = %d, %d',[heap.TotalAddrSpace,heap.TotalAllocated]));
 //affichage total
 self.TreeView.FullExpand();
 //-------------------------
 heap:= GetHeapStatus();
 //sMsgLog:= sMsgLog+format('used mem for diagram = %d Ko',[(heap.TotalAllocated-curMem) div 1024]);
 //TraceLog.WriteToLogFile(sMsgLog);
 //vrif dure
 //tps:= GetTickCount()-tps;
 //TraceLog.WriteToLogFile('[I/O] TMLDiagram.LoadFromStream >> dure chargement = '+IntToStr(tps)+' ms.');
end;

procedure TMLDiagram.OnAdvancedCustomDrawItem(Sender: TCustomTreeView;
  Node: TTreeNode; State: TCustomDrawState; Stage: TCustomDrawStage;
  var PaintImages, DefaultDraw: Boolean);
var r: TRect;
    curMLC: TMLComponent;
begin
 //aucune raison de dessiner quoi que ce soit en mode BATCH
 if not(BATCH_MODE_EXECUTION)
  then
   begin
     curMLC:= TMLComponent(node.Data);
     //test si le noeud a l'tat non execut -- hum, hum, a sent un peu le bricolage tous ces tests...
     {$B-}
     if (Stage = cdPostPaint) and assigned(curMLC) and not(curMLC.isAvailable()) and assigned(FTreeView) and assigned(FTreeView.Images)
      then
       begin
        r:= node.DisplayRect(true);
        //bricolage pour l'instant -- rcuprer l'emplacement de l'image
        r.Left:= r.Left-FTreeView.Images.Width-3;
        r.Right:= r.Left+FTreeView.Images.Width;
        r.Top:= r.Top+1;
        //modifier le pinceau du canvas
        FTreeView.Canvas.Brush.Style:= bsSolid;
        FTreeView.Canvas.Brush.Color:= FTreeView.Color;
        //redessiner
        FTreeView.Canvas.FillRect(r);
        FTreeView.Images.Draw(FTreeView.Canvas,r.Left,r.Top,node.ImageIndex,dsSelected,itImage,true);
       end;
   end;
end;

procedure TMLDiagram.OnContextPopup(Sender: TObject; MousePos: TPoint;
  var Handled: Boolean);
var node: TTreeNode;
    posScreen: TPoint;
begin
 //est-ce un clic de souris ?
 if (MousePos.X>=0) and (MousePos.Y>=0)
  then node:= self.FTreeView.getNodeAt(MousePos.X,MousePos.Y)
  else node:= self.FTreeView.Selected;
 //valide ?
 if assigned(node)
  //comment rcuprer la bonne position de curseur lorsque le popup n'a pas t demand par souris
  //c'est le cas par ex. avec les menus contextuels
  //il faut dans ce cas rcuprer la coordonne du noeud (GetTextRect)
  //ce n'est pas primordial pour l'instant
  then
   begin
    posScreen:= FTreeView.ClientToScreen(MousePos);
    TMLComponent(node.Data).PopMenu.Popup(posScreen.X,posScreen.Y);
   end;
end;

procedure TMLDiagram.OnDblClick(Sender: TObject);
var curMLC: TMLComponent;
begin
 //rcuprer le composant courant
 if assigned(self.FTreeView.Selected)
  then
   begin
    curMLC:= TMLComponent(self.FTreeView.Selected.Data);
    if assigned(curMLC)
     then curMLC.OnMenuView(sender);
   end;
end;

procedure TMLDiagram.OnDragDrop(Sender, Source: TObject; X, Y: Integer);
begin
 //c'est parti, on connecte la bte
 //new -- 11/05/2006 -- attention, on peut avoir  grer un copier-coller  l'intrieur de l'arbre
 if (sender = source)
  //ajouter en dessous du composant FMLComp le sous-arbre sous "Selected"
  then
    begin
    //vider la liste temporaire pour viter la duplication dans les appels rcursifs
    FLstCompDuplicated.Clear();
    //zoo... maintenant
    TMLComponent(self.FTreeView.Selected.Data).copySubTree(FMLComp);
    end
  //ajout classique d'un nouveau composant  partir de la palette
  else FItemGen.GetClassMLComponent.CreateMLComponent(self,FItemGen,FMlComp);
 //puis on montre la chose
 self.FTreeView.FullExpand();
 self.FTreeView.Refresh();
end;

procedure TMLDiagram.OnDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
var node: TTreeNode;
    item: TListItem;
    //new -- 11/05/2006
    srcCopyNode: TTreeNode;
    srcCopyComp: TMLComponent;
begin
 //vrifier si la connexion est valable
 Accept:= FALSE;
 node:= self.FTreeView.GetNodeAt(X,Y);
 //vrifer que c'est bien un gnrateur de component qui arrive
 {$B-}
 if assigned(node)
  then
   begin
    //*******************************
    //cration  partir du gnrateur
    //*******************************
    if (source is TListView)
     then
      begin
       item:= (source as TListView).Selected;
       if assigned(item)
        then
         begin
          FItemGen:= TListItemMLComponent(item.Data).MLGenComp;
          FMlComp:= TMLComponent(node.Data);
          if FMlComp.isConnectable(FItemGen)
           then Accept:= TRUE;//enfin !!!
         end;
      end;
      
     //***********************************************
     //new -- 11/05/2006 -- copier-coller dans l'arbre
     //***********************************************
     //ok si : noeud de destination ok, la source est la TTreeView elle-mme
     if (Sender = Source)
      then
       begin
        {$B-}
        if assigned(self.FTreeView.Selected) and assigned(self.FTreeView.Selected.Data)
         then
          begin
           //rcuprer le composant de dpart
           srcCopyNode:= self.FTreeView.Selected;
           srcCopyComp:= TMLComponent(srcCopyNode.Data);
           //on essaie pas de recopier  partir de la racine ?
           if (srcCopyComp <> self.FRootMLComp)
            then
             begin
              FMlComp:= TMLComponent(node.Data);
              //rcuprer le gnrateur correspondant
              FItemGen:= globalLstGenComp.getGenComp(srcCopyComp.FMLGenClassName);
              //tester la possibilit de connexion  partir de la source
              Accept:= TMLComponent(node.Data).isConnectable(FItemGen);
             end;
          end;
       end;
   end;
end;

procedure TMLDiagram.OtherInitializations;
begin
 FLstMLComp:= TObjectList.Create(TRUE);
 FHTMLAccessInfos:= TAccessDataInfo.create();
 FAssessmentProcessing:= FALSE;
 //new -- 11/05/2006 -- liste prive temporaire des composants dupliques pour viter un appel rcursif sans fin, non-propritaire
 FLstCompDuplicated:= TObjectList.Create(FALSE);
end;

procedure TMLDiagram.SaveComponentsToMemINI(prmComp: TMLComponent;
  prmINI: TMemIniFile);
var i,n: integer;
    comp: TMLComponent;
begin
 prmComp.SaveToIniFile(prmINI);
 //les successeurs
 n:= prmComp.NbSuccessors;
 prmINI.WriteInteger(prmComp.sectionINI(),'successors',n);
 for i:= 1 to n do
  begin
   comp:= prmComp.Successeur[pred(i)];
   prmINI.WriteString(prmComp.sectionINI(),'succ_'+IntToStr(i),comp.sectionINI());
   self.SaveComponentsToMemINI(comp,prmINI);
  end;
end;

procedure TMLDiagram.SaveComponentsToStream(prmComp: TMLComponent;
  prmStream: TStream);
var i,n: integer;
    comp: TMLComponent;
begin
 prmComp.SaveToStream(prmStream);
 //les successeurs
 n:= prmComp.NbSuccessors;
 prmStream.WriteBuffer(n,sizeof(n));
 for i:= 0 to pred(n) do
  begin
   comp:= prmComp.Successeur[i];
   self.SaveComponentsToStream(comp,prmStream);
  end;
end;

procedure TMLDiagram.SaveToBinaryFile(prmFileName: string);
var st: TFileStream;
begin
 if (prmFileName<>'')
  then
   begin
    FFileName:= prmFileName;
    FHTMLFileName:= ChangeFileExt(FFileName,'.html');
   end;
 st:= TFileStream.Create(FFileName,fmCreate);
 self.SaveToStream(st);
 st.Free;
end;

procedure TMLDiagram.SaveToFile(prmFileName: string);
var sExt: string;
    tps: cardinal;
begin
 tps:= GetTickCount();
 //
 if (prmFileName<>'')
  then FFileName:= prmFileName;
 //tester le type de fichier
 sExt:= ExtractFileExt(FFileName);
 sExt:= UPPERCASE(sExt);
 if (sExt = '.BDM')
  then self.SaveToBinaryFile()
  else self.SaveToINIFile();
 //dure de sauvegarde
 tps:= GetTickCount()-tps;
 TraceLog.WriteToLogFile(format('[I/O] save duration = %d ms.',[tps]));
end;

procedure TMLDiagram.SaveToINIFile(prmFileName: string);
var fINI: TMemIniFile;
    tps: cardinal;
    sMsg: string;
begin
 if (prmFileName<>'')
  then
   begin
    FFileName:= prmFileName;
    FHTMLFileName:= ChangeFileExt(FFileName,'.html');
   end;
 //dispositif de sauvegarde
 sMsg:= '';
 tps:= getTickCount;
 fINI:= TMemIniFile.Create(FFileName);
 sMsg:= sMsg+format('[I/O] MEMINIFILES <create = %d ms>',[GetTickCount()-tps]);
 TRY
 tps:= getTickCount;
 fINI.Clear;
 sMsg:= sMsg+format('<clear = %d ms>',[GetTickCount()-tps]);
 tps:= getTickCount;
 self.SaveToMemINI(fINI);
 sMsg:= sMsg+format('<save = %d ms>',[GetTickCount()-tps]);
 tps:= getTickCount;
 fINI.UpdateFile;
 sMsg:= sMsg+format('<update to disk = %d ms>',[GetTickCount()-tps]);
 FINALLY
 TraceLog.WriteToLogFile(sMsg);
 //pour tre sr de librer le fichier
 fINI.Free;
 END;
end;

procedure TMLDiagram.SaveToMemINI(prmINI: TMemINIFile);
begin
 prmINI.WriteString(dgm_ini_section,'Title',FTitle);
 prmINI.WriteString(dgm_ini_section,'Database',FDatabaseName);
 self.SaveComponentsToMemINI(FRootMLComp,prmINI);
end;

procedure TMLDiagram.SaveToStream(prmStream: TStream);
var l: integer;
    tps: cardinal;
begin
 tps:= GetTickCount();
 //le titre de l'analyse
 l:= length(FTitle);
 prmStream.WriteBuffer(l,sizeof(l));
 prmStream.WriteBuffer(FTitle[1],l);
 //le nom de la base
 l:= length(FDatabaseName);
 prmStream.WriteBuffer(l,sizeof(l));
 prmStream.WriteBuffer(FDatabaseName[1],l);
 //la base
 FDataset.SaveToStream(prmStream);
 //sauvegarder de la structure
 self.SaveComponentsToStream(FRootMLComp,prmStream);
 //fin de sauvegarde
 tps:= GetTickCount()-tps;
 TraceLog.WriteToLogFile('[I/O] TMLDiagram.SaveToStream >> dure sauvegarde ::: '+IntToStr(tps)+' ms.');
end;

procedure TMLDiagram.setAssessmentProcessing(newValue: boolean);
begin
 FAssessmentProcessing:= newValue;
end;

procedure TMLDiagram.setHTMLFileName(prmNewName: string);
begin
 FHTMLFileName:= prmNewName;
end;

end.
