(*************************************************************************)
(* UDlgBaseOperatorParameter.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*************************************************************************)

{
@abstract(Bote de dialogue de base pour les paramtres d'oprateur)
@author(Ricco)
@created(12/01/2004)
Les plus important dans cette classe est la prsence de procdures pour passer et
rcuprer les rsultats de manipulation de paramtres d'oprateurs.
}
unit UDlgBaseOperatorParameter;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBase, StdCtrls, ExtCtrls, UOperatorDefinition, ComCtrls,
  CheckLst;

type
  {Toutes les botes de paramtrage doivent en deriver}
  TDlgBaseOperatorParameter = class(TDlgBase)
    pgCtrlPrm: TPageControl;
    tabPrm: TTabSheet;
    procedure btnOkClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    {pointeur sur l'objet paramtrage}
    FOpPrm: TOperatorParameter;
  public
    {constructeur avec passage de l'objet paramtre}
    constructor CreateFromOpPrm(OpPrm: TOperatorParameter);
    procedure   GetPrmModification(var prmModif: boolean);
    {Rcupration des modifs sur le paramtrage - surcharge obligatoire}
    procedure   ApplyModifications();virtual; abstract;
    {Mettre  jour la bote de paramtrage par rapport  l'tat actuel des paramtres}
    procedure   SetParameters(); virtual; abstract;
    {le paramtre  traiter}
    property    OpPrm: TOperatorParameter read FOpPrm;
  end;

var
  DlgBaseOperatorParameter: TDlgBaseOperatorParameter;

implementation

{$R *.dfm}

{ TDlgBaseOperatorParameter }

constructor TDlgBaseOperatorParameter.CreateFromOpPrm(OpPrm: TOperatorParameter);
begin
 inherited Create(NIL);
 FOpPrm:= OpPrm;
 //et faire apparatre la fiche directement !!!
 if assigned(FOpPrm)
  then self.SetParameters();
end;

procedure TDlgBaseOperatorParameter.btnOkClick(Sender: TObject);
begin
 //appliquer
 self.ApplyModifications();
 //la suite est la fermeture de la bote tout simplement
end;

procedure TDlgBaseOperatorParameter.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
 //librer la bote  la fin des oprations
 Action:= caFree;
end;

procedure TDlgBaseOperatorParameter.GetPrmModification(
  var prmModif: boolean);
begin
 prmModif:= (self.ShowModal() = mrOk);
end;

end.
