(****************************************************************)
(* UFrmBaseOperator.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(****************************************************************)

{
@abstract(Fiche de base pour la visualisation d'un oprateur)
@author(Ricco)
@created(12/01/2004)
RQ: 01/08/03 on ajoute un autre pointeur sur le composant
}
unit UFrmBaseOperator;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmBase, UOperatorDefinition, UCompDefinition,
  ExtCtrls, ComCtrls, ActnList, Menus, HTMLLite;

type
  TFrmBaseOperator = class(TFrmBase)
    pnlFond: TPanel;
    pgctrlFond: TPageControl;
    tabHTML: TTabSheet;
    ActListFrmOperator: TActionList;
    actCopy: TAction;
    MenuOperator: TMainMenu;
    menuComponent: TMenuItem;
    menuCopy: TMenuItem;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure TimerBusyTimer(Sender: TObject);
    procedure actCopyExecute(Sender: TObject);
    private
    FOperator: TOperator;
    FMLComponent: TMLComponent;
    FHTML: string;
    LiteHTML: ThtmlLite;
    procedure InsertViewHTML();
    public
    {crer et connecter  l'oprateur}
    constructor CreateFromOperator(prmOp: TOperator);
    destructor  Destroy; override;
    {afficher les infos prvues}
    procedure   PrepareView(); virtual;
    {la proprit oprateur associe}
    property    Operator: TOperator read FOperator;
    property    MLComponent: TMLComponent read FMLComponent;
  end;

var
  FrmBaseOperator: TFrmBaseOperator;

implementation

USES
        Clipbrd, ULogFile, UBatchExecution;

CONST
        TIMER_CYCLE_ATTENTE = 200;


{$R *.dfm}

{ TFrmBaseOperator }

constructor TFrmBaseOperator.CreateFromOperator(prmOp: TOperator);
begin
 inherited Create(NIL);
 FOperator:= prmOp;
 FMLComponent:= prmOp.MLOwner as TMLComponent;
 self.Caption:= FMLComponent.Description;
 //new -- 05/04/2006 -- si BATCH MODE, pas d'affichage dans les fentres de visualisation
 if not(BATCH_MODE_EXECUTION)
  then
   begin
     //insrer le visualisateur HTMLLite
     self.InsertViewHTML();
     //envoyer l'affichage
     self.PrepareView();
   end;
end;

procedure TFrmBaseOperator.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
 FOperator.Form:= NIL;
 Action:= caFree;
end;

procedure TFrmBaseOperator.PrepareView;
var tps: cardinal;
begin
 tps:= GetTickCount();
 FHTML:= MLComponent.getHTMLDescriptionContents();
 tps:= GetTickCount() - tps;
 TraceLog.WriteToLogFile(format('FRMBASEOPERATOR >> dure formation du string2html %d',[tps]));
 
 //solution HtmlLite
 tps:= GetTickCount();
 LiteHTML.LoadFromString(FHTML,'');
 tps:= GetTickCount() - tps;
 TraceLog.WriteToLogFile(format('FRMBASEOPERATOR >> dure chargement dans le browser %d',[tps]));
end;

procedure TFrmBaseOperator.TimerBusyTimer(Sender: TObject);
begin
 (*
 //attendre tant que le navigateur n'est pas prt
 if not(viewHTML.Busy)
  then
   begin
    self.TimerBusy.Enabled:= FALSE;

    //aprs avoir stopp le timer, charger effectivement le document
    viewHTML.OleObject.Document.Close;
    viewHTML.OleObject.Document.Write(FHTML);
   end;
  *)
end;

procedure TFrmBaseOperator.actCopyExecute(Sender: TObject);
var curClipBrd: TClipBoard;
begin
 //envoyer la chane de rsultats dans le clipboard
 curClipBrd:= ClipBoard();
 TRY
 curClipBrd.Open();
 curClipbrd.AsText:= FHTML;
 FINALLY
 curClipBrd.Close();
 END;
end;

destructor TFrmBaseOperator.Destroy;
begin
 if assigned(LiteHTML)
  then FreeAndNil(LiteHTML);
 inherited Destroy();
end;

procedure TFrmBaseOperator.InsertViewHTML;
begin

 LiteHTML:= THTMLLite.Create(tabHTML);
 LiteHTML.Parent:= tabHTML;

 LiteHTML.Align:= alClient;
 LiteHTML.DefBackground:= clWhite;

end;

end.
