(********************************************************************************)
(* UFrmOpViewCorrelationScatterplot.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(********************************************************************************)

unit UFrmOpViewCorrelationScatterplot;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmBaseOperator, Menus, ActnList, ExtCtrls, OleCtrls,
  ComCtrls, TeEngine, Series, TeeProcs, Chart;

type
  TFrmOpViewCorrelationScatterplot = class(TFrmBaseOperator)
    tabChart: TTabSheet;
    chart: TChart;
    scatter: TPointSeries;
  private
  public
  procedure   PrepareView(); override;
  end;

var
  FrmOpViewCorrelationScatterplot: TFrmOpViewCorrelationScatterplot;

implementation

uses UCalcStatDesCorrelation, UCompViewCorrelationScatter;

{$R *.dfm}

{ TFrmOpViewCorrelationScatterplot }

procedure TFrmOpViewCorrelationScatterplot.PrepareView;
var op: TOpCorrelationScatter;
    cx1,cx2: TCalcSDCorrelation;
    i: integer;
begin
 op:= operator as TOpCorrelationScatter;
 chart.Title.Text.Text:= format('Correlation scatterplot (%s vs. %s)',[op.X1.Name,op.X2.Name]);
 chart.BottomAxis.Title.Caption:= op.X1.Name;
 chart.LeftAxis.Title.Caption:= op.X2.Name;
 scatter.Clear;
 for i:= 0 to pred(op.LstX1.Count) do
  begin
   cx1:= TCalcSDCorrelation(op.LstX1.Stat(i));
   cx2:= TCalcSDCorrelation(op.LstX2.Stat(i));
   scatter.AddXY(cx1.R,cx2.R,cx1.XAtt.Name,clTeeColor);
  end;
end;

end.
