(******************************************************************)
(* UCompExportDataset.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(******************************************************************)

{
@abstract(Exporter les donnes au format .TXT)
@author(Ricco)
@created(12/01/2004)
Trs simple, la rapidit est la proccupation premire...

15/04/2006 -- Ajout de nouveaux formats, on gre maintenant >> TXT, ARFF, XLS
}
unit UCompExportDataset;

interface

USES
        Forms, IniFiles, Classes,
        UCompDefinition,
        UCompManageDataset,
        UOperatorDefinition;

TYPE
        {Gnrateur de composant d'exportation}
        TMLGenCompExportData = class(TMLGenComp)
                               protected
                               procedure   GenCompInitializations(); override;
                               public
                               function    GetClassMLComponent: TClassMLComponent; override;
                               end;

        {le composant d'exportation}
        TMLCompExportData = class(TMLCompLocalData)
                            protected
                            function    getClassOperator: TClassOperator; override;
                            function    GetLogResultDescription(): string; override;
                            end;

        {oprateur}
        TOpExportData = class(TOpLocalData)
                        private
                        {nb individus exports}
                        FNbExamples: integer;
                        {nb d'attributs exports}
                        FNbAttributes: integer;
                        protected
                        function    getClassParameter: TClassOperatorParameter; override;
                        function    CoreExecute(): boolean; override;
                        public
                        function    getHTMLResultsSummary(): string; override;
                        property    NbExamples: integer read FNbExamples;
                        property    NbAttributes: integer read FNbAttributes;
                        end;

        {paramtrage de l'oprateur}
        TOpPrmExportData = class(TOperatorParameter)
                           private
                           {individus : tous -> 0 ou les slectionns -> 1}
                           FSelectExamples: integer;
                           {attributs : tous -> 0 ou les targets -> 1 ou les inputs -> 2}
                           FSelectAttributes: integer;
                           {fichier de sortie}
                           FFileName: string;
                           public
                           function    getHTMLParameters(): string; override;
                           function    CreateDlgParameters(): TForm; override;
                           procedure   SetDefaultParameters(); override;
                           procedure   LoadFromStream(prmStream: TStream); override;
                           procedure   SaveToStream(prmStream: TStream); override;
                           procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                           procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                           property    SelectExamples: integer read FSelectExamples write FSelectExamples;
                           property    SelectAttributes: integer read FSelectAttributes write FSelectAttributes;
                           property    FileName: string read FFileName write FFileName;
                           end;


implementation

uses
        Sysutils, UDatasetExamples, UDatasetImplementation,
        UDatasetDefinition, UConstConfiguration, UDlgOpPrmExportData,
        UStringsResources, ULogFile, XLSfile;

//******************************************************************************
//******************** procdures d'exportation de fichiers ********************
//******************************************************************************

TYPE
    //type de format pour l'exportation
    TTypeFileFormatExportation = (ffexpTXT, ffexpARFF, ffexpXLS);

TYPE
    //type de fonction pour l'exportation
    TFuncExportationDataset = function(filename: string; examples: TExamples; attributes: TLstAttributes): boolean;

    
//fonction renvoyant le type  partir de l'extension de fichier
function getFileFormat(const filename: string): TTypeFileFormatExportation;
var extension: string;
begin
 extension:= ExtractFileExt(filename);
 extension:= uppercase(extension);
 result:= ffexpTXT;
 if (extension = '.ARFF') then result:= ffexpARFF;
 if (extension = '.XLS') then result:= ffexpXLS;
end;

//exportation d'un fichier texte
function exportDatasetTXT(filename: string; examples: TExamples; attributes: TLstAttributes): boolean;
var ok: boolean;
    i,j,idExample: integer;
    s: string;
    FFile: TextFile;
begin
 ok:= TRUE;
 TRY
 assignfile(FFile,fileName);
   TRY
   rewrite(FFile);
   //nom de variables
   s:= '';
   for j:= 0 to pred(attributes.Count) do
    s:= s+attributes.Attribute[j].Name+TEXTFILE_COL_SEPARATOR;
   // tester les plus rapides
   setlength(s,pred(length(s)));
   //s:= copy(s,1,pred(length(s)));
   writeln(FFile,s);
   //pour chaque individu
   for i:= 1 to examples.Size do
    begin
     idExample:= examples.Number[i];
     //trs lent le TRY...EXCEPT mais dans ce cas, a permet de suivre le processus
     TRY
       s:= '';
       for j:= 0 to pred(attributes.Count) do
        s:= s+attributes.Attribute[j].sValue[idExample]+TEXTFILE_COL_SEPARATOR;
       // tester le plus rapide
       setlength(s,pred(length(s)));
       writeln(FFile,s);
     EXCEPT
       //crire dans le DEBUGFILE en cas d'erreur -- ne pas crire dans le fichier
       TraceLog.WriteToLogFile(format('[EXPORT DATASET] error on row number >>%d<<',[i])); 
     END;
    end;
   EXCEPT
   ok:= FALSE;
   END;
 FINALLY
 //don't forget
 closefile(FFile);
 END;
 result:= ok;
end;

//exportation d'un fichier ARFF
function exportDatasetARFF(filename: string; examples: TExamples; attributes: TLstAttributes): boolean;
begin
 result:= true;
end;

//exportation d'un fichier XLS
//hum ! 15/04/2006 -- pas trs fiable pour l'instant et surtout gnre un XLS non-orthodoxe
//je n'arrive pas  me relire -->  voir la classe TXLSFile qui pose problme : il gnre un XLS 5.0 semble-t-il ?
//la fonction reste cache donc pour l'instant (15/04/2006)
function exportDatasetXLS(filename: string; examples: TExamples; attributes: TLstAttributes): boolean;
var ok: boolean;
    i,j,idExample: integer;
    s: string;
    value: TTypeContinue;
    xls: TXLSfile;
begin
 xls:= nil;
 ok:= TRUE;
 TRY
 xls:= TXLSFile.create(nil);
  TRY
  //assigner un nom
  xls.FileName:= filename;
  //remplir le nom des variables sur la premire ligne
  for j:= 0 to pred(attributes.Count) do
   xls.AddStrCell(succ(j),1,[],attributes.Attribute[j].Name);
  //les donnes -- criture ligne par ligne
  for i:= 1 to examples.Size do
   begin
    idExample:= examples.Number[i];
    for j:= 0 to pred(attributes.Count) do
     begin
      if attributes.Attribute[j].isCategory(caDiscrete)
       then
        begin
         s:= attributes.Attribute[j].sValue[idExample];
         xls.AddStrCell(succ(j),succ(i),[],s);
        end
       else
        begin
         value:= attributes.Attribute[j].cValue[idExample];
         xls.AddDoubleCell(succ(j),succ(i),[],value);
        end;
     end;
   end;
  //crire sur le disque
  xls.write();
  EXCEPT
  ok:= false;
  END;
 FINALLY
 if assigned(xls) then xls.Free();
 END;
 result:= ok;
end;

CONST
    //tableau de fonctions d'exportation -- pour le plaisir de faire compliqu !
    FUNC_EXPORTATION_DATASET : array[TTypeFileFormatExportation] of TFuncExportationDataset
                             = (exportDatasetTXT,exportDatasetARFF,exportDatasetXLS);

//******************************************************************************     

{ TMLGenCompExportData }

procedure TMLGenCompExportData.GenCompInitializations;
begin
 FMLComp:= mlcDataView;
 //FMLNumIcon:= 26;
 //FMLCompName:= str_comp_name_export_data;
 //FMLBitmapFileName:= 'MLExportDataset.bmp';
end;

function TMLGenCompExportData.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompExportData;
end;

{ TMLCompExportData }

function TMLCompExportData.getClassOperator: TClassOperator;
begin
 result:= TOpExportData;
end;

function TMLCompExportData.GetLogResultDescription: string;
begin
 result:= format('export %d examples and %d attributes',[(Operator as TOpExportData).NbExamples,(Operator as TOpExportData).NbAttributes]);
end;

{ TOpPrmExportData }

function TOpPrmExportData.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmExportDataset.CreateFromOpPrm(self);
end;

function TOpPrmExportData.getHTMLParameters: string;
var s,sPrm: string;
begin
 s:= HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<th colspan=2>Export parameters</th></tr>';
 if (self.SelectAttributes=0)
  then sPrm:= 'all'
  else sPrm:= 'target';
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<td>Attributes</td><td>%s</td></tr>',[sPrm]);
 if (self.SelectExamples=0)
  then sPrm:= 'all'
  else sPrm:= 'selected';
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<td>Examples</td><td>%s</td></tr>',[sPrm]);
 s:= s+'</table>';
 result:= s;
end;

procedure TOpPrmExportData.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 FSelectExamples:= prmINI.ReadInteger(prmSection,'SelectExamples',FSelectExamples);
 FSelectAttributes:= prmINI.ReadInteger(prmSection,'SelectAttributes',FSelectAttributes);
 FFileName:= prmINI.ReadString(prmSection,'Filename',FFileName);
end;

procedure TOpPrmExportData.LoadFromStream(prmStream: TStream);
var l: integer;
begin
 prmStream.ReadBuffer(FSelectExamples,sizeof(FSelectExamples));
 prmStream.ReadBuffer(FSelectAttributes,sizeof(FSelectAttributes));
 prmStream.ReadBuffer(l,sizeof(l));
 setLength(FFileName,l);
 prmStream.ReadBuffer(FFileName[1],l);
end;

procedure TOpPrmExportData.SaveToINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 prmINI.WriteInteger(prmSection,'SelectExamples',FSelectExamples);
 prmINI.WriteInteger(prmSection,'SelectAttributes',FSelectAttributes);
 prmINI.WriteString(prmSection,'Filename',FFileName);
end;

procedure TOpPrmExportData.SaveToStream(prmStream: TStream);
var l: integer;
begin
 prmStream.WriteBuffer(FSelectExamples,sizeof(FSelectExamples));
 prmStream.WriteBuffer(FSelectAttributes,sizeof(FSelectAttributes));
 l:= length(FFileName);
 prmStream.WriteBuffer(l,sizeof(l));
 prmStream.WriteBuffer(FFileName[1],l);
end;

procedure TOpPrmExportData.SetDefaultParameters;
begin
 FSelectExamples:= 0;
 FSelectAttributes:= 0;
 FFileName:= ExpandUNCfilename('output.txt');
end;

{ TOpExportData }

function TOpExportData.CoreExecute: boolean;
var prm: TOpPrmExportData;
    examples: TExamples;
    atts: TLstAttributes;
begin
 prm:= PrmOp as TOpPrmExportData;
 //les individus -- prendre comme rf. le nombre d'individus total d'abord
 examples:= TExamples.Create(workdata.LstAtts[asAll].Size);
 case prm.SelectExamples of
  1: examples.Copy(workdata.Examples)
  else examples.Initialize();
 end;
 //les variables -- new 11/01/2005
 case prm.SelectAttributes of
  1: atts:= workdata.LstAtts[asTarget];
  2: atts:= workdata.LstAtts[asInput]
  else atts:= workdata.LstAtts[asAll];
 end;
 //les indicateurs
 FNbExamples:= examples.Size;
 FNbAttributes:= atts.Count;
 //zoo... -- new -- 16/04/2006 -- branchement de la fonction par un tableau de constantes de fonctions, ouahhh !!!
 result:= FUNC_EXPORTATION_DATASET[getFileFormat(prm.FileName)](prm.FileName,examples,atts);
 //ne pas oublier... 
 examples.Free;
end;

function TOpExportData.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmExportData;
end;

function TOpExportData.getHTMLResultsSummary: string;
var s: string;
begin
 s:= format('<P>Exportation : <B>%d</B> examples, <B>%d</B> attributes.<BR>',[FNbExamples,FNbAttributes]);
 s:= s+format('Filename : <B>%s</B>',[(PrmOp as TOpPrmExportData).FileName]);
 result:= s;
end;

Initialization
 RegisterClass(TMLGenCompExportData);
end.
