(************************************************************************)
(* UCompViewMultipleScatter.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(************************************************************************)

{
@abstract(Visualiser dans le plan les points moyens de modalits de variables cargorielles)
@author(Ricco)
@created(12/01/2004)
Ce composant peut tre trs utile par exemple lorsque l'on veut visualiser dans le plan
les rsultats produits par une ACM. Il est un peu plus gnral que a quand mme et permet de couvrir un
large spectre d'utilisation.
Les classes de calculs conditionnels crs notamment pour l'ANOVA sont largement utilises ici.
}
unit UCompViewMultipleScatter;

interface

USES
        Forms,
        UCompDefinition,
        UCompManageDataset,
        UOperatorDefinition,
        UDatasetDefinition,
        UDatasetImplementation,
        UCalcStatDesConditionnalDesc;

TYPE
        {Gnrateur de composant de visualisation}
        TMLGenCompMultipleScatter = class(TMLGenComp)
                                    protected
                                    procedure   GenCompInitializations(); override;
                                    public
                                    function    GetClassMLComponent: TClassMLComponent; override;
                                    end;

        {le composant de visualisation}
        TMLCompMultipleScatter = class(TMLCompLocalData)
                                 protected
                                 function    getClassOperator: TClassOperator; override;
                                 end;

        {l'oprateur de visualisation}
        TOpMultipleScatter = class(TOpLocalData)
                             private
                             {attribut X1}
                             FX1: TAttribute;
                             {attribut X2}
                             FX2: TAttribute;
                             {liste de stats conditionnelles pour la variable X1}
                             FLstX1: TLstStatDesCondANOVA;
                             {idem pour X2}
                             FLstX2: TLstStatDesCondANOVA;
                             protected
                             function    getClassParameter: TClassOperatorParameter; override;
                             function    getNewForm(): TForm; override;
                             {initialiser les stats descriptives conditionnelles}
                             procedure   InitializeStatDesConditionnal();
                             {vider les listes conditionnelles}
                             procedure   ClearLists();
                             {crer les statistiques adquates: X1 et X2 sont dans les Target, les caractrisantes sont dans les Input}
                             procedure   BuildLists();
                             {reconstruire les stats descriptives ici}
                             function    CoreExecute(): boolean; override;
                             function    CheckAttributes(): boolean; override;
                             public
                             constructor Create(AOwner: TObject); override;
                             destructor  Destroy; override;
                             {variable X1}
                             property    X1: TAttribute read FX1;
                             {variable X2}
                             property    X2: TAttribute read FX2;
                             {liste de stats sur X1}
                             property    LstX1: TLstStatDesCondANOVA read FLstX1;
                             {liste de stats sur X2}
                             property    LstX2: TLstStatDesCondANOVA read FLstX2;
                             end;

        {paramtrage de l'oprateur de visualisation}
        TOpPrmMultipleScatter = class(TOperatorParameter)
                                protected
                                procedure   SetDefaultParameters(); override;
                                function    CreateDlgParameters(): TForm; override;
                                end;


implementation

uses
        Classes,
        UFrmOpViewMultipleScatterplot, UStringsResources;

{ TMLGenCompMultipleScatter }

procedure TMLGenCompMultipleScatter.GenCompInitializations;
begin
 FMLComp:= mlcDataView;
 //FMLNumIcon:= 14;
 //FMLCompName:= str_comp_name_view_multiple_scatterplot;
 //FMLBitmapFileName:= 'MLViewMultipleScatter.bmp';
end;

function TMLGenCompMultipleScatter.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompMultipleScatter;
end;

{ TMLCompMultipleScatter }

function TMLCompMultipleScatter.getClassOperator: TClassOperator;
begin
 result:= TOpMultipleScatter;
end;

{ TOpMultipleScatter }

procedure TOpMultipleScatter.BuildLists;
var statX1,statX2: TCalcSDCondDesc;
    y: TAttribute;
    i: integer;
begin
 self.ClearLists();
 //sinon, on ne fait rien
 if (workdata.LstAtts[asTarget].Count=2)
  then
   begin
    FX1:= workdata.LstAtts[asTarget].Attribute[0];
    FX2:= workdata.LstAtts[asTarget].Attribute[1];
    //sinon galement il n'y a rien  faire
    if FX1.isCategory(caContinue) and FX2.isCategory(caContinue)
     then
      begin
       for i:= 0 to pred(workdata.LstAtts[asInput].Count) do
        begin
         y:= workdata.LstAtts[asInput].Attribute[i];
         //sinon, a va pas non plus
         if y.isCategory(caDiscrete)
          then
           begin
            //cration
            statX1:= TCalcSDCondDescANOVA.Create(FX1,y,workdata.Examples);
            statX2:= TCalcSDCondDescANOVA.Create(FX2,y,workdata.Examples);
            //ajout simultan dans les listes
            FLstX1.AddStat(statX1);
            FLstX2.AddStat(statX2);
           end;
        end;
      end;
   end;
end;

function TOpMultipleScatter.CheckAttributes: boolean;
var ok: boolean;
begin
 ok:= TRUE;
 {$B-}
 //vrification des target
 ok:= ok and (self.WorkData.LstAtts[asTarget].Count = 2) and (self.WorkData.LstAtts[asTarget].isAllCategory(caContinue));
 //vrification des input
 ok:= ok and (self.WorkData.LstAtts[asInput].Count>0) and (self.WorkData.LstAtts[asInput].isAllCategory(caDiscrete));
 //and then...
 result:= ok;
end;

procedure TOpMultipleScatter.ClearLists;
begin
 FLstX1.FreeAll;
 FLstX2.FreeAll;
 FX1:= NIL;
 FX2:= NIL;
end;

function TOpMultipleScatter.CoreExecute: boolean;
begin
 result:= TRUE;
 TRY
 self.BuildLists();
 //FLstX1.RefreshStat(workdata.Examples);
 //FLstX2.RefreshStat(workdata.Examples);
 EXCEPT
 result:= FALSE;
 END;
end;

constructor TOpMultipleScatter.Create(AOwner: TObject);
begin
 inherited Create(AOwner);
 self.InitializeStatDesConditionnal();
end;

destructor TOpMultipleScatter.Destroy;
begin
 FLstX1.Free;
 FLstX2.Free;
 inherited;
end;

function TOpMultipleScatter.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmMultipleScatter;
end;

function TOpMultipleScatter.getNewForm: TForm;
begin
 result:= TFrmOpViewMultipleScatterplot.CreateFromOperator(self);
end;

procedure TOpMultipleScatter.InitializeStatDesConditionnal;
begin
 FLstX1:= TLstStatDesCondANOVA.Create(nil,nil);
 FLstX2:= TLstStatDesCondANOVA.Create(nil,nil);
end;

{ TOpPrmMultipleScatter }

function TOpPrmMultipleScatter.CreateDlgParameters: TForm;
begin
 result:= NIL;
end;

procedure TOpPrmMultipleScatter.SetDefaultParameters;
begin
 //rien pour l'instant
end;

initialization
 RegisterClass(TMLGenCompMultipleScatter);
end.
