(*****************************************************************************)
(* UFrmOpViewMultipleScatterplot.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*****************************************************************************)

unit UFrmOpViewMultipleScatterplot;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmBaseOperator, Menus, ActnList, ExtCtrls, OleCtrls,
  ComCtrls, TeEngine, Series, TeeProcs, Chart, UCompViewMultipleScatter;

type
  TFrmOpViewMultipleScatterplot = class(TFrmBaseOperator)
    tabChart: TTabSheet;
    chart: TChart;
  private
    {pointeur sur l'oprateur associ}
    FOpMS: TOpMultipleScatter;
    {crer un scatterplot  nos spcifications}
    function    CreateScatterplot(): TPointSeries;
  public
    procedure   PrepareView(); override;
  end;

var
  FrmOpViewMultipleScatterplot: TFrmOpViewMultipleScatterplot;

implementation

uses UCalcStatDesConditionnalDesc, UCalcStatDes, UDatasetDefinition;

{$R *.dfm}

{ TFrmOpViewMultipleScatterplot }

function TFrmOpViewMultipleScatterplot.CreateScatterplot: TPointSeries;
var sc: TPointSeries;
begin
 sc:= TPointSeries.Create(self);
 sc.Pointer.HorizSize:= 4;
 sc.Pointer.VertSize:= 4;
 sc.Pointer.Style:= psStar;
 sc.SeriesColor:= clTeeColor;
 sc.Marks.Visible:= TRUE;
 sc.Marks.Style:= smsLabel;
 //renvoyer le pointeur
 result:= sc;
end;

procedure TFrmOpViewMultipleScatterplot.PrepareView;
var i,j: integer;
    cX1,cX2: TCalcSDCondDesc;
    scatter: TPointSeries;
    y: TAttribute;
    m1,m2: double;
begin
 //rcuprer le pointeur
 FOpMS:= Operator as TOpMultipleScatter;
 //prparer le graphique
 if assigned(FOpMS.X1) and assigned(FOpMS.X2)
  then
   begin
    chart.Title.Text.Text:= format('%s vs %s',[FOpMS.X1.Name,FOpMS.X2.Name]);
    for i:= 0 to pred(FOpMS.LstX1.Count) do
     begin
      cX1:= TCalcSDCondDesc(FOpMS.LstX1.Stat(i));
      cX2:= TCalcSDCondDesc(FOpMS.LstX2.Stat(i));
      y:= cX1.AttDescription;//forcment discret donc
      scatter:= self.CreateScatterplot();
      scatter.Title:= y.Name;
      //ajouter les points
      for j:= 0 to pred(y.nbValues) do
       begin
        m1:= cX1.StatCond[j].Average;
        m2:= cX2.StatCond[j].Average;
        scatter.AddXY(m1,m2,y.LstValues.getDescription(succ(j)));
       end;
      chart.AddSeries(scatter);
      scatter.Marks.BackColor:= scatter.SeriesColor;
     end;
   end
  else chart.Title.Text.Text:= 'no information available, use define status for attribute selection';
end;

end.
