(********************************************************************)
(* UCompViewScatterPlot.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(********************************************************************)

{
@abstract(Voir les donnes sous forme de scatterplot)
@author(Ricco)
@created(12/01/2004)
}
unit UCompViewScatterPlot;

interface

USES
        Forms,
        UCompDefinition,
        UCompManageDataset,
        UOperatorDefinition,
        UDatasetImplementation;

TYPE
        {Gnrateur de composant de visualisation}
        TMLGenCompScatterPlot = class(TMLGenComp)
                                protected
                                procedure   GenCompInitializations(); override;
                                public
                                function    GetClassMLComponent: TClassMLComponent; override;
                                end;

        {le composant de visualisation}
        TMLCompScatterPlot = class(TMLCompLocalData)
                             protected
                             function    getClassOperator: TClassOperator; override;
                             end;

        {l'oprateur de visualisation}
        TOpScatterPlot = class(TOpLocalData)
                         protected
                         function    getClassParameter: TClassOperatorParameter; override;
                         function    getNewForm(): TForm; override;
                         {pas de lancement de calcul ici}
                         function    CoreExecute(): boolean; override;
                         public
                         end;

        {paramtrage de l'oprateur de visualisation}
        TOpPrmScatterPlot = class(TOperatorParameter)
                            protected
                            procedure   SetDefaultParameters(); override;
                            function    CreateDlgParameters(): TForm; override;
                            procedure   GetParameters(var prmModif: boolean); override;
                            end;


implementation

uses
        Classes,
        UFrmOpScatterplot, UStringsResources;

{ TMLGenCompScatterPlot }

procedure TMLGenCompScatterPlot.GenCompInitializations;
begin
 FMLComp:= mlcDataView;
 //FMLNumIcon:= 12;
 //FMLCompName:= str_comp_name_view_scatterplot;
 //FMLBitmapFileName:= 'MLViewScatterPlot.bmp';
end;

function TMLGenCompScatterPlot.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompScatterPlot;
end;

{ TMLCompScatterPlot }

function TMLCompScatterPlot.getClassOperator: TClassOperator;
begin
 result:= TOpScatterPlot;
end;

{ TOpScatterPlot }

function TOpScatterPlot.CoreExecute: boolean;
begin
 result:= TRUE;
end;

function TOpScatterPlot.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmScatterPlot; 
end;

function TOpScatterPlot.getNewForm: TForm;
begin
 result:= TFrmOpViewDataScatterplot.CreateFromOperator(self);
end;

{ TOpPrmScatterPlot }

function TOpPrmScatterPlot.CreateDlgParameters: TForm;
begin
 //#ToDo1
 result:= NIL;
end;

procedure TOpPrmScatterPlot.GetParameters(var prmModif: boolean);
begin
 inherited GetParameters(prmModif);
 //pas d'invalidation de la suite du diagramme
 prmModif:= FALSE;
end;

procedure TOpPrmScatterPlot.SetDefaultParameters;
begin
 //#ToDo1 - rien a priori,  voir
end;

Initialization
 RegisterClass(TMLGenCompScatterPlot);
end.
