(*****************************************************************)
(* UFrmOpScatterplot.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*****************************************************************)

unit UFrmOpScatterplot;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmBaseOperator, Menus, ActnList, ExtCtrls,
  ComCtrls, TeeProcs, TeEngine, Chart, Series, StdCtrls, UDatasetImplementation;

type
  TFrmOpViewDataScatterplot = class(TFrmBaseOperator)
    tabChart: TTabSheet;
    panelChart: TPanel;
    chart: TChart;
    Series1: TPointSeries;
    cmbX2: TComboBox;
    cmbX1: TComboBox;
    cmbBy: TComboBox;
    actModifySeries: TAction;
    Copycharttoclipboard1: TMenuItem;
    actCopyChartToClipboard: TAction;
    N1: TMenuItem;
    Increasepointsize1: TMenuItem;
    Decreasepointsize1: TMenuItem;
    actIncPointSize: TAction;
    actDecresePointSize: TAction;
    procedure actModifySeriesExecute(Sender: TObject);
    procedure actCopyChartToClipboardExecute(Sender: TObject);
    procedure actIncPointSizeExecute(Sender: TObject);
    procedure actDecresePointSizeExecute(Sender: TObject);
  private
  {donnes  visualiser}
  FData: TMLDataset;
  {accepter le rafrachissement  la vole}
  FOkRefresh: boolean;
  {rafrachir l'affichage}
  procedure   RefreshChart();
  {rafraichir trs simplement}
  procedure   RefreshWithoutBy();
  {rafraichir avec des couleurs diffrentes}
  procedure   RefreshWithBy();
  {crer un scatterplot  nos spcifications}
  function    CreateScatterplot(): TPointSeries;
  public
  procedure   PrepareView(); override;
  end;

var
  FrmOpViewDataScatterplot: TFrmOpViewDataScatterplot;

implementation

uses
        UCompViewScatterPlot, UDatasetDefinition, UCalcDistribution,
        Contnrs;

const
        NB_MOTIFS_GRAPHIQUES = 6;
        MOTIFS_GRAPHIQUES : array[0..pred(NB_MOTIFS_GRAPHIQUES)] of TSeriesPointerStyle
                          = (psCircle,psCross,psTriangle,psDiagCross,psStar,psRectangle);

        MAX_POINT_SIZE = 10;
        MIN_POINT_SIZE = 2;

var
        CUR_POINT_SIZE : integer = 2;//!\ ah bon ? on peut faire a en PASCAL maintenant ???

{$R *.dfm}

{ TFrmOpViewDataScatterplot }

function TFrmOpViewDataScatterplot.CreateScatterplot: TPointSeries;
var sc: TPointSeries;
begin
 sc:= TPointSeries.Create(self);
 sc.Pointer.HorizSize:= CUR_POINT_SIZE;
 sc.Pointer.VertSize:= CUR_POINT_SIZE;
 sc.Pointer.Style:= psStar;
 sc.SeriesColor:= clTeeColor;
 //renvoyer le pointeur
 result:= sc;
end;

procedure TFrmOpViewDataScatterplot.PrepareView;
var att: TAttribute;
    i: integer;
begin
 //activer la bonne page
 self.pgctrlFond.ActivePage:= tabChart;
 //connecter les donnes
 FData:= (Operator as TOpScatterPlot).Workdata;
 //la premire slection vide pour le "BY"
 self.cmbBy.Items.AddObject('',nil);
 //remplir les listes
 for i:= 0 to pred(FData.LstAtts[asAll].Count) do
  begin
   att:= FData.LstAtts[asAll].Attribute[i];
   if att.isCategory(caContinue)
    then
     begin
      cmbX1.Items.AddObject(att.Name,att);
      cmbX2.Items.AddObject(att.Name,att);
     end
    else cmbBy.Items.AddObject(att.Name,att);
  end;
 FOkRefresh:= FALSE;
 //provoquer la premire slection
 cmbX1.ItemIndex:= 0;
 cmbX2.ItemIndex:= 0;
 FOkRefresh:= TRUE;
 self.RefreshChart();
end;

procedure TFrmOpViewDataScatterplot.RefreshChart;
begin
 if (cmbBY.ItemIndex>0)
  then RefreshWithBy()
  else RefreshWithoutBy();
end;

procedure TFrmOpViewDataScatterplot.RefreshWithBy;
var x1,x2,y: TAttribute;
    scatter: TPointSeries;
    dist: TTabFrequence;
    j,i,p,example: integer;
    lstChart: TObjectLIst;
begin
 chart.SeriesList.Clear;
 //rcuprer les attributs
 x1:= cmbX1.Items.Objects[cmbX1.ItemIndex] as TAttribute;
 x2:= cmbX2.Items.Objects[cmbX2.ItemIndex] as TAttribute;
 y:= cmbBy.Items.Objects[cmbBy.ItemIndex] as TAttribute;
 if assigned(y)
  then
   begin
     //rcuprer le titre
     chart.Title.Text.Text:= format('(X1) %s vs. (X2) %s by (Y) %s',[x1.Name,x2.Name,y.Name]);
     //trs difficile de travailler sans faire deux passages malheureusement
     //construire la distribution des donnes
     dist:= TTabFrequence.CreateFromAtt(y,FData.Examples);
     lstChart:= TObjectList.Create(FALSE);
     //initialiser les scatters
     for j:= 1 to dist.Size do
      begin
       scatter:= self.CreateScatterplot();
       //mj du style pour les copies en noir et blanc -- de 0  7
       scatter.Pointer.Style:= MOTIFS_GRAPHIQUES[pred(j) mod 8];
       scatter.Title:= y.LstValues.getDescription(j);
       //tester si la liste est vide !!!
       if (dist.Value[j]>0)
        then scatter.FillSampleValues(dist.Value[j]);// tout a pour a !!!
       lstChart.Add(scatter);
      end;
     //dist va maintenant servir de compteur d'ajout
     dist.ReInitialization();
     //remplir les scatters
     for i:= 1 to FData.Examples.Size do
      begin
       //rcuprer le bon scatter
       example:= FData.Examples.Number[i];
       p:= y.dValue[example];
       scatter:= lstChart.Items[pred(p)] as TPointSeries;
       //remplir
       scatter.XValue[dist.Value[p]]:= x1.cValue[example];
       scatter.YValue[dist.Value[p]]:= x2.cValue[example];
       dist.IncrementCell(p);
      end;
     //insrer les sries dans le CHART
     for j:= 0 to pred(lstChart.Count) do
      begin
       scatter:= lstChart.Items[j] as TPointSeries;
       chart.AddSeries(scatter);
      end;
     dist.Free;
     lstChart.Free;
     chart.Legend.Visible:= TRUE;
   end;
end;

procedure TFrmOpViewDataScatterplot.RefreshWithoutBy;
var x1,x2: TAttribute;
    scatter: TPointSeries;
    i: integer;
begin
 chart.Legend.Visible:= FALSE;
 //vider le graphique
 chart.SeriesList.Clear;
 //rcuprer les attributs
 x1:= cmbX1.Items.Objects[cmbX1.ItemIndex] as TAttribute;
 x2:= cmbX2.Items.Objects[cmbX2.ItemIndex] as TAttribute;
 //rcuprer le titre
 chart.Title.Text.Text:= format('(X1) %s vs. (X2) %s',[x1.Name,x2.Name]);
 //crer la srie
 scatter:= self.CreateScatterplot();
 scatter.FillSampleValues(FData.Examples.Size);
 //puis remplir les points
 for i:= 1 to FData.Examples.Size do
  begin
   scatter.XValue[pred(i)]:= x1.cValue[FData.Examples.Number[i]];
   scatter.YValue[pred(i)]:= x2.cValue[FData.Examples.Number[i]];
  end;
 chart.AddSeries(scatter);
end;

procedure TFrmOpViewDataScatterplot.actModifySeriesExecute(
  Sender: TObject);
begin
 //modifier les sries slectionnes
 self.RefreshChart();
end;

procedure TFrmOpViewDataScatterplot.actCopyChartToClipboardExecute(
  Sender: TObject);
begin
 self.chart.CopyToClipboardMetafile(TRUE);
end;

procedure TFrmOpViewDataScatterplot.actIncPointSizeExecute(
  Sender: TObject);
var k: integer;
begin
 if (CUR_POINT_SIZE < MAX_POINT_SIZE)
  then
   begin
     for k:= 0 to pred(self.chart.SeriesCount) do
      begin
       (self.Chart.Series[k] as TPointSeries).Pointer.HorizSize:= succ(CUR_POINT_SIZE);
       (self.Chart.Series[k] as TPointSeries).Pointer.VertSize := succ(CUR_POINT_SIZE);
      end;
     inc(CUR_POINT_SIZE);
   end;
end;

procedure TFrmOpViewDataScatterplot.actDecresePointSizeExecute(
  Sender: TObject);
var k: integer;
begin
 if (CUR_POINT_SIZE > MIN_POINT_SIZE)
  then
   begin
     for k:= 0 to pred(self.chart.SeriesCount) do
      begin
       (self.Chart.Series[k] as TPointSeries).Pointer.HorizSize:= pred(CUR_POINT_SIZE);
       (self.Chart.Series[k] as TPointSeries).Pointer.VertSize := pred(CUR_POINT_SIZE);
      end;
     dec(CUR_POINT_SIZE);
   end;
end;

end.
