(**************************************************************)
(* UFrmOpViewData.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(**************************************************************)

{
@abstract(Fiche visualisation des donnes, dans une grille)
@author(Ricco)
@created(12/01/2004)
Fiche de visualisation des donnes, qqs options volues : (1) choix de l'ensemble de variables (input, target, etc.)  voir,
(2) tri ??? (fastidieux mais peut tre utile quand mme !!!)
}
unit UFrmOpViewData;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmBaseOperator, Grids, UDatasetDefinition, UDatasetImplementation,
  Menus, ActnList, ExtCtrls, OleCtrls, ComCtrls;

type
  TFrmOpViewData = class(TFrmBaseOperator)
    tabData: TTabSheet;
    GridData: TDrawGrid;
    procedure GridDataDrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure actCopyExecute(Sender: TObject);
  private
    curLstAtt: TLstAttributes;
    data: TMLDataset;
  protected
    procedure InsertComponents(); override;
  public
    procedure   PrepareView(); override;
  end;

var
  FrmOpViewData: TFrmOpViewData;

implementation

USES
        Clipbrd,
        UCompViewDataset, UCompManageDataset, UCompDefinition, ULogFile,
        UConstConfiguration, UStringAddBuffered;

{$R *.dfm}

{ TFrmOpViewData }

procedure TFrmOpViewData.PrepareView;
begin
 //rcuprer la liste d'attributs  visualiser
 data:= ((Operator as TOpViewData).MLOwner as TMLCompViewData).OutputData;
 curLstAtt:= data.LstAtts[(Operator.PrmOp as TOpPrmViewData).ViewStatus];
 //afficher les infos sur les donnes
 Caption:= Format('%s [%s] (%d examples, %d attributes)',[((Operator as TOpViewData).MLOwner as TMLCompViewData).Description,
           STR_ENUM_ATT_STATUS[(Operator.PrmOp as TOpPrmViewData).ViewStatus],data.Examples.Size,curLstAtt.Count]);
 //retailler la grille et prparer la grille
 if (data.Examples.Size>0) and (curLstAtt.Count>0)
  then
   begin
    gridData.ColCount:= succ(curLstAtt.Count);
    gridData.RowCount:= succ(data.Examples.Size);
   end;
end;

procedure TFrmOpViewData.GridDataDrawCell(Sender: TObject; ACol,
  ARow: Integer; Rect: TRect; State: TGridDrawState);
var oldPenColor: TColor;
    att: TAttribute;
begin
 //les bords
 If (ARow=0) OR (ACol=0)
  Then
   Begin
     //dessin du fond des colonnes fixes...
     with gridData do
      begin
       Canvas.Brush.Color:= clBtnFace;
       Canvas.FillRect(Rect);
       OldPenColor:= Canvas.Pen.Color;
       Canvas.Pen.Color:= clBtnHighLight;
       Canvas.MoveTo(Rect.Left,Rect.Bottom);
       Canvas.LineTo(Rect.Left,Rect.Top);
       Canvas.LineTo(Rect.Right,Rect.Top);
       Canvas.Pen.Color:= clBtnShadow;
       Canvas.LineTo(Rect.Right,Rect.Bottom);
       Canvas.LineTo(Rect.Left,Rect.Bottom);
       Canvas.Pen.Color:= oldPenColor;
      end;
     //TraceLog.WriteToLogFile('TFrmOpViewData.GridDataDrawCell >> ['+IntToSTr(ARow)+','+IntToStr(ACol)+']');
   end;
 //y a-t-il matire  dessiner ?
 if (curLstAtt.Size>0) and (curLstAtt.Count>0)
  then
   begin
     //le nom de variable
     if (ARow=0) and (ACol>0)
      then
       begin
        att:= curLstAtt.Attribute[pred(ACol)];
        gridData.Canvas.Font.Color:= GRID_DATA_HEADER_FONT_COLOR;
        gridData.Canvas.TextOut(Rect.Left+1,Rect.Top+1,att.Name);
        gridData.Canvas.Font.Color:= GRID_DATA_DEFAULT_FONT_COLOR;
       end;
     //le contenu de la variable
     if (ARow>0) and (ACol>0)
      then
       begin
        att:= curLstAtt.Attribute[pred(ACol)];
        gridData.Canvas.TextOut(Rect.Left+1,Rect.Top+1,att.sValue[data.Examples.Number[ARow]]);
       end;
     //le numro d'individu
     if (ACol=0) and (ARow>0)
      then
       begin
        gridData.Canvas.Font.Color:= GRID_DATA_HEADER_FONT_COLOR;
        gridData.Canvas.TextOut(Rect.Left+1,Rect.Top+1,IntToStr(data.Examples.Number[ARow]));
        gridData.Canvas.Font.Color:= GRID_DATA_DEFAULT_FONT_COLOR;
       end;

   end;
end;

procedure TFrmOpViewData.InsertComponents;
begin
 self.pgctrlFond.ActivePage:= tabData;
 gridData.Color:= GRID_DATA_BACK_COLOR;
 gridData.Font.Color:= GRID_DATA_DEFAULT_FONT_COLOR;
 gridData.DefaultRowHeight:= GRID_DATA_DEFAULT_ROW_HEIGHT;
 gridData.DefaultColWidth:= GRID_DATA_DEFAULT_COL_WIDTH;
end;

const
    COL_SEPARATOR : CHAR = #9;
    LINE_SEPARATOR : STRING = #13#10;

procedure TFrmOpViewData.actCopyExecute(Sender: TObject);
var buf: TBufString;
    i,j,example: integer;
    s: string;
    tmp: cardinal;
begin
 screen.Cursor:= crHourGlass;
 TRY
 tmp:= GetTickCount();
 //**********************************************************************************************************
 //copier les donnes dans le presse-papier -- en passant par une criture buffrise pour acclerer la chose
 //buffer = 1 Mo semble raisonnable
 //**********************************************************************************************************
 buf:= TBufString.Create(1*1024*1024);
 buf.BeginUpdate();
 //les noms de variables
 s:= 'examples';
 for j:= 0 to pred(self.curLstAtt.Count) do
  s:= s + COL_SEPARATOR + self.curLstAtt.Attribute[j].Name;
 s:= s + LINE_SEPARATOR;
 buf.AddStr(s);
 //enquiller les donnes par ligne
 for i:= 1 to self.data.Examples.Size do
  begin
   example:= self.data.Examples.Number[i];
   s:= inttostr(example);
   for j:= 0 to pred(self.curLstAtt.Count) do
    s:= s + COL_SEPARATOR + self.curLstAtt.Attribute[j].sValue[example];
   s:= s + LINE_SEPARATOR;
   buf.AddStr(s);
  end;
 //finaliser
 buf.EndUpdate();
 //envoyer dans le presse papier
 clipboard.AsText:= buf.BufS;
 tmp:= GetTickCount() - tmp;
 TraceLog.WriteToLogFile(format('[GRID] %d octets transmis au presse-papier en %d s.',[Length(buf.BufS),tmp div 1000]));
 //and then...
 buf.Free();
 FINALLY
 screen.Cursor:= crDefault;
 END;
end;

end.
