(*****************************************************************)
(* UMLDiagramDrawing.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*****************************************************************)

{
@abstract(dessiner le diagramme dans un TGraphic)
@author(Ricco)
}
unit UMLDiagramDrawing;

interface

USES
        Types, Graphics, GifImage, ComCtrls, ClipBrd,
        UCompDefinition;

TYPE
        {dessin du diagramme}
        TMLDgmDrawing = class(TObject)
                        private
                        {le diagramme associ}
                        FDgm: TMLDiagram;
                        {le treeview associ}
                        FTreeView: TTreeView;
                        {taille de l'image}
                        FImgSize: TRect;
                        {rcuprer la taille de l'image, manipule FImgSize}
                        procedure   getImageSize();
                        {dessiner dans un canvas}
                        procedure   DrawIntoCanvas(prmCanvas: TCanvas);
                        {decalage pour bien centrer l'image dans le canvas}
                        function    Decalage(r: TRect): TRect; 
                        public
                        {construire en associant au diagramme}
                        constructor Create(prmDgm: TMLDiagram);
                        {dessiner dans un TMetaFile}
                        procedure   Drawing(mf: TMetaFile); overload;
                        {dessiner dans un TGifImage}
                        procedure   Drawing(gif: TGifImage); overload;
                        {dessiner dans le presse-papier}
                        procedure   Drawing(prmClipbrd: TClipBoard); overload;
                        {rcuprer la description de coordones des sommets}
                        function    getMapDescription(): string;
                        end;

implementation

USES
        Forms, Windows, SysUtils,
        UMLDiagramReport;

CONST
        DECALAGE_HORZ_CANVAS = -10;
        DECALAGE_VERT_CANVAS = 1;

        CANVAS_PEN_STYLE = psDot;

{ TMLDgmDrawing }

constructor TMLDgmDrawing.Create(prmDgm: TMLDiagram);
begin
 inherited Create();
 FDgm:= prmDgm;
 FTreeView:= prmDgm.TreeView;
end;

procedure TMLDgmDrawing.Drawing(mf: TMetaFile);
var mfc: TMetaFileCanvas;
begin
 //rcuprer la taille de l'image
 self.getImageSize();
 //modifier la taille de l'image
 mf.Height:= FImgSize.Bottom-FImgSize.Top;
 mf.Width:= FIMgSize.Right-FImgSize.Left;
 //crer un canvas pour le dessin
 mfc:= TMetaFileCanvas.Create(mf,0);
 mfc.Font.Name:= FTreeView.Font.Name;
 mfc.Font.Size:= FTreeView.Font.Size;
 //dessiner dans le canvas
 self.DrawIntoCanvas(mfc);
 //librer la surface de dessin
 mfc.Free;
end;

function TMLDgmDrawing.Decalage(r: TRect): TRect;
var tmp: TRect;
begin
 tmp.Left:= r.Left-FImgSize.Left+DECALAGE_HORZ_CANVAS;
 tmp.Top:= r.Top-FImgSize.Top+DECALAGE_VERT_CANVAS;
 tmp.Right:= r.Right-FImgSize.Left+DECALAGE_HORZ_CANVAS;
 tmp.Bottom:= r.Bottom-FImgSize.Top+DECALAGE_VERT_CANVAS;
 result:= tmp;
end;

procedure TMLDgmDrawing.Drawing(gif: TGifImage);
var mf: TMetaFile;
begin
 //petit tour de passe-passe
 mf:= TMetaFile.Create();
 self.Drawing(mf);
 gif.Assign(mf);
 mf.Free;
end;

procedure TMLDgmDrawing.DrawIntoCanvas(prmCanvas: TCanvas);
var node: TTreeNode;
    r,rp: TRect;
    i,cx,cy: Integer;
begin
 prmCanvas.Pen.Style:= CANVAS_PEN_STYLE;

 for i:= 0 to pred(FTreeView.Items.Count) do
  begin
   node:= FTreeView.Items[i];

   //coordonnes
   r:= node.DisplayRect(TRUE);
   r:= self.Decalage(r);

   cx:= r.Left;
   cy:= r.Top;

   //texte
   prmCanvas.TextOut(cx,cy,node.Text);

   //image
   if (node.ImageIndex>=0) and assigned(FTreeView.Images)
    then
     begin
      cx:= cx-FTreeView.Images.Width-2;
      FTreeView.Images.Draw(prmCanvas,cx,cy,node.ImageIndex);
     end;

   //state image
   if (node.StateIndex>=0) and assigned(FTreeView.StateImages)
    then
     begin
      cx:= cx-FtreeView.StateImages.Width-2;
      FTreeView.StateImages.Draw(prmCanvas,cx,cy,node.StateIndex);
     end;

   //lien avec les noeuds parents
   if assigned(node.Parent)
    then
     begin
      cy:= cy+(r.Bottom-r.Top) div 2;
      prmCanvas.MoveTo(cx-2,cy);
      rp:= node.Parent.DisplayRect(TRUE);
      rp:= self.decalage(rp);

      if (node.Parent.ImageIndex>=0)
       then rp.Left:= rp.Left-FTreeView.Images.Width-2;
      if (node.Parent.StateIndex>=0)
       then rp.Left:= rp.Left-FTreeView.Images.Width-2;
       
      prmCanvas.LineTo(rp.Left+FTreeView.Images.Width div 2+1,cy);
      prmCanvas.LineTo(rp.Left+FTreeView.Images.Width div 2+1,rp.Bottom);
     end;

  end;
end;

procedure TMLDgmDrawing.getImageSize;
var i: integer;
    r: TRect;
    node: TTreeNode;    
begin
 FTreeView.FullExpand;
 Application.ProcessMessages;
 //passer en revue chaque noeud, il n'y a pas de technique
 //plus sioux pour l'instant
 for i:= 0 to pred(FTreeView.Items.Count) do
  begin
   node:= FTreeView.Items[i];
   r:= node.DisplayRect(TRUE);//uniquement le texte
   //mj des tailles
   if (r.Left<FImgSize.Left)
    then FImgSize.Left:= r.Left;
   if (r.Top<FImgSize.Top)
    then FImgSize.Top:= r.Top;
   if (r.Right>FImgSize.Right)
    then FImgSize.Right:= r.Right;
   if (r.Bottom>FImgSize.Bottom)
    then FImgSize.Bottom:= r.Bottom;
  end;
end;

procedure TMLDgmDrawing.Drawing(prmClipbrd: TClipBoard);
var Graph: TMetaFile;
    AData: THandle;
    APalette: HPalette;
    Format: Word;
begin
 Graph:= TMetafile.Create();
 self.Drawing(Graph);
 //envoyer dans le ClipBoard
 Graph.SaveToClipboardFormat(Format,AData,APalette);
 prmClipbrd.SetAsHandle(Format,AData);
 //puis dtruire
 Graph.Free;
end;

function TMLDgmDrawing.getMapDescription: string;
var s,sr: string;
    i: integer;
    r: TRect;
    node: TTreeNode;
    cmp: TMLComponent;
begin
 s:= Format('<MAP NAME="%s">',[REPORT_DIAGRAM_MAP_NAME]);
 //pour chaque composant
 for i:= 0 to pred(FTreeView.Items.Count) do
  begin
   node:= FTreeView.Items[i];
   r:= node.DisplayRect(TRUE);
   r:= self.Decalage(r);
   sr:= Format('%d,%d,%d,%d',[r.Left,r.Top,r.Right,r.Bottom]);
   
   cmp:= TMLComponent(node.Data);
   s:= s+Format('<AREA SHAPE=RECT COORDS="%s" HREF="%s" TARGET="%s">',[sr,ExtractFileName(cmp.getHTMLFrameName()),REPORT_FRAME_MLCOMPONENT_NAME]);
  end;
 s:= s+'</MAP>';
 
 result:= s;
end;

end.
