(****************************************************************)
(* UMLDiagramReport.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(****************************************************************)

{
@abstract(Cration de rapport pour un diagramme - tout au format HTML)
@author(Ricco)
}
unit UMLDiagramReport;

interface

USES
        UCompDefinition;

CONST
        {nom du MAP associ  l'image du diagramme dans le rapport}
        REPORT_DIAGRAM_MAP_NAME = 'dgmMAP';

        {nom de la fentre frame du diagramme}
        REPORT_FRAME_DIAGRAM_NAME = 'frmDGM';

        {nom de la fentre frame de composant}
        REPORT_FRAME_MLCOMPONENT_NAME = 'frmMLComp';

        {nom de la fentre frame de menu pour un composant}
        REPORT_FRAME_MLCOMPONENT_MENU_NAME = 'frmMLCompMenu';

        {nom de la fentre frame de description pour un composant}
        REPORT_FRAME_MLCOMPONENT_DESCRIPTION_NAME = 'frmMLCompDesc';

TYPE
        {classe de cration d'un rapport HTML pour un diagramme}
        TMLDgmReport = class(TObject)
                       private
                       {pointeur sur le diagrame}
                       FDgm: TMLDiagram;
                       {Nom de fichier}
                       FFileName: string;
                       {rpertoire d'criture}
                       FFilePath: string;
                       {criture sur le disque dur}
                       procedure WriteHTML(prmText: string; prmFileName: string);
                       {crire le frame principal}
                       function  getMainFrame(): string;
                       {le menu du frame principal - on en profite pour crire le fichier GIF !!!}
                       function  getMenuMainFrame(): string;
                       {crire un composant}
                       procedure WriteHTMLComponent(prmComp: TMLComponent);
                       public
                       {initialiser pointeurs et noms de fichiers/rpertoires}
                       constructor create(prmDgm: TMLDiagram);
                       {crire directement sur le disque dur}
                       procedure   WriteReport();
                       end; 

implementation

USES
        SysUtils, UMLDiagramDrawing, GIFImage, ULogFile;

CONST
        {le slash/backslash dlimitant les noms de fichier,
        non kylix compatible clairement}
        PATH_DELIMITATION = '\';

{ TMLDgmReport }

constructor TMLDgmReport.create(prmDgm: TMLDiagram);
begin
 inherited Create();
 FDgm:= prmDgm;
 //new -- 17/10/2004 -- tester si le fichier de rapport est rellement rfrenc
 if (FDgm.HTMLFileName='')
  then FDgm.HTMLFileName:= ChangeFileExt(FDgm.FileName,'.html');
 //---
 FFileName:= FDgm.HTMLFileName;
 FFileName:= ExpandUNCFileName(FFileName);//pour assurer le coup
 FFilePath:= ExtractFilePath(FFileName);
 if (FFilePath[length(FFilePath)]<>PATH_DELIMITATION)
  then FFilePath:= FFilePath+PATH_DELIMITATION;
end;

function TMLDgmReport.getMainFrame: string;
var s: string;
begin
 s:= '<HTML><HEAD><TITLE>';
 s:= s+FDgm.Title+'</TITLE></HEAD>';

 s:= s+'<FRAMESET COLS="30%,70%">';

 //menu de gauche avec le dessin du diagramme
 s:= s+Format('<FRAME NAME="%s" SRC="%s">',[REPORT_FRAME_DIAGRAM_NAME,ExtractFileName(FDgm.getHTMLFrameName)]);
 //premier composant
 s:= s+Format('<FRAME NAME="%s" SRC="%s">',[REPORT_FRAME_MLCOMPONENT_NAME,ExtractFileName(FDgm.RootMLComp.getHTMLFrameName())]);

 s:= s+'</FRAMESET>';

 result:= s;
end;

function TMLDgmReport.getMenuMainFrame: string;
var s: string;
    gif: TGifImage;
    gifGen: TMLDgmDrawing;
    gifName: string;
begin
 //cration du fichier gif
 gifName:= ChangeFileExt(FDgm.getHTMLFrameName(),'.gif');
 
 gifGen:= TMLDgmDrawing.Create(FDgm);
 
 gif:= TGifImage.Create();
 gifGen.Drawing(gif);
 gif.SaveToFile(gifName);
 gif.Free;


 //criture de la page
 s:= '<HTML><BODY class="BodyStyle">';
 s:= s+'<H4>'+FDgm.Title+'</H4>';
 //le descriptif MAP
 s:= s+gifGen.getMapDescription();
 s:= s+Format('<IMG SRC="%s" USEMAP="#%s">',[ExtractFileName(gifName),REPORT_DIAGRAM_MAP_NAME]);

 gifGen.Free;

 s:= s+'</BODY></HTML>';
 result:= s;
end;

procedure TMLDgmReport.WriteHTML(prmText, prmFileName: string);
var F: TextFile;
begin
 assignFile(F,prmFileName);
 rewrite(F);
 writeln(F,prmText);
 closeFile(F);
end;

procedure TMLDgmReport.WriteHTMLComponent(prmComp: TMLComponent);
begin
 //criture de la fentre principale du composant
 self.WriteHTML(prmComp.getHTMLFrameContents(),prmComp.getHTMLFrameName());
 //criture du menu
 self.WriteHTML(prmComp.getHTMLMenuContents(),prmComp.getHTMLMenuName());
 //criture de la description des rsultats
 self.WriteHTML(prmComp.getHTMLDescriptionContents(),prmComp.getHTMLDescriptionName());
end;

procedure TMLDgmReport.WriteReport;
var i: integer;
    mlc: TMLComponent;
begin
 //la structure globale du rapport
 self.WriteHTML(self.getMainFrame,FDgm.HTMLFileName);
 //le menu du gauche avec le dessin du diagramme
 self.WriteHTML(self.getMenuMainFrame(),FDgm.getHTMLFrameName());

 //criture de chaque composant
 for i:= 0 to pred(FDgm.LstMLComp.Count) do
  begin
   mlc:= FDgm.MLComponent[i];
   self.WriteHTMLComponent(mlc);
  end;
  
end;

end.
