(*******************************************************************)
(* UConstConfiguration.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*******************************************************************)

{
@abstract(Runit l'ensemble des constantes de configuration de l'appli)
@author(Ricco)
}
unit UConstConfiguration;

interface

USES
        Graphics,
        LibXmlParser,
        IniFiles;

{************************************************}
{*** Constantes de configuration du logiciel ****}
{************************************************}

CONST

        //version courante du logiciel
        TANAGRA_NUMERO_CURRENT_VERSION = '1.4.7';

        //nom du logiciel
        TANAGRA_NAME_CURRENT_VERSION = 'TANAGRA '+TANAGRA_NUMERO_CURRENT_VERSION;

        {*****************************************}
        {**** polices et couleurs d'affichage ****}
        {*****************************************}

        //VIEW_FONT_NAME = 'Bookman Old Style';
        VIEW_FONT_NAME = 'Trebuchet MS';

        {Police utilise pour toutes les fiches}
        FRM_FONT_NAME = 'Microsoft Sans Serif';

        {Taille de police par dfaut pour les fiches}
        FRM_FONT_SIZE = 9;

        {couleur de fond du gestionnaire de diagramme}
        DGM_BACK_COLOR = $00FFFFFF;

        {fonte du diagramme}
        DGM_FONT_NAME = VIEW_FONT_NAME;

        {taille de fonte du diagramme}
        DGM_FONT_SIZE = 9;

        {couleur de fonte dans le gestionnaire de diagramme}
        DGM_FONT_COLOR = $00000000;

        {couleur lorsque l'excution est en cours}
        DGM_FONT_COLOR_EXECUTION = $000000FF;

        {couleur de fond du gestionnaire de palette}
        COMP_PALETTE_BACK_COLOR = DGM_BACK_COLOR;

        {police d'affichage la palette}
        COMP_PALETTE_FONT_NAME = VIEW_FONT_NAME;

        {Taille du texte dans la palette de composants}
        COMP_PALETTE_FONT_SIZE = 9;

        {Hauteur du tab dans les catgories de composants}
        COMP_PALETTE_TAB_HEIGHT = 20;

        {Taille du tab dans l'annonce des catgories de MLComponent}
        COMP_PALETTE_TAB_WIDTH = 150;

        {couleur de fond des fentres d'affichage}
        OP_WINDOW_BACK_COLOR = $00A56E3A;

        {couleur affichage des infos sur les donnes}
        OP_ATTRIBUTE_FONT_COLOR = clYellow;

        {couleur d'affichage des rsultats}
        OP_INFO_FONT_COLOR = clAqua;

        {couleur de fond de la grille d'affichage des donnes}
        GRID_DATA_BACK_COLOR = OP_WINDOW_BACK_COLOR;

        {couleur std d'affichage dans la grille de donnes}
        GRID_DATA_DEFAULT_FONT_COLOR = clAqua;

        {couleur d'affichage des en-tte dans la grille de donnes}
        GRID_DATA_HEADER_FONT_COLOR = clBlack;

        {Hauteur d'affichage pour la grille de donnes}
        GRID_DATA_DEFAULT_ROW_HEIGHT = 18;

        {Largeur de colonne dans la grille de donnes}
        GRID_DATA_DEFAULT_COL_WIDTH  = 80;

        {prcision d'affichage en chane de caractres pour les rels - modifiable globalement !!!}
        VIEW_ATTRIBUTE_ACCURACY_CONTINUE = '%.6g';

        {prcision d'affichage des rsultats statistiques}
        STR_FORMAT_VIEW_STAT_ACCURACY = '%.4f';

        {prcision haute d'affichage des stats, par ex. pour les probas critiques et stat calcules}
        STR_FORMAT_VIEW_STAT_ACCURACY_HIGH = '%.6f';

        {sparateur tabulation pour les fichiers texte}
        TEXTFILE_COL_SEPARATOR = #9;

        {style standard utilis pour les rapports}
        //pas de style pour HTMLLite
        (*
        HTML_REPORT_CLASS_STYLE =       '<style type="text/css">'
                                        +'<!--'
                                        //+'.BodyStyle {  font-family: Geneva, Arial, Helvetica, sans-serif; font-size: 9pt; color: #000000}'
                                        +'.BodyStyle {  font-family: '+VIEW_FONT_NAME+'; font-size: 9pt; color: #000000}'
                                        +'.MainMenu {  color: #000033; text-decoration: none; background-color: #00CC99;'
                                        +' border-color: #00FF33 #666666 #666666 #00FF33; font-weight: bold; border-style: solid; border-top-width: thin; border-right-width: thin; border-bottom-width: thin; border-left-width: thin}'
                                        +'.LinkMenu {  font-weight: bold; text-decoration: none; background-color: #0099CC; border-color: #00CCFF #003366 #003366 #00CCFF;'
                                        +' color: #000066; border-style: solid; border-top-width: thin; border-right-width: thin; border-bottom-width: thin; border-left-width: thin}'
                                        +'a:hover {  color: #FFFF00}'
                                        +'-->'
                                        +'</style>';
        *)
        HTML_REPORT_CLASS_STYLE = '';

        {couleur menu principal description composant}
        HTML_BGCOLOR_MAIN_MENU  = '#00CC99';

        {couleur menu intermdiaire description composant}
        HTML_BGCOLOR_LINK_MENU  = '#0099CC';

        {alternative - fonte et taille de fonte par dfaut}
        HTML_REPORT_FONT_STYLE  = '<FONT FACE="'+VIEW_FONT_NAME+'" SIZE=1>';

        {nom de la classe HTML pour les menus principaux}
        HTML_MAIN_MENU_CLASS = 'MainMenu';

        {nom de la classe HTML pour les menus de lien}
        HTML_LINK_MENU_CLASS = 'LinkMenu';

        {largeur de boutons faisant office de titre dans les rapports}
        HTML_BUTTON_TITLE_WIDTH = '100%';

        {en-tte standard d'une table de prsentation des rsultats}
        HTML_HEADER_TABLE_RESULT = '<TABLE class="BodyStyle" cellspacing=2 cellpadding=2>';

        {fond de couleur gris fonc pour les en-ttes}
        HTML_BGCOLOR_HEADER_GRAY = 'BGCOLOR="#E0E0E0"';

        {fond de couleur gris clair pour l'intrieur des tableaux}
        HTML_BGCOLOR_DATA_GRAY = 'BGCOLOR="#EFEFEF"';

        {en-tte bleue}
        HTML_BGCOLOR_HEADER_BLUE = 'BGCOLOR="#789ADA"';

        {intrieur blue intermdiaire}
        HTML_BGCOLOR_MIDDLE_BLUE = 'BGCOLOR="#9191FF"';

        {intrieur bleu}
        HTML_BGCOLOR_DATA_BLUE = 'BGCOLOR="#ACCAF0"';

        {en-tte verte}
        HTML_BGCOLOR_HEADER_GREEN = 'BGCOLOR="#60CAB3"';

        {intrieur vert}
        HTML_BGCOLOR_DATA_GREEN = 'BGCOLOR="#9FDFD1"';

        {intrieur rouge}
        HTML_BGCOLOR_DATA_RED = 'BGCOLOR="#FF9191"';

        {couleur d'en-tte de table, couleur grise}
        HTML_TABLE_COLOR_HEADER_GRAY = '<TR '+HTML_BGCOLOR_HEADER_GRAY+'>';

        {couleur de contenu de table, couleur grise}
        HTML_TABLE_COLOR_DATA_GRAY = '<TR '+HTML_BGCOLOR_DATA_GRAY+'>';

        {couleur d'en-tte de table, couleur bleue}
        HTML_TABLE_COLOR_HEADER_BLUE = '<TR '+HTML_BGCOLOR_HEADER_BLUE+'>';

        {couleur de contenu de table, couleur bleue}
        HTML_TABLE_COLOR_DATA_BLUE = '<TR '+HTML_BGCOLOR_DATA_BLUE+'>';

        {couleur d'en-tte de table, couleur verte}
        HTML_TABLE_COLOR_HEADER_GREEN = '<TR '+HTML_BGCOLOR_HEADER_GREEN+'>';

        {couleur de contenu de table, couleur verte}
        HTML_TABLE_COLOR_DATA_GREEN = '<TR '+HTML_BGCOLOR_DATA_GREEN+'>';

        {couleur de contenu de table, couleur rouge}
        HTML_TABLE_COLOR_DATA_RED = '<TR '+HTML_BGCOLOR_DATA_RED+'>';

        {espace en code HTML}
        HTML_SPACE = '&nbsp;';

        {longueur de ce code espace html}
        LEN_HTML_SPACE = Length(HTML_SPACE);

        {*******************************************}
        {***** Calculs statistiques ****************}
        {*******************************************}

        {used significance level for statistical tests --> pourrait tre spcifi dans le fichier de config.}
        SIGNIFICANCE_LEVEL_FOR_TESTS : double = 0.01;

        {*******************************************}
        {***** Rpertoires et sous-rpertoires *****}
        {*******************************************}

        {sous-rpertoire des fichiers bitmaps}
        ML_COMPONENTS_BITMAP_SUB_DIR = 'MLBitmap';

        {*************************************************}
        {**** qqs fonctions globales de mise en forme ****}
        {*************************************************}

        {histogramme au format HTML}
        function getHtmlHistogram(number: integer): string;

        {complter une chane, en mettant des espaces devant}
        function completeWithSpace(_str: string; newLength: integer): string;


{**********************************************************}
{**** gestion des fichiers de configuration  **************}
{**********************************************************}

var
        {lecture dufichier des paramtres INI -- new 05/02/2005}
        TanagraParameters: TMemIniFile;
        {lecture du fichier des composants XML}
        TanagraComponents: TXmlParser;
        {chemin de l'excutable TANAGRA}
        S_PATH_EXE: string;


implementation

USES
        Forms, SysUtils, Dialogs, ULogFile;

{complter une chane, en mettant des espaces devant}
function completeWithSpace(_str: string; newLength: integer): string;
var l: integer;
    newString: string;
begin
 newString:= _str;
 for l:= length(_str) to newLength do
  newString:= HTML_SPACE + newString;
 result:= newString;
end;


{histogramme au format HTML, la grosse astuce des tableaux...}
function getHtmlHistogram(number: integer): string;
var s: string;
    i: integer;
begin
 setLength(s,LEN_HTML_SPACE*number);
 for i:= 1 to number do
  move(HTML_SPACE[1],s[1+LEN_HTML_SPACE*pred(i)],LEN_HTML_SPACE);
 //structure de table
 result:= format('<table><tr><td %s>%s</td></tr></table>',[HTML_BGCOLOR_DATA_RED,s]);
end;

{rcupration ud fichier de configuration}
procedure getTanagraComponents();
var sFName: string;
    err: boolean;
begin
 S_PATH_EXE:= ExtractFilePath(Application.ExeName);
 if (S_PATH_EXE[length(S_PATH_EXE)]<>'\') then S_PATH_EXE:= S_PATH_EXE+'\';
 
 sFName:= S_PATH_EXE+'tanagra_components.xml';
 //
 TraceLog.WriteToLogFile(format('[Fichier de config XML] : %s',[sFName]));
 //
 err:= true;
 if FileExists(sFName)
  then
   //chargement effectif
   begin
    TanagraComponents:= TXmlParser.Create();
    TRY
     TanagraComponents.LoadFromFile(sFName);
     TraceLog.WriteToLogFile(format('[Fichier de config XML] : %s',['chargement successfull']));
     err:= false;
    EXCEPT
     err:= true;
    END;
   end;
 if err
  then
   //drame...
   begin
    MessageDlg('Cannot download <<tanagra_components.xml>>',mtError,[mbOk],0);
    Application.Terminate;
   end;
end;

procedure getTanagraParameters();
var sFName: string;
begin
 S_PATH_EXE:= ExtractFilePath(Application.ExeName);
 if (S_PATH_EXE[length(S_PATH_EXE)]<>'\') then S_PATH_EXE:= S_PATH_EXE+'\';
 //
 sFName:= S_PATH_EXE+'tanagra.ini';
 TraceLog.WriteToLogFile(format('[Fichier de paramtres] : %s',[sFName]));
 //chargement des paramtres le cas chant
 if FileExists(sFName)
  then
   begin
    TanagraParameters:= TMemIniFile.Create(sFName);
    TraceLog.WriteToLogFile(format('[Fichier de paramtres] : %s',['chargement successfull']));
   end
  else
   begin
    TanagraParameters:= NIL;
    TraceLog.WriteToLogFile(format('[Fichier de paramtres] : %s',['not found']));
   end;
end;

Initialization
 //chargement du fichier de configuration des composants
 getTanagraComponents();
 //chargement du fichier de configuration du logiciel
 getTanagraParameters();
Finalization
 if assigned(TanagraComponents) then TanagraComponents.Free();
 if assigned(TanagraParameters) then TanagraParameters.Free();
end.
 
