(************************************************************************)
(* UFrmPaletteGenComponents.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(************************************************************************)

{
@abstract(Construction de la palette de composants)
@author(Ricco)
@created(12/01/2004)
Cette unit a pour rle de construire la palette de composants. Cette palette tant compose de gnrateur de
composants. Toute la cration est dynamique. La palette est par la suite intgre au bas de la fiche principale @link(UFrmMainForm).
Les icnes associes aux composants sont regroups ici.
}
unit UFrmPaletteGenComponents;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmBase, ComCtrls, ImgList, UPaletteGenCompDefinition, UCompDefinition;

type
  {Fiche grant la palette de composants}
  TFrmPaletteComp = class(TFrmBase)
    imglstMLComponents: TImageList;
    ImageListSecours: TImageList;
  private
    {gestionnaire de palettes de composants}
    FPalette: TPgCtrlMLComponent;
    {ajouter le gestionnaire de palette de composants}
    procedure InsertTabSheetComponents();
    {insertion des composants - regroupe toute la liste - gestion par fichier de config. plus tard ???}
    procedure InsertMLComponents();
    {ajouter un composant}
    procedure AddComponent(prmGenComp: TMLGenComp);
  protected
    procedure InsertComponents(); override;
  public
    {accs rapide au gnrateur de composant}
    GenCompDefStatus: TMLGenComp;
    {pointeur sur le gestionnaire de palettes}
    property Palette: TPgCtrlMLComponent read FPalette;
  end;

var
  FrmPaletteComp: TFrmPaletteComp;

implementation

uses UCompTest,

     UCompViewDataset,
     UCompISSampling, UCompSDUnivariateContinuousAtt,
     UCompSDUnivariateDiscreteAtt, UCompFCFormula, UCompFSDefineStatus,
  UCompRegMultiple, UCompSDOneWayAnova, UCompSDCrossTabutation,
  UCompFactAnalysisPCA, UCompFactAnalysisMCA, UCompViewScatterPlot,
  UCompSDKruskalWallis, UCompViewMultipleScatter, UCompSpvLTest,
  UCompMetaSpvOneInstance, UCompSpvNaiveBayes, UCompSpvDiscriminantAnalysis,
  UCompSpvAssesTrainTest, UCompSpvLogisticRegression,
  UCompSDLinearCorrelation, UCompViewCorrelationScatter, UCompSpvTreeID3,
  UCompSDGroupCaracterization, UCompClusteringKMeans, UCompClusteringSOM,
  UCompExportDataset, UCompISStratifiedSampling, UCompISRecoverExamples,
  UCompSpvMLPerceptron, UCompSpvRBF, UCompSpvAssesCrossValidation,
  UCompMetaSpvBagging, UCompMetaSpvArcing, UCompMetaSpvBoosting,
  UCompSpvKNN, UCompSpvPrototypeNN, UCompClusteringLVQ,
  UCompAssocRuleAPriori, UConstConfiguration, LibXmlParser, ULogFile;

{$R *.dfm}

{ TFrmPaletteComp }

procedure TFrmPaletteComp.InsertComponents;
begin
 self.InsertTabSheetComponents();
 self.InsertMLComponents();
end;

procedure TFrmPaletteComp.InsertTabSheetComponents;
begin
 FPalette:= TPgCtrlMLComponent.CreateML(self,imglstMLComponents);
end;

procedure TFrmPaletteComp.AddComponent(prmGenComp: TMLGenComp);
begin
 prmGenComp.MLNumIcon:= self.imglstMLComponents.Add(prmGenComp.MLBitmap,nil);
 FPalette.AddMLGenComp(prmGenComp);
 //TraceLog.WriteToLogFile(format('-- %s -- class added',[prmGenComp.ClassName]));
end;

procedure TFrmPaletteComp.InsertMLComponents;
var sClassName,sMethodName,sBitmapFileName,sMethodDescription: String;
    cGenComp: TClassMLGenComp;
    nbComp: integer;
    sMsgLog: string;

    procedure ScanElement();
    begin

     while TanagraComponents.Scan do
      begin
       case TanagraComponents.CurPartType of
        //description d'un composant
        ptStartTag:
         begin
          if (TanagraComponents.CurName='component')
           then sClassName:= TanagraComponents.CurAttr.Value('class_name');
           
          if TanagraComponents.CurPartType = ptStartTag
           then ScanElement(); //attaque rcursive -- tant que ce n'est pas en vrille
         end;
         
        ptContent, ptCData:
         begin
          if (TanagraComponents.CurName='name')
           then sMethodName:= TanagraComponents.CurContent;

          if (TanagraComponents.CurName='bitmap')
           then sBitmapFileName:= TanagraComponents.CurContent;

          if (TanagraComponents.CurName='description')
           then sMethodDescription:= TanagraComponents.CurContent;

         end;

        ptEndTag:
         begin
          if (TanagraComponents.CurName='component')
           //tout est dispo pour crer une classe
           then
            begin
             //
             //TraceLog.WriteToLogFile(format('** %s ** adding...',[sClassName]));
             //
             inc(nbComp);
             //
             cGenComp:= TClassMLGenComp(getClass(sClassName));
             if assigned(cGenComp)
              then self.AddComponent(cGenComp.Create(sMethodName,sBitmapFileName,sMethodDescription));
            end;
         end;
       end;
      end;
    end;
begin

 {composant dfinition du statut des variables - on a besoin d'un pointeur global sur le gnrateur}
 GenCompDefStatus:= TMLGenFSDefStatus.Create('','','');
 self.AddComponent(GenCompDefStatus);

 sMsgLog:= '[MLComponents from XML] = ';
 //chargement des mthodes  partir du fichier XML de description des composants
 TanagraComponents.Normalize:= TRUE;
 TanagraComponents.StartScan;
 TRY
 //compteur de contrle
 nbComp:= 0;
 //--------------------
 ScanElement();
 SMsgLog:= sMsgLog+format('%d composants installs',[nbComp]);
 TraceLog.WriteToLogFile(sMsgLog);
 EXCEPT
 //soyons radical... n'a qu' pas trifouiller inconsidrement ce fameux fichier
 TraceLog.WriteToLogFile('Error parsing components file');
 MessageDlg('Error parsing components file',mtError,[mbOk],0);
 Application.Terminate;
 END;

 //ancienne gestion avec fichier de config. au format .INI
 (*
 lstMethods:= TStringList.Create();
 TanagraIni.ReadSectionValues(COMPONENTS_SECTION_NAME,lstMethods);
 for i:= 0 to pred(lstMethods.Count) do
  begin
   sClassName:= lstMethods.Strings[i];
   cGenComp:= TClassMLGenComp(getClass(sClassName));
   if assigned(cGenComp)
    then self.AddComponent(cGenComp.Create());
  end;
 lstMethods.Free;
 *)

end;

end.
