(***************************************************************)
(* UBatchExecution.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(***************************************************************)

{
@abstract(Excution en mode BATCH)
@author(Ricco)
@created(13/10/2004)

Charger la filire courante, lancer son excution et fermer l'application !!!
}

unit UBatchExecution;

interface

TYPE
        TEnum_ERR_BatchMode = (bmNoError, bmDiagramNotFound, bmErrorExecution);

CONST
        MSG_ERR_BatchMode : array[TEnum_ERR_BatchMode] of string =
                            ('No error in batch mode','Diagram file not found','Error during batch execution');

        BATCH_MODE_EXECUTION : Boolean = FALSE;

        STR_IDENT_INI_BUILD_REPORT = 'Build_Report';
        

{procdure globale, responsable de l'excution en mode batch}
function RunBatchMode(): TEnum_ERR_BatchMode;

implementation

USES
        SysUtils,
        ULogFile, UCompDefinition, UFrmMainForm, UFrmPaletteGenComponents,
  UMLDiagramReport, UConstConfiguration;

function RunBatchMode(): TEnum_ERR_BatchMode;
var sFileName,sFileReport: string;
    diagram: TMLDiagram;
    report: TMLDgmReport;
begin
 //mode batch en cours donc...
 BATCH_MODE_EXECUTION:= TRUE;
 //---------------------------
 result:= bmNoError;
 //rcuprer le nom de filire et analyser son intgrit
 sFileName:= ParamStr(1);
 sFileName:= ExpandUNCFileName(sFileName);
 if not(FileExists(sFileName))
  then result:= bmDiagramNotFound
  else
   begin
    TRY
     TraceLog.WriteToLogFile(format('[BATCH MODE] << BEGIN, analyse du diagramme "%s"',[sFileName]));
     //cacher la fentre principale
     frmMain.Hide();
     //charger -- excuter
     diagram:= TMLDiagram.CreateFromFile(frmMain,frmPaletteComp.imglstMLComponents,sFileName);
     diagram.FullExecute();
     //gnrer automatiquement le rapport, sans le faire apparatre
     sFileReport:= ChangeFileExt(sFileName,'.html');
     diagram.HTMLFileName:= sFileReport;//!!! pas trs catholique mais si rellement on ne peut pas faire autrement !!!
     //new -- 05/02/2005
     //test si rapport demand
     if not(assigned(TanagraParameters)) or (assigned(TanagraParameters) and (TanagraParameters.ReadInteger('BATCH_MODE',STR_IDENT_INI_BUILD_REPORT,0)=1))
      then
       begin
         report:= TMLDgmReport.create(diagram);
         report.WriteReport();
         //librer
         report.Free();
       end;
     diagram.Free();
     //debugfile...
     TraceLog.WriteToLogFile('[BATCH MODE] END >>');
    EXCEPT
     result:= bmErrorExecution;
    END;
   end;
end;

end.
