(***********************************************************)
(* UDlgLicense.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(***********************************************************)

{
@abstract(Affichage du fichier de licence, et gestion de l'apporbation)
@author(Ricco)
@created(12/01/2004)
}

unit UDlgLicense;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ComCtrls;

type
  TDlgLicense = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    rgAgree: TRadioGroup;
    btnOk: TButton;
    reLicense: TRichEdit;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

var
  DlgLicense: TDlgLicense;

implementation

uses UConstConfiguration;

{$R *.dfm}

procedure TDlgLicense.FormShow(Sender: TObject);
var sFileName: string;
begin
 //rcuprer le fichier de licence
 sFileName:= S_PATH_EXE+'license.rtf';
 //tester son existence
 if FileExists(sFileName)
  then
   begin
    self.reLicense.Lines.LoadFromFile(sFileName);
   end
  else self.ModalResult:= mrCancel;
end;

procedure TDlgLicense.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 //tester la sortie - il a cliqu sur le bouton OK mais pas sur "Agree"
 if (ModalResult = mrOk) and (self.rgAgree.ItemIndex<>0)
  then ModalResult:= mrCancel;
 //librer la bote de dialogue
 Action:= caFree;
end;

end.
