(************************************************************)
(* UFrmMainForm.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(************************************************************)

{
@abstract(Fiche principale de l'application)
@author(Ricco)
@created(12/01/2004)
Cette fiche reprsente la fiche principale de l'application.
Elle dfinit le comportement global du logiciel.
}
unit UFrmMainForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmBase, ActnList, Menus, ImgList, ComCtrls, ExtCtrls, ToolWin,
  LMDCustomControl, LMDCustomPanel, LMDCustomBevelPanel, LMDFormDisplay,
  UCompDefinition, StdActns;

type
  {Fiche principale de pilotage de l'application.}
  TFrmMain = class(TFrmBase)
    MainMenuMainForm: TMainMenu;
    ActListMainForm: TActionList;
    ImageListMainFormMenu: TImageList;
    ActNew: TAction;
    ActOpen: TAction;
    ActSave: TAction;
    menuFile: TMenuItem;
    menuFileNew: TMenuItem;
    N1: TMenuItem;
    menuFileOpen: TMenuItem;
    menuFileSave: TMenuItem;
    menuFileSaveAs: TMenuItem;
    N2: TMenuItem;
    menuFileExit: TMenuItem;
    ActExit: TAction;
    ActSaveAs: TAction;
    MainStatusBar: TStatusBar;
    MainToolBar: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ActClose: TAction;
    N3: TMenuItem;
    menuFileClose: TMenuItem;
    menuWindow: TMenuItem;
    menuWindowCascade: TMenuItem;
    SaveDlgDiagram: TSaveDialog;
    OpenDlgDiagram: TOpenDialog;
    menuFullExecute: TMenuItem;
    menuFileReport: TMenuItem;
    ActExecute: TAction;
    actWindowTileVertical: TWindowTileVertical;
    menuTile: TMenuItem;
    actWindowCascade: TWindowCascade;
    actWindowTileHorizontal: TWindowTileHorizontal;
    menuWindowTileHorizontal: TMenuItem;
    menuDiagram: TMenuItem;
    N4: TMenuItem;
    menuCopy: TMenuItem;
    ActCopy: TAction;
    SaveDlgHTMLReport: TSaveDialog;
    ActReport: TAction;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    actInsertDefStatus: TAction;
    ActDeleteComponent: TAction;
    menuDeleteComponent: TMenuItem;
    ActHelpIndex: TAction;
    MenuHelp: TMenuItem;
    menuHelpIndex: TMenuItem;
    N6: TMenuItem;
    menuHelpAbout: TMenuItem;
    ActHelpAbout: TAction;
    N7: TMenuItem;
    panelBottom: TPanel;
    pnlComponents: TPanel;
    pnlCompDisplay: TLMDFormDisplay;
    pnlTools: TPanel;
    pnlDiagram: TPanel;
    panelTitleBarDiagram: TPanel;
    pnlMLDiagramDisplay: TLMDFormDisplay;
    panelAll: TPanel;
    Splitter1: TSplitter;
    panelComponentsTitle: TPanel;
    Splitter2: TSplitter;
    procedure FormShow(Sender: TObject);
    procedure ActNewExecute(Sender: TObject);
    procedure ActCloseExecute(Sender: TObject);
    procedure ActExitExecute(Sender: TObject);
    procedure ActSaveAsExecute(Sender: TObject);
    procedure ActOpenExecute(Sender: TObject);
    procedure ActSaveExecute(Sender: TObject);
    procedure ActExecuteExecute(Sender: TObject);
    procedure ActCopyExecute(Sender: TObject);
    procedure ActReportExecute(Sender: TObject);
    procedure actInsertDefStatusExecute(Sender: TObject);
    procedure ActDeleteComponentExecute(Sender: TObject);
    procedure ActHelpAboutExecute(Sender: TObject);
    procedure ActHelpIndexExecute(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
   {insertion de la palette de composants}
   procedure InsertMLCompPalette();
   {dsactiver les menus de manipulation de diagram
   c'est le cas lorsque le diagramme courant est NIL}
   procedure DeactivateMenusActionDiagram();
   {invserse, activer les menus actions diagram}
   procedure ActivateMenusActionDiagram();
  protected
   procedure InsertComponents(); override;
   procedure InsertTexts(); override;
  public

  end;

var
  FrmMain: TFrmMain;

  {un objet fondamental - le diagramme courant}
  curMLDiagram: TMLDiagram;

implementation

uses
        Clipbrd, ShellApi,
        UFrmPaletteGenComponents, UMLDiagramDrawing, UMLDiagramReport,
        UCompFSDefineStatus, UDlgAboutBox, UStringsResources,
  UConstConfiguration, UCalcStatDesCondDescRuns;

{$R *.dfm}

{ TFrmMain }

procedure TFrmMain.InsertComponents;
begin
 inherited InsertComponents();
end;

procedure TFrmMain.FormShow(Sender: TObject);
begin
 self.InsertMLCompPalette();
 self.DeactivateMenusActionDiagram();
end;

procedure TFrmMain.InsertMLCompPalette;
begin
 //insertion de la palette de composants
 //FrmPaletteComp.Show();
 pnlCompDisplay.AddForm(FrmPaletteComp,TRUE);
end;

procedure TFrmMain.ActNewExecute(Sender: TObject);
var ok: Boolean;
begin
 //vrification
 if assigned(curMLDiagram)
  then curMLDiagram.Free;
 //branchement sur la fiche principale
 ok:= true;
 curMLDiagram:= TMLDiagram.Create(self,FrmPaletteComp.imglstMLComponents,FrmPaletteComp.imglstMLComponents,ok);
 //si pas de chargement de donnes et prparations idoines effectues correctement
 if not(ok)
  then self.ActCloseExecute(sender)
  //sauvegarde automatique
  else
   begin
    curMLDiagram.SaveToFile();
    self.panelTitleBarDiagram.Caption:= curMLDiagram.Title;
    //self.pnlDiagram.Show;
    self.ActivateMenusActionDiagram();
   end;
end;

procedure TFrmMain.ActCloseExecute(Sender: TObject);
begin
 if assigned(curMLDiagram)
  then
   begin
    curMLDiagram.Free;//un peu brutal pour l'instant
    curMLDiagram:= NIL;
   end;
 //menus appropris
 self.DeactivateMenusActionDiagram();
 //info
 self.panelTitleBarDiagram.Caption:= str_dgm_data_mining_diagram_empty;
 //self.pnlDiagram.Hide;
end;

procedure TFrmMain.ActExitExecute(Sender: TObject);
begin
// if assigned(curMLDiagram)
//  then self.ActCloseExecute(sender);
 self.Close();
end;

procedure TFrmMain.ActSaveAsExecute(Sender: TObject);
begin
 if assigned(curMLDiagram)
  then
   begin
    if SaveDlgDiagram.Execute
     then curMLDiagram.SaveToFile(SaveDlgDiagram.FileName);
   end;
end;

procedure TFrmMain.ActOpenExecute(Sender: TObject);
begin
 if OpenDlgDiagram.Execute
  then
   begin
    self.ActCloseExecute(sender);
    screen.Cursor:= crHourGlass;
    TRY
    curMLDiagram:= TMLDiagram.CreateFromFile(self,frmPaletteComp.imglstMLComponents,OpenDlgDiagram.FileName);
    //info
    self.panelTitleBarDiagram.Caption:= curMLDiagram.Title;
    //self.pnlDiagram.Show;
    self.ActivateMenusActionDiagram();
    FINALLY
    screen.Cursor:= crDefault;
    END;
   end;
end;

procedure TFrmMain.ActSaveExecute(Sender: TObject);
begin
 if assigned(curMLDiagram)
  then curMLDiagram.SaveToFile();
end;

procedure TFrmMain.ActExecuteExecute(Sender: TObject);
begin
 if assigned(curMLDiagram)
  then curMLDiagram.FullExecute();
end;

procedure TFrmMain.DeactivateMenusActionDiagram;
begin
 self.ActSave.Enabled:= FALSE;
 self.ActSaveAs.Enabled:= FALSE;
 menuDiagram.Enabled:= FALSE;
 self.actInsertDefStatus.Enabled:= FALSE;
 self.ActDeleteComponent.Enabled:= FALSE;
 self.ActClose.Enabled:= FALSE; 
 //a contrario les autres menus sont actifs
 self.ActNew.Enabled:= TRUE;
 self.ActOpen.Enabled:= TRUE;
end;

procedure TFrmMain.ActivateMenusActionDiagram;
begin
 self.ActSave.Enabled:= TRUE;
 self.ActSaveAs.Enabled:= TRUE;
 menuDiagram.Enabled:= TRUE;
 self.actInsertDefStatus.Enabled:= TRUE;
 self.ActDeleteComponent.Enabled:= TRUE;
 self.ActClose.Enabled:= TRUE;
 //a contrario les autres menus sont inactifs
 self.ActNew.Enabled:= FALSE;
 self.ActOpen.Enabled:= FALSE;
 //le premier composant doit tre slectionn
 curMLDiagram.TreeView.Select(curMLDiagram.TreeView.Items.GetFirstNode());
end;

procedure TFrmMain.ActCopyExecute(Sender: TObject);
var mld: TMLDgmDrawing;
begin
 if assigned(curMLDiagram)
  then
   begin
    mld:= TMLDgmDrawing.Create(curMLDiagram);
    mld.Drawing(Clipboard);
    mld.Free;
   end;
end;

procedure TFrmMain.ActReportExecute(Sender: TObject);
var report: TMLDgmReport;
begin
 if assigned(curMLDiagram)
  then
   begin
    //initialisation
    SaveDlgHTMLReport.FileName:= curMLDiagram.HTMLFileName;
    //rcupration et excution
    if SaveDlgHTMLReport.Execute
     then
      begin
       curMLDiagram.HTMLFileName:= SaveDlgHTMLReport.FileName;//!!! trs important !!!
       report:= TMLDgmReport.create(curMlDiagram);
       report.WriteReport();
       report.Free;
       //lancer le navigateur html - c'est plus simple que createprocess
       ShellExecute(0,'open',PANSICHAR(SaveDlgHTMLReport.FileName),nil,nil,SW_SHOWMAXIMIZED);
      end;
   end;
end;

procedure TFrmMain.actInsertDefStatusExecute(Sender: TObject);
var curComp: TMLComponent;
    newComp: TMLComponent;
begin
 if assigned(curMLDiagram)
  then
   begin
    //rcuprer le composant courant
    if assigned(curMLDiagram.TreeView.Selected)
     then
      begin
       curComp:= TMLComponent(curMLDiagram.TreeView.Selected.Data);
       //ajouter  la suite une dfinition des attributs
       newComp:= TMLCompFSDefStatus.CreateMLComponent(curMLDiagram,FrmPaletteComp.GenCompDefStatus,curComp);
       curMLDiagram.TreeView.Selected.Expand(true);
       //montrer automatiquement la bote de paramtrage
       newComp.ShowDlgParameters();
      end;
   end;
end;

procedure TFrmMain.ActDeleteComponentExecute(Sender: TObject);
begin
 curMLDiagram.DelCurMLComponent();
end;

procedure TFrmMain.ActHelpAboutExecute(Sender: TObject);
begin
 with TDlgAboutBox.Create(self) do
  ShowModal();
end;

procedure TFrmMain.ActHelpIndexExecute(Sender: TObject);
begin
 ShellExecute(0,'open',PANSICHAR('http://eric.univ-lyon2.fr/~ricco/tanagra/index.html'),nil,nil,SW_SHOWMAXIMIZED);
end;

procedure TFrmMain.InsertTexts;
begin
 inherited InsertTexts();

 //dnomination du logiciel
 self.Caption:= TANAGRA_NAME_CURRENT_VERSION;
 Application.Title:= TANAGRA_NAME_CURRENT_VERSION;

 //nom initial du diagramme
 self.panelTitleBarDiagram.Caption:= str_dgm_data_mining_diagram_empty;

 {les actions et menus}

 //fichier
 self.menuFile.Caption:= str_frm_menu_file;
 self.ActNew.Caption:= str_frm_menu_new+'...';
 self.ActOpen.Caption:= str_frm_menu_open+'...';
 self.ActSave.Caption:= str_frm_menu_save;
 self.ActSaveAs.Caption:= str_frm_menu_save_as+'...';
 self.ActClose.Caption:= str_frm_menu_close;
 self.ActExit.Caption:= str_frm_menu_exit;

 //diagramme
 self.menuDiagram.Caption:= str_frm_menu_diagram;
 self.menuFullExecute.Caption:= str_frm_menu_execute;
 self.ActExecute.Caption:= str_frm_menu_execute;
 self.ActCopy.Caption:= str_frm_menu_copy;
 self.ActReport.Caption:= str_frm_menu_report;
 self.ActDeleteComponent.Caption:= str_frm_menu_delete_component;

 //fentre
 self.menuWindow.Caption:= str_frm_menu_window;
 self.actWindowCascade.Caption:= str_frm_menu_window_cascade;
 self.actWindowTileVertical.Caption:= str_frm_menu_window_tile_vertical;
 self.actWindowTileHorizontal.Caption:= str_frm_menu_window_tile_horizontal;

 //aide
 self.MenuHelp.Caption:= str_frm_menu_help;
 self.ActHelpIndex.Caption:= str_frm_menu_help_index;
 self.ActHelpAbout.Caption:= str_frm_menu_help_about+'...';

end;

procedure TFrmMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 if assigned(curMLDiagram)
  then self.ActCloseExecute(sender);
end;

initialization
 curMLDiagram:= NIL;
end.
