{ **********************************************************************
  *                            MATHCONS.INC                            *
  **********************************************************************
                    Mathematical types and constants
  ********************************************************************** }

{ **********************************************************************
  This section defines some mathematical constants.
  ********************************************************************** }

const
  PI         = 3.14159265358979323846;  { Pi }
  LN2        = 0.69314718055994530942;  { Ln(2) }
  LN10       = 2.30258509299404568402;  { Ln(10) }
  LNPI       = 1.14472988584940017414;  { Ln(Pi) }
  INVLN2     = 1.44269504088896340736;  { 1/Ln(2) }
  INVLN10    = 0.43429448190325182765;  { 1/Ln(10) }
  TWOPI      = 6.28318530717958647693;  { 2*Pi }
  PIDIV2     = 1.57079632679489661923;  { Pi/2 }
  SQRTPI     = 1.77245385090551602730;  { Sqrt(Pi) }
  SQRT2PI    = 2.50662827463100050242;  { Sqrt(2*Pi) }
  INVSQRT2PI = 0.39894228040143267794;  { 1/Sqrt(2*Pi) }
  LNSQRT2PI  = 0.91893853320467274178;  { Ln(Sqrt(2*Pi)) }
  LN2PIDIV2  = 0.91893853320467274178;  { Ln(2*Pi)/2 }
  SQRT2      = 1.41421356237309504880;  { Sqrt(2) }
  SQRT2DIV2  = 0.70710678118654752440;  { Sqrt(2)/2 }
  GOLD       = 1.61803398874989484821;  { Golden Mean = (1 + Sqrt(5))/2 }
  CGOLD      = 0.38196601125010515179;  { 2 - GOLD }

{ **********************************************************************
  This section defines some machine-dependent and type-dependent
  constants.
  ********************************************************************** }

{$IFDEF EXTENDEDREAL}
const
  MACHEP = 1.08420217248550444E-19;   { Floating point precision: 2^(-63) }
  MAXNUM = 1.18973149535723103E+4932; { Max. floating point number: 2^16384 }
  MINNUM = 3.36210314311209558E-4932; { Min. floating point number: 2^(-16382) }
  MAXLOG = 11356.5234062941439;       { Max. argument for Exp = Ln(MAXNUM) }
  MINLOG = - 11355.137111933024;      { Min. argument for Exp = Ln(MINNUM) }
  MAXFAC = 1754;                      { Max. argument for Factorial }
  MAXGAM = 1755.455;                  { Max. argument for Gamma }
  MAXLGM = 1.04848146839019521E+4928; { Max. argument for LnGamma }
{$ELSE}
{$IFDEF DOUBLEREAL}
const
  MACHEP = 2.220446049250313E-16;     { 2^(-52) }
  MAXNUM = 1.797693134862315E+308;    { 2^1024 }
  MINNUM = 2.225073858507202E-308;    { 2^(-1022) }
  MAXLOG = 709.7827128933840;
  MINLOG = -708.3964185322641;
  MAXFAC = 170;
  MAXGAM = 171.624376956302;
  MAXLGM = 2.556348E+305;
{$ELSE}
{$IFDEF SINGLEREAL}
const
  MACHEP = 1.192093E-7;               { 2^(-23) }
  MAXNUM = 3.402823E+38;              { 2^128 }
  MINNUM = 1.175495E-38;              { 2^(-126) }
  MAXLOG = 88.72283;
  MINLOG = -87.33655;
  MAXFAC = 33;
  MAXGAM = 34.648;
  MAXLGM = 1.0383E+36;
{$ELSE}
{$IFDEF PASCALREAL}
const
  MACHEP = 1.818989404E-12;           { 2^(-39) }
  MAXNUM = 4.253529586E+37;           { 2^126 }
  MINNUM = 2.350988703E-38;           { 2^(-125) }
  MAXLOG = 8.664339757E+01;
  MINLOG = - 4.253529586E+01;
  MAXFAC = 33;
  MAXGAM = 34.64809785;
  MAXLGM = 1.038324114E+36;
{$ENDIF}
{$ENDIF}
{$ENDIF}
{$ENDIF}

{ **********************************************************************
  This section defines the complex type
  (based on CMPLX.ZIP by E.F. Glynn)
  ********************************************************************** }

type
  ComplexForm = (Pol, Rec);      { Polar or rectangular }
  Complex = record
              case Form : ComplexForm of
                Rec : (X, Y : Float);      { Z = X + i * Y }
                Pol : (R, Theta : Float);  { Z = R * Exp(i * Theta) }
            end;                           { Theta = -Pi..Pi in canonical form }

{ **********************************************************************
  This section defines some complex "constants" (in fact, initialized
  variables).
  ********************************************************************** }

const
  C_zero     : Complex = (Form : Rec; X : 0.0; Y : 0.0);
  C_one      : Complex = (Form : Rec; X : 1.0; Y : 0.0);
  C_i        : Complex = (Form : Rec; X : 0.0; Y : 1.0);
  C_pi       : Complex = (Form : Rec; X : PI; Y : 0.0);
  C_pi_div_2 : Complex = (Form : Rec; X : PIDIV2; Y : 0.0);     { Pi/2 }
  C_infinity : Complex = (Form : Rec; X : MAXNUM; Y : MAXNUM);

{ **********************************************************************
  This section defines some error codes.
  ********************************************************************** }

const
  FN_OK     =   0;  { No error }
  DOMAIN    = - 1;  { Argument domain error }
  SING      = - 2;  { Function singularity }
  OVERFLOW  = - 3;  { Overflow range error }
  UNDERFLOW = - 4;  { Underflow range error }
  TLOSS	    = - 5;  { Total loss of precision }
  PLOSS	    = - 6;  { Partial loss of precision }
