{ --------------------------------------------------------------------
  BFGS method. Requires a procedure to compute the gradient of the
  objective function. Here we use procedure NumGradient (defined in
  OPTIM.PAS), which performs numerical differentiation.
  -------------------------------------------------------------------- }

  procedure Minimize;
  begin
    WriteLn('BFGS');
    WriteLn('----'#10);

    {$IFDEF FPK}
      ErrCode := BFGS(@Func, @NumGradient, X, 1, NVAR,
                      MAXITER, TOL, F_min, H_inv);
    {$ELSE}
      ErrCode := BFGS(Func, NumGradient, X, 1, NVAR,
                      MAXITER, TOL, F_min, H_inv);
    {$ENDIF}

    case ErrCode of
      MAT_OK   : WriteResult(True);
      NON_CONV : WriteLn('Too many iterations');
    end;
  end;

