{ --------------------------------------------------------------------
  Powell function.

  True minimum is at (0, 0, 0, 0), F = 0

  Ref: M.J.D. Powell, Comput. J., 1962, 5, 147
  -------------------------------------------------------------------- }

const
  NVAR       = 4;       { Number of variables }
  SA_MAXITER = 100;     { Simul. annealing: number of annealing steps }
  SA_T_RATIO = 1.0E-08; { Simul. annealing: ratio of final to initial temp. }

  {$F+}
  function Func(X : PVector) : Float;
  begin
    Func := Sqr(X^[1] + 10.0 * X^[2]) + 5.0 * Sqr(X^[3] - X^[4])
            + Sqr(Sqr(X^[2] - 2.0 * X^[3])) + 10.0 * Sqr(Sqr(X^[1] - X^[4]));
  end;
  {$F-}

  procedure InitVar;
  begin
    X^[1] := 3.0;
    X^[2] := - 1.0;
    X^[3] := 0.0;
    X^[4] := 1.0;
  end;

