{ --------------------------------------------------------------------
  Another Powell function.

  Multiple minima at x1 = x2 = x3 = +/- Sqrt(4*n+1), n integer, F = -3

  Ref: M.J.D. Powell, Comput. J., 1964, 7, 155

  NB: The original reference maximizes F. Here we shall minimize -F.
  -------------------------------------------------------------------- }

const
  NVAR       = 3;       { Number of variables }
  SA_MAXITER = 200;     { Simul. annealing: number of annealing steps }
  SA_T_RATIO = 1.0E-08; { Simul. annealing: ratio of final to initial temp. }

  {$F+}
  function Func(X : PVector) : Float;
  begin
    Func := - 1.0 / (1.0 + Sqr(X^[1] - X^[2])) - Sin(PIDIV2 * X^[2] * X^[3])
            - Exp(- Sqr((X^[1] + X^[3]) / X^[2] - 2.0));
  end;
  {$F-}

  procedure InitVar;
  begin
    X^[1] := 0.0;
    X^[2] := 1.0;
    X^[3] := 2.0;
  end;

