(******************************************************************)
(* UStringAddBuffered.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(******************************************************************)

{
@abstract(class utilitaire pour les ajouts rapides dans une chane de caractre)
@author(Ricco)
@created(12/01/2004)
Par rapport aux ralisation prcdentes, on ne passe plus par un PChar, on manipule directement
la chaine de caractre, pas d'allocations mmoires intermdiaires ainsi.
}
unit UStringAddBuffered;

interface

USES
        Classes;

TYPE
        {chane buffrise}
        TBufString = class(TObject)
                     private
                     {la chane qui sert de buffer}
                     FBufS: string;
                     {longueur courante relle}
                     FCurLength: integer;
                     {taille du buffer allou}
                     FBufSize: integer;
                     {taille de l'ajout}
                     FAddLength: integer;
                     {initialisation}
                     procedure   Initialize();
                     public
                     constructor Create();
                     destructor  Destroy; override;
                     {rinitialiser un ajout}
                     procedure   BeginUpdate();
                     {finaliser un ajout}
                     procedure   EndUpdate();
                     {ajouter une chane de caractre}
                     procedure   AddStr(s: string);
                     {pointeur sur la chane de caractre}
                     property BufS: string read FBufS;
                     end;

        {une procdure trs simple pour remplacer un caractre par un autre dans une chane de caractres}
        procedure strUtil_ReplaceCharInString(old_char,new_char: char; var prmStr: string);

        {une procdure simple pour inscrire une chane de caractre dans un flux}
        procedure saveStringToStream(var prmS: string; prmStream: TStream);

        {une procdure simple pour lire une chane de caractre  partir un flux}
        procedure loadStringFromStream(var prmS: string; prmStream: TStream);

implementation

CONST
        {augmentation de la taille du buffer  chaque coup}
        INC_BUF_SIZE = 50000;

{une procdure trs simple pour remplacer un caractre par un autre dans une chane de caractres}
procedure strUtil_ReplaceCharInString(old_char,new_char: char; var prmStr: string);
var i: integer;
begin
 for i:= 1 to length(prmStr) do
  if (prmStr[i]=old_char)
   then prmStr[i]:= new_char;
end;

{une procdure simple pour inscrire une chane de caractre dans un flux}
procedure saveStringToStream(var prmS: string; prmStream: TStream);
var len: integer;
    tmp: string;
begin
 tmp:= prmS;
 //longueur de la chane de caractre
 len:= length(tmp);
 prmStream.WriteBuffer(len,sizeof(len));
 //si chane ne vide...
 if (len>0)
  //le contenu
  then prmStream.WriteBuffer(tmp[1],len);
end;

{une procdure simple pour lire une chane de caractre  partir un flux}
procedure loadStringFromStream(var prmS: string; prmStream: TStream);
var len: integer;
begin
 prmStream.ReadBuffer(len,sizeof(len));
 if (len>0)
  then
   begin
    SetLength(prmS,len);
    prmStream.ReadBuffer(prmS[1],len);
   end
  else prmS:= '';
end;



{ TBufString }

procedure TBufString.AddStr(s: string);
begin
 FAddLength:= length(s);
 if (FAddLength>0)
  then
   begin
     //while pour le cas o la chane  ajouter est vraiment de trs grande taille
     //c'est le cas pour un fichier entier par exemple
     while ((FCurLength+FAddLength)>FBufSize) do
      begin
       inc(FBufSize,INC_BUF_SIZE);
       SetLength(FBufS,FBufSize);
      end;
     //ajouter rellement
     Move(s[1],FBufS[FCurLength],FAddLength);
     inc(FCurLength,FAddLength);
   end;
end;

procedure TBufString.BeginUpdate;
begin
 self.Initialize();
end;

constructor TBufString.Create;
begin
 inherited Create();
 self.Initialize();
end;

destructor TBufString.Destroy;
begin
 SetLength(FBufS,0);
 inherited Destroy;
end;

procedure TBufString.EndUpdate;
begin
 setlength(FBufS,pred(FCurLength));//rcupration de l'astuce
end;

procedure TBufString.Initialize;
begin
 FBufS:= '';
 FBufSize:= 0;
 FCurLength:= 1;//petite astuce pour commencer au bon endroit les ajouts
end;

end.
