(*******************************************************************)
(* UDataAccessTextFile.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*******************************************************************)

{
@abstract(Accs  un fichier au format texte)
@author(Ricco)
@created(12/01/2004)
Lecture d'un fichier de donnes au format texte. On utilise les flux buffriss
dj implments et tests auparavant.
"!!! 17/07/03 nouveau gestion de l'interruption de l'execution du thread !!!"

new -- 27/12/2004 -- utiliser le framework mis en place dans l'import de WEKA
>> Il semble que les accs TextFile aient t optimiss dans ce compilateur (par rapport  Delphi 2.0 en tous cas) <<
>> On va en profiter le plus possible <<
}
unit UDataAccessTextFile;

interface

USES
        Classes,
        UDataAccessDefinition;

TYPE
        {classe d'import de fichier texte dans un ensemble de donnes}
        TAccessTextFile = class(TAccessAbstract)
                          private
                          {Position courante dans le fichier}
                          FCurPos: Integer;
                          {Taille du fichier}
                          FFileSize: Integer;
                          {Sparateur de colonne}
                          FColumnSep: Char;
                          {analyse des deux premire lignes afin de lire le nom et dterminer le type des variables}
                          procedure   AnalyzeTextFile();
                          {chargement rel du fichier  l'aide des flux buffriss @link(UIOFastTextFileAccess) -
                          attention, un peu fragile ?!}
                          procedure   DownloadCoreTextFile(prmThread: TThread);
                          protected
                          procedure   SetDefaultParameters(); override;
                          function    coreDownload(prmThread: TThread): boolean; override;
                          public
                          function    GetProgression: Integer; override;
                          end;

implementation

uses
        Sysutils, UFileResources,
        UDatasetDefinition, UDatasetImplementation, UIOFastTextFileAccess,
        UDlgDatasetDownload, UConstConfiguration;

const
        NULL_CHAR : CHAR = #0;
        LF_CHAR   : CHAR = #10;
        CR_CHAR   : CHAR = #13;

        {dfinit le saut pour la rallocation de mmoire lors d'ajout d'individus}
        DELTA_ADD_EXAMPLES = 5000;

{ TAccessTextFile }

function TAccessTextFile.coreDownload(prmThread: TThread): boolean;
var ok: boolean;
begin
 ok:= TRUE;
 TRY
 self.AnalyzeTextFile();
 self.DownloadCoreTextFile(prmThread);
 EXCEPT
 ok:= FALSE;
 END;
 result:= ok;
end;

procedure TAccessTextFile.SetDefaultParameters;
begin
 FColumnSep:= TEXTFILE_COL_SEPARATOR;//tabulation
end;

procedure TAccessTextFile.AnalyzeTextFile();
var p: integer;
    prmNoms,prmDonnees: string;
    tmpNom,tmpDonnee: shortstring;
    valeur: TTypeContinue;
    att: TAttribute;
    FFile: TextFile;


 procedure DetecterType(var prmNom, prmDonnee: shortstring);
 begin
   //tester le type - si ce n'est pas continu, c'est que c'est discret - lapalissade ??? voir le type label plus tard !!!
   TRY
   valeur:= StrToFloat(prmDonnee);
   att:= TAttContinue.Create(prmNom,1);
   EXCEPT
   att:= TAttDiscrete.Create(prmNom,1);
   END;
 end;

begin
 //pointeur de fichier - risque d'erreur bien que protg par "connecting"
 AssignFile(FFile,FileName);
 Reset(FFile);
 //Lire les deux premires lignes et analyser pour crer les bonnes variables
 Readln(FFile,prmNoms);
 Readln(FFile,prmDonnees);
 //analyse
 p:= pos(FColumnSep,prmNoms);
 while (p>0) do
  begin
   tmpNom:= copy(prmNoms,1,pred(p));
   System.Delete(prmNoms,1,p);
   p:= Pos(FColumnSep,prmDonnees);
   tmpDonnee:= copy(prmDonnees,1,pred(p));
   System.Delete(prmDonnees,1,p);
   //crer attribut
   DetecterType(tmpNom,tmpDonnee);
   //ajouter l'attribut
   LstAtt.Add(att);
   //lecture suivante
   p:= pos(FColumnSep,prmNoms);
  end;
 tmpNom:= prmNoms;
 tmpDonnee:= prmDonnees;
 //sur les derniers caractres
 DetecterType(tmpNom,tmpDonnee);
 //ajouter l'attribut
 LstAtt.Add(att);
 //donner le bon indicateur de taille
 LstAtt.Size:= 1;
 //
 CloseFile(FFile);
end;

(* -- bien tent mais textfile reste le meilleur !!! --
procedure TAccessTextFile.DownloadCoreTextFile(prmThread: TThread);

const
    debCol = 0;
    debRow = 1;

var
    strRow: string;
    strData: string;
    firstLine: string;
    col,row: Integer;
    att: TAttribute;
    dThread: TThreadDownload;
    deb_p,p,lengthRow: integer;

    gp: TGpTextFile;

begin
 //rcuprer le thread
 dThread:= prmThread as TThreadDownload;
 ///qq initialisations
 row:= debRow;
 FFileSize:= FileSizeByName(FileName);//taille du fichier
 FCurPos:= 0;//octets lus...
 //accs au fichier
 gp:= TGpTextFile.Create(FileName);
 gp.Reset([ofNo8BitCPConversion],0,0);

 TRY
 //vacuer la premire ligne contenant le nom des attributs
 //self.ReadLine(firstLine);

 firstLine:= gp.Readln();
 inc(FCurPos,length(firstLine));

 //commencer la lecture du reste du fichier et l'analyse
 //tant que pas de fin de fichier et non interruption du thread
 while NOT(gp.EOF()) and not(assigned(dThread) and dThread.isTerminated) do
  begin
   //grer la taille de l'ensemble de donnes
   if (row>LstAtt.Size)
    then LstAtt.Size:= LstAtt.Size+DELTA_ADD_EXAMPLES;
   //lire la ligne
   //self.ReadLine(strRow);
   //lengthRow:= Length(strRow);
   
   strRow:= gp.Readln();
   lengthRow:= Length(strRow);
   inc(FCurPos,lengthRow);

   //initialiser le compteur de colonne
   col:= debCol;
   p:= 1;
   REPEAT
    deb_p:= p;
    REPEAT
     inc(p);
    {$B-}
    UNTIL (p>lengthRow) OR (strRow[p]=self.FColumnSep);
    //copier la portion
    strData:= copy(strRow,deb_p,p-deb_p);
    //insrer
    att:= self.LstAtt.Attribute[col];
    att.sValue[row]:= strData;
    //dcaler les colonnes
    inc(col);
    //se dcaler pour viter le sparateur
    inc(p);
   UNTIL (p>lengthRow);
   //passage  la ligne suivante
   inc(row);
  end;
 FINALLY
 //dfinir la bonne taille du fichier
 LstAtt.Size:= pred(row);
 //fermer le flux
 gp.Close();
 gp.Free();
 END;
end;
*)

procedure TAccessTextFile.DownloadCoreTextFile(prmThread: TThread);

const
    debCol = 0;
    debRow = 1;

    BUF_SIZE_KO = 16;
    SIZE_OF_BUF_TEXTFILE = BUF_SIZE_KO*1024;

var
    strRow: string;
    strData: string;
    firstLine: string;
    col,row: Integer;
    att: TAttribute;
    dThread: TThreadDownload;
    deb_p,p,lengthRow: integer;

    F: TextFile;

    buf: array [0..pred(SIZE_OF_BUF_TEXTFILE)] of CHAR;//utiliser un buffer de BUF_SIZE Ko



begin
 //rcuprer le thread
 dThread:= prmThread as TThreadDownload;
 ///qq initialisations
 row:= debRow;
 //FFileSize:= FileSizeByName(FileName);//taille du fichier
 //new -- 26/02/2005 -- IdGlobal.pas n'est pas dispo dans la version perso de DELPHI 6.0
 FFileSize:= tanagra_getFileSizeByName(FileName);
 FCurPos:= 0;//octets lus...
 
 //accs au fichier
 AssignFile(F,FileName);
 SetTextBuf(F,buf,SIZE_OF_BUF_TEXTFILE);
 Reset(F);
 
 TRY
 //vacuer la premire ligne contenant le nom des attributs -- ne pas oublier le compteur d'avancement
 Readln(F,firstLine);
 inc(FCurPos,length(firstLine));
 
 //commencer la lecture du reste du fichier et l'analyse
 //tant que pas de fin de fichier et non interruption du thread
 while NOT(EOF(F)) and not(assigned(dThread) and dThread.isTerminated) do
  begin
   //grer la taille de l'ensemble de donnes
   if (row>LstAtt.Size)
    then LstAtt.Size:= LstAtt.Size+DELTA_ADD_EXAMPLES;

   //lire la ligne et mettre  jour l'info sur l'avancement
   Readln(F,strRow);
   lengthRow:= Length(strRow);
   inc(FCurPos,lengthRow);
   
   //initialiser le compteur de colonne
   col:= debCol;
   p:= 1;
   REPEAT
    deb_p:= p;
    REPEAT
     inc(p);
    {$B-}
    UNTIL (p>lengthRow) OR (strRow[p]=self.FColumnSep);
    //copier la portion
    strData:= copy(strRow,deb_p,p-deb_p);
    //insrer
    att:= self.LstAtt.Attribute[col];
    att.sValue[row]:= strData;
    //dcaler les colonnes
    inc(col);
    //se dcaler pour viter le sparateur
    inc(p);
   UNTIL (p>lengthRow);
   //passage  la ligne suivante
   inc(row);
  end;
 FINALLY
 //dfinir la bonne taille du fichier
 LstAtt.Size:= pred(row);
 //fermer le flux
 CloseFile(F);
 END;
end;


function TAccessTextFile.GetProgression: Integer;
begin
 if (FFileSize>0)
  then result:= trunc(100.0*FCurPos/(1.0*FFileSize))
  else result:= 0;
end;

end.
