(******************************************************************)
(* UDatasetDefinition.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(******************************************************************)

{
@abstract(Structure d'accs aux donnes)
@author(Ricco)
@created(12/01/2004)
Structure centrale dans la gestion des donnes, tout est dvolu  la rapidit ici, d'o
le choix des bytes par exemple pour le type nominal, d'o galement l'absence de type ordinal.
C'est une synthse des diffrentes approches dfinies jusqu'ici, on mise sur la rapidit, donc
utilisation des tables de hachage pour la liste de valeurs (modalits). Les gains en tant de calcul est hallucinant et
l'utilisation est compltement transparente.

new -- 01/04/2005 -- cration d'un troisime type de variable, les caQuasiContinue qui sont les donnes soit continues soit discrtes binaires -- a vite le recodage systmatique !
}
unit UDatasetDefinition;

interface

USES
        Classes, IniFiles, Contnrs;

TYPE
        {Catgorie d'attributs dispo}
        TEnumCatAttribut = (caDiscrete,caContinue,caQuasiContinue);

CONST
        {Description des types d'attributs, le dernier est un peu spcial : ce sont les donnes binaires que l'on peut considrer comme continus}
        STR_CAT_ATTRIBUT : array[TEnumCatAttribut] of string =
                           ('Discrete','Continue','Quasi Continue');

TYPE
        {Type de donnes discret}
        TTypeDiscrete = byte;

        {Type de donnes continue}
        TTypeContinue = single;

CONST
        {nombre de modalits max traits}
        MAX_NB_VALUES_CATEGORICAL = high(TTypeDiscrete);

        {nombre max d'individus traits - de manire toute arbitraire pour l'instant}
        MAX_NB_EXAMPLES = 5000000;

        {nombre max. de variables traites, tout aussi arbitraire}
        MAX_NB_ATTRIBUTES = 25000;

        {Taille des discrets}
        SIZE_DISCRETE = sizeof(TTypeDiscrete);

        {Taille des continues}
        SIZE_CONTINUE    = sizeof(TTypeContinue);

        {Valeur manquante}
        CONTINUE_MISSING_VALUE = -99999.99;
        DISCRETE_MISSING_VALUE = 0;

        {valeur trs petite -- utilisable pour les tests de nullit par exemple}
        EPSILON_VALUE = 1.0e-7;

TYPE
        {la liste des valeurs associes  un attribut discret}
        TDiscreteValues = class(TObject)
                          private
                          {liste des valeurs - attention zro based !!! -- classe anctre ici, peut tre HASHED en instanciation}
                          FLstValues: TStringList;
                          public
                          constructor Create();
                          destructor  Destroy; override;
                          {vider la liste de description}
                          procedure   clear();
                          {rcuprer la description d'une valeur - pas de contrle d'tendue !!!}
                          function    getDescription(prmValue: TTypeDiscrete): string;
                          {renvoie la valeur associe  une modalits - l'ajoute  la liste des modalits si non trouve -- !!! very dangerous !!! -- 05/08/2004}
                          function    getValue(const prmStr: string): TTypeDiscrete;
                          {vrifie si une modalit particulire est prsente, en la reprant par son libell -- renvoie 0 si non trouv}
                          function    isValueAvailable(prmStr: string): TTypeDiscrete;
                          {renvoie le nombre de modalits}
                          function    getNbValues: Integer;
                          {copier la description d'un autre attribut}
                          procedure   assign(prmSource: TDiscreteValues);
                          {sauver dans un flux}
                          procedure   SaveToStream(prmStream: TStream);
                          {charger  partir d'un flux}
                          procedure   LoadFromStream(prmStream: TStream);
                          end;

        {Classe abstraite d'accs  un attribut}
        TAttribute = class(TPersistent)
                     private
                     {rcuprer la catgorie sous forme de chane de caractre}
                     function    GetSCategory(): string;
                     protected
                     {Catgorie de l'attribut}
                     FCategory: TEnumCatAttribut;
                     {Nombre d'individus grs}
                     FSize: Integer;
                     {Nom de l'attribut}
                     FName: string;
                     {liste des modalits - non utilise si continue - mais toujours dispo}
                     FLstValues: TDiscreteValues;
                     {lecture - discret}
                     function    dGetValue(i: Integer): TTypeDiscrete; virtual; abstract;
                     {lecture - continue}
                     function    cGetValue(i: Integer): TTypeContinue; virtual; abstract;
                     {lecture - discret - la description de la modalit}
                     function    sGetValue(i: Integer): string; virtual; abstract;
                     {criture - discret}
                     procedure   dSetValue(i: Integer; const prmValue: TTypeDiscrete); virtual; abstract;
                     {criture - continue}
                     procedure   cSetValue(i: Integer; const prmValue: TTypeContinue); virtual; abstract;
                     {criture - discret - attention, ajout de la valeur si non trouve dans la liste}
                     procedure   sSetValue(i: Integer; const prmValue: string); virtual; abstract;
                     {modification  la vole de la taille du tableau interne}
                     procedure   SetSize(newSize: Integer); virtual; abstract;
                     {dfinir la catgorie de l'attribut}
                     procedure   SetCategory(); virtual; abstract;
                     {rcuprer le nombre de valeurs distinctes - n'est intrssant que pour les attributs discrets}
                     function    GetNbValues(): Integer; virtual;
                     public
                     constructor Create(prmName: string; prmSize: Integer);
                     destructor  Destroy; override;
                     {sauver dans le flux}
                     procedure   SaveToStream(prmStream: TStream); virtual;
                     {construire  partir d'un chargement de flux}
                     constructor CreateFromStream(prmStream: TStream); virtual;
                     {new -- 01/04/2005 -- encapsuler la demande de catgorie}
                     function    isCategory(prmCat: TEnumCatAttribut): boolean;
                     //properties
                     property    Name: string read FName;
                     //new -- 01/04/2005 -- passe  la trappe --> property    Category: TEnumCatAttribut read FCategory;
                     property    sCategory: string read GetSCategory;
                     property    Size: Integer read FSize write SetSize;
                     property    dValue[i: Integer]: TTypeDiscrete read dGetValue write dSetValue;
                     property    cValue[i: Integer]: TTypeContinue read cGetValue write cSetValue;
                     property    sValue[i: Integer]: string read sGetValue write sSetValue;
                     property    nbValues: Integer read GetNbValues;
                     property    LstValues: TDiscreteValues read FLstValues;
                     end;

        {classe d'attributs}
        TClassAttribute = class of TAttribute;

        {classe grant une liste d'attributs}
        TLstAttributes = class(TObject)
                         private
                         {liste propritaire ou non}
                         FOwned: Boolean;
                         {liste interne des attributs}
                         FLstAtt: TObjectList;
                         {nombre d'individus - redondant ici mais a rend la chose plus facile}
                         FSize: Integer;
                         {compter les attributs}
                         function    getCount: Integer;
                         {accs  un attribut}
                         function    getAt(i: Integer): TAttribute;
                         {modifier la taille de l'ensemble des attributs}
                         procedure   setSize(newSize: Integer);
                         public
                         constructor Create(Owned: boolean; prmSize: Integer);
                         destructor  Destroy; override;
                         {ajouter un nouvel attribut en fin de liste}
                         procedure   Add(prmAtt: TAttribute);
                         {ajouter une srie d'attributs}
                         procedure   Assign(prmSource: TLstAttributes);
                         {sauver dans un flux}
                         procedure   SaveToStream(prmStream: TStream);
                         {charger  partir d'un flux}
                         constructor CreateFromStream(prmStream: TStream);
                         {chercher un attribut  partir de son nom}
                         function    GetFromName(prmName: string): TAttribute;
                         {rcuprer le numro de l'attribut}
                         function    GetIndex(prmAtt: TAttribute): integer;
                         {envoyer l'ensemble d'attributs dans une TStrings}
                         procedure   FlashLstAtt(prmDest: TStrings);
                         {vider la liste - selon que l'on est proprio ou non, l'attribut est dtruit}
                         procedure   Clear();
                         {tester si tous les attributs sont d'un type donn}
                         function   isAllCategory(prmCat: TEnumCatAttribut): boolean;
                         //properties
                         property    Count: Integer read getCount;
                         property    Attribute[i: Integer]: TAttribute read getAt;
                         property    Size: Integer read FSize write setSize;
                         property    LstAtt: TObjectList read FLstAtt;
                         end;
        


implementation

uses UStringFastHash;

{ TDiscreteValues }

procedure TDiscreteValues.assign(prmSource: TDiscreteValues);
var i: integer;
begin
 FLstValues.Clear;
 for i:= 1 to prmSource.getNbValues do
  FLstValues.Add(prmSource.getDescription(i));
end;

procedure TDiscreteValues.clear;
begin
 FLstValues.Clear;
end;

constructor TDiscreteValues.Create;
begin
 inherited Create();
 //FLstValues:= THashedStringList.Create; -- NON, NON, mieux vaut r-crire la chose
 FLstValues:= TFastHashedStrings.Create;
end;

destructor TDiscreteValues.Destroy;
begin
 FLstValues.Free;
 inherited;
end;

function TDiscreteValues.getDescription(prmValue: TTypeDiscrete): string;
begin
 //pas de contrle ici
 result:= FLstValues.Strings[pred(prmValue)];
end;

function TDiscreteValues.getNbValues: Integer;
begin
 result:= FLstValues.Count;
end;

function TDiscreteValues.getValue(const prmStr: string): TTypeDiscrete;
var p: integer;
begin
 p:= FLstValues.IndexOf(prmStr);
 if (p<0)
  then
   begin
    FLstValues.Add(prmStr);
    result:= FLstValues.Count;
   end
  else result:= succ(p);//car zro based les TStringList
end;

function TDiscreteValues.isValueAvailable(prmStr: string): TTypeDiscrete;
begin
 result:= succ(FLstValues.IndexOf(prmStr));
end;

procedure TDiscreteValues.LoadFromStream(prmStream: TStream);
var nb,i: integer;
    l: integer;
    s: string;
begin
 prmStream.ReadBuffer(nb,sizeof(nb));
 for i:= 0 to pred(nb) do
  begin
   prmStream.ReadBuffer(l,sizeof(l));
   SetLength(s,l);
   prmStream.ReadBuffer(s[1],l);
   self.FLstValues.Add(s);
  end;
end;

procedure TDiscreteValues.SaveToStream(prmStream: TStream);
var l: integer;
    nb,i: integer;
    s: string;
begin
 nb:= FLstValues.Count;
 prmStream.WriteBuffer(nb,sizeof(nb));
 for i:= 0 to pred(nb) do
  begin
   s:= FLstValues[i];
   l:= length(s);
   prmStream.WriteBuffer(l,sizeof(l));
   prmStream.WriteBuffer(s[1],l);
  end;
end;

{ TAttribute }

constructor TAttribute.Create(prmName: string; prmSize: Integer);
begin
 inherited Create();
 //dfinir la catgorie
 self.SetCategory();
 //valeurs
 FLstValues:= TDiscreteValues.Create();
 //rcup les infos
 FName:= prmName;
 FSize:= prmSize;
end;

constructor TAttribute.CreateFromStream(prmStream: TStream);
var l: integer;
begin
 inherited Create();
 self.SetCategory();
 prmStream.ReadBuffer(FSize,sizeof(FSize));
 prmStream.ReadBuffer(l,sizeof(l));
 setLength(FName,l);
 prmStream.ReadBuffer(FName[1],l);
 FLstValues:= TDiscreteValues.Create();
 FLstValues.LoadFromStream(prmStream);
end;

destructor TAttribute.Destroy;
begin
 FLstValues.Free;
 inherited;
end;

function TAttribute.GetNbValues: Integer;
begin
 result:= FLstValues.getNbValues();
end;

function TAttribute.GetSCategory: string;
begin
 result:= STR_CAT_ATTRIBUT[FCategory];
end;

function TAttribute.isCategory(prmCat: TEnumCatAttribut): boolean;
begin
 case prmCat of
  caQuasiContinue: result:= (FCategory = caContinue) OR ((FCategory = caDiscrete) and (self.nbValues = 2))
  else result:= (FCategory = prmCat);
 end;
end;

procedure TAttribute.SaveToStream(prmStream: TStream);
var l: integer;
begin
 prmStream.WriteBuffer(FSize,sizeof(FSize));
 l:= length(FName);
 prmStream.WriteBuffer(l,sizeof(l));
 prmStream.WriteBuffer(FName[1],l);
 FLstValues.SaveToStream(prmStream);
end;

{ TLstAttributes }

procedure TLstAttributes.Add(prmAtt: TAttribute);
begin
 FLstAtt.Add(prmAtt);
end;

procedure TLstAttributes.Assign(prmSource: TLstAttributes);
var i: Integer;
begin
 FLstAtt.Clear;//freeall car "Owner=true"
 //recopie bte et mchante
 for i:= 0 to pred(prmSource.Count) do
  self.Add(prmSource.Attribute[i]);
 //la taille de la base
 FSize:= prmSource.Size;
end;

procedure TLstAttributes.Clear;
begin
 self.FLstAtt.Clear();
end;

constructor TLstAttributes.Create(Owned: boolean; prmSize: Integer);
begin
 inherited Create();
 FOwned:= Owned;
 FSize:= prmSize;
 FLstAtt:= TObjectList.Create(FOwned);
end;

constructor TLstAttributes.CreateFromStream(prmStream: TStream);
var nb,i: integer;
    sshort: shortstring;
    att: TAttribute;
begin
 inherited Create();
 prmStream.ReadBuffer(FOwned,sizeof(FOwned));
 prmStream.ReadBuffer(FSize,sizeof(FSize));
 FLstAtt:= TObjectList.Create(FOwned);
 prmStream.ReadBuffer(nb,sizeof(nb));
 for i:= 0 to pred(nb) do
  begin
   prmStream.ReadBuffer(sshort,sizeof(sshort));
   att:= TClassAttribute(getClass(sshort)).CreateFromStream(prmStream);
   self.Add(att);
  end;
end;

destructor TLstAttributes.Destroy;
begin
 FLstAtt.Free;//le rle de owned est primordial ici !!!
 inherited;
end;

procedure TLstAttributes.FlashLstAtt(prmDest: TStrings);
var i: integer;
    att: TAttribute;
begin
 prmdest.Clear;
 for i:= 0 to pred(self.Count) do
  begin
   att:= self.Attribute[i];
   prmDest.AddObject(att.Name,att);
  end;
end;

function TLstAttributes.getAt(i: Integer): TAttribute;
begin
 result:= FLstAtt.Items[i] as TAttribute;
end;

function TLstAttributes.getCount: Integer;
begin
 result:= FLstAtt.Count;
end;

function TLstAttributes.GetFromName(prmName: string): TAttribute;
var i: integer;
    att,tmpAtt: TAttribute;
begin
 att:= nil;
 //pas de tri donc recherche squentielle,  voir si possibilit d'amlioration
 i:= 0;
 while not(assigned(att)) and (i<self.Count) do
  begin
   tmpAtt:= self.Attribute[i];
   if (tmpAtt.Name = prmName)
    then att:= tmpAtt;
   inc(i);
  end;
 //
 result:= att;
end;

function TLstAttributes.GetIndex(prmAtt: TAttribute): integer;
begin
 result:= FLstAtt.IndexOf(prmAtt);
end;

function TLstAttributes.isAllCategory(prmCat: TEnumCatAttribut): boolean;
var ok: boolean;
    i: integer;
begin
 ok:= true;
 for i:= 0 to pred(self.Count) do
  ok:= ok and self.Attribute[i].isCategory(prmCat);
 result:= ok;
end;

procedure TLstAttributes.SaveToStream(prmStream: TStream);
var nb,i: integer;
    sshort: shortstring;
    att: TAttribute;
begin
 prmStream.WriteBuffer(FOwned,sizeof(FOwned));
 prmStream.WriteBuffer(FSize,sizeof(FSize));
 nb:= self.Count;
 prmStream.WriteBuffer(nb,sizeof(nb));
 for i:= 0 to pred(nb) do
  begin
   att:= self.Attribute[i];
   sshort:= att.ClassName;
   prmStream.WriteBuffer(sshort,sizeof(sshort));//un peu long mais tellement plus simple
   att.SaveToStream(prmStream);
  end
end;

procedure TLstAttributes.setSize(newSize: Integer);
var i: Integer;
begin
 if (newSize<>FSize)
  then
   begin
    FSize:= newSize;
    for i:= 0 to pred(self.Count) do
     self.Attribute[i].Size:= newSize;
   end;
end;

initialization
 RegisterClass(TAttribute);
end.
