unit UFlxMessages;
{*$DEFINE SPANISH}
interface
uses {$IFDEF WIN32} Windows, {$ENDIF}
     {$IFDEF ConditionalExpressions}{$if CompilerVersion >= 14} variants,{$IFEND}{$ENDIF} //Delphi 6 or above
     SysUtils;
resourcestring
  FieldStr='##';
  DataSetStr='__';
  VarStr='#.';
  MarkedRowStr='...delete row...';
  HPageBreakStr='...page break...';
  FullDataSetStr='*';

  FlexCelVersion='2.5';

{$IFDEF SPANISH}
  {$INCLUDE FlxSpanish.inc}
{$ELSE}
{$IFDEF FRENCH}
  {$INCLUDE FlxFrench.inc}
{$ELSE}
{$IFDEF ITALIAN}
  {$INCLUDE FlxItalian.inc}
{$ELSE}
  {$INCLUDE FlxEnglish.inc}
{$ENDIF}
{$ENDIF}
{$ENDIF}

  xls_Emf='EMF';
  xls_Wmf='WMF';
  xls_Jpeg='JPEG';
  xls_Png='PNG';

type
  TClientAnchor= packed record
    Flag,
    Col1, Dx1, Row1, Dy1,
    Col2, Dx2, Row2, Dy2: word;
  end;
  PClientAnchor = ^TClientAnchor;

const
  DefColWidthAdapt: integer=290; //256;
var
  ColMult:extended=36.6;
  RowMult:extended=15;


type
  TColorPaletteRange=1..56;

  TXlsCellRange=record
    Left, Top, Right, Bottom: integer;
  end;

type
  TOnGetFileNameEvent = procedure (Sender: TObject; const  FileFormat: integer; var Filename: TFileName) of object;
  TXlsImgTypes = (xli_Emf, xli_Wmf, xli_Jpeg, xli_Png, xli_Bmp, xli_Unknown);

  VariantArray=Array [0..maxint div sizeof(Variant)-1]of variant;
  ArrayOfVariant=Array of Variant;

  TXlsCellValue= record
    Value: variant;
    XF: integer;
    IsFormula: boolean;
  end;

  function SearchPathStr(const AFileName: String): String;

implementation

{$IFDEF WIN32}
function SearchPathStr(const AFileName: String): String;
var
  FilePart: PChar;
begin
  SetLength(Result, MAX_PATH + 1);

  if SearchPath(nil, PChar(AFileName), '.xls',
                MAX_PATH, PChar(Result), FilePart) <> 0 then
  begin
    SetLength(Result, Length(PChar(Result)));
  end
  else
    Raise Exception.CreateFmt(ErrCantFindFile,[AFileName]);
end; // SearchRecStr
{$ELSE}
function SearchPathStr(const AFileName: String): String;
begin
  //We dont search for templates in linux
  if not FileExists(AFileName) then Raise Exception.CreateFmt(ErrCantFindFile,[AFileName]);
  Result:=AFileName;
end; // SearchRecStr
{$ENDIF}


end.







