unit UXlsXF;

interface
uses Classes, SysUtils, UXlsBaseRecords, UXlsBaseRecordLists, XlsMessages,
     UFlxFormats;

type
  TXFDat=packed Record
    Font: word;       //0
    Format: word;     //2
    Options4: word;    //4
    Options6: word;  //6
    Options8: word;  //8
    Options10: word;  //10
    Options12: word;     //12
    Options14: LongWord; //14
    Options18: Word; //18
  end;
  PXFDat=^TXFDat;

  TXFRecord=class(TBaseRecord)
    function CellPattern: integer;
    function CellFgColorIndex: integer;
    function CellBgColorIndex: integer;

    function FontIndex: integer;
    function FormatIndex: integer;

    function GetBorderStyle(const aPos: integer; const FirstBit: byte):TFlxBorderStyle;
    function GetBorderColorIndex(const aPos: integer; const FirstBit: byte):integer;
    function GetBorderStyleExt(const aPos: integer; const FirstBit: byte):TFlxBorderStyle;
    function GetBorderColorIndexExt(const aPos: integer; const FirstBit: byte):integer;

    function DiagonalStyle: TFlxDiagonalBorder;

    function VAlign: TVFlxAlignment;
    function HAlign: THFlxAlignment;

    procedure FillMisc(var Locked, Hidden: boolean;var Parent: integer;
                       var WrapText, ShrinkToFit: boolean; var Rotation: byte;
                       var Indent: byte);
                       

  end;

  TXFRecordList= class(TBaseRecordList)  //Items are TXFRecord
  {$INCLUDE TXFRecordListHdr.inc}
  public
  end;

/////////////////////////////////////////////////// FONT
  TFontRecord= class(TBaseRecord)
    function Name: widestring;
    function Height: integer;
    function ColorIndex: integer;

    function Style: SetOfTFlxFontStyle;
    function Underline: TFlxUnderline;
  end;

  TFontRecordList=class(TBaseRecordList)  //Items are TFontRecord
  {$INCLUDE TFontRecordListHdr.inc}
  public
  end;

/////////////////////////////////////////////////// Style
  TStyleRecord= class(TBaseRecord)
  end;

/////////////////////////////////////////////////// FORMAT
  TFormatRecord= class(TBaseRecord)
  public
    function Id: integer;
    function Value: widestring;
  end;

  TFormatRecordList=class(TBaseRecordList)
  private
    function GetFormat(Id: integer): Widestring;  //Items are TFormatRecord
  {$INCLUDE TFormatRecordListHdr.inc}
  public
    property Format[index: integer]: Widestring read GetFormat; default;
  end;
implementation
  {$INCLUDE TXFRecordListImp.inc}
  {$INCLUDE TFontRecordListImp.inc}
  {$INCLUDE TFormatRecordListImp.inc}

const
  XlsBuiltInFormats: array[0..49] of widestring=
  ('', '0', '0.00','#,##0','#,##0.00',                              //0..4
   '', '', '', '',                                                   //5..8  Contained in file
   '0%','0.00%','0.00E+00','?/?','# ??/??',                         //9..13
   'DD.MM.YY','DD. MMM YY','DD. MMM','MMM YY',                      //14..17
   'h:mm AM/PM','h:mm:ss AM/PM','hh:mm','hh:mm:ss',                 //18..21
   'DD.MM.YYYY hh:mm',                                              //22
   '','','','','','','','','','','','','','',                       //23..36 Reserved
   '"#,##0 _$;-#,##0 _$"','"#,##0 _$;[Red]-#,##0 _$"',              //37..38
   '"#,##0.00 _$;-#,##0.00 _$"','"#,##0.00 _$;[Red]-#,##0.00 _$"',  //39..40
   '','','','',                                                     //41..44 contained in file
   '"mm:ss"','[h]:mm:ss','mm:ss,0','"##0.0E+0"','@'                 //45..49
  );


{ TXFRecord }

function TXFRecord.CellBgColorIndex: integer;
begin
  Result:= PXFDat(Data).Options18 and $3F80 shr 7 -8;
end;

function TXFRecord.CellFgColorIndex: integer;
begin
  Result:= PXFDat(Data).Options18 and $7F -8;
end;

function TXFRecord.CellPattern: integer;
begin
  Result:= PXFDat(Data).Options14 and $FC000000 shr 26;
end;

function TXFRecord.DiagonalStyle: TFlxDiagonalBorder;
begin
  Result:=TFlxDiagonalBorder((GetCardinal(Data,14) shr 14) and  3);
end;

procedure TXFRecord.FillMisc(var Locked, Hidden: boolean;
  var Parent: integer; var WrapText, ShrinkToFit: boolean; var Rotation, Indent: byte);
begin
  Locked:=PXFDat(Data).Options4 and $1 = $1;
  Hidden:=PXFDat(Data).Options4 and $2 = $2;
  Parent:=PXFDat(Data).Options4 and $FFF0;

  WrapText:= PXFDat(Data).Options6 and $8 = $8;

  ShrinkToFit:= PXFDat(Data).Options8 and $10 = $10;

  Rotation:= PXFDat(Data).Options6 and $FF00;
  Indent:= PXFDat(Data).Options8 and $F;

end;

function TXFRecord.FontIndex: integer;
begin
  Result:= PXFDat(Data).Font;
end;

function TXFRecord.FormatIndex: integer;
begin
  Result:= PXFDat(Data).Format;
end;

function TXFRecord.GetBorderColorIndex(const aPos: integer; const FirstBit: byte): integer;
begin
  Result:=(GetWord(Data, aPos) shr FirstBit) and $7F -7;
end;

function TXFRecord.GetBorderColorIndexExt(const aPos: integer; const FirstBit: byte): integer;
begin
  Result:=(GetCardinal(Data, aPos) shr FirstBit) and $7F-7;
end;

function TXFRecord.GetBorderStyle(const aPos: integer; const FirstBit: byte): TFlxBorderStyle;
begin
  Result:=TFlxBorderStyle((Data[aPos] shr FirstBit) and $F)
end;

function TXFRecord.GetBorderStyleExt(const aPos: integer; const FirstBit: byte): TFlxBorderStyle;
begin
  Result:=TFlxBorderStyle((GetCardinal(Data, aPos) shr FirstBit) and $F)
end;

function TXFRecord.HAlign: THFlxAlignment;
begin
  Result:=THFlxAlignment(PXFDat(Data).Options6 and $7);
end;

function TXFRecord.VAlign: TVFlxAlignment;
begin
  Result:=TVFlxAlignment(PXFDat(Data).Options6 and $70 shr 4);
end;

{ TFontRecord }

function TFontRecord.ColorIndex: integer;
begin
  Result:=GetWord(Data, 4)-8;
end;

function TFontRecord.Height: integer;
begin
  Result:=GetWord(Data, 0);
end;

function TFontRecord.Name: widestring;
var
  w: widestring;
  s: string;
  aPos, DestPos, StrLen: integer;
  OptionFlags, ActualOptionFlags: byte;
  MySelf: TBaseRecord;
begin
  aPos:=16; MySelf:=Self;DestPos:=0;
  StrLen:=Data[14];
  OptionFlags:=Data[15]; ActualOptionFlags:=OptionFlags;
  SetLength(s, StrLen);
  SetLength(w, StrLen);
  ReadStr( MySelf, aPos, s, w, OptionFlags, ActualOptionFlags, DestPos, StrLen );
  if (OptionFlags and $1) = 0 then Result:=StringToWideStringNoCodePage(s) else Result:=w;

end;

function TFontRecord.Style: SetOfTFlxFontStyle;
begin
  Result:=[];
  if GetWord(Data,6)=$2BC then Include(Result,flsBold);
  if GetWord(Data,2) and $02=$02 then Include(Result,flsItalic);
  if GetWord(Data,2) and $08=$08 then Include(Result,flsStrikeOut);
  case GetWord(Data,8) of
    1: Include(Result,flsSuperscript);
    2: Include(Result,flsSubscript);
  end; //case
end;

function TFontRecord.Underline: TFlxUnderline;
begin
  case data[10] of
    $01: Result:=fu_Single;
    $02: Result:= fu_Double;
    $21: Result:=fu_SingleAccounting;
    $22: Result:=fu_DoubleAccounting;
    else Result:=fu_None;
  end;//case
end;

{ TFormatRecord }

function TFormatRecord.Id: integer;
begin
  Result:=GetWord(Data, 0);
end;

function TFormatRecord.Value: widestring;
var
  MySelf: TBaseRecord;
  aPos: integer;
  StrLen: integer;
  s: string;
  w: WideString;
  OptionFlags, ActualOptionFlags: byte;
  DestPos: integer;
begin
  aPos:=5;MySelf:=Self;DestPos:=0;
  OptionFlags:=Data[4]; ActualOptionFlags:=OptionFlags;
  StrLen:=GetWord(Data, 2);
  SetLength(s, StrLen);
  SetLength(w, StrLen);
  ReadStr( MySelf, aPos, s, w, OptionFlags, ActualOptionFlags, DestPos, StrLen );
  if (OptionFlags and $1) = 0 then Result:=StringToWideStringNoCodePage(s) else Result:=w;
end;

{ TFormatRecordList }

function TFormatRecordList.GetFormat(Id: integer): Widestring;
var
  Index: integer;
begin
  if Find(Id, Index) then Result:=Items[Index].Value else
  if (Id>=Low(XlsBuiltInFormats)) and (Id<=High(XlsBuiltInFormats)) then Result:=XlsBuiltInFormats[Id]
  else Result:='';
end;

end.
