(****************************************************************************)
(* UCalcTreeStructureDefinition.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(****************************************************************************)

{
@abstract(Structure d'arbre de dcision)
@author(Ricco)
@created(12/01/2004)
Le plus gnrique possible, le plus simple possible et le plus rapide possible, essaies de t'en
sortir avec a !!! Va falloir faire qqs compromis ... mais sur quoi ?

--> new -- ces deux options ont t supprimes -- 02/02/2005 -- GLOBAL_SORTED_TREE_LIST est devenu le choix dfinitif

2 options de compilation sont dispo:

"TREE_SPLIT_EXAMPLES" indique que la liste des individus sur un noeud est maintenu sur le split candidat,
cela vite un passage supplmentaire dans la BD lorsque l'on applique un split, on vite donc LxN oprations (L nombre de feuilles, N individus),
c'est peu tranchant en ralit en temps et pourtant c'est trs gourmand en mmoire, cette option peut tre
intressante si la base n'est pas en mmoire mais ce n'est pas le cas ici ==>>>  viter

"GLOBAL_SORTED_TREE_LIST" ide de WEKA, construire au dpart une liste trie des individus pour chaque attribut continu
candidat  la segmentation, ainsi le tri n'est effectu qu'une seule fois, la liste filtre est pass de sommet en sommet.
on vite ainsi "nombre attributs continus x nombre de sommets x nlog(n)" oprations (tri sur chaque sommet)
gourmand en mmoire (la taille est connue  l'avance : 4 x nb att continu x nb individus total) mais a permet de rduire
dans des proportions considrables le temps de calcul, surtout lorsque la base est constitue d'attributs
en majorit continus (cf. par exemple sur les wave) ==>>>  garder donc

}
unit UCalcTreeStructureDefinition;

interface

USES
        Contnrs,
        EZDSLBAR,
        UCalcRulesDefinition,
        UDatasetExamples,
        UOperatorDefinition,
        UDatasetDefinition,
        UStringAddBuffered;

TYPE

        TMLTreeNode = class;
        TMLTreeStructure = class;

        {une feuille gnr par une segmentation}
        TSplitLeaf = class(TObject)
                     private
                     {les attributs servant au calcul des stats}
                     FTargetAttributes: TLstAttributes;
                     {condition  l'origine de la feuille}
                     FCondition: TRuleCondition;
                     {Nombre d'individus associs}
                     FNbExamples: integer;
                     public
                     {construction, on lui passe la condition, il en devient propritaire}
                     constructor create(prmTargetAttributes: TLstAttributes; prmCond: TRuleCondition; nbExamples: integer); virtual;
                     {commencer la mise  jour -  surcharger, avec inherited}
                     procedure   BeginUpdate(); virtual;
                     {ajouter un exemple -  surcharger, avec inherited}
                     procedure   AddExample(prmExample: integer); virtual;
                     {fin de mise  jour -  surcharger, avec inherited}
                     procedure   EndUpdate(); virtual;
                     {fusionner deux feuilles}
                     procedure   Merge(prmOther: TSplitLeaf); virtual;
                     {dtruire}
                     destructor Destroy; override;
                     {la condition associe}
                     property   Condition: TRuleCondition read FCondition;
                     {les individus associs}
                     property   NbExamples: integer read FNbExamples;
                     end;

        {classe de feuille}
        TClassSplitLeaf = class of TSplitLeaf;

        {un attribut  l'origine de feuilles}
        TSplitAttribut = class(TObject)
                        private
                        {paramtre de mthode associe}
                        FPrmMethod: TOperatorParameter;
                        {attribut associ}
                        FAttribute: TAttribute;
                        {le sommet associ}
                        FNode: TMLTreeNode;
                        {liste des feuilles}
                        FLstSplitLeaves: TObjectList;
                        {la qualit du partitionnement}
                        FGoodnessSplit: double;
                        {acceptation}
                        FAcceptSplit: boolean;
                        {nombre de feuilles}
                        function getCountSplitLeaves(): integer;
                        {accs  une feuille}
                        function getSplitLeaf(i: integer): TSplitLeaf;
                        protected
                        {la classe de la feuille  gnrer}
                        function  getClassSplitLeaf(): TClassSplitLeaf; virtual; abstract;
                        {construire les feuilles}
                        procedure   BuildLeaves();
                        {construire les feuilles discrtes - une feuille par modalit}
                        procedure   BuildLeavesDiscrete();
                        {optimiser les feuilles discrtes}
                        procedure   OptimizeDiscreteLeaves(); virtual;
                        {construire les feuilles continues}
                        procedure   BuildLeavesContinue();
                        {optimiser les feuilles continues}
                        procedure   OptimizeContinuousLeaves(); virtual; abstract;
                        {commencer la mise  jour}
                        procedure   BeginUpdate();
                        {finaliser la mise  jour}
                        procedure   EndUpdate();
                        {valuer la qualit du partitionnement}
                        function    ComputeGoodness(): double; virtual; abstract;
                        {valuer la pertinence du partitionnement}
                        function    ComputeAcceptSplit(): boolean; virtual; abstract;
                        {valuer le partitionnement}
                        procedure   EvaluateSplitting();
                        public
                        {construire la liste  partir d'un attribut - attention lien direct avec les mthodes d'apprentissage}
                        constructor Create(prmMethod: TOperatorParameter; prmAtt: TAttribute; prmNode: TMLTreeNode); virtual;
                        {dtruire uniquement la liste de feuilles}
                        destructor  Destroy; override;
                        {dtruire la feuille nj}
                        procedure   DeleteLeaf(j: integer);
                        {une feuille}
                        property  SplitLeaf[i: integer]: TSplitLeaf read getSplitLeaf;
                        {nombre de feuilles}
                        property  Count: integer read getCountSplitLeaves;
                        {qualit de segmentation}
                        property  GoodnessSplit: double read FGoodnessSplit;
                        {acceptation de la segmentation}
                        property  AcceptSplit: boolean read FAcceptSplit;
                        {le sommet associ}
                        property  Node: TMLTreeNode read FNode;
                        {proprit de la mthode associe}
                        property  PrmMethod: TOperatorParameter read FPrmMethod;
                        {attribut de travail}
                        property  Attribute: TAttribute read FAttribute;
                        end;

        {classe de split attribut}
        TClassSplitAttribut = class of TSplitAttribut;

        {une liste d'attributs candidats pour un sommet}
        TLstSplitAttributes = class(TObject)
                              private
                              {le sommet associ}
                              FNode: TMLTreeNode;
                              {liste de candidats}
                              FLstSplitAttributes: TObjectList;
                              {numro du split choisi}
                              FNumberSplit: integer;
                              {sa qualit}
                              FGoodnessSplit: double;
                              protected
                              {renvoyer la classe de split attribut associe}
                              function  getClassSplitAttribut(): TClassSplitAttribut; virtual; abstract;
                              public
                              {prparer la liste de splits candidats}
                              constructor create(prmNode: TMLTreeNode); virtual; 
                              {dtruire les candidats}
                              destructor  destroy; override;
                              {calculer les segmentations pour chaque attribut candidat}
                              procedure   buildCandidateSplits(prmInputAtts: TLstAttributes);
                              {le split attribut optimum}
                              function    getSplitOptima(): TSplitAttribut;
                              {numro du choisi}
                              property NumberSplit: integer read FNumberSplit;
                              {sa qualit de partitionnement}
                              property GoodnessSplit: double read FGoodnessSplit;
                              end;

        {classe de recherche des splits}
        TClassLstSplitAttributes = class of TLstSplitAttributes;

        {un sommet de l'arbre de dcision}
        TMLTreeNode = class(TObject)
                      private
                      {la structure d'arbre associe}
                      FTreeStructure: TMLTreeStructure;
                      {les targets}
                      FTargetAttributes: TLstAttributes;
                      {les inputs}
                      FInputAttributes: TLstAttributes;
                      {une liste trie des individus - la question est pose de son opportunit}
                      FInputSortedExamples: TObjectList;
                      {les paramtres de mthode associes}
                      FPrmMethod: TOperatorParameter;
                      {les candidats au split}
                      FSplitCandidates: TLstSplitAttributes;
                      {le noeud parent}
                      FPredecessor: TMLTreeNode;
                      {les noeuds successeurs}
                      FSuccessors: TObjectList;
                      {Qualit de segementation candidate}
                      FGoodnessSplit: double;
                      {numro de segementation  appliquer}
                      FNumberSplit: integer;
                      {la rgle associe au sommet}
                      FCondition: TRuleCondition;
                      {profondeur du noeud}
                      FDepth: integer;
                      {function qui renvoie le fait qu'aucune segmentation intressante n'a t trouve}
                      function  noGoodSplitFounded(): boolean;
                      {se retirer de la liste des feuilles}
                      procedure ExtractFromLeaves();
                      protected
                      {les individus prsents sur le sommet - dispo trs fugacement lors de la cration ???}
                      FExamples: TExamples;
                      {test prlable pour savoir si un split est vraiment ncessaire, par exemple lorsque une rgle d'arrt sur les effectifs est dclench}
                      function  isNoSplitNeeded(): boolean; virtual; abstract;
                      {la classe de recherche de splits}
                      function  getClassLstSplitAttributes(): TClassLstSplitAttributes; virtual; abstract;
                      {calculer les infos locales si non passs par la feuille de sgementation}
                      procedure computeLocalInfos(prmExamples: TExamples); virtual;
                      {rcuprer les infos de la feuille -  surcharger avec override}
                      procedure getLeafInfos(prmLeaf: TSplitLeaf); virtual;
                      {obtenir l'info localement sur le noeud}
                      function  getHTMLLocalInfo(): string; virtual;
                      public
                      {construire un sommet - les exemples ne sont ncessaires que si les deux prcdents paramtres sont NIL, i.e. le sommet racine}
                      constructor create(prmStructure: TMLTreeStructure; prmPredecessor: TMLTreeNode; leafSource: TSplitLeaf; prmExamples: TExamples = nil); virtual;
                      {dtruire}
                      destructor  destroy; override;
                      {calculer les segmentations candidates d'un sommet}
                      procedure ComputeSplitNode();
                      {appliquer une segmentation}
                      procedure ApplySplitting();
                      {savoir si le sommet est satur, pas de split candidat donc}
                      function  isSatured(): boolean;
                      {savoir si c'est une feuille de l'arbre}
                      function  isLeaf(): boolean;
                      {obtenir la description HTML en cascade}
                      procedure getHTMLDescription(var bs: TBufString);
                      {obtenir de l'info lorsque le sommet est une feuille}
                      function  getHTMLLeafInfos(): string; virtual; abstract;
                      function  getTXTLeafInfos(): string; virtual; abstract;
                      {nombre de successeurs}
                      function  getCountSuccessors(): integer;
                      {accder au successeur ni}
                      function  getSuccessor(i: integer): TMLTreeNode; overload;
                      {recherche le numro d'un successeur, renvoie une valeur ngative si non-trouv}
                      function  getSuccessor(node: TMLTreeNode): integer; overload;
                      {vider (sans dtruire les objets -- la liste n'est pas propritaire) les successeurs}
                      procedure clearSuccessors();
                      {individus du sommet}
                      property Examples: TExamples read FExamples;
                      {les targets}
                      property TargetAttributes: TLstAttributes read FTargetAttributes;
                      {les inputs}
                      property InputAttributes: TLstAttributes read FInputAttributes;
                      {paramtres de mthode}
                      property PrmMethod: TOperatorParameter read FPrmMethod;
                      {numro de split}
                      property NumberSplit: integer read FNumberSplit;
                      {qualit de split}
                      property GoodnessSplit: double read FGoodnessSplit;
                      {structure d'arbre associe}
                      property TreeStructure: TMLTreeStructure read FTreeStructure;
                      {la condition associe au sommet}
                      property Condition: TRuleCondition read FCondition;
                      {liste des exemples tries selon le descripteur}
                      property InputSortedExamples: TObjectList read FInputSortedExamples;
                      {profondeur du neoud}
                      property Depth: integer read FDepth;
                      {prdecesseur du noeud}
                      property Predecessor: TMLTreeNode read FPredecessor;
                      end;

        {classe de sommets}
        TClassMLTreeNode = class of TMLTreeNode;

        {une structure d'arbre de dcision}
        TMLTreeStructure = class(TObject)
                           private
                           {liste des sommets de l'arbre}
                           FLstNodes: TObjectList;
                           {liste des feuilles de l'arbre}
                           FLstLeaves: TObjectList;
                           {la racine de l'arbre}
                           FRootNode: TMLTreeNode;
                           {les inputs}
                           FInputAttributes: TLstAttributes;
                           {les targets}
                           FTargetAttributes: TLstAttributes;
                           {paramtre de mthode}
                           FPrmMethod: TOperatorParameter;
                           {new -- 02/02/2005 -- structure temporaire de calcul -- optimisation du code}
                           FFlagExample: TBooleanArray;
                           {nombre de sommets}
                           function   getCountNodes(): integer;
                           {sommet n i}
                           function   getNode(i: integer): TMLTreeNode;
                           {nombre de feuilles}
                           function   getCountLeaves(): integer;
                           {feuille ni}
                           function   getLeaf(i: integer): TMLTreeNode;
                           protected
                           {les exemples d'apprentissage}
                           FTrainingSet: TExamples;
                           {prparation des donnes - ex. split "training-pruning"}
                           procedure  prepareDataset(prmExamples: TExamples); virtual;
                           {prparer les structures internes -- liste de noeuds, de feuilles, etc.}
                           procedure  prepareInternalStructures(); virtual;
                           {dtruire les structures internes}
                           procedure  destroyInternalStructures(); virtual;
                           {la classe de sommet associe}
                           function   getClassMLTreeNode(): TClassMLTreeNode; virtual; abstract;
                           {chercher une segmentation}
                           function   SplitFound(): boolean;
                           {ajouter une feuille uniquement, que la rfrence -- utile pour le post-lagage}
                           procedure   addLeaveReference(node: TMLTreeNode);
                           public
                           {initialiser}
                           constructor create(paramMethod: TOperatorParameter; prmTarget,prmInput: TLstAttributes; prmExamples: TExamples); virtual;
                           {dtruire}
                           destructor  destroy; override;
                           {construire l'arbre}
                           procedure   GrowingTree(); virtual;
                           {procdure  mettre en oeuvre aprs le growing}
                           procedure   PostGrowing(); virtual; abstract;
                           {procdure  mettre en oeuvre pour rduire la taille de l'arbre le cas chant}
                           procedure   PostPruning(); virtual; abstract;
                           {ajouter un noeud  la structure}
                           procedure   addNode(node: TMLTreeNode);
                           {supprimer un noeud de la structure}
                           procedure   deleteNode(node: TMLTreeNode);
                           {la racine}
                           property   RootNode: TMLTreeNode read FRootNode;
                           {les sommets}
                           property   CountNodes: integer read getCountNodes;
                           property   Node[i: integer]: TMLTreeNode read getNode;
                           {les feuilles}
                           property   CountLeaves: integer read getCountLeaves;
                           property   Leaf[i: integer]: TMLTreeNode read getLeaf;
                           {paramtre de mthode}
                           property   PrmMethod: TOperatorParameter read FPrmMethod;
                           {les attributs en entre}
                           property   InputAttributes: TLstAttributes read FInputAttributes;
                           {les attributs  dcrire}
                           property   TargetAttributes: TLstAttributes read FTargetAttributes;
                           end;

        {classe de classe structure d'arbre}
        TClassMLTreeStructure = class of TMLTreeStructure; 

implementation

uses
        SysUtils, ULogFile;

{ TSplitLeaf }

procedure TSplitLeaf.AddExample(prmExample: integer);
begin
 inc(FNbExamples);
end;

procedure TSplitLeaf.BeginUpdate;
begin
 FNbExamples:= 0;
end;

constructor TSplitLeaf.create(prmTargetAttributes: TLstAttributes; prmCond: TRuleCondition;
  nbExamples: integer);
begin
 inherited Create();
 FTargetAttributes:= prmTargetAttributes;
 FCondition:= prmCond;
end;

destructor TSplitLeaf.Destroy;
begin
 FCondition.Free;
 inherited destroy;
end;

procedure TSplitLeaf.EndUpdate;
begin
 //
end;

procedure TSplitLeaf.Merge(prmOther: TSplitLeaf);
begin
 FCondition.Merge(prmOther.Condition);
end;

{ TSplitAttribut }

procedure TSplitAttribut.BeginUpdate;
var j: integer;
begin
 for j:= 0 to pred(self.Count) do
  self.SplitLeaf[j].BeginUpdate();
end;

procedure TSplitAttribut.BuildLeaves;
begin
 if FAttribute.isCategory(caDiscrete)
  then BuildLeavesDiscrete()
  else BuildLeavesContinue();
end;

procedure TSplitAttribut.BuildLeavesContinue;
var ls,rs: TSplitLeaf;
    classSplit: TClassSplitLeaf;
    cond: TRuleCondition;
begin
 classSplit:= self.getClassSplitLeaf();
 //partition binaire simple - tout  fait fictive
 //gauche "<"
 cond:= TRuleCondContinue.Create(FAttribute,1,-1.0e38);
 ls:= classSplit.create(FNode.TargetAttributes,cond,0);
 FLstSplitLeaves.Add(ls);
 //droite ">="
 cond:= TRuleCondContinue.Create(FAttribute,2,-1.0e38);
 rs:= classSplit.create(FNode.TargetAttributes,cond,FNode.Examples.Size);
 FLstSplitLeaves.Add(rs);
 //optimisation pour trouver le point de discrtisation optimal
 self.OptimizeContinuousLeaves();
 //valuer la qualit avec les rgles de gestion d'acceptation
 self.EvaluateSplitting();
end;

procedure TSplitAttribut.BuildLeavesDiscrete;
var j: TTypeDiscrete;
    leaf: TSplitLeaf;
    cond: TRuleCondition;
    i,example: integer;
    classSplit: TClassSplitLeaf;
begin
 //construire une feuille par modalit "prsente"
 for j:= 1 to FAttribute.nbValues do
  begin
   cond:= TRuleCondDiscrete.Create(FAttribute,1,j);
   classSplit:= self.getClassSplitLeaf();
   leaf:= classSplit.create(FNode.TargetAttributes,cond,FNode.Examples.Size);
   FLstSplitLeaves.Add(leaf);
  end;
 //remplir avec les individus du sommet
 self.BeginUpdate();
 for i:= 1 to FNode.Examples.Size do
  begin
   example:= FNode.Examples.Number[i];
   //plus rapide je vois pas -- rcuprer la position de la feuille -- le revers de la mdaille est que le codage est dpendant de l'ordre des valeurs dans les donnes
   j:= FAttribute.dValue[example];
   leaf:= self.SplitLeaf[pred(j)];
   //ajouter l'exemple  la feuille
   leaf.AddExample(example);
  end;
 self.EndUpdate();
 //optimiser le cas chant
 self.OptimizeDiscreteLeaves();
 //valuer la qualit
 self.EvaluateSplitting();
end;

constructor TSplitAttribut.Create(prmMethod: TOperatorParameter;
  prmAtt: TAttribute; prmNode: TMLTreeNode);
begin
 inherited Create();
 FPrmMethod:= prmMethod;
 FAttribute:= prmAtt;
 FNode:= prmNode;
 FLstSplitLeaves:= TObjectList.Create(TRUE);
 //construire directement les feuilles
 self.BuildLeaves();
end;

procedure TSplitAttribut.DeleteLeaf(j: integer);
begin
 if (j>=0) and (j<self.Count)
  then FLstSplitLeaves.Delete(j);
end;

destructor TSplitAttribut.Destroy;
begin
 FLstSplitLeaves.Free;
 inherited;
end;

procedure TSplitAttribut.EndUpdate;
var j: integer;
begin
 for j:= 0 to pred(self.Count) do
  self.SplitLeaf[j].EndUpdate();
end;

procedure TSplitAttribut.EvaluateSplitting;
begin
 FGoodnessSplit:= self.ComputeGoodness();
 FAcceptSplit:= self.ComputeAcceptSplit();
 //TraceLog.WriteToLogFile(self.Attribute.Name+'>>'+format('goodness %.6f, accept = %d',[FGoodnessSplit,ord(FAcceptSplit)]));
end;

function TSplitAttribut.getCountSplitLeaves: integer;
begin
 result:= FLstSplitLeaves.Count;
end;

function TSplitAttribut.getSplitLeaf(i: integer): TSplitLeaf;
begin
 result:= FLstSplitLeaves.Items[i] as TSplitLeaf;
end;

procedure TSplitAttribut.OptimizeDiscreteLeaves;
begin
 //nothing au dpart
end;

{ TLstSplitAttributes }

procedure TLstSplitAttributes.buildCandidateSplits(
  prmInputAtts: TLstAttributes);
var j,jMax: integer;
    att: TAttribute;
    split: TSplitAttribut;
    goodMax: double;
begin
 jMax:= -1;
 goodMax:= -1.0e308; 
 //pour chaque attribut candidat
 for j:= 0 to pred(prmInputAtts.Count) do
  begin
   att:= prmInputAtts.Attribute[j];
   split:= self.getClassSplitAttribut.Create(FNode.PrmMethod,att,FNode);
   //afficher les infos
   //TraceLog.WriteToLogFile(format('%s>>%.4f,%d',[split.Attribute.Name,split.GoodnessSplit,ord(split.AcceptSplit)]));
   //tester si max
   if split.AcceptSplit and (split.GoodnessSplit>goodMax)
    then
     begin
      jMax:= j;
      //ce n'est pas une fonction, on peut l'appeler plusieurs fois
      goodMax:= split.GoodnessSplit;
     end;
   //l'ajouter dans la liste
   FLstSplitAttributes.Add(split);
  end;
 //ok donc, on dispose des bonnes rfrences
 FNumberSplit:= jMax;
 FGoodnessSplit:= goodMax;
end;

constructor TLstSplitAttributes.create(prmNode: TMLTreeNode);
begin
 inherited Create();
 FNode:= prmNode;
 FLstSplitAttributes:= TObjectList.Create(TRUE);
end;

destructor TLstSplitAttributes.destroy;
begin
 FLstSplitAttributes.Free;
 inherited;
end;

function TLstSplitAttributes.getSplitOptima: TSplitAttribut;
begin
 result:= nil;
 if (FNumberSplit>=0)
  then result:= FLstSplitAttributes.Items[FNumberSplit] as TSplitAttribut;
end;

{ TMLTreeNode }

procedure TMLTreeNode.ApplySplitting;
var split: TSplitAttribut;
    leaf: TSplitLeaf;
    j: integer;
    node: TMLTreeNode;
    //memBefore: integer;
begin
 //il y a  splitter
 if assigned(FSplitCandidates) and (FNumberSplit>=0)
  then
   begin
    split:= FSplitCandidates.getSplitOptima();
    //crer les enfants
    for j:= 0 to pred(split.Count) do
     begin
      leaf:= split.SplitLeaf[j];
      //memBefore:= AllocMemSize;
      node:= FTreeStructure.getClassMLTreeNode().create(FTreeStructure,self,leaf,nil);
      //memBefore:= AllocMemSize-memBefore;
      //TraceLog.WriteToLogFile(format('DT ==> ApplySplitting, used memory for node creation : %d',[memBefore]));
      FTreeStructure.AddNode(node);
     end;
    //memBefore:= AllocMemSize;
    //retirer le noeud courant de la liste des feuilles
    self.ExtractFromLeaves();
    //TraceLog.WriteToLogFile(format('DT ==> ApplySplitting, size before and after extractfromleaves %d <-> %d',[memBefore,AllocMemSize]));
   end;
end;

procedure TMLTreeNode.clearSuccessors;
begin
 self.FSuccessors.Clear();
end;

procedure TMLTreeNode.computeLocalInfos(prmExamples: TExamples);
var j: integer;
    att: TAttribute;
    ex: TExamples;
begin
 //rcuprer les individus
 FExamples:= TExamples.Create(prmExamples.Size);
 FExamples.Copy(prmExamples); 
 //on le fait une fois sur la racine
 //construire la liste trie sur les inputs
 FInputSortedExamples:= TObjectList.Create(TRUE);
 //pour chaque attribut continu
 for j:= 0 to pred(FInputAttributes.Count) do
  begin
   att:= FInputAttributes.Attribute[j];
   if att.isCategory(caContinue)
    then
     begin
      ex:= TExamples.Create(prmExamples.Size);
      ex.Copy(prmExamples);
      ex.QuickSortBy(att);
      FInputSortedExamples.Add(ex);
     end
    //rien du tout sinon
    else FInputSortedExamples.Add(NIL);
  end;
end;

procedure TMLTreeNode.ComputeSplitNode;
begin
 FSplitCandidates:= getClassLstSplitAttributes.create(self);
 FSplitCandidates.buildCandidateSplits(FInputAttributes);
 FNumberSplit:= FSplitCandidates.NumberSplit;
 FGoodnessSplit:= FSplitCandidates.GoodnessSplit;
end;

constructor TMLTreeNode.create(prmStructure: TMLTreeStructure;
  prmPredecessor: TMLTreeNode; leafSource: TSplitLeaf;
  prmExamples: TExamples);
begin
 inherited Create();
 FTreeStructure:= prmStructure;
 FPrmMethod:= prmStructure.PrmMethod;
 FInputAttributes:= prmStructure.InputAttributes;
 FTargetAttributes:= prmStructure.TargetAttributes;
 FPredecessor:= prmPredecessor;
 if assigned(Fpredecessor)
  then FDepth:= succ(FPredecessor.Depth)
  else FDepth:= 0;//c'est la racine donc
 //s'ajouter dans la liste du prdcesseur
 if assigned(FPredecessor)
  then FPredecessor.FSuccessors.Add(self);
 //crer la liste des ventuels successeurs
 FSuccessors:= TObjectList.Create(FALSE);
 if assigned(leafSource)
  then self.getLeafInfos(leafSource)
  else self.computeLocalInfos(prmExamples);
 //tester si une segmentation est ncessaire
 FNumberSplit:= -1;
 if not(self.isNoSplitNeeded)
  then self.ComputeSplitNode();
 //vider quelques listes internes post-calculatoires
 if assigned(FSplitCandidates) and (FNumberSplit<0)
  then freeAndNil(FSplitCandidates);
end;

destructor TMLTreeNode.destroy;
begin
 if assigned(FCondition)
  then FreeAndNil(FCondition);
 if assigned(FExamples)
  then FreeAndNil(FExamples);
 if assigned(FSplitCandidates)
  then FreeAndNil(FSplitCandidates);
 if assigned(FInputSortedExamples)
  then FreeAndNil(FInputSortedExamples);
 FSuccessors.Free;
 inherited;
end;

procedure TMLTreeNode.ExtractFromLeaves;
begin
 FTreeStructure.FLstLeaves.Extract(self);
 //en profiter pour virer des infos inutiles
 if assigned(FExamples)
  then FreeAndNil(FExamples);
 if assigned(FSplitCandidates)
  then FreeAndNil(FSplitCandidates);
 if assigned(FInputSortedExamples)
  then FreeAndNil(FInputSortedExamples);
end;

function TMLTreeNode.getCountSuccessors: integer;
begin
 result:= FSuccessors.Count;
end;

procedure TMLTreeNode.getHTMLDescription(var bs: TBufString);
var i: Integer;
    successor: TMLTreeNode;
begin
 if not(self.isLeaf)
  then
   begin
     //pour chaque enfant, inscrire la rgle puis les infos locales
     bs.AddStr('<UL>');
     For i:= 0 To pred(self.FSuccessors.Count) do
      Begin
       successor:= self.FSuccessors.Items[i] as TMLTreeNode;
       bs.AddStr('<LI>'+successor.getHTMLLocalInfo());
       successor.getHTMLDescription(bs);
      End;
     bs.AddStr('</UL>');
   end
  else bs.AddStr(self.getHTMLLeafInfos());
end;

function TMLTreeNode.getHTMLLocalInfo: string;
var s: string;
begin
 //rcuprer au moins la description de la rgle
 if assigned(FCondition)
  then s:= FCondition.getHTMLDescription()
  else s:= '';
 result:= s;
end;

procedure TMLTreeNode.getLeafInfos(prmLeaf: TSplitLeaf);
var ex,exSource: TExamples;
    att: TAttribute;
    j,i,example: integer;
    bFlagExample: TBooleanArray;
begin
 //rcuprer la condition et les exemples
 FCondition:= prmLeaf.Condition.Duplicate();
 //attFiltering:= FCondition.Attribute;

 //-- new -- 02/02/2005 -- amliorer les calculs pour var. continues
 //affectation directe du pointeur -- not propertary
 bFlagExample:= self.TreeStructure.FFlagExample;
 //il faut viter les alloc-dsalloc successives gourmands en CPU
 bFlagExample.Capacity:= succ(FCondition.Attribute.Size);
 bFlagExample.SetAllFalse();

 //-- dans ce cas, il faut soi-mme reconstruire la liste des exemples  partir des individus du sommet prcdent
 exSource:= FPredecessor.Examples;
 FExamples:= TExamples.create(exSource.Size);
 FExamples.BeginAdd();
 for i:= 1 to exSource.Size do
  begin
   example:= exSource.Number[i];
   //il va bien dans ce noeud ?
   //if FCondition.TestValue(attFiltering.cValue[example])
   //-- new -- 02/02/2005 -- pourquoi pas directement ceci ?
   if FCondition.TestExample(example)
    Then
     begin
      FExamples.AddExample(example);
      bFlagExample.Flag[example]:= TRUE;
     end;
  end;
 FExamples.EndAdd();

 //rcuprer la liste d'exemples trie
 FInputSortedExamples:= TObjectList.Create(TRUE);
 //il faut rellement optimiser ce filtrage - le noeud du problme est transfr ici maintenant
 //pour chaque attribut continu
 for j:= 0 to pred(FInputAttributes.Count) do
  begin
   att:= FInputAttributes.Attribute[j];
   if att.isCategory(caContinue)
    then
     begin
      exSource:= FPredecessor.InputSortedExamples.Items[j] as TExamples;
      ex:= TExamples.Create(exSource.Size);
      ex.BeginAdd();
      //TraceLog.WriteToLogFile(format('taille sommet predecesseur (%d)',[exSource.Size]));
      //copie conditionnelle
      for i:= 1 to exSource.Size do
       begin
        example:= exSource.Number[i];
        //si condition ok
        //if FCondition.TestValue(attFiltering.cValue[example])
        //-- new -- 02/02/2005 -- pourquoi pas directement ceci ?
        //if FCondition.TestExample(example)
        //-- new -- 02/02/2005 -- ou encore ceci -- finalement --> on passe de 60 sec.  45 sec. sur BIGWAVE
        if bFlagExample.Flag[example]
         then ex.AddExample(example);
       end;
      ex.EndAdd();
      FInputSortedExamples.Add(ex);
      //TraceLog.WriteToLogFile(format('taille expecte (%d), taille obtenue trie (%d)',[prmLeaf.Examples.Size,ex.Size]));
     end
    //rien du tout sinon
    else FInputSortedExamples.Add(NIL);
  end;

end;

function TMLTreeNode.getSuccessor(i: integer): TMLTreeNode;
begin
 result:= FSuccessors.Items[i] as TMLTreeNode;
end;

function TMLTreeNode.getSuccessor(node: TMLTreeNode): integer;
begin
 result:= self.FSuccessors.IndexOf(node);
end;

function TMLTreeNode.isLeaf: boolean;
begin
 result:= (FSuccessors.Count = 0);
end;

function TMLTreeNode.isSatured: boolean;
begin
 //deux conditions, a ne peut pas tre intressant et on a cherch mais rien trouv
 //si la premire est  true, la seconde ne sera pas teste
 {$B-}
 result:= self.isNoSplitNeeded() or self.noGoodSplitFounded();
end;

function TMLTreeNode.noGoodSplitFounded: boolean;
begin
 //on a test mais rien trouv
 result:= not(assigned(FSplitCandidates))
          or (assigned(FSplitCandidates) and (FSplitCandidates.NumberSplit<0));
end;

{ TMLTreeStructure }

procedure TMLTreeStructure.addNode(node: TMLTreeNode);
begin
 self.FLstNodes.Add(node);
 self.FLstLeaves.Add(node);
end;

procedure TMLTreeStructure.addLeaveReference(node: TMLTreeNode);
begin
 self.FLstLeaves.Add(node);
end;

procedure TMLTreeStructure.GrowingTree;
begin
 //algo trs simple
 while self.SplitFound do
  begin
   //suivre l'volution de la mmoire alloue, elle doit tre stable au fil du temps
   //affichage dans le log
   //TraceLog.WriteToLogFile(format('volution mmoire >> feuilles (%3d), mmoire alloue (%10d)',[self.CountLeaves,AllocMemSize]));
  end;
end;

constructor TMLTreeStructure.create(paramMethod: TOperatorParameter; prmTarget, prmInput: TLstAttributes;
  prmExamples: TExamples);
begin
 inherited Create();
 //rcup infos
 FPrmMethod:= paramMethod;
 FTargetAttributes:= prmTarget;
 FInputAttributes:= prmInput;
 //prepare internal structures
 self.prepareInternalStructures();
 //prepare dataset
 self.prepareDataset(prmExamples);
 //cration de la racine  la vole
 FRootNode:= self.getClassMLTreeNode().create(self,NIL,NIL,FTrainingSet);
 self.addNode(FRootNode);
end;

procedure TMLTreeStructure.prepareInternalStructures;
begin
 FLstNodes:= TObjectList.Create(TRUE);
 FLstLeaves:= TObjectList.Create(FALSE);
 //02/02/2005 -- structures temporaires pour les calculs
 FFlagExample:= TBooleanArray.Create(0);
end;

procedure TMLTreeStructure.destroyInternalStructures;
begin
 if assigned(FFlagExample)
  then FreeAndNil(FFlagExample);
 FLstLeaves.Free;
 FLstNodes.Free;
end;

procedure TMLTreeStructure.prepareDataset(prmExamples: TExamples);
begin
 //simple passage du pointeur -- pas de liste propritaire
 FTrainingSet:= prmExamples;
end;

destructor TMLTreeStructure.destroy;
begin
 self.destroyInternalStructures();
 FTrainingSet:= NIL;//pas propritaire ici...
 inherited destroy;
 TraceLog.WriteToLogFile(format('DT :: aprs destruction de la structure arbre, mmoire alloue = %d',[AllocMemSize])); 
end;

function TMLTreeStructure.getCountLeaves: integer;
begin
 result:= FLstLeaves.Count;
end;

function TMLTreeStructure.getCountNodes: integer;
begin
 result:= FLstNodes.Count;
end;

function TMLTreeStructure.getLeaf(i: integer): TMLTreeNode;
begin
 result:= FLstLeaves.Items[i] as TMLTreeNode;
end;

function TMLTreeStructure.getNode(i: integer): TMLTreeNode;
begin
 result:= FLstNodes.Items[i] as TMLTreeNode;
end;

function TMLTreeStructure.SplitFound: boolean;
var leaf: TMLTreeNode;
    i: integer;
    gMax: double;
    iMax: integer;
begin
 iMax:= -1;
 gMax:= -1.0e308;
 result:= false;
 //passer en revue les feuilles
 for i:= 0 to pred(self.CountLeaves) do
  begin
   leaf:= self.Leaf[i];
   {$B-}
   if not(leaf.isSatured) and (leaf.GoodnessSplit>gMax)
    then
     begin
      iMax:= i;
      gMax:= leaf.GoodnessSplit;
     end;
  end;
 //on peut appliquer ?
 if (iMax>=0)
  then
   begin
    leaf:= self.Leaf[iMax];
    leaf.ApplySplitting();
    result:= TRUE;
   end;
end;

procedure TMLTreeStructure.deleteNode(node: TMLTreeNode);
begin
 FLstLeaves.Remove(node);
 FLstNodes.Remove(node);//ce qui entrane la destruction de l'objet !!! (lstNodes est propritaire)
end;

end.
