(**********************************************************************************)
(* UCompSDUnivariateContinuousAttPlus.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(**********************************************************************************)

{
@abstract(Composant statistique descriptive pour des variables continues - Traitement univari)
@author(Ricco)
@created(05/07/2004)
}

unit UCompSDUnivariateContinuousAttPlus;

interface

uses
        Forms, Classes,
        UCompDefinition,
        UCompSDDefinition,
        UOperatorDefinition,
        UCompManageDataset;

type
        {Gnrateur de univariate stat cont desc}
        TMLGenCompSDUnivContPlus = class(TMLGenComp)
                               protected
                               procedure   GenCompInitializations(); override;
                               public
                               function    GetClassMLComponent: TClassMLComponent; override;
                               end;

        {le composant}
        TMLCompSDUnivContPlus = class(TMLCompSD)
                                protected
                                function    getClassOperator: TClassOperator; override;
                                function    GetLogResultDescription(): string; override;
                                end;

        {l'oprateur associ}
        TOpSDUnivContPlus     = class(TOpSD)
                                protected
                                procedure   InitializeListStat(); override;
                                function    getClassParameter: TClassOperatorParameter; override;
                                procedure   RebuildStatDes(); override;
                                function    CheckAttributes(): boolean; override;
                                public
                                end;

        {le paramtrage}
        TOpPrmSDUnivCont = class(TOpPrmSD)
                           protected
                           function    CreateDlgParameters(): TForm; override;
                           public
                           function    getHTMLParameters(): string; override;
                           end;

implementation

uses
        Sysutils,
        UDatasetDefinition,
        UDatasetImplementation, UDlgOpPrmUnivStatDesCont,
        UConstConfiguration, UStringsResources,
        UCalcStatDes,UCalcStatDesContinuousPlus;

{ TMLGenCompSDUnivContPlus }

procedure TMLGenCompSDUnivContPlus.GenCompInitializations;
begin
 FMLComp:= mlcDescriptiveStat;
end;

function TMLGenCompSDUnivContPlus.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSDUnivContPlus;
end;

{ TMLCompSDUnivContPlus }

function TMLCompSDUnivContPlus.getClassOperator: TClassOperator;
begin
 result:= TOpSDUnivContPlus;
end;

function TMLCompSDUnivContPlus.GetLogResultDescription: string;
begin
 result:= Format('stats on %d examples for %d attributes',
          [(self.Operator as TOpLocalData).WorkData.Examples.Size,(self.Operator as TOpLocalData).WorkData.LstAtts[asInput].Count]);
end;

{ TOpPrmSDUnivCont }

function TOpPrmSDUnivCont.CreateDlgParameters: TForm;
begin
 result:= NIL;
end;

function TOpPrmSDUnivCont.getHTMLParameters: string;
var sHtml: string;
begin
 sHTML:= format('<P><B>Attributes : </B>%d<BR>',[(Operator as TOpSDUnivContPlus).LstStat.Count]);
 sHTML:= sHTML+format('<B>Examples : </B>%d<BR>',[(Operator as TOpSDUnivContPlus).Workdata.Examples.Size]);
 result:= sHTML;
end;

{ TOpSDUnivContPlus }

function TOpSDUnivContPlus.CheckAttributes: boolean;
begin
 result:= (self.WorkData.LstAtts[asInput].Count>0) and (self.WorkData.LstAtts[asInput].isAllCategory(caContinue));
end;

function TOpSDUnivContPlus.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmSDUnivCont;
end;

procedure TOpSDUnivContPlus.InitializeListStat;
begin
 FLstStat:= TLstCalcStatDesContinuousPlus.Create(nil,nil);
end;

procedure TOpSDUnivContPlus.RebuildStatDes;
var i: integer;
    att: TAttribute;
    stat: TCalcStatDesContPlus;
begin
 //si modification des paramtres, rcupration des nouvelles variables
 for i:= 0 to pred(workdata.LstAtts[asInput].Count) do
  begin
   att:= workdata.LstAtts[asInput].Attribute[i];
   if att.isCategory(caContinue)
    then
     begin
      stat:= TCalcStatDesContPlus.Create(att,NIL);//nil, pas de calculs
      self.LstStat.AddStat(stat);
     end;
  end;
end;

initialization
 RegisterClass(TMLGenCompSDUnivContPlus);
end.
