(*****************************************************************)
(* UCalcDistribution.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*****************************************************************)

{
@abstract(Structure pour calculer une distribution de frquence d'une var. discrte)
@author(Ricco)
@created(12/01/2004)
La grande nouveaut vient de notre gestion trs particulire de la liste de modalits
d'une variable discrte, cela va acclerer grandement les calculs !!!
}
unit UCalcDistribution;

interface

USES
        Classes,
        UDatasetDefinition,
        UDatasetImplementation,
        UDatasetExamples;

TYPE
        {Mode de comptage - entier}
        TFreqCountType = integer;

CONST
        {taille d'une valeur}
        SIZE_FREQ_COUNT_TYPE = sizeof(TFreqCountType);

TYPE
        {Tableau interne de calcul des distributions, le zro est la marge}
        TTabFreqStruc = array[0..MAX_NB_VALUES_CATEGORICAL] of TFreqCountType;
        PTabFreqStruc = ^TTabFreqStruc;

        {classe de calcul des distributions de frquence}
        TTabFrequence = class(TObject)
                        private
                        {Tableau interne de comptage}
                        FTab: PTabFreqStruc;
                        {Nombre de cases}
                        FSize: integer;
                        {l'attribut associ au tableau de frquence}
                        FAtt: TAttDiscrete;
                        {modifier le nombre de cases}
                        procedure SetSize(prmNewSize: integer);
                        {rinitialiser le tableau en le remplissant avec des 0 (zro)}
                        procedure Initialize();
                        {connecter avec un attribut}
                        procedure ConnectAtt(prmAtt: TAttribute);
                        {rcuprer une valeur du tableau}
                        function  GetValue(i: integer): TFreqCountType;
                        {insrer une valeur dans la case i -- /!\ recalcule la marge sans tenir compte de l'ancienne valeur}
                        procedure  SetValue(i: integer; const value: integer);
                        {rcuprer la frquence d'une case}
                        function  GetFrequence(i: integer): double;
                        public
                        {construire}
                        constructor Create(prmSize: integer);
                        {construire avec une variable et des observations}
                        constructor CreateFromAtt(prmAtt: TAttribute; prmExamples: TExamples = NIL);
                        {dtruire le tableau interne avec}
                        destructor  Destroy; override;
                        {recalculer les distributions}
                        procedure   RefreshFromAtt(prmAtt: TAttribute; prmExamples: TExamples);
                        {recalculer les distributions avec l'hypothse que le branchement existe}
                        procedure   Refresh(prmExamples: TExamples);
                        {rinitialiser le vecteur}
                        procedure   ReInitialization();
                        {incrmenter la valeur d'une cellule, y compris la marge donc}
                        procedure   IncrementCell(i: integer);
                        {dcrmenter}
                        procedure   DecrementCell(i: integer);
                        {fusionner avec une source}
                        procedure   Merge(prmSource: TTabFrequence);
                        {copier le contenu d'une source}
                        procedure   Copy(prmSource: TTabFrequence);
                        {envoyer les rsultats sous forme HTML}
                        function    getHTMLResult(): string;
                        {envoyer les rsultats sous forme HTML, version simplife}
                        function    getHTMLResultSimplified(): string;
                        {envoyer une description au format texte}
                        function    getStringResult(): string;
                        {renvoyer la case contenant la plus forte valeur}
                        function    getIndexMaxValue(): TTypeDiscrete;
                        {valeur dans une case}
                        property    Value[i: integer]: TFreqCountType read GetValue write SetValue;
                        {frquence d'une case}
                        property    Frequence[i: integer]: double read GetFrequence;
                        {taille du tableau}
                        property    Size: integer read FSize;
                        end;

implementation

uses
        SysUtils,
        UConstConfiguration, UCalcRndGenerator, UStringAddBuffered;

{ TTabFrequence }

procedure TTabFrequence.ConnectAtt(prmAtt: TAttribute);
begin
 FAtt:= prmAtt as TAttDiscrete;
 if (FAtt.nbValues<>FSize)
  then self.SetSize(FAtt.nbValues);
end;

procedure TTabFrequence.Copy(prmSource: TTabFrequence);
var i: integer;
begin
 //on pourrait passer par un MOVE tout bte aussi
 for i:= 0 to self.Size do
  FTab^[i]:= prmSource.Value[i];
end;

constructor TTabFrequence.Create(prmSize: integer);
begin
 inherited Create();
 self.SetSize(prmSize);
end;

constructor TTabFrequence.CreateFromAtt(prmAtt: TAttribute;
  prmExamples: TExamples);
begin
 inherited Create();
 self.ConnectAtt(prmAtt);
 if assigned(prmExamples)
  then self.Refresh(prmExamples);
end;

procedure TTabFrequence.DecrementCell(i: integer);
begin
 dec(FTab^[i]);
 dec(FTab^[0]);
end;

destructor TTabFrequence.Destroy;
begin
 ReAllocMem(FTab,0);
 inherited Destroy;
end;

function TTabFrequence.GetFrequence(i: integer): double;
begin
 if (FTab^[0]>0)
  then result:= (1.0*FTab^[i]/(1.0*FTab^[0]))
  else result:= 0.0;//grosse hypothse !!!
end;

function TTabFrequence.getHTMLResult: string;
var s: string;
    j: integer;
    buf: TBufString;
begin
   buf:= TBufString.Create();
   buf.BeginUpdate();
   s:= HTML_HEADER_TABLE_RESULT+HTML_TABLE_COLOR_HEADER_BLUE+
       '<th width=150>Values</th><th width=50>Count</th><th width=80>Percent</th><th width=200>Histogram</th></tr>';
   buf.AddStr(s);
   //pour chaque modalit de la variable
   for j:= 1 to self.Size do
    begin
     s:= Format(HTML_TABLE_COLOR_DATA_BLUE+'<td>%s</td><td align=right>%d</td><td align=right>%.2f %s</td><td>%s</td></tr>',
                [FAtt.LstValues.getDescription(j),self.Value[j],100.0*self.Frequence[j],'%',getHtmlHistogram(trunc(50.0*self.Frequence[j]))]);
     buf.AddStr(s);
    end;

   s:= '</TABLE>';
   buf.AddStr(s);
   //result:= s;
   buf.EndUpdate();

   result:= buf.BufS;
   buf.Free();

end;

function TTabFrequence.getHTMLResultSimplified: string;
var s: string;
    j: integer;
begin
 s:= '(';
 for j:= 1 to self.Size do
  s:= s+Format('%d; ',[self.Value[j]]);
 result:= SYSTEM.COPY(s,1,Length(s)-2)+')';
end;

function TTabFrequence.getIndexMaxValue: TTypeDiscrete;
var i,iMax: TTypeDiscrete;
    v,vMax: integer;
begin
 vMax:= -1;
 iMax:= 0;
 for i:= 1 to self.Size do
  begin
   v:= self.Value[i];
   //si plus grand...
   if (v>vMax)
    then
     begin
      iMax:= i;
      vMax:= v;
     end;
  end;
 result:= iMax;
end;

function TTabFrequence.getStringResult: string;
var s: string;
    i: integer;
begin
 s:= '(';
 for i:= 1 to self.Size do
  s:= s+format('%d;',[self.Value[i]]);
 s:= System.copy(s,1,pred(length(s)))+')';
 result:= s;
end;

function TTabFrequence.GetValue(i: integer): TFreqCountType;
begin
 result:= FTab^[i];
end;

procedure TTabFrequence.IncrementCell(i: integer);
begin
 inc(FTab^[i]);
 inc(FTab^[0]);
end;

procedure TTabFrequence.Initialize;
begin
 FillChar(FTab^,succ(FSize)*SIZE_FREQ_COUNT_TYPE,0);
end;

procedure TTabFrequence.Merge(prmSource: TTabFrequence);
var i: integer;
begin
 for i:= 0 to self.Size do
  inc(FTab^[i],prmSource.Value[i]);
end;

procedure TTabFrequence.Refresh(prmExamples: TExamples);
var i: Integer;
begin
 //vider le tableau
 self.Initialize();
 //puis recalculer pour chaque exemple pass
 if assigned(FAtt)
  then
   begin
     for i:= 1 to prmExamples.Size do
      begin
       inc(FTab^[FAtt.dValue[prmExamples.Number[i]]]);//la ligne qui tue
       inc(FTab^[0]);//la marge aussi !!!
      end;
   end;
end;

procedure TTabFrequence.RefreshFromAtt(prmAtt: TAttribute;
  prmExamples: TExamples);
begin
 self.ConnectAtt(prmAtt);
 self.Refresh(prmExamples);
end;

procedure TTabFrequence.ReInitialization;
var i: integer;
begin
 for i:= 0 to self.Size do
  FTab^[i]:= 0;
end;

procedure TTabFrequence.SetSize(prmNewSize: integer);
begin
 FSize:= prmNewSize;
 ReAllocMem(FTab,succ(FSize)*SIZE_FREQ_COUNT_TYPE);
end;

procedure TTabFrequence.SetValue(i: integer; const value: integer);
begin
 FTab^[i]:= value;
 FTab^[0]:= FTab^[0]+value; 
end;

end.
