(*****************************************************************)
(* UCalcAssocTreeSpv.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*****************************************************************)

{
@abstract(Unit de calcul - Recherche en arbre supervis de rgles d'association)
@author(Ricco)
@created(29/11/2004)

Treillis de recherche -- Algorithme supervis trs simplifi
Growing + Post-lagage.

Mme si les noms sont proches, il ne s'agit pas d'un hritier des ASSOC_APRIORI
}

unit UCalcAssocTreeSpv;

interface

USES
        Contnrs,
        EZDSLBar,
        UDatasetDefinition,
        UDatasetExamples,
        UCalcAssocStructure,
        UCalcStatDes,
        UOperatorDefinition,
        UStringAddBuffered;

TYPE

     {type de donnes pour l'valuation de l'arbre}
     TEnumDataStatusAssocTree = (dsAT_Learning,dsAT_Test);

     {noeud de l'arbre -- dclaration forward}
     TAssocTreeNode = class;

     {classe valuation d'une rgle}
     TAssocTreeEval = class
                      private
                      {notations A.M.}
                      n, nA, nC, nAC: integer;
                      {le noeud associ}
                      FNode: TAssocTreeNode;
                      public
                      constructor create(prmNode: TAssocTreeNode);
                      procedure   beginUpdate(prmN, prmNC: integer);
                      procedure   endUpdate();
                      procedure   addValue(example: integer);
                      //valuation d'une rgle
                      function    getSupport(): double;
                      function    getConfidence(): double;
                      function    getLift(): double;
                      end; 

     {structure d'arbre -- dclaration forward}
     TAssocTreeStructure = class;

     {un noeud de l'arbre d'association}
     TAssocTreeNode = class(TObject)
                      private
                      {distribution sur apprentissage et test}
                      FEval: array[TEnumDataStatusAssocTree] of TAssocTreeEval;
                      {conclusion sur le noeud}
                      FNodeConclusion: TTypeDiscrete;
                      {predecesseur}
                      FPredNode: TAssocTreeNode;
                      {successeurs}
                      FSuccNodes: TObjectList;
                      {individus couverts}
                      FBoolArray: TBooleanArray;
                      {profondeur}
                      FDepth: integer;
                      {couverts}
                      FNbCovered: integer;
                      {Item associ}
                      FItem: TAssocItem;
                      {structure d'arbre associe}
                      FTree: TAssocTreeStructure;
                      public
                      {constructeur}
                      constructor create(prmTree: TAssocTreeStructure; prmPredNode: TAssocTreeNode; prmBoolArray: TBooleanArray; prmItem: TAssocItem);
                      {destructeur}
                      destructor  destroy(); override;
                      {est-il racine}
                      function isRoot(): boolean;
                      {est-il feuille}
                      function isLeaf(): boolean;
                      {description de proche en proche}
                      procedure getHTMLDescription(var bs: TBufString);
                      {test si le noeud est eligible  la conclusion -- sur la base des paramtres de l'arbre}
                      function  isEligible(): boolean;
                      end;

     {forward -- liste de rgles}
     TLstAssocTreeSpvRule = class;

     {le treillis complet}
     TAssocTreeStructure = class(TObject)
                           private
                           {target}
                           FTarget: TAttribute;
                           {target value}
                           FTargetValue: TTypeDiscrete;
                           {inputs}
                           FInputs: TLstAttributes;
                           {la racine}
                           FRootNode: TAssocTreeNode;
                           {les items}
                           FLstItems: TLstAssocItem;
                           {paramtre d'oprateur}
                           FPrmOp: TOperatorParameter;
                           {base de rgles associe}
                           FLstRules: TLstAssocTreeSpvRule;
                           {Paramtres internes}
                           FSupportThresoldAbsolute: integer;//en absolu
                           FSupportThresoldPercent: double; //en relatif
                           FMaxDepth: integer;
                           FConfidenceThresold: double;
                           FLiftThresold: double;
                           {construire les items}
                           procedure   buildItems(prmExamples: TExamples; prmThresold: integer);
                           {construire le successeur avec l'item j}
                           procedure   buildSuccessor(curNode: TAssocTreeNode; curItem: TAssocItem);
                           {initialiser les ajouts -- total indiv, et consquent calculs  l'avance}
                           procedure   beginUpdate(node: TAssocTreeNode; dsAT: TEnumDataStatusAssocTree; n,nC: integer);
                           {finaliser les ajouts}
                           procedure   endUpdate(node: TAssocTreeNode; dsAT: TEnumDataStatusAssocTree);
                           {glisser un individu dans la structure}
                           procedure   setExample(node: TAssocTreeNode; dsAT: TEnumDataStatusAssocTree; example: integer);
                           {construire la racine de l'arbre de recherche}
                           procedure   buildRootNode(prmExamples: TExamples);
                           {calculer les effectifs et les couverts par la conclusion}
                           procedure   compute_n_nC(var n,nC: integer; prmExamples: TExamples);
                           {rcuprer les paramtres}
                           procedure   recupParameters(prmOp: TOperatorParameter; prmExamples: TExamples);
                           public
                           {constructeur}
                           constructor create(Operator: TOperator);
                           {destructeur}
                           destructor  destroy(); override;
                           {construire la structure}
                           function buildTree(prmExamples: TExamples): boolean;
                           {dtruire la structure}
                           procedure destroyFromNode(var node: TAssocTreeNode);
                           {calculer les distributions}
                           procedure computeDistribution(dsAT: TEnumDataStatusAssocTree; prmExamples: TExamples);
                           {dessiner la structure}
                           function getHTMLDescription(): string;
                           end;

     {structure de rgle -- une rgle correspond au chemin d'un noeud  une racine}
     TAssocTreeSpvRule = class
                         private
                         {noeud associ}
                         FNode: TAssocTreeNode;
                         {le chemin jusqu' la racine -- liste de noeuds -- not propertary}
                         FPathToRoot: TObjectList;
                         public
                         {constructeur -- insertion d'un noeud et constitution de la liste}
                         constructor create(node: TAssocTreeNode);
                         {libration de la liste (sans dtruire les objets)}
                         destructor  destroy(); override;
                         {lister la rgle}
                         function    getHTMLDescription(): string;
                         end;

     {base de rgles en spv assoc-rule}
     TLstAssocTreeSpvRule = class
                            private
                            {structure d'arbre associe}
                            FAssocTree: TAssocTreeStructure;
                            {liste des rgles -- propritaire}
                            FLstAssocRule: TObjectList;
                            {parcourir les noeuds pour en faire des rgles}
                            procedure   computeRulefrom(node: TAssocTreeNode);
                            public
                            {constructeur}
                            constructor create(tree: TAssocTreeStructure);
                            {destructeur}
                            destructor  destroy(); override;
                            {construire les rgles}
                            procedure   computeRules();
                            {description HTML}
                            function    getHTMLDescription(): string;
                            end;    

implementation

USES
        Sysutils, Windows,
        UCompAssocTreeSpv, ULogFile,
        UCompAssociationRuleDefinition, UCompAssocRuleSupervised,
        UConstConfiguration;

{ TAssocTreeNode }

(*
procedure TAssocTreeNode.computeConclusion;
var k,kMax: integer;
    value,maxValue: integer;
begin
 kMax:= -1;
 maxValue:= 0;
 for k:= 1 to FDist[dsAT_Learning].TabFreq.Size do
  begin
   value:= FDist[dsAT_Learning].TabFreq.Value[k];
   if (value>maxValue)
    then
     begin
      kMax:= k;
      maxValue:= value;
     end;
  end;
 //affectation alatoire si pas trouv
 if (kMax<0)
  then kMax:= succ(random(FDist[dsAT_Learning].TabFreq.Size));
 //puis la conclusion
 FNodeConclusion:= kMax;
 //TraceLog.WriteToLogFile('conclsuion --->>> '+IntToStr(FNodeConclusion));
end;
*)

constructor TAssocTreeNode.create(prmTree: TAssocTreeStructure; prmPredNode: TAssocTreeNode; prmBoolArray: TBooleanArray; prmItem: TAssocItem);
begin
 inherited Create();
 //arbre associ
 FTree:= prmTree;
 //item -- not propertary
 FItem:= prmItem;
 //prdcesseur
 FPredNode:= prmPredNode;
 //spcifier la profondeur
 if (prmPredNode = NIL)
  then FDepth:= 1
  else FDepth:= succ(prmPredNode.FDepth);
 //tableau de bits -- pour le comptage
 FBoolArray:= prmBoolArray;
 FNbCovered:= FBoolArray.Count;
 //les successeurs
 FSuccNodes:= TObjectList.Create(TRUE);
 //la distribution
 FEval[dsAT_Learning]:= TAssocTreeEval.create(self);
 FEval[dsAT_Test]:= TAssocTreeEval.create(self);
 //la conclusion est connue  l'avance
 FNodeConclusion:= prmTree.FTargetValue;
end;

destructor TAssocTreeNode.destroy;
begin
 FreeAndNil(FEval[dsAT_Learning]);
 FreeAndNil(FEval[dsAT_Test]);
 if assigned(FBoolArray) then FreeAndNil(FBoolArray);
 //vider le tableau des successeurs
 FreeAndNil(FSuccNodes);
 inherited;
end;

procedure TAssocTreeNode.getHTMLDescription(var bs: TBufString);
var i: Integer;
    successor: TAssocTreeNode;
    sTemp: string;
begin
 // *** description courante ***
 //rgle
 sTemp:= '';
 if assigned(FItem) then sTemp:= FItem.Description;

 //valuation
 //if (self.FEval[dsAT_Learning].getConfidence() >=self.FTree.FConfidenceThresold)
 //afficher toutes les infos...
 if TRUE
  then
   begin
     //conclusion possible
     sTemp:= sTemp+' then <I>';
     sTemp:= sTemp+self.FTree.FTarget.LstValues.getDescription(FNodeConclusion);

     //mettre en vidence les noeuds slectionns
     if self.isEligible() then sTemp:= sTemp+'<B>';

     //valuation chiffre
     sTemp:= sTemp+format(' (Sup = %.2f ; Conf = %.2f ; Lift = %.2f)',
                   [self.FEval[dsAT_Learning].getSupport(),self.FEval[dsAT_Learning].getConfidence(),self.FEval[dsAT_Learning].getLift()]);

     //
     if self.isEligible() then sTemp:= sTemp+'</B>';

     //suite..
     sTemp:= sTemp+'</I>';

   end;
 //add...
 bs.AddStr(sTemp);
 
 //*** suite ***
 if not(self.isLeaf())
  then
   begin
     //pour chaque enfant, inscrire la rgle puis les infos locales
     bs.AddStr('<UL>');
     For i:= 0 To pred(self.FSuccNodes.Count) do
      Begin
       successor:= self.FSuccNodes.Items[i] as TAssocTreeNode;
       bs.AddStr('<LI>');
       successor.getHTMLDescription(bs);
      End;
     bs.AddStr('</UL>');
   end;
end;

function TAssocTreeNode.isEligible: boolean;
var ok: boolean;
begin
 ok:= (self.FEval[dsAT_Learning].getSupport()>= self.FTree.FSupportThresoldPercent);
 ok:= ok and (self.FEval[dsAT_Learning].getConfidence()>= self.FTree.FConfidenceThresold);
 ok:= ok and (self.FEval[dsAT_Learning].getLift()>= self.FTree.FLiftThresold);
 result:= ok;
end;

function TAssocTreeNode.isLeaf: boolean;
begin
 result:= (FSuccNodes.Count = 0);
end;

function TAssocTreeNode.isRoot: boolean;
begin
 result:= (FPredNode=NIL);
end;

{ TAssocTreeStructure }

procedure TAssocTreeStructure.beginUpdate(node: TAssocTreeNode;
  dsAT: TEnumDataStatusAssocTree; n,nC: integer);
var i: integer;
begin
 //lancer la mise  jour dans chacune des feuilles
 node.FEval[dsAT].BeginUpdate(n,nC);
 for i:= 0 to pred(node.FSuccNodes.Count) do
  self.beginUpdate(node.FSuccNodes.Items[i] as TAssocTreeNode,dsAT,n,nC);
end;

procedure TAssocTreeStructure.buildItems(prmExamples: TExamples;
  prmThresold: integer);
var j: integer;
begin
 for j:= 0 to pred(FInputs.Count) do
  FLstItems.buildItems(FInputs.Attribute[j],prmExamples);
 //trier et filtrer
 FLstItems.FilterItemsOnSupport(prmThresold);
end;

procedure TAssocTreeStructure.buildRootNode(prmExamples: TExamples);
var rootBool: TBooleanArray;
    i: integer;
begin
 //boolarray de la racine
 rootBool:= TBooleanArray.Create(prmExamples.Size);
 for i:= 1 to prmExamples.Size do
  rootBool[pred(i)]:= (FTargetValue = FTarget.dValue[prmExamples.Number[i]]);
 rootBool.RefreshCount();
 //construire la racine
 FRootNode:= TAssocTreeNode.create(self,NIL,rootBool,NIL);
end;

procedure TAssocTreeStructure.buildSuccessor(curNode: TAssocTreeNode;
  curItem: TAssocItem);
var j: integer;
    boolArray: TBooleanArray;
    curSupport: integer;
    tmpNode: TAssocTreeNode;
begin
 //calculer le nombre d'individus couverts
 boolArray:= TBooleanArray.CreateFrom(curNode.FBoolArray);
 //"and" avec le noeud prcdent
 boolArray.AndArray(curItem.BoolArray);
 //compter
 boolArray.RefreshCount();
 curSupport:= boolArray.Count;
 //ok couverture
 if (curSupport>=FSupportThresoldAbsolute)
  //crer le noeud enfant
  then
   begin
    tmpNode:= TAssocTreeNode.create(self,curNode,boolArray,curItem);
    curNode.FSuccNodes.Add(tmpNode);
    //tester la profondeur
    if (tmpNode.FDepth<FMaxDepth)
     then
      //ok -- aller chercher la suite
      begin
       for j:= succ(curItem.Numero) to pred(FLstItems.Count) do
        self.buildSuccessor(tmpNode,FLstItems.Item[j]);
      end;
   end
  //on laisse tomber -- et on remonte
  else boolArray.Free();
end;

function TAssocTreeStructure.buildTree(prmExamples: TExamples): boolean;
var j: integer;
    tps: cardinal;
    training,test: TExamples;
begin
 TRY

 //partitionner en apprentissage et test
 training:= TExamples.Create(0);
 test:= TExamples.Create(0);
 if ((FPrmOp as TOpPrmAssocTreeSpv).AppPortion = 1)
  then training.Copy(prmExamples)
  else prmExamples.SamplingSplitting((FPrmOp as TOpPrmAssocTreeSpv).AppPortion,training,test);

 //rcuprer les paramtres en les adaptant au nombre d'individus courant
 self.recupParameters(FPrmOp,training);

 //*****************
 //**** CALCULS ****
 //*****************

 TRY

   //construire la liste des items
   tps:= GetTickCount();
   self.buildItems(training,FSupportThresoldAbsolute);
   tps:= GetTickCount()-tps;
   TraceLog.WriteToLogFile(format('[SPV ASSOC TREE] build items = %d ms.',[tps]));

   //construire la racine
   tps:= GetTickCount();
   self.buildRootNode(training);
   //construire l'arbre
   for j:= 0 to pred(FLstItems.Count) do
    self.buildSuccessor(FRootNode,FLstItems.Item[j]);
   tps:= GetTickCount()-tps;
   TraceLog.WriteToLogFile(format('[SPV ASSOC TREE] build tree = %d ms.',[tps]));

   //calculer les distributions sur les noeuds
   tps:= GetTickCount();
   self.computeDistribution(dsAT_Learning,training);
   if (test.Size>0)
    then self.computeDistribution(dsAT_Test,test);
   tps:= GetTickCount()-tps;
   TraceLog.WriteToLogFile(format('[SPV ASSOC TREE] evaluate = %d ms.',[tps]));

   //construire la base de rgles
   tps:= GetTickCount();
   self.FLstRules.computeRules();
   tps:= GetTickCount()-tps;
   TraceLog.WriteToLogFile(format('[SPV ASSOC TREE] extract rules = %d ms.',[tps]));

   //and then...
   result:= TRUE;
   EXCEPT
   result:= FALSE;
   END;
   
 FINALLY
 //s'assurer de la libration des var. locales...
 FreeAndNil(training);
 FreeAndNil(test);
 END;
end;

procedure TAssocTreeStructure.computeDistribution(
  dsAT: TEnumDataStatusAssocTree; prmExamples: TExamples);
var i: integer;
    n,nC: integer;
begin
 //calcul une fois pour toutes
 self.compute_n_nC(n,nC,prmExamples);
 //calculer les distributions
 self.beginUpdate(FRootNode,dsAT,n,nC);
 for i:= 1 to prmExamples.Size do
  self.setExample(FRootNode,dsAT,prmExamples.Number[i]);
 self.endUpdate(FRootNode,dsAT);
end;

procedure TAssocTreeStructure.compute_n_nC(var n, nC: integer;
  prmExamples: TExamples);
var i: integer;
begin
 n:= prmExamples.Size;
 nC:= 0;
 for i:= 1 to n do
  nC:= nC+Integer(self.FTarget.dValue[prmExamples.Number[i]] = self.FTargetValue);
end;

constructor TAssocTreeStructure.create(operator: TOperator);
var op: TOpAssocTreeSpv;
begin
 inherited Create();
 op:= operator as TOpAssocTreeSpv;
 FTarget:= op.Target;
 FTargetValue:= op.TargetValue;
 FInputs:= op.Inputs;
 FLstItems:= TLstAssocItem.Create();
 FLstRules:= TLstAssocTreeSpvRule.create(self);
 FPrmOp:= op.PrmOp;
end;

destructor TAssocTreeStructure.destroy;
begin
 FreeAndNil(FlstRules);
 self.destroyFromNode(FRootNode);
 FreeAndNil(FLstItems);
 inherited;
end;

procedure TAssocTreeStructure.destroyFromNode(var node: TAssocTreeNode);
var j: integer;
    succNode: TAssocTreeNode;
begin
 if not(node.isLeaf())
  then
   begin
    for j:= pred(node.FSuccNodes.Count) downto 0 do
     begin
      succNode:= node.FSuccNodes.Items[j] as TAssocTreeNode;
      self.destroyFromNode(succNode);
     end;
   end
  else
   begin
    if assigned(node.FPredNode)
     then
      begin
       j:= node.FPredNode.FSuccNodes.IndexOf(node);
       node.FPredNode.FSuccNodes.Delete(j);
      end
     else FreeAndNil(node);
   end;
end;

procedure TAssocTreeStructure.endUpdate(node: TAssocTreeNode;
  dsAT: TEnumDataStatusAssocTree);
var i: integer;
begin
 node.FEval[dsAT].EndUpdate();
 for i:= 0 to pred(node.FSuccNodes.Count) do
  self.endUpdate(node.FSuccNodes.Items[i] as TAssocTreeNode,dsAT);
end;

function TAssocTreeStructure.getHTMLDescription: string;
var buf: TBufString;
begin
 buf:= TBufString.Create();
 buf.BeginUpdate();
 //description des rgles
 buf.AddStr(self.FLstRules.getHTMLDescription());
 
 (*
 buf.AddStr('<HR>');
 //description de l'arbre
 buf.AddStr('<H3>Tree description</H3>');
 FRootNode.getHTMLDescription(buf);
 *)

 buf.EndUpdate();
 result:= buf.BufS;
 buf.Free();
end;

procedure TAssocTreeStructure.recupParameters(prmOp: TOperatorParameter; prmExamples: TExamples);
begin
 //set parameters...
 FSupportThresoldAbsolute:= trunc((prmOp as TOpPrmAssocTreeSpv).MinSupport*prmExamples.Size);
 FSupportThresoldPercent:= (prmOp as TOpPrmAssocTreeSpv).MinSupport;
 TraceLog.WriteToLogFile(format('[SPV ASSOC TREE] absolute support thresold = %d',[FSupportThresoldAbsolute]));
 FMaxDepth:= (prmOp as TOpPrmAssocTreeSpv).MaxRuleLength;
 FConfidenceThresold:= (prmOp as TOpPrmAssocTreeSpv).MinConfidence;
 FLiftThresold:= (prmOp as TOpPrmAssocTreeSpv).MinLift;
end;

procedure TAssocTreeStructure.setExample(node: TAssocTreeNode;
  dsAT: TEnumDataStatusAssocTree; example: integer);
var i: integer;
begin
 //si pas de filtre -- la racine --, ou si rgle dclenche...
 if not(assigned(node.FItem)) OR (node.FItem.Attribute.dValue[example] = node.FItem.Value)
  then
   begin
     node.FEval[dsAT].AddValue(example);
     for i:= 0 to pred(node.FSuccNodes.Count) do
      self.setExample(node.FSuccNodes.Items[i] as TAssocTreeNode,dsAT,example);
   end;
end;

{ TAssocTreeEval }

procedure TAssocTreeEval.addValue(example: integer);
begin
 //nouvel individu couvert par l'antcdent
 inc(nA);
 //couvert par le consquent ?
 nAC:= nAC+Integer(self.FNode.FTree.FTarget.dValue[example] = self.FNode.FNodeConclusion);
end;

procedure TAssocTreeEval.beginUpdate(prmN,prmNC: integer);
begin
 //rcup. -- les mmes partout
 n:= prmN;
 nC:= prmNC;
 //raz
 nA:= 0;
 nAC:= 0;
end;

constructor TAssocTreeEval.create(prmNode: TAssocTreeNode);
begin
 inherited Create();
 FNode:= prmNode;
end;

procedure TAssocTreeEval.endUpdate;
begin
 //none...
end;

function TAssocTreeEval.getConfidence: double;
begin
 if (nA>0)
  then result:= (1.0*nAC)/(1.0*nA)
  else result:= 0.0;
end;

function TAssocTreeEval.getLift: double;
begin
 if (nA>0) and (nC>0)
  then result:= (1.0*n*nAC)/(1.0*nA*nC)
  else result:= 0.0;
end;

function TAssocTreeEval.getSupport: double;
begin
 if (n>0)
  then result:= (1.0*nAC)/(1.0*n)
  else result:= 0.0;
end;

{ TAssocTreeSpvRule }


//** critre de comparaison des items **
function compare_node(Item1, Item2: Pointer): Integer;
begin
 if (TAssocTreeNode(Item1).FItem.Numero<TAssocTreeNode(Item2).FItem.Numero)
  then result:= -1
  else
   begin
    if (TAssocTreeNode(Item1).FItem.Numero>TAssocTreeNode(Item2).FItem.Numero)
     then result:= +1
     else result:= 0;
   end;
end;
//**************************************


constructor TAssocTreeSpvRule.create(node: TAssocTreeNode);
var curNode: TAssocTreeNode;
begin
 inherited create();
 self.FNode:= node;
 //la liste
 self.FPathToRoot:= TObjectList.Create(FALSE);
 //parcourir le chemin jusqu' la racine
 curNode:= node;
 while (curNode.FItem<>NIL) do //si Item est NIL, c'est la racine, il n'y a pas de rgle sur ce noeud
  begin
   self.FPathToRoot.Add(curNode);
   curNode:= curNode.FPredNode;
  end;
 //puis trier selon le numro
 self.FPathToRoot.Sort(compare_node);
end;

destructor TAssocTreeSpvRule.destroy;
begin
 FPathToRoot.Free();
 inherited destroy();
end;

function TAssocTreeSpvRule.getHTMLDescription: string;
var sTemp: string;
    i: integer;
begin
 //la rgle
 sTemp:= '<TD>';
 for i:= 0 to pred(self.FPathToRoot.Count) do
  sTemp:= sTemp+(self.FPathToRoot.Items[i] as TAssocTreeNode).FItem.Description+' - ';
 sTemp:= copy(sTemp,1,length(sTemp)-3)+'</TD>';
 //** les valuations **
 //length
 sTemp:= sTemp+format('<TD>%d</TD>',[self.FPathToRoot.Count]);
 //support
 sTemp:= sTemp+format('<TD>%.3f ( %.2f )</TD>',[self.FNode.FEval[dsAT_Learning].getSupport(),self.FNode.FEval[dsAT_Test].getSupport()]);
 //confiance
 sTemp:= sTemp+format('<TD>%.3f ( %.2f )</TD>',[self.FNode.FEval[dsAT_Learning].getConfidence(),self.FNode.FEval[dsAT_Test].getConfidence()]);
 //lift -- TAssocTreeSpvRule(Item1).FNode.FEval[dsAT_Learning].getLift()
 sTemp:= sTemp+format('<TD>%.3f ( %.2f )</TD>',[self.FNode.FEval[dsAT_Learning].getLift(),self.FNode.FEval[dsAT_Test].getLift()]);
 //and then...
 result:= sTemp;
end;

{ TLstAssocTreeSpvRule }

procedure TLstAssocTreeSpvRule.computeRulefrom(node: TAssocTreeNode);
var ok: boolean;
    i: integer;
begin
 //tester s'il passe
 ok:= not(node.isRoot());
 ok:= ok and node.isEligible();
 //il passe alors ???
 if ok
  then FLstAssocRule.Add(TAssocTreeSpvRule.create(node));
 //il y a une suite ?
 if not(node.isLeaf())
  then
   begin
    for i:= 0 to pred(node.FSuccNodes.Count) do
     self.computeRulefrom(node.FSuccNodes.Items[i] as TAssocTreeNode);
   end;
end;

//** tri des rgles selon leur longueur **
function compare_rule_with_length(Item1, Item2: Pointer): Integer;
begin
 if (TAssocTreeSpvRule(Item1).FPathToRoot.Count<TAssocTreeSpvRule(Item2).FPathToRoot.Count)
  then result:= -1
  else
   begin
    if (TAssocTreeSpvRule(Item1).FPathToRoot.Count>TAssocTreeSpvRule(Item2).FPathToRoot.Count)
     then result:= +1
     else result:= 0;
   end;
end;
//****************************************

//** tri des rgles selon la confiance **
function compare_rule_with_confidence(Item1, Item2: Pointer): Integer;
var conf1,conf2: double;
begin
 conf1:= TAssocTreeSpvRule(Item1).FNode.FEval[dsAT_Learning].getConfidence();
 conf2:= TAssocTreeSpvRule(Item2).FNode.FEval[dsAT_Learning].getConfidence();
 if (conf1<conf2)
  then result:= +1
  else
   begin
    if (conf1>conf2)
     then result:= -1
     else result:= 0;
   end;
end;
//****************************************

//** tri des rgles selon le lift **
function compare_rule_with_lift(Item1, Item2: Pointer): Integer;
var lift1,lift2: double;
begin
 //recup une fois des valeurs
 lift1:= TAssocTreeSpvRule(Item1).FNode.FEval[dsAT_Learning].getLift();
 lift2:= TAssocTreeSpvRule(Item2).FNode.FEval[dsAT_Learning].getLift();
 //tests
 if (lift1<lift2)
  then result:= +1
  else
   begin
    if (lift1>lift2)
     then result:= -1
     else result:= 0;
   end;
 //TraceLog.WriteToLogFile(format('%.4f ? %.4f = %d',[lift1,lift2,result]));
end;
//****************************************

//** tri des rgles selon l'ordre lexicographique **
function compare_rule_with_lexicographic_ordering(Item1, Item2: Pointer): Integer;
var assoc1,assoc2: TAssocTreeSpvRule;

    i: integer;
    temoin: integer;
begin
 assoc1:= TAssocTreeSpvRule(Item1);
 assoc2:= TAssocTreeSpvRule(Item2);
 temoin:= 0;//a priori, ils sont ex-aequos
 i:= 0; //premier lment -- toujours valide, les rgles ne sont jamais vides
 while (temoin=0) do
  begin
   //comparer sur les numros
   if ((assoc1.FPathToRoot.Items[i] as TAssocItem).Numero<(assoc2.FPathToRoot.Items[i] as TAssocItem).Numero)
    then temoin:= -1
    else
     begin
      if ((assoc1.FPathToRoot.Items[i] as TAssocItem).Numero>(assoc2.FPathToRoot.Items[i] as TAssocItem).Numero)
       then temoin:= +1
     end;
   //si pas de dcision, passer au suivant
   if (temoin=0)
    then
     begin
      inc(i);
      //si dbordement, prendre une dcision -- il ne peut pas y avoir d'galit parfaite entre 2 rgles
      if (i=assoc2.FPathToRoot.Count) then temoin:= +1;
      if (i=assoc1.FPathToRoot.Count) then temoin:= -1;
     end;
  end;
 //and then...
 result:= temoin;
end;
//****************************************


procedure TLstAssocTreeSpvRule.computeRules;
begin
 //vider la liste actuelle le cas chant
 FLstAssocRule.Clear();
 //parcourir l'arbre pour rcuprer les rgles
 self.computeRulefrom(self.FAssocTree.FRootNode);
 //trier la base de rgles -- 0 --> pas de tri
 case (self.FAssocTree.FPrmOp as TOpPrmAssocTreeSpv).SortCriteria of
  //tri sur la longueur
  1: FLstAssocRule.Sort(compare_rule_with_length);
  //tri sur la confiance
  2: FLstAssocRule.Sort(compare_rule_with_confidence);
  //tri sur le lift
  3: FLstAssocRule.Sort(compare_rule_with_lift);
 end;
end;

constructor TLstAssocTreeSpvRule.create(tree: TAssocTreeStructure);
begin
 inherited Create();
 FAssocTree:= tree;
 FLstAssocRule:= TObjectList.Create(TRUE);
end;

destructor TLstAssocTreeSpvRule.destroy;
begin
 FLstAssocRule.Free();
 inherited destroy();
end;

function TLstAssocTreeSpvRule.getHTMLDescription: string;
var bs: TBufString;
    i: integer;
begin
 bs:= TBufString.Create();
 bs.BeginUpdate();
 bs.AddStr('<H3>Rules</H3>');
 bs.AddStr(format('<H4>"%s" is "%s" -- IF ...</H4>',[self.FAssocTree.FTarget.Name,self.FAssocTree.FTarget.LstValues.getDescription(self.FAssocTree.FTargetValue)]));
 //liste
 bs.AddStr(HTML_HEADER_TABLE_RESULT);
 bs.AddStr(HTML_TABLE_COLOR_HEADER_GRAY+'<TH>N</TH><TH>Antecedent</TH><TH>Length</TH><TH>Support</TH><TH>Confidence</TH><TH>Lift</TH></TR>');
 //rgle
 for i:= 0 to pred(self.FLstAssocRule.Count) do
  bs.AddStr(HTML_TABLE_COLOR_DATA_GRAY+'<TD>'+IntToStr(succ(i))+'</TD>'+(self.FLstAssocRule.Items[i] as TAssocTreeSpvRule).getHTMLDescription()+'</TR>');
 //fin de rgle
 bs.AddStr('</TABLE>');
 //fin de liste
 bs.EndUpdate();
 result:= bs.BufS;
 bs.Free();
end;

end.
