(*********************************************************************)
(* UCompAssocRuleAPriori.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*********************************************************************)

{
@abstract(Gnration de rgles d'association - Algorithme a priori)
@author(Ricco)
@created(12/01/2004)
}
unit UCompAssocRuleAPriori;

interface

USES
        Forms,
        UCompDefinition,
        UOperatorDefinition,
        UCompAssociationRuleDefinition,
        UDatasetExamples,
        UCalcAssocStructure;

TYPE
        {gnrateur de composant}
        TGenCompAssocAPriori = class(TMLGenComp)
                               protected
                               procedure   GenCompInitializations(); override;
                               public
                               function    GetClassMLComponent: TClassMLComponent; override;
                               end;

        {composant}
        TMLCompAssocAPriori = class(TMLCompAssocRule)
                              protected
                              function    getClassOperator: TClassOperator; override;   
                              end;

        {oprateur}
        TOpAssocAPriori = class(TOpAssocRule)
                          protected
                          function    getClassParameter: TClassOperatorParameter; override;
                          function    getClassAssocRule(): TClassCalcAssocRule; override;
                          end;

        {paramtre de l'oprateur}
        TOpPrmAssocAPriori = class(TOpPrmAssocRule)
                             protected
                             function    CreateDlgParameters(): TForm; override;
                             public
                             function    getHTMLParameters(): string; override;
                             end;

        {calculateur}
        TCalcAssocAPriori = class(TCalcAssocRule)
                            protected
                            function    classRuleStructure(): TClassAssocRuleStructure; override;
                            function    classLstAssocRules(): TClassLstAssocRules; override;    
                            end;

implementation

uses
        Classes, Sysutils,
        UStringsResources, UDlgOpPrmAssociationRule, UConstConfiguration;

{ TGenCompAssocAPriori }

procedure TGenCompAssocAPriori.GenCompInitializations;
begin
 FMLComp:= mlcAssociation;
end;

function TGenCompAssocAPriori.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompAssocAPriori;
end;

{ TMLCompAssocAPriori }

function TMLCompAssocAPriori.getClassOperator: TClassOperator;
begin
 result:= TOpAssocAPriori;
end;

{ TOpAssocAPriori }

function TOpAssocAPriori.getClassAssocRule: TClassCalcAssocRule;
begin
 result:= TCalcAssocAPriori;
end;

function TOpAssocAPriori.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmAssocAPriori;
end;

{ TOpPrmAssocAPriori }

function TOpPrmAssocAPriori.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmAssociationRule.CreateFromOpPrm(self);
end;


function TOpPrmAssocAPriori.getHTMLParameters: string;
var s: string;
begin
 s:= HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<TH colspan=2>A-Priori parameters</TH></TR>';
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Support min</TD><TD align="right">%.2f</TD></TR>',[MinSupport]);
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Confidence min</TD><TD align="right">%.2f</TD></TR>',[MinConfidence]);
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Max rule length</TD><TD align="right">%d</TD></TR>',[MaxRuleLength]);
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Lift filtering</TD><TD align="right">%.2f</TD></TR>',[MinLift]);
 s:= s+'</table>';
 result:= s;
end;

{ TCalcAssocAPriori }

function TCalcAssocAPriori.classLstAssocRules: TClassLstAssocRules;
begin
 result:= TLstAssocRules; 
end;

function TCalcAssocAPriori.classRuleStructure: TClassAssocRuleStructure;
begin
 result:= TAssocRuleStructure;
end;

initialization
 RegisterClass(TGenCompAssocAPriori);
end.
