(************************************************************************)
(* UCompAssocRuleSupervised.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(************************************************************************)

{
@abstract(Gnration de rgles d'association - Algorithme a priori supervis i.e. il y a une classe  prdire)
@author(Ricco)
@created(26/07/2004)

Reprendre les ides dans CBA et construire des rgles d'association avec une variable  prdire. Cet algo
peut tre gnralis d'ailleurs en choisisant plusieurs variables  mettre dans le consquent, pas forcment
une seule mais pour l'instant on s'en tient  un seul consquent... 26/07/2004
}

unit UCompAssocRuleSupervised;

interface

USES
        Contnrs,
        Forms,Classes,IniFiles,
        UCompDefinition,
        UOperatorDefinition,
        UCompAssociationRuleDefinition,
        UDatasetExamples,
        UCalcAssocStructure,
        UCompAssocRuleAPriori,
        UCompAssocRuleAPrioriMR,
        UDatasetDefinition,
        UDatasetImplementation;


TYPE
        {gnrateur de composant}
        TGenCompAssocRuleSpv = class(TMLGenComp)
                               protected
                               procedure   GenCompInitializations(); override;
                               public
                               function    GetClassMLComponent: TClassMLComponent; override;
                               end;

        {composant}
        TMLCompAssocRuleSpv = class(TMLCompAssocAPrioriMR)
                              protected
                              function    getClassOperator: TClassOperator; override;
                              end;

        {oprateur}
        TOpAssocRuleSpv = class(TOpAssocAPrioriMR)
                          private
                          {Variable classe}
                          FTarget: TAttribute;
                          {Valeur  prdire de l'attribut Target}
                          FTargetValue: TTypeDiscrete;
                          protected
                          function    getClassParameter: TClassOperatorParameter; override;
                          function    getClassAssocRule(): TClassCalcAssocRule; override;
                          {tester les attributs -- on demande un seul target discret supplmentaire}
                          function    CheckAttributes(): boolean; override;
                          public
                          property    Target: TAttribute read FTarget;
                          property    TargetValue: TTypeDiscrete read FTargetValue;
                          end;

        {paramtre de l'oprateur -- un nouveau paramtre est demand, la modalit de la variable  prdire  traiter}
        TOpPrmAssocRuleSpv = class(TOpPrmAssocAPrioriMR)
                             private
                             FValueToPredict: string;
                             protected
                             function    CreateDlgParameters(): TForm; override;
                             function    getCoreHTMLParameters(): string; override;
                             function    getCoreTXTParameters(): string; override;
                             public
                             procedure   SetDefaultParameters(); override;
                             procedure   LoadFromStream(prmStream: TStream); override;
                             procedure   SaveToStream(prmStream: TStream); override;
                             procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                             procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                             property    ValueToPredict: string read FValueToPredict write FValueToPredict;
                             end;

        {computerizer}
        TCalcAssocRuleSpv = class(TCalcAssocAPrioriMR)
                            private
                            {Variable classe}
                            FTarget: TAttribute;
                            {Valeur de la classe  prdire}
                            FTargetValue: TTypeDiscrete;
                            {Toutes les rgles avant le tri sur le target}
                            FRulesBeforeTargetFiltering: TLstAssocRules;
                            {nombre d'items dans le input et dans le target}
                            //FNbInputItems, FNbTargetItems: integer;
                            protected
                            {construire les items}
                            procedure   buildItems(prmExamples: TExamples); override;
                            {construire les itemsets de card=2, l'astuce est de n'introduire que les target  ce stade, aprs on fait ce qu'on veut}
                            procedure   buildFrequentItemsetOfCard2(prmExamples: TExamples); override;
                            {classe de calcul des rgles  partir des itemsests}
                            function    getClassCalcRuleFromItemset(): TClassCalcRuleFromItemset; override;
                            {simple filtrage a posteriori pour vrifier les calculs}
                            procedure   buildRulesFromItemset(prmExamples: TExamples; prmClassAssocStructure: TClassAssocRuleStructure); override;
                            public
                            constructor create(AssocOperator: TOpAssocRule); override;
                            destructor  destroy(); override;
                            property    Target: TAttribute read FTarget;
                            end;

        {gnrateur de rgles  partir d'un itemset -- seuls le target doit tre dans le consquent}
        TCalcRuleFromItemsetSpv = class(TCalcRuleFromItemset)
                                  public
                                  procedure    BuildRules(prmItemset: TAssocItemset; prmClassARStructre: TClassAssocRuleStructure); override;
                                  end;


implementation

USES
        Sysutils, Windows, ULogFile, UConstConfiguration,
        UStringAddBuffered, UDlgOpPrmAssocRuleSupervised;

CONST
        STR_CRLF = #13#10;

{ TGenCompAssocRuleSpv }

procedure TGenCompAssocRuleSpv.GenCompInitializations;
begin
 FMLComp:= mlcAssociation;
end;

function TGenCompAssocRuleSpv.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompAssocRuleSpv; 
end;

{ TMLCompAssocRuleSpv }

function TMLCompAssocRuleSpv.getClassOperator: TClassOperator;
begin
 result:= TOpAssocRuleSpv; 
end;

{ TOpAssocRuleSpv }

function TOpAssocRuleSpv.CheckAttributes: boolean;
begin
 result:= FALSE;
 //new -- 05/110/2004 --
 //on revient  la dfinition standard des spcifs ici, tous "inputs" discrets...
 //---------------------
 if ((self.WorkData.LstAtts[asInput].Count>0) and (self.WorkData.LstAtts[asInput].isAllCategory(caDiscrete)))
  then
   begin
    //tester le target
    if (self.WorkData.LstAtts[asTarget].Count=1) and (self.WorkData.LstAtts[asTarget].isAllCategory(caDiscrete))
     then
      Begin
       //les inputs
       FInputs:= self.WorkData.LstAtts[asInput];
       //le target
       FTarget:= self.WorkData.LstAtts[asTarget].Attribute[0];
       //reprer la modalit de l'attribut  prdire
       FTargetValue:= FTarget.LstValues.isValueAvailable((self.PrmOp as TOpPrmAssocRuleSpv).ValueToPredict);
       //TRUE si ok il y a qq chose  faire
       result:= (FTargetValue>0);
      End;
   end;
end;

function TOpAssocRuleSpv.getClassAssocRule: TClassCalcAssocRule;
begin
 result:= TCalcAssocRuleSpv; 
end;

function TOpAssocRuleSpv.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmAssocRuleSpv;
end;

{ TCalcAssocRuleSpv }

procedure TCalcAssocRuleSpv.buildFrequentItemsetOfCard2(
  prmExamples: TExamples);
var lstItemsets: TLstAssocItemSet;
    i,j: integer;
    itemset: TAssocItemSet;
    item1,item2: TAssocItem;
begin
 //les items de cardinal 2
 lstItemsets:= FStructureItemsets.AddLstAssocItemset();
 //tester le croisement
 for i:= 0 to FItems.Count-2 do
  begin
   item1:= FItems.Item[i];
   //tester si Target candidat
   if (item1.Attribute = self.Target)
    then
     begin
       for j:= succ(i) to pred(FItems.Count) do
       begin
        item2:= FItems.Item[j];
        //s'assurer que non-target candidat
        if (item2.Attribute<>self.Target)
         then
          begin
            itemset:= TAssocItemSet.Create(item1,item2);
            //faire passer sur les individus et tester si acceptable
            //itemset.computeSupport(prmExamples);
            //avec les bit array, c'est inutile
            if (itemset.Support<FAbsMinSupport)
             then itemset.Free
             else lstItemsets.AddItemSet(itemset);
          end;
       end;
     end;
  end;
end;


procedure TCalcAssocRuleSpv.buildItems(prmExamples: TExamples);
var j: integer;
    att: TAttribute;
begin
 if assigned(FItems)
  then FItems.Free;
 //construire les items
 FItems:= TLstAssocItem.Create();
 //les items de target
 att:= FTarget;
 //FItems.buildItems(att,prmExamples);
 //************************************************************
 //*** new -- 05/08/2004 -- on prcise la valeur de sortie ****
 //*** !!!!! le target est donc forcment DISCRET !!!! ********
 //************************************************************
 FItems.buildValueItem(att,self.FTargetValue,prmExamples);
 //les items de input
 for j:= 0 to pred(FInputs.Count) do
  begin
   att:= FInputs.Attribute[j];
   FItems.buildItems(att,prmExamples);
  end;
 //filtrer les items sans procder  un tri pour viter les confusions et respecter l'ordre des variables
 FItems.FilterItemsOnSupportNoSort(FAbsMinSupport);
end;

procedure TCalcAssocRuleSpv.buildRulesFromItemset(prmExamples: TExamples;
  prmClassAssocStructure: TClassAssocRuleStructure);
var k,i: integer;
    rule: TAssocRuleStructure;
    item: TAssocItem;
    tps: cardinal;
begin
 inherited buildRulesFromItemset(prmExamples,prmClassAssocStructure);
 tps:= GetTickCount();
 {trier les rgles selon le nombre d'items dans l'antcdent, et en cas d'ex-aequo selon le lift -- 26/07/2004}
 FRules.SortRulesOn(RuleCompareOnNbAnteItemsAndLift);
 {puis un second filtrage sur le target -- trs lent pour l'instant mais on n'a pas mieux...}
 //copier les rgles
 self.FRulesBeforeTargetFiltering.copy(FRules);
 //changement de propitaire
 FRules.setOwner(FALSE);
 FRules.clear();
 //passer les rgles dans l'ordre de la target -- pas terrible comme stratgie mais a reste linaire en nombre de rgles
 //for k:= 1 to self.Target.nbValues do
 //new -- 01/12/2004 -- un seul item candidat pour le consquent -- choisi en paramtre
 for k:= self.FTargetValue to self.FTargetValue do
  begin
   for i:= 0 to pred(self.FRulesBeforeTargetFiltering.count) do
    begin
     rule:= self.FRulesBeforeTargetFiltering.getRule(i);
     //tester si la condition est de cardinal 1
     if (rule.Consequent.Count=1)
      then
       begin
        //tester s'il s'agit bien de la conclusion-target
        item:= rule.Consequent.Items[0] as TAssocItem;
        if (item.Attribute = self.Target) and (item.Value = k)
         then FRules.addRule(rule);
       end;
     end;
  end;
 tps:= GetTickCount()-tps;
 TraceLog.WriteToLogFile(format('[SUPERVISED ASSOC RULE] :: dure filtrage a posteriori des rgles sur target et nombre items = %d ms. (%d rgles)',[tps,FRules.Count]));
end;

constructor TCalcAssocRuleSpv.create(AssocOperator: TOpAssocRule);
begin
 inherited Create(AssocOperator);
 FTarget:= (AssocOperator as TOpAssocRuleSpv).Target;
 FTargetValue:= (AssocOperator as TOpAssocRuleSpv).TargetValue;
 FRulesBeforeTargetFiltering:= TLstAssocRules.create(TRUE);
end;

destructor TCalcAssocRuleSpv.destroy;
begin
 if assigned(FRulesBeforeTargetFiltering)
  then FRulesBeforeTargetFiltering.Free();
 inherited destroy();
end;

function TCalcAssocRuleSpv.getClassCalcRuleFromItemset: TClassCalcRuleFromItemset;
begin
 result:= TCalcRuleFromItemsetSpv;
end;

{ TCalcRuleFromItemsetSpv }

//new -- 26/07/2004
//!\\  ce stade, on est sr que si l'itemset est prsent, c'est que le premier item est forcment un item de la TARGET
//!\\ on court-cirtcuite l'appel  GENERATE RULES, en effet il n'est pas ncessaire d'explorer en profondeur les solutions
procedure TCalcRuleFromItemsetSpv.BuildRules(prmItemset: TAssocItemset;
  prmClassARStructre: TClassAssocRuleStructure);
var item: TAssocItem;
    k,iTarget: integer;
    curConf: double;
    rule: TAssocRuleStructure;
    nbAnte,nbCons: integer;
begin
 self.Initialize(prmItemset);
 //portage simplifi de GenerateRules directement  ce niveau i.e. dans la procdure appellante
 //enlever i (du target) de l'antcdent pour l'ajouter dans le consquent
 //il faut le chercher ???
 (*
 iTarget:= -1;
 for i:= 0 to pred(FCurItemset.card) do
  begin
   item:= FCurItemset.getItem(i);
   //test
   if (item.Attribute = (self.FCalcAssoc as TCalcAssocRuleSpv).Target)
    then
     begin
      iTarget:= i;
      BREAK;
     end;
  end;
 *)
 //non... a priori ... si l'itemset est prsent c'est qu'il est frquent ET target est prsent en position 0 ...
 iTarget:= 0;
 //zoo..
 if (iTarget>=0)
  then
   begin
     //prciser la target
     FItemInConsequent.Value[iTarget]:= TRUE;
     //comptage
     FBitCons.SetAllTrue;
     FBitAnte.SetAllTrue;
     nbAnte:= 0;
     nbCons:= 0;
     for k:= 0 to pred(FCurItemset.card) do
      begin
       item:= FCurItemset.getItem(k);
       if FItemInConsequent.Value[k]
        then
         begin
          FBitCons.AndArray(item.BoolArray);
          inc(nbAnte);
         end
        else
         begin
          FBitAnte.AndArray(item.BoolArray);
          inc(nbCons);
         end;
      end;
     //si la rgle est valable
     if (nbAnte>0) and (nbCons>0)
      then
       begin
         //valuer la confiance de la rgle forme
         FBitCons.RefreshCount;
         FBitAnte.RefreshCount;
         curConf:= 1.0*FCurItemset.Support/(1.0*FBitAnte.Count);
         //tester si ok
         if (curConf>FMinConfiance)
          then
           //on valide la rgle et on explore en profondeur
           begin
            //rule:= TAssocRuleStructure.Create(self);
            //rendre la chose paramtrable -- 23/05/2004
            rule:= prmClassARStructre.Create(self);
            ///suite std.
            FLstRules.Add(rule);
           end;
       end;
     //on dsinitialise la slection
     FItemInConsequent.Value[iTarget]:= FALSE;
  end;
end;

{ TOpPrmAssocRuleSpv }

function TOpPrmAssocRuleSpv.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmAssociationRuleSpv.CreateFromOpPrm(self);
end;

function TOpPrmAssocRuleSpv.getCoreHTMLParameters: string;
begin
 result:= inherited getCoreHTMLParameters()+
          HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Value to predict</TD><TD align="right">%s</TD></TR>',[FValueToPredict]);
end;

function TOpPrmAssocRuleSpv.getCoreTXTParameters: string;
begin
 result:= inherited getCoreTXTParameters()+
          format('Value to predict;%s',[FValueToPredict])+STR_CRLF;
end;

procedure TOpPrmAssocRuleSpv.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
  inherited;
  FValueToPredict:= prmINI.ReadString(prmSection,'value_to_predict',FValueToPredict);
end;

procedure TOpPrmAssocRuleSpv.LoadFromStream(prmStream: TStream);
begin
  inherited;
  loadStringFromStream(FValueToPredict,prmStream);
end;

procedure TOpPrmAssocRuleSpv.SaveToINI(prmSection: string;
  prmINI: TMemIniFile);
begin
  inherited;
  prmINI.WriteString(prmSection,'value_to_predict',FValueToPredict);
end;

procedure TOpPrmAssocRuleSpv.SaveToStream(prmStream: TStream);
begin
  inherited;
  saveStringToStream(FValueToPredict,prmStream);
end;

procedure TOpPrmAssocRuleSpv.SetDefaultParameters;
begin
  inherited;
  FValueToPredict:= '';
end;

initialization
 Classes.RegisterClass(TGenCompAssocRuleSpv);
end.
