unit UDlgOpPrmAssocRuleSupervised;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgOpPrmAssociationRuleMR, StdCtrls, lmdstdcA,
  LMDCustomControl, LMDCustomPanel, LMDCustomBevelPanel, LMDBaseEdit,
  LMDCustomEdit, LMDCustomMaskEdit, LMDMaskEdit, ComCtrls, ExtCtrls;

type
  TDlgOpPrmAssociationRuleSpv = class(TDlgOpPrmAssociationRuleMR)
    Label7: TLabel;
    cmbTargetValue: TComboBox;
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    procedure   ApplyModifications(); override;
    procedure   SetParameters(); override;        
  end;

var
  DlgOpPrmAssociationRuleSpv: TDlgOpPrmAssociationRuleSpv;

implementation

uses UCompAssocRuleSupervised, UDatasetImplementation, UDatasetDefinition,
  UCompManageDataset;

{$R *.dfm}

{ TDlgOpPrmAssociationRuleSpv }

procedure TDlgOpPrmAssociationRuleSpv.ApplyModifications;
begin
  inherited ApplyModifications();
  (self.OpPrm as TOpPrmAssocRuleSpv).ValueToPredict:= cmbTargetValue.Items.Strings[cmbTargetValue.ItemIndex];
end;

procedure TDlgOpPrmAssociationRuleSpv.SetParameters;
var att: TAttDiscrete;
    i: TTypeDiscrete;
begin
 inherited SetParameters();
 //lister les valeurs dispos de la target
 cmbTargetValue.Items.Clear();
 //y a-t-il un target dj ?
 if ((self.OpPrm.Operator as TOpLocalData).WorkData.LstAtts[asTarget].Count=1) and ((self.OpPrm.Operator as TOpLocalData).WorkData.LstAtts[asTarget].isAllCategory(caDiscrete))
  then
   begin
    att:= (self.OpPrm.Operator as TOpLocalData).WorkData.LstAtts[asTarget].Attribute[0] as TAttDiscrete;
    //charger
    for i:= 1 to att.nbValues do
     cmbTargetValue.Items.Add(att.LstValues.getDescription(i));
    //activer le bon
    cmbTargetValue.ItemIndex:= pred(att.LstValues.isValueAvailable((self.OpPrm as TOpPrmAssocRuleSpv).ValueToPredict));
   end;
end;

end.
